/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.common.utils;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.Locale;
import java.util.TimeZone;

public class CalendarHelper {
    protected Calendar calendar = null;
    public static final int MONTHS_OF_YEAR = 12;
    public static final int QUARTER_OF_YEAR = 4;
    public static final int HALF_OF_YEAR = 2;
    public static final int YEAR_OF_YEAR = 1;

    public CalendarHelper() {
        this.calendar = Calendar.getInstance();
    }

    public CalendarHelper(Date date) {
        this.calendar = Calendar.getInstance();
        this.calendar.setTime(date);
    }

    public CalendarHelper(Locale locale) {
        this.calendar = Calendar.getInstance(locale);
    }

    public void setTime(Date date) {
        this.calendar.setTime(date);
    }

    public Date getTime() {
        return this.calendar.getTime();
    }

    public int computeToDate(Date day, Date compareDay) {
        long point = 0L;
        long compare = 0L;
        if (day == null) {
            this.calendar.setTime(new Date());
        } else {
            this.calendar.setTime(day);
        }
        this.processClearTime(this.calendar);
        point = this.calendar.getTimeInMillis();
        if (compareDay == null) {
            this.calendar.setTime(new Date());
        } else {
            this.calendar.setTime(compareDay);
        }
        this.processClearTime(this.calendar);
        compare = this.calendar.getTimeInMillis();
        if (point == compare) {
            return 0;
        }
        if (point < compare) {
            return 1;
        }
        return -1;
    }

    public int computeToTime(Date time, Date compareTime) {
        long point = 0L;
        long compare = 0L;
        if (time == null) {
            this.calendar.setTime(new Date());
        } else {
            this.calendar.setTime(time);
        }
        point = this.calendar.getTimeInMillis();
        if (compareTime == null) {
            this.calendar.setTime(new Date());
        } else {
            this.calendar.setTime(compareTime);
        }
        compare = this.calendar.getTimeInMillis();
        if (point == compare) {
            return 0;
        }
        if (point < compare) {
            return 1;
        }
        return -1;
    }

    public boolean isLeapYear(int year) {
        return year % 400 == 0 || year % 4 == 0 && year % 100 != 0;
    }

    public int getYear() {
        return this.calendar.get(1);
    }

    public int getCurrentlyYear() {
        return this.getCurrentlyYear(null);
    }

    public int getCurrentlyYear(Date date) {
        if (date != null) {
            this.calendar.setTime(date);
        }
        if (this.calendar.getTime() == null) {
            this.calendar.setTime(new Date());
        }
        return this.calendar.get(1);
    }

    public int getCurrentlyHalfYear() {
        return this.getCurrentlyHalfYear(null);
    }

    public int getCurrentlyHalfYear(Date date) {
        int month;
        if (date != null) {
            this.calendar.setTime(date);
        }
        if (this.calendar.getTime() == null) {
            this.calendar.setTime(new Date());
        }
        if ((month = this.calendar.get(2) + 1) >= 1 && month <= 6) {
            return 1;
        }
        return 2;
    }

    public int getDaysOfYear(int year) {
        this.calendar.set(year, 0, 1);
        return this.calendar.getActualMaximum(6);
    }

    public int getWeeksOfYear(int year, boolean isYearWeek) {
        int weeks = 0;
        if (isYearWeek) {
            this.calendar.set(year + 1, 0, 1);
            this.calendar.add(6, -1);
            weeks = this.calendar.getActualMaximum(3);
            if (weeks > this.calendar.get(3)) {
                ++weeks;
            }
        } else {
            int count = 12;
            for (int index = 1; index <= count; ++index) {
                this.calendar.set(year, this.processMonth(index), 1);
                weeks += this.calendar.getActualMaximum(4);
            }
        }
        return weeks;
    }

    public Date getFirstDayOfYear(int year) {
        this.calendar.set(year, 0, 1);
        this.processClearTime(this.calendar);
        return this.calendar.getTime();
    }

    public Date getLastDayOfYear(int year) {
        this.calendar.set(year + 1, 0, 1);
        this.calendar.add(6, -1);
        return this.calendar.getTime();
    }

    public Date getFirstDayOfHalfYear(int year, int halfYear) {
        if (halfYear == 1) {
            this.calendar.set(year, 0, 1);
        } else {
            this.calendar.set(year, 6, 1);
        }
        this.processClearTime(this.calendar);
        return this.calendar.getTime();
    }

    public Date getLastDayOfHalfYear(int year, int halfYear) {
        if (halfYear == 1) {
            this.calendar.set(year, 6, 1);
        } else {
            this.calendar.set(year + 1, 0, 1);
        }
        this.calendar.add(6, -1);
        return this.calendar.getTime();
    }

    public int getQuarterOfYear() {
        return 4;
    }

    public int getCurrentlyQuarter() {
        return this.getCurrentlyQuarter(null);
    }

    public int getCurrentlyQuarter(Date date) {
        int month;
        if (date != null) {
            this.calendar.setTime(date);
        }
        if (this.calendar.getTime() == null) {
            this.calendar.setTime(new Date());
        }
        if ((month = this.calendar.get(2) + 1) >= 1 && month <= 3) {
            return 1;
        }
        if (month >= 4 && month <= 6) {
            return 2;
        }
        if (month >= 7 && month <= 9) {
            return 3;
        }
        return 4;
    }

    public Date getLastDayOfQuarterBySelfDefined(int year, int quarter, int startMonth) {
        switch (quarter) {
            case 1: {
                int start = -1;
                if (startMonth + 3 > 12) {
                    start = startMonth + 3 - 12;
                    this.calendar.set(year + 1, start - 1, 1);
                    break;
                }
                start = startMonth + 3;
                this.calendar.set(year, start - 1, 1);
                break;
            }
            case 2: {
                if (startMonth + 6 > 12) {
                    int start = startMonth + 6 - 12;
                    this.calendar.set(year + 1, start - 1, 1);
                    break;
                }
                int start = startMonth + 6;
                this.calendar.set(year, start - 1, 1);
                break;
            }
            case 3: {
                if (startMonth + 9 > 12) {
                    int start = startMonth + 9 - 12;
                    this.calendar.set(year + 1, start - 1, 1);
                    break;
                }
                int start = startMonth + 9;
                this.calendar.set(year, start - 1, 1);
                break;
            }
            default: {
                if (startMonth + 12 > 12) {
                    int start = startMonth + 12 - 12;
                    this.calendar.set(year + 1, start - 1, 1);
                    break;
                }
                int start = startMonth + 12;
                this.calendar.set(year, start - 1, 1);
            }
        }
        this.calendar.add(6, -1);
        return this.calendar.getTime();
    }

    public Date getFirstDayOfQuarterBySelfDefined(int year, int quarter, int startMonth) {
        switch (quarter) {
            case 1: {
                this.calendar.set(year, startMonth - 1, 1);
                break;
            }
            case 2: {
                int start = -1;
                if (startMonth + 3 > 12) {
                    start = startMonth + 3 - 12;
                    this.calendar.set(year + 1, start - 1, 1);
                    break;
                }
                start = startMonth + 3;
                this.calendar.set(year, start - 1, 1);
                break;
            }
            case 3: {
                if (startMonth + 6 > 12) {
                    int start = startMonth + 6 - 12;
                    this.calendar.set(year + 1, start - 1, 1);
                    break;
                }
                int start = startMonth + 6;
                this.calendar.set(year, start - 1, 1);
                break;
            }
            default: {
                if (startMonth + 9 > 12) {
                    int start = startMonth + 9 - 12;
                    this.calendar.set(year + 1, start - 1, 1);
                    break;
                }
                int start = startMonth + 9;
                this.calendar.set(year, start - 1, 1);
            }
        }
        this.processClearTime(this.calendar);
        return this.calendar.getTime();
    }

    public Date getFirstDayOfQuarter(int year, int quarter) {
        switch (quarter) {
            case 1: {
                this.calendar.set(year, 0, 1);
                break;
            }
            case 2: {
                this.calendar.set(year, 3, 1);
                break;
            }
            case 3: {
                this.calendar.set(year, 6, 1);
                break;
            }
            default: {
                this.calendar.set(year, 9, 1);
            }
        }
        this.processClearTime(this.calendar);
        return this.calendar.getTime();
    }

    public Date getLastDayOfQuarter(int year, int quarter) {
        switch (quarter) {
            case 1: {
                this.calendar.set(year, 3, 1);
                break;
            }
            case 2: {
                this.calendar.set(year, 6, 1);
                break;
            }
            case 3: {
                this.calendar.set(year, 9, 1);
                break;
            }
            default: {
                this.calendar.set(year + 1, 0, 1);
            }
        }
        this.calendar.add(6, -1);
        return this.calendar.getTime();
    }

    public int getCurrentlyMonth() {
        return this.getCurrentlyMonth(null);
    }

    public int getCurrentlyMonth(Date date) {
        if (date != null) {
            this.calendar.setTime(date);
        }
        if (this.calendar.getTime() == null) {
            this.calendar.setTime(new Date());
        }
        return this.calendar.get(2) + 1;
    }

    public int getCurrentlyWeek() {
        return this.getCurrentlyWeek(new Date());
    }

    public int getCurrentlyWeek(Date date) {
        Date _date = date != null ? this.getStartDate(date) : this.getStartDate(new Date());
        Date _tmpDate = this.getStartDate(this.getLastDayOfWeek(this.getCurrentlyYear(_date), 1));
        if (this.getStartDate(_date).compareTo(_tmpDate) > 0) {
            int maxWeeks = this.getWeeksOfYear(this.getCurrentlyYear(_date), true);
            this.calendar.setTime(_tmpDate);
            for (int i = 2; i <= maxWeeks; ++i) {
                this.calendar.add(3, 1);
                if (this.calendar.getTime().compareTo(_date) < 0) continue;
                return i;
            }
        }
        return 1;
    }

    public int getCurrentlyDay() {
        return this.getCurrentlyDay(null);
    }

    public int getCurrentlyDay(Date date) {
        if (date != null) {
            this.calendar.setTime(date);
        }
        if (this.calendar.getTime() == null) {
            this.calendar.setTime(new Date());
        }
        return this.calendar.get(5);
    }

    public int getDaysOfMonth(int year, int month) {
        this.calendar.set(year, this.processMonth(month), 1);
        return this.calendar.getActualMaximum(5);
    }

    public int getWeeksOfMonth(int year, int month) {
        this.calendar.set(year, this.processMonth(month), 1);
        return this.calendar.getActualMaximum(4);
    }

    public Date getFirstDayOfMonth(int year, int month) {
        this.calendar.set(year, this.processMonth(month), 1);
        this.processClearTime(this.calendar);
        return this.calendar.getTime();
    }

    public Date getFirstDayOfMonthTenDays(int year, int month, int tenDays) {
        if (tenDays == 1) {
            this.calendar.set(year, this.processMonth(month), 1);
        } else if (tenDays == 2) {
            this.calendar.set(year, this.processMonth(month), 11);
        } else {
            this.calendar.set(year, this.processMonth(month), 1);
        }
        return this.calendar.getTime();
    }

    public Date getLastDayOfMonthTenDays(int year, int month, int tenDays) {
        if (tenDays == 1) {
            this.calendar.set(year, this.processMonth(month), 10);
        } else if (tenDays == 2) {
            this.calendar.set(year, this.processMonth(month), 20);
        } else {
            this.calendar.set(1, year);
            this.calendar.set(2, this.processMonth(month));
            this.calendar.set(5, this.calendar.getActualMaximum(5));
        }
        return this.calendar.getTime();
    }

    public Date getLastDayOfMonth(int year, int month) {
        this.calendar.set(year, this.processMonth(month), 1);
        this.calendar.add(6, this.calendar.getActualMaximum(5) - 1);
        return this.calendar.getTime();
    }

    public Date getFirstDayOfWeek(int year, int week) {
        this.calendar.set(year, 0, 1);
        if (week <= 1) {
            return this.calendar.getTime();
        }
        this.calendar.set(year + 1, 0, 1);
        this.calendar.add(6, -1);
        int WEEKS_OF_MONTH = this.calendar.getActualMaximum(3);
        if (WEEKS_OF_MONTH > this.calendar.get(3)) {
            ++WEEKS_OF_MONTH;
        }
        this.calendar.set(year, 0, 1);
        int DAY_IN_WEEK = this.calendar.get(7);
        this.calendar.add(6, 1 - DAY_IN_WEEK);
        if (week > WEEKS_OF_MONTH) {
            week = WEEKS_OF_MONTH;
        }
        this.calendar.add(3, week - 1);
        return this.calendar.getTime();
    }

    public Date getLastDayOfWeek(int year, int week) {
        this.calendar.set(year + 1, 0, 1);
        this.calendar.add(6, -1);
        int WEEKS_OF_MONTH = this.calendar.getActualMaximum(3);
        if (WEEKS_OF_MONTH > this.calendar.get(3)) {
            ++WEEKS_OF_MONTH;
        }
        if (week >= WEEKS_OF_MONTH) {
            return this.calendar.getTime();
        }
        this.calendar.set(year, 0, 1);
        int DAY_IN_WEEK = this.calendar.get(7);
        this.calendar.add(6, 0 - DAY_IN_WEEK);
        if (week < 1) {
            week = 1;
        }
        this.calendar.add(3, week);
        return this.calendar.getTime();
    }

    public Date getFirstDayOfWeek(int year, int month, int week) {
        this.calendar.set(year, this.processMonth(month), 1);
        if (week <= 1) {
            return this.calendar.getTime();
        }
        int DAY_IN_WEEK = this.calendar.get(7);
        int WEEKS_OF_MONTH = this.calendar.getActualMaximum(4);
        this.calendar.add(6, 1 - DAY_IN_WEEK);
        if (week > WEEKS_OF_MONTH) {
            week = WEEKS_OF_MONTH;
        }
        this.calendar.add(3, week - 1);
        return this.calendar.getTime();
    }

    public Date getLastDayOfWeek(int year, int month, int week) {
        this.calendar.set(year, this.processMonth(month), 1);
        int DAY_IN_WEEK = this.calendar.get(7);
        int WEEKS_OF_MONTH = this.calendar.getActualMaximum(4);
        if (week >= WEEKS_OF_MONTH) {
            this.calendar.add(6, this.calendar.getActualMaximum(5) - 1);
            return this.calendar.getTime();
        }
        this.calendar.add(6, 0 - DAY_IN_WEEK);
        if (week < 1) {
            week = 1;
        }
        this.calendar.add(3, week);
        return this.calendar.getTime();
    }

    public Date setDay(int year, int month, int day) {
        this.calendar.set(year, this.processMonth(month), day);
        return this.calendar.getTime();
    }

    public Date getStartDate(Date day) {
        this.calendar.setTime(day);
        this.processClearTime(this.calendar);
        return this.calendar.getTime();
    }

    public Date getBeoverDate(Date day) {
        this.calendar.setTime(day);
        this.processSetMaxTime(this.calendar);
        return this.calendar.getTime();
    }

    public int[] getYear(int sYear, int eYear) {
        int yearNum = eYear - sYear;
        if (yearNum != 0) {
            int[] rtnAry = new int[yearNum + 1];
            for (int i = 0; i < yearNum + 1; ++i) {
                rtnAry[i] = sYear + i;
            }
            return rtnAry;
        }
        return new int[]{sYear};
    }

    private int processMonth(int month) {
        if (month <= 1) {
            return 0;
        }
        if (month >= 12) {
            return 11;
        }
        int CALENDAR_PROCESS = 0;
        switch (month) {
            case 2: {
                CALENDAR_PROCESS = 1;
                break;
            }
            case 3: {
                CALENDAR_PROCESS = 2;
                break;
            }
            case 4: {
                CALENDAR_PROCESS = 3;
                break;
            }
            case 5: {
                CALENDAR_PROCESS = 4;
                break;
            }
            case 6: {
                CALENDAR_PROCESS = 5;
                break;
            }
            case 7: {
                CALENDAR_PROCESS = 6;
                break;
            }
            case 8: {
                CALENDAR_PROCESS = 7;
                break;
            }
            case 9: {
                CALENDAR_PROCESS = 8;
                break;
            }
            case 10: {
                CALENDAR_PROCESS = 9;
                break;
            }
            case 11: {
                CALENDAR_PROCESS = 10;
            }
        }
        return CALENDAR_PROCESS;
    }

    private void processClearTime(Calendar cal) {
        if (cal == null) {
            return;
        }
        cal.set(11, 0);
        cal.set(12, 0);
        cal.set(13, 0);
        cal.set(14, 0);
    }

    public void processClearTime() {
        this.calendar.set(11, 0);
        this.calendar.set(12, 0);
        this.calendar.set(13, 0);
        this.calendar.set(14, 0);
    }

    private void processSetMaxTime(Calendar cal) {
        if (cal == null) {
            return;
        }
        this.calendar.set(11, 23);
        this.calendar.set(12, 59);
        this.calendar.set(13, 59);
        this.calendar.set(14, 999);
    }

    public void processSetMaxTime() {
        this.calendar.set(11, 23);
        this.calendar.set(12, 59);
        this.calendar.set(13, 59);
        this.calendar.set(14, 999);
    }

    public Date parseDate(String s) throws ParseException {
        try {
            return this.parseDate(s, "yyyy-MM-dd HH:mm:ss");
        }
        catch (ParseException parseException) {
            try {
                return this.parseDate(s, "yyyy-MM-dd");
            }
            catch (ParseException parseException2) {
                try {
                    return this.parseDate(s, "MM/dd/yyyy HH:mm:ss");
                }
                catch (ParseException parseException3) {
                    try {
                        return this.parseDate(s, "MM/dd/yyyy");
                    }
                    catch (ParseException parseException4) {
                        try {
                            return this.parseDate(s, "HH:mm:ss");
                        }
                        catch (ParseException parseException5) {
                            throw new ParseException("can not understand your format", -1);
                        }
                    }
                }
            }
        }
    }

    private Date parseDate(String s, String fmt) throws ParseException {
        return this.parseDate(s, fmt, null);
    }

    private Date parseDate(String s, String fmt, TimeZone timezone) throws ParseException {
        return this.parseDate(s, fmt, timezone, null);
    }

    private Date parseDate(String s, String fmt, TimeZone timezone, Locale locale) throws ParseException {
        SimpleDateFormat df = locale == null ? new SimpleDateFormat(fmt) : new SimpleDateFormat(fmt, locale);
        if (timezone == null) {
            timezone = TimeZone.getDefault();
        }
        df.setTimeZone(timezone);
        df.setLenient(false);
        return df.parse(s);
    }

    public Date getDayBefore(Date date) {
        Calendar c = Calendar.getInstance();
        c.setTime(date);
        int day = c.get(5);
        c.set(5, day - 1);
        return c.getTime();
    }

    public static Date clearTime(Date date) {
        if (date == null) {
            return null;
        }
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        calendar.set(11, 0);
        calendar.set(12, 0);
        calendar.set(13, 0);
        calendar.set(14, 0);
        return calendar.getTime();
    }
}

