/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.common.utils;

import com.alibaba.fastjson.JSON;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.exception.KDBizException;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.epm.eb.common.cache.IModelCacheHelper;
import kd.epm.eb.common.cache.ModelCacheContext;
import kd.epm.eb.common.cache.impl.BaseCache;
import kd.epm.eb.common.cache.impl.Dimension;
import kd.epm.eb.common.cache.impl.Member;
import kd.epm.eb.common.constant.BgBaseConstant;
import kd.epm.eb.common.enums.SysDimensionEnum;
import kd.epm.eb.common.utils.BusinessModelServiceHelper;
import kd.epm.eb.common.utils.IDUtils;
import kd.epm.eb.common.utils.JSONUtils;
import kd.epm.eb.common.utils.LogStats;
import kd.epm.eb.common.utils.QFBuilder;
import kd.epm.eb.common.utils.StringUtils;
import kd.epm.eb.common.utils.control.Centralized;
import org.jetbrains.annotations.NotNull;

public class CentralizedServiceHelper {
    public static final String FIELDS = "id, account, version, dimension, dimension.number, bussmodel.id, orgrange.id, orgrange.entity, orgrange.entity.number, orgrange.entity.name, orgrange.rangenumbers, orgrange.entityrange, orgrange.entityrangenumbers, orgrange.dimensionrange";

    public static List<Centralized> queryCentralized(@NotNull Long modelId, @NotNull Long busModelId, LogStats stats) {
        Centralized.CentEntry centEntry;
        Centralized centralized;
        if (stats == null) {
            return Collections.emptyList();
        }
        LinkedHashMap centralizedMap = Maps.newLinkedHashMap();
        LinkedHashMap centEntryMap = Maps.newLinkedHashMap();
        LinkedHashMap entryMappingMap = Maps.newLinkedHashMap();
        LinkedHashMap parseRangMap = Maps.newLinkedHashMap();
        LinkedHashMap accountCache = Maps.newLinkedHashMap();
        QFBuilder builder = new QFBuilder();
        builder.add(new QFilter("model", "=", (Object)modelId));
        if (IDUtils.isNotNull(busModelId)) {
            builder.add(new QFilter("bussmodel.id", "=", (Object)busModelId));
        }
        builder.add(new QFilter("status", "=", (Object)"1"));
        DataSet ds = QueryServiceHelper.queryDataSet((String)"query centralized", (String)"eb_centralized_entity", (String)FIELDS, (QFilter[])builder.toArrays(), null);
        Object object = null;
        try {
            if (ds != null) {
                for (Row row : ds) {
                    Map rangeMap;
                    String orgRange;
                    centralized = centralizedMap.computeIfAbsent(row.getLong("id"), f -> {
                        Centralized _centralized = new Centralized();
                        _centralized.setId(row.getLong("id"));
                        _centralized.setBusModelId(row.getLong("bussmodel.id"));
                        Set<String> accounts = CentralizedServiceHelper.parseAccount(row.getString("account"), accountCache, stats);
                        if (accounts == null || accounts.isEmpty()) {
                            stats.addInfo("parse Centralized account error." + row.getString("account"));
                        } else {
                            _centralized.getAccounts().addAll(accounts);
                        }
                        _centralized.setDimNumber(row.getString("dimension.number"));
                        _centralized.setVersion(row.getLong("version"));
                        return _centralized;
                    });
                    centEntry = centEntryMap.computeIfAbsent(row.getLong("orgrange.id"), f -> new Centralized.CentEntry());
                    centEntry.setEntryId(row.getLong("orgrange.id"));
                    centEntry.centOrgMember = CentralizedServiceHelper.parseCentOrgMember(row);
                    entryMappingMap.put(centEntry.getEntryId(), centralized);
                    if (StringUtils.isEmpty(centralized.getDimNumber()) || SysDimensionEnum.Entity.getNumber().equals(centralized.getDimNumber())) {
                        if (StringUtils.isEmpty(centralized.getDimNumber())) {
                            centralized.setDimNumber(SysDimensionEnum.Entity.getNumber());
                        }
                        if (StringUtils.isNotEmpty(orgRange = row.getString("orgrange.rangenumbers")) && !orgRange.contains("##")) {
                            centEntry.getOrgRange().addAll(CentralizedServiceHelper.parseRange(orgRange));
                        } else {
                            rangeMap = parseRangMap.computeIfAbsent(centEntry.getEntryId(), f -> Maps.newHashMap());
                            rangeMap.put(centralized.getDimNumber(), row.getString("orgrange.dimensionrange"));
                        }
                    } else {
                        orgRange = row.getString("orgrange.entityrangenumbers");
                        String orgrangeJson = row.getString("orgrange.entityrange");
                        if (StringUtils.isNotEmpty(orgRange) && orgrangeJson != null && !orgrangeJson.contains("\"pro\"")) {
                            centEntry.getOrgRange().addAll(CentralizedServiceHelper.parseRange(orgRange));
                        } else {
                            rangeMap = parseRangMap.computeIfAbsent(centEntry.getEntryId(), f -> Maps.newHashMap());
                            rangeMap.put(SysDimensionEnum.Entity.getNumber(), orgrangeJson);
                        }
                        String bizRange = row.getString("orgrange.rangenumbers");
                        if (StringUtils.isNotEmpty(bizRange)) {
                            centEntry.getBizRange().addAll(CentralizedServiceHelper.parseRange(bizRange));
                        } else {
                            rangeMap = parseRangMap.computeIfAbsent(centEntry.getEntryId(), f -> Maps.newHashMap());
                            rangeMap.put(centralized.getDimNumber(), row.getString("orgrange.dimensionrange"));
                        }
                    }
                    centralized.getEntries().put(centEntry.getEntryId(), centEntry);
                }
            }
        }
        catch (Throwable throwable) {
            object = throwable;
            throw throwable;
        }
        finally {
            if (ds != null) {
                if (object != null) {
                    try {
                        ds.close();
                    }
                    catch (Throwable throwable) {
                        ((Throwable)object).addSuppressed(throwable);
                    }
                } else {
                    ds.close();
                }
            }
        }
        if (!parseRangMap.isEmpty()) {
            Map<Long, Map<String, Set<String>>> centRangeMap = CentralizedServiceHelper.parse(modelId, busModelId, parseRangMap, centEntryMap, entryMappingMap);
            for (Map.Entry entry : centRangeMap.entrySet()) {
                centEntry = (Centralized.CentEntry)centEntryMap.get(entry.getKey());
                if (centEntry == null) continue;
                centralized = (Centralized)entryMappingMap.get(centEntry.getEntryId());
                for (Map.Entry dimMember : ((Map)entry.getValue()).entrySet()) {
                    if (SysDimensionEnum.Entity.getNumber().equals(dimMember.getKey())) {
                        centEntry.getOrgRange().addAll((Collection)dimMember.getValue());
                        continue;
                    }
                    if (!centralized.getDimNumber().equals(dimMember.getKey())) continue;
                    centEntry.getBizRange().addAll((Collection)dimMember.getValue());
                }
            }
        }
        return new ArrayList<Centralized>(centralizedMap.values());
    }

    private static Map<Long, Map<String, Set<String>>> parse(Long modelId, Long busModelId, Map<Long, Map<String, String>> rangeMap, Map<Long, Centralized.CentEntry> centralizedMap, Map<Long, Centralized> entryMappingMap) {
        if (modelId == null || busModelId == null || rangeMap == null || rangeMap.isEmpty() || centralizedMap == null) {
            return Collections.emptyMap();
        }
        HashMap<Long, Map<String, Set<String>>> centRangeMap = new HashMap<Long, Map<String, Set<String>>>(rangeMap.size());
        IModelCacheHelper modelCacheHelper = ModelCacheContext.getOrCreate(modelId);
        List<Dimension> dimensions = modelCacheHelper.getDimensionList();
        HashMap dimensionMap = Maps.newHashMapWithExpectedSize((int)dimensions.size());
        for (Dimension dimension : dimensions) {
            dimensionMap.put(dimension.getNumber(), dimension);
        }
        Map<String, Long> views = BusinessModelServiceHelper.getViewIds(busModelId, false);
        ArrayList<Object[]> orgParams = new ArrayList<Object[]>(rangeMap.size());
        ArrayList<Object[]> bizParams = new ArrayList<Object[]>(rangeMap.size());
        for (Map.Entry<Long, Map<String, String>> range : rangeMap.entrySet()) {
            Centralized centralized;
            Long entryId = range.getKey();
            Map<String, String> dimRange = range.getValue();
            Centralized.CentEntry entry = centralizedMap.get(entryId);
            if (entry == null || (centralized = entryMappingMap.get(entryId)) == null || dimRange == null || dimRange.isEmpty()) continue;
            orgParams.clear();
            bizParams.clear();
            for (Map.Entry<String, String> dimEntry : dimRange.entrySet()) {
                String[] split;
                Long viewId;
                String dimNumber = dimEntry.getKey();
                String rangeStr = dimEntry.getValue();
                Dimension dimension = (Dimension)dimensionMap.get(dimNumber);
                Long l = viewId = views != null ? views.get(dimNumber) : null;
                if (rangeStr == null || (split = rangeStr.split("@")) == null || split.length == 0) continue;
                LinkedHashSet all = Sets.newLinkedHashSet();
                ArrayList<Long> propertyIds = new ArrayList<Long>(16);
                for (String value : split) {
                    Member member;
                    Map _rangeMap = (Map)JSON.parse((String)value);
                    if (_rangeMap == null) continue;
                    if (_rangeMap.containsKey("pro") && _rangeMap.containsKey("id")) {
                        propertyIds.add(IDUtils.toLong(_rangeMap.get("id")));
                        continue;
                    }
                    String rangeNumber = (String)_rangeMap.get("number");
                    if (!StringUtils.isNotEmpty(rangeNumber) || (member = modelCacheHelper.getMemberByAnyView(dimNumber, rangeNumber)) == null) continue;
                    List<Member> members = member.getAllMembers();
                    all.addAll(members.stream().map(BaseCache::getNumber).collect(Collectors.toSet()));
                }
                if (!propertyIds.isEmpty()) {
                    all.addAll(CentralizedServiceHelper.getOrgNumber(propertyIds, dimension.getId()));
                }
                if (!all.isEmpty()) {
                    if (SysDimensionEnum.Entity.getNumber().equals(dimNumber)) {
                        orgParams.add(new Object[]{String.join((CharSequence)",", new HashSet(all)), entryId});
                    } else {
                        bizParams.add(new Object[]{String.join((CharSequence)",", new HashSet(all)), entryId});
                    }
                }
                Map dimMember = centRangeMap.computeIfAbsent(entryId, f -> Maps.newHashMap());
                dimMember.put(dimNumber, all);
            }
            if (orgParams.size() <= 0 && bizParams.size() <= 0) continue;
            TXHandle th = TX.requiresNew();
            Throwable throwable = null;
            try {
                try {
                    if (SysDimensionEnum.Entity.getNumber().equals(centralized.getDimNumber())) {
                        if (orgParams.isEmpty()) continue;
                        DB.executeBatch((DBRoute)BgBaseConstant.epm, (String)"update t_eb_centralized_range set frangenumbers = ?, fentityrangenumbers = ' ' where fentryid = ?", orgParams);
                        continue;
                    }
                    if (!bizParams.isEmpty()) {
                        DB.executeBatch((DBRoute)BgBaseConstant.epm, (String)"update t_eb_centralized_range set frangenumbers = ? where fentryid = ?", bizParams);
                    }
                    if (orgParams.isEmpty()) continue;
                    DB.executeBatch((DBRoute)BgBaseConstant.epm, (String)"update t_eb_centralized_range set fentityrangenumbers = ? where fentryid = ?", orgParams);
                }
                catch (Exception ex) {
                    th.markRollback();
                    throw new KDBizException(ex.getMessage());
                }
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                if (th == null) continue;
                if (throwable != null) {
                    try {
                        th.close();
                    }
                    catch (Throwable throwable3) {
                        throwable.addSuppressed(throwable3);
                    }
                    continue;
                }
                th.close();
            }
        }
        return centRangeMap;
    }

    private static Set<String> parseAccount(String accountStr, Map<String, Set<String>> cacheMap, LogStats stats) {
        if (StringUtils.isEmpty(accountStr) || cacheMap == null || stats == null) {
            return null;
        }
        Set numbers = cacheMap.computeIfAbsent(accountStr, f -> {
            LinkedHashSet _numbers = Sets.newLinkedHashSet();
            String[] accounts = accountStr.split("@");
            if (accounts != null) {
                for (String account : accounts) {
                    if (StringUtils.isEmpty(account)) continue;
                    try {
                        String _account;
                        Map objMap = JSONUtils.parse(account, Map.class);
                        if (objMap == null || !StringUtils.isNotEmpty(_account = (String)objMap.get("number"))) continue;
                        _numbers.add(_account);
                    }
                    catch (Throwable ex) {
                        stats.addInfo("parse-error:" + account);
                    }
                }
            }
            return _numbers;
        });
        return numbers;
    }

    private static String[] parseCentOrgMember(Row row) {
        if (row != null) {
            String[] member = new String[]{row.getString("orgrange.entity"), row.getString("orgrange.entity.name"), row.getString("orgrange.entity.number")};
            return member;
        }
        return null;
    }

    private static Set<String> parseRange(String range) {
        if (range == null) {
            return null;
        }
        Object[] tmpStr = range.split(",");
        return tmpStr != null && tmpStr.length > 0 ? Sets.newHashSet((Object[])tmpStr) : null;
    }

    private static List<String> getOrgNumber(List<Long> propertyIds, Long dimensionId) {
        ArrayList<String> orgNumbers = new ArrayList<String>();
        StringBuilder sql = new StringBuilder("select a.fnumber ,b.fpropertyvalueid,c.fnumber as propvaluenumber from t_eb_structofent a,t_eb_memberpropertyvalue b,t_eb_custompropertyvalue c ");
        sql.append("where a.fid = b.fid and b.fpropertyvalueid = c.fid and a.fdimensionid = ");
        sql.append(dimensionId);
        sql.append(" and b.fpropertyvalueid in (");
        sql.append(StringUtils.join(propertyIds, ","));
        sql.append(")");
        try (DataSet ds = DB.queryDataSet((String)"dimensionpropertyById", (DBRoute)DBRoute.of((String)"epm"), (String)sql.toString(), null);){
            if (ds != null) {
                Row row = null;
                while (ds.hasNext()) {
                    row = ds.next();
                    orgNumbers.add(row.getString("fnumber") + "#" + row.getString("propvaluenumber"));
                }
            }
        }
        return orgNumbers;
    }
}

