/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.common.utils;

import java.util.HashMap;
import java.util.Map;
import kd.bos.algo.DataSet;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.epm.eb.common.enums.SysDimensionEnum;
import kd.epm.eb.common.model.BizModel;
import kd.epm.eb.common.model.Dimension;
import kd.epm.eb.common.model.Member;
import kd.epm.eb.common.utils.CommonServiceHelper;
import kd.epm.eb.common.utils.QFBuilder;
import kd.epm.eb.common.utils.StringUtils;

public class ChangeTypeServiceHelper {
    public static final String FIELDS = "id, number, name, isleaf, dimension.id, dimension.name, dimension.number, dimension.shortnumber, dimension.dseq, dimension.fieldmapped";

    public static Member loadChangeType(Map<String, Object> object) {
        if (object == null) {
            return null;
        }
        Member changeType = new Member((Long)object.get("id"));
        changeType.setNumber((String)object.get("number"));
        changeType.setName((String)object.get("name"));
        changeType.setLongNumber((String)object.get("longnumber"));
        changeType.setLeaf((Boolean)object.get("isleaf"));
        Dimension dimension = new Dimension((Long)object.get("dimension.id"));
        dimension.setNumber((String)object.get("dimension.number"));
        dimension.setName((String)object.get("dimension.name"));
        changeType.setDimension(dimension);
        return changeType;
    }

    public static Map<String, Object> getOccupy(BizModel model) {
        return ChangeTypeServiceHelper.queryChangeType(model, "Occupation", FIELDS);
    }

    public static Map<String, Object> getExecuted(BizModel model) {
        return ChangeTypeServiceHelper.queryChangeType(model, "Execute", FIELDS);
    }

    public static DynamicObject getOccupyObj(BizModel model) {
        return ChangeTypeServiceHelper.queryChangeTypeObj(model, "Occupation", FIELDS);
    }

    public static DynamicObject getExecutedObj(BizModel model) {
        return ChangeTypeServiceHelper.queryChangeTypeObj(model, "Execute", FIELDS);
    }

    public static Map<String, Object> queryChangeType(BizModel model, String number, String fields) {
        if (model == null || StringUtils.isEmpty(number)) {
            return null;
        }
        QFBuilder builder = new QFBuilder();
        builder.add(new QFilter("model", "=", (Object)model.getId()));
        builder.add(new QFilter("number", "=", (Object)number));
        Map<String, Object> changeType = null;
        String memberModel = SysDimensionEnum.ChangeType.getMemberTreemodel();
        Dimension dimension = model.getDimension(SysDimensionEnum.ChangeType.getNumber());
        if (dimension != null) {
            memberModel = dimension.getMemberModel();
        }
        try (DataSet ds = QueryServiceHelper.queryDataSet((String)"queryChangeType", (String)memberModel, (String)(StringUtils.isEmpty(fields) ? FIELDS : fields), (QFilter[])builder.toArrays(), null, (int)1);){
            changeType = CommonServiceHelper.transDataMap(ds);
        }
        return changeType;
    }

    public static DynamicObject queryChangeTypeObj(BizModel model, String number, String fields) {
        if (model == null || model.getId() == null || StringUtils.isEmpty(number)) {
            return null;
        }
        QFBuilder builder = new QFBuilder();
        builder.add(new QFilter("model", "=", (Object)model.getId()));
        builder.add(new QFilter("number", "=", (Object)number));
        Dimension dimension = model.getDimension(SysDimensionEnum.ChangeType.getNumber());
        if (dimension != null) {
            return QueryServiceHelper.queryOne((String)dimension.getMemberModel(), (String)(StringUtils.isEmpty(fields) ? FIELDS : fields), (QFilter[])builder.toArrays());
        }
        return null;
    }

    public static Map<String, Object> getOccupation(BizModel model, Map<Long, Map<String, Map<String, Object>>> changeTypes) {
        if (model == null || model.getId() == null) {
            return null;
        }
        Map changeType = null;
        if (changeTypes != null) {
            Map types = changeTypes.computeIfAbsent(model.getId(), k -> new HashMap());
            changeType = types.computeIfAbsent("Occupation", k -> ChangeTypeServiceHelper.getOccupy(model));
        } else {
            changeType = ChangeTypeServiceHelper.getOccupy(model);
        }
        return changeType;
    }

    public static Map<String, Object> getExecuted(BizModel model, Map<Long, Map<String, Map<String, Object>>> changeTypes) {
        if (model == null || model.getId() == null) {
            return null;
        }
        Map changeType = null;
        if (changeTypes != null) {
            Map types = changeTypes.computeIfAbsent(model.getId(), k -> new HashMap());
            changeType = types.computeIfAbsent("Execute", k -> ChangeTypeServiceHelper.getExecuted(model));
        } else {
            changeType = ChangeTypeServiceHelper.getExecuted(model);
        }
        return changeType;
    }
}

