/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.common.utils;

import java.util.regex.Pattern;

public class ChineseUtil {
    public static boolean hasChinese(String str) {
        char[] ch;
        if (str == null) {
            return false;
        }
        for (char c : ch = str.toCharArray()) {
            if (!ChineseUtil.isChinese(c)) continue;
            return true;
        }
        return false;
    }

    public static boolean isChinese(String str) {
        char[] ch;
        if (str == null) {
            return false;
        }
        for (char c : ch = str.toCharArray()) {
            if (ChineseUtil.isChinese(c)) continue;
            return false;
        }
        return true;
    }

    private static boolean isChinese(char c) {
        Character.UnicodeBlock ub = Character.UnicodeBlock.of(c);
        if (ub == Character.UnicodeBlock.CJK_UNIFIED_IDEOGRAPHS) {
            return true;
        }
        if (ub == Character.UnicodeBlock.CJK_COMPATIBILITY_IDEOGRAPHS) {
            return true;
        }
        if (ub == Character.UnicodeBlock.CJK_SYMBOLS_AND_PUNCTUATION) {
            return true;
        }
        if (ub == Character.UnicodeBlock.CJK_UNIFIED_IDEOGRAPHS_EXTENSION_A) {
            return true;
        }
        if (ub == Character.UnicodeBlock.CJK_UNIFIED_IDEOGRAPHS_EXTENSION_B) {
            return true;
        }
        if (ub == Character.UnicodeBlock.CJK_UNIFIED_IDEOGRAPHS_EXTENSION_C) {
            return true;
        }
        if (ub == Character.UnicodeBlock.CJK_UNIFIED_IDEOGRAPHS_EXTENSION_D) {
            return true;
        }
        if (ub == Character.UnicodeBlock.GENERAL_PUNCTUATION) {
            return true;
        }
        return ub == Character.UnicodeBlock.HALFWIDTH_AND_FULLWIDTH_FORMS;
    }

    public static boolean hasChineseByReg(String str) {
        if (str == null) {
            return false;
        }
        Pattern pattern = Pattern.compile("[\\u4E00-\\u9FBF]+");
        return pattern.matcher(str).find();
    }

    public static boolean isChineseByReg(String str) {
        if (str == null) {
            return false;
        }
        Pattern pattern = Pattern.compile("[\\u4E00-\\u9FBF]+");
        return pattern.matcher(str).matches();
    }

    public static boolean hasChineseByRange(String str) {
        char[] ch;
        if (str == null) {
            return false;
        }
        for (char c : ch = str.toCharArray()) {
            if (c < '\u4e00' || c > '\u9fbf') continue;
            return true;
        }
        return false;
    }

    public static boolean isChineseByRange(String str) {
        char[] ch;
        if (str == null) {
            return false;
        }
        for (char c : ch = str.toCharArray()) {
            if (c >= '\u4e00' && c <= '\u9fbf') continue;
            return false;
        }
        return true;
    }

    public static boolean isChinesePunctuation(char c) {
        Character.UnicodeBlock ub = Character.UnicodeBlock.of(c);
        return ub == Character.UnicodeBlock.GENERAL_PUNCTUATION || ub == Character.UnicodeBlock.CJK_SYMBOLS_AND_PUNCTUATION || ub == Character.UnicodeBlock.HALFWIDTH_AND_FULLWIDTH_FORMS || ub == Character.UnicodeBlock.CJK_COMPATIBILITY_FORMS || ub == Character.UnicodeBlock.VERTICAL_FORMS;
    }
}

