/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.common.utils;

import java.io.File;
import java.io.IOException;
import java.lang.reflect.Method;
import java.net.JarURLConnection;
import java.net.URL;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.epm.eb.common.utils.StringUtils;

public class ClassUtil {
    private static final Log log = LogFactory.getLog(ClassUtil.class);
    private static final String CLASS_SUFFIX = ".class";
    private static final String CLASS_FILE_PREFIX = File.separator + "classes" + File.separator;
    private static final String PACKAGE_SEPARATOR = ".";

    public static List<String> getClazzName(String packageName, boolean showChildPackageFlag) {
        ArrayList<String> result = new ArrayList<String>();
        String suffixPath = packageName.replaceAll("\\.", "/");
        ClassLoader loader = Thread.currentThread().getContextClassLoader();
        try {
            Enumeration<URL> urls = loader.getResources(suffixPath);
            while (urls.hasMoreElements()) {
                URL url = urls.nextElement();
                if (url == null) continue;
                String protocol = url.getProtocol();
                if ("file".equals(protocol)) {
                    String path = url.getPath();
                    result.addAll(ClassUtil.getAllClassNameByFile(new File(path), showChildPackageFlag));
                    continue;
                }
                if (!"jar".equals(protocol)) continue;
                JarFile jarFile = null;
                try {
                    jarFile = ((JarURLConnection)url.openConnection()).getJarFile();
                }
                catch (Exception exception) {
                    // empty catch block
                }
                if (jarFile == null) continue;
                result.addAll(ClassUtil.getAllClassNameByJar(jarFile, packageName, showChildPackageFlag));
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return result;
    }

    private static List<String> getAllClassNameByFile(File file, boolean flag) {
        ArrayList<String> result = new ArrayList<String>();
        if (!file.exists()) {
            return result;
        }
        if (file.isFile()) {
            String clazzName;
            String path = file.getPath();
            if (path.endsWith(CLASS_SUFFIX) && -1 == (clazzName = (path = path.replace(CLASS_SUFFIX, "")).substring(path.indexOf(CLASS_FILE_PREFIX) + CLASS_FILE_PREFIX.length()).replace(File.separator, PACKAGE_SEPARATOR)).indexOf("$")) {
                result.add(clazzName);
            }
            return result;
        }
        File[] listFiles = file.listFiles();
        if (listFiles != null && listFiles.length > 0) {
            for (File f : listFiles) {
                String clazzName;
                String path;
                if (flag) {
                    result.addAll(ClassUtil.getAllClassNameByFile(f, flag));
                    continue;
                }
                if (!f.isFile() || !(path = f.getPath()).endsWith(CLASS_SUFFIX) || -1 != (clazzName = (path = path.replace(CLASS_SUFFIX, "")).substring(path.indexOf(CLASS_FILE_PREFIX) + CLASS_FILE_PREFIX.length()).replace(File.separator, PACKAGE_SEPARATOR)).indexOf("$")) continue;
                result.add(clazzName);
            }
        }
        return result;
    }

    private static List<String> getAllClassNameByJar(JarFile jarFile, String packageName, boolean flag) {
        ArrayList<String> result = new ArrayList<String>();
        Enumeration<JarEntry> entries = jarFile.entries();
        while (entries.hasMoreElements()) {
            JarEntry jarEntry = entries.nextElement();
            String name = jarEntry.getName();
            if (!name.endsWith(CLASS_SUFFIX)) continue;
            name = name.replace(CLASS_SUFFIX, "").replace("/", PACKAGE_SEPARATOR);
            if (flag) {
                if (!name.startsWith(packageName) || -1 != name.indexOf("$")) continue;
                result.add(name);
                continue;
            }
            if (!packageName.equals(name.substring(0, name.lastIndexOf(PACKAGE_SEPARATOR))) || -1 != name.indexOf("$")) continue;
            result.add(name);
        }
        return result;
    }

    public static void executeMethod(Object object, String methodName, Class<?>[] parameterTypes, Object[] parameter) {
        if (object == null || StringUtils.isEmpty(methodName)) {
            return;
        }
        try {
            Method method = object.getClass().getMethod(methodName, parameterTypes);
            method.invoke(object, parameter);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }
}

