/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.common.utils;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public final class CollectionUtils {
    public static boolean isEmpty(Collection<?> colls) {
        return colls == null || colls.isEmpty();
    }

    public static boolean isEmpty(Map<?, ?> colls) {
        return colls == null || colls.isEmpty();
    }

    public static boolean isEmpty(Object ... colls) {
        if (colls == null || colls.length == 0) {
            return true;
        }
        for (Object _str : colls) {
            if (_str != null) continue;
            return true;
        }
        return false;
    }

    public static boolean isNotEmpty(Collection<?> colls) {
        return !CollectionUtils.isEmpty(colls);
    }

    public static boolean isNotEmpty(Map<?, ?> colls) {
        return !CollectionUtils.isEmpty(colls);
    }

    public static <T> List<T> asList(T ... objects) {
        if (objects == null || objects.length == 0) {
            return Collections.emptyList();
        }
        return Stream.of(objects).collect(Collectors.toList());
    }

    public static <T> List<T> asList(Collection<T> objects) {
        if (objects == null || objects.isEmpty()) {
            return Collections.emptyList();
        }
        return new ArrayList<T>(objects);
    }

    public static <T> List<T> asList(Collection<T> ... objects) {
        if (objects == null || objects.length == 0) {
            return Collections.emptyList();
        }
        LinkedList<T> tmpList = new LinkedList<T>();
        for (Collection<T> entry : objects) {
            tmpList.addAll(entry);
        }
        return tmpList;
    }

    public static <T> List<T> asListByCollection(Collection<List<T>> objects) {
        if (objects == null || objects.isEmpty()) {
            return Collections.emptyList();
        }
        LinkedList _tmpLists = Lists.newLinkedList();
        objects.forEach(_tmpLists::addAll);
        return _tmpLists;
    }

    public static <T> Set<T> asSet(T ... objects) {
        if (objects == null || objects.length == 0) {
            return Collections.emptySet();
        }
        return Stream.of(objects).collect(Collectors.toSet());
    }

    public static <K, V> Map<K, V> asMap(K key, V value) {
        HashMap<K, V> map = new HashMap<K, V>();
        map.put(key, value);
        return map;
    }

    public static boolean includeByStarts(String str, Collection<String> collection) {
        if (CollectionUtils.isEmpty(str) || CollectionUtils.isEmpty(collection)) {
            return false;
        }
        for (String _str : collection) {
            if (!str.startsWith(_str)) continue;
            return true;
        }
        return false;
    }

    public static boolean include(Map<?, ?> includeMap, Map<?, ?> distMap) {
        if (includeMap == null || distMap == null) {
            return false;
        }
        boolean isInclude = true;
        for (Map.Entry<?, ?> entry : includeMap.entrySet()) {
            Object object = distMap.get(entry.getKey());
            if (object != entry.getValue()) {
                isInclude = entry.getValue() instanceof Collection ? CollectionUtils.include((Collection)entry.getValue(), object) : false;
            }
            if (isInclude) continue;
            break;
        }
        return isInclude;
    }

    public static boolean includeByIgn(Map<?, ?> includeMap, Map<?, ?> distMap) {
        if (includeMap == null || distMap == null) {
            return false;
        }
        boolean isInclude = true;
        for (Map.Entry<?, ?> entry : includeMap.entrySet()) {
            if (!distMap.containsKey(entry.getKey())) continue;
            Object object = distMap.get(entry.getKey());
            if (object != entry.getValue()) {
                isInclude = entry.getValue() == null || object == null ? false : (entry.getValue() instanceof Collection ? CollectionUtils.include((Collection)entry.getValue(), object) : (entry.getValue() instanceof Comparable && object instanceof Comparable ? ((Comparable)entry.getValue()).compareTo(object) == 0 : entry.getValue().equals(object)));
            }
            if (isInclude) continue;
            break;
        }
        return isInclude;
    }

    public static boolean include(Collection<?> includes, Object distObject) {
        return includes.contains(distObject);
    }

    public static boolean include(Collection<?> includes, Collection<?> destObjects) {
        if (includes == null || destObjects == null) {
            return false;
        }
        boolean include = false;
        Iterator<?> iterator = destObjects.iterator();
        while (!include && iterator.hasNext()) {
            include = includes.contains(iterator.next());
        }
        return include;
    }

    public static <K, V> Map<K, V> merge(Map<K, V> dest, Map<K, V> src) {
        if (dest == null || src == null || src.isEmpty()) {
            return dest;
        }
        for (Map.Entry<K, V> entry : src.entrySet()) {
            V value = dest.get(entry.getKey());
            if (value == null) {
                dest.put(entry.getKey(), entry.getValue());
                continue;
            }
            if (!(value instanceof Collection) || !(entry.getValue() instanceof Collection)) continue;
            ((Collection)value).addAll((Collection)entry.getValue());
        }
        return dest;
    }

    public static <K, V> Map<K, V> retainAll(Map<K, V> src, Collection<K> dest) {
        if (src == null || src.isEmpty() || dest == null || dest.isEmpty()) {
            return Collections.emptyMap();
        }
        HashMap _filter = Maps.newHashMapWithExpectedSize((int)src.size());
        for (Map.Entry<K, V> entry : src.entrySet()) {
            if (dest.contains(entry.getKey())) continue;
            _filter.put(entry.getKey(), entry.getValue());
        }
        return _filter;
    }

    public static boolean equals(Collection value1, Collection value2) {
        if (value1 == value2) {
            return true;
        }
        if (value1 == null || value2 == null) {
            return false;
        }
        return value1.size() == value2.size() && value1.containsAll(value2);
    }

    public static boolean equals(Map<?, ?> value1, Map<?, ?> value2) {
        if (value1 != null && value2 != null) {
            return value1.equals(value2);
        }
        return CollectionUtils.isEmpty(value1) && CollectionUtils.isEmpty(value2);
    }

    public static boolean notEquals(Map<?, ?> value1, Map<?, ?> value2) {
        return !CollectionUtils.equals(value1, value2);
    }

    public static int[] getBase(List<Integer> colls) {
        if (colls == null || colls.isEmpty()) {
            return new int[0];
        }
        int[] _rows = new int[colls.size()];
        int in = colls.size();
        for (int i = 0; i < in; ++i) {
            _rows[i] = colls.get(i);
        }
        return _rows;
    }
}

