/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.common.utils;

import java.util.Arrays;
import java.util.Date;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.epm.eb.common.bgmddatalock.BgmdDataLockService;
import kd.epm.eb.common.bgmddatalock.IBgmdDataLockCache;
import kd.epm.eb.common.cache.IModelCacheHelper;
import kd.epm.eb.common.cache.impl.Dimension;
import kd.epm.eb.common.cache.impl.Member;
import kd.epm.eb.common.enums.ApplicationScenarioEnum;
import kd.epm.eb.common.enums.AuditTrailUseEnum;
import kd.epm.eb.common.enums.SysDimensionEnum;

public class CommonCheckUtil {
    private static Log log = LogFactory.getLog(CommonCheckUtil.class);

    public static boolean checkDataLock(Long modelId, Long bizModelId, Map<String, String> dimenData) {
        IBgmdDataLockCache dataLockCache = BgmdDataLockService.getInstance().getDataLockCache(modelId, bizModelId);
        return dataLockCache.isDataLock(dimenData);
    }

    public static boolean checkRollBudget(Long modelId, Map<String, String> dimenData) {
        DynamicObject dataType = CommonCheckUtil.getDynamicObjectByNumber(modelId, dimenData.get(SysDimensionEnum.DataType.getNumber()), SysDimensionEnum.DataType.getMemberTreemodel());
        String bizModelKey = "bizmodel";
        if (dataType == null || dataType.get(bizModelKey) == null) {
            return false;
        }
        DynamicObject bizmodel = dataType.getDynamicObject(bizModelKey);
        if (bizmodel == null || bizmodel.get("number") == null) {
            return false;
        }
        String bizModelNumber = bizmodel.getString("number");
        if (ApplicationScenarioEnum.ROLLBUDGET.getNumber().equals(bizModelNumber)) {
            Date rollDateStart = dataType.getDate("datestart");
            DynamicObject budgetPeriod = CommonCheckUtil.getDynamicObjectByNumber(modelId, dimenData.get(SysDimensionEnum.BudgetPeriod.getNumber()), SysDimensionEnum.BudgetPeriod.getMemberTreemodel());
            Date enddate = budgetPeriod.getDate("enddate");
            boolean isRoll = enddate != null && enddate.before(rollDateStart);
            return isRoll;
        }
        return false;
    }

    public static boolean checkChangeType(Map<String, String> dimenData) {
        if (dimenData == null) {
            return false;
        }
        String changeTypeMemberNumber = dimenData.get(SysDimensionEnum.ChangeType.getNumber());
        if (StringUtils.isBlank((CharSequence)changeTypeMemberNumber)) {
            return false;
        }
        List<String> noAdjust = Arrays.asList("EBChanges", "Occupation", "Execute");
        return noAdjust.contains(changeTypeMemberNumber);
    }

    public static boolean checkAuditTrailUse(IModelCacheHelper modelCacheHelper, Map<String, String> dimenData, AuditTrailUseEnum useEnum) {
        if (dimenData == null || dimenData.isEmpty()) {
            return false;
        }
        String auditTrailNumber = dimenData.get(SysDimensionEnum.AuditTrail.getNumber());
        if (StringUtils.isBlank((CharSequence)auditTrailNumber)) {
            return false;
        }
        Member member = modelCacheHelper.getMember(SysDimensionEnum.AuditTrail.getNumber(), null, auditTrailNumber);
        if (member == null) {
            return false;
        }
        AuditTrailUseEnum trailUseEnum = AuditTrailUseEnum.loadAuditTrailUseEnumByCode(member.getUse());
        if (trailUseEnum == null) {
            trailUseEnum = AuditTrailUseEnum.loadAuditTrailUseEnumByCode(member.getAuditTrailUse());
        }
        return useEnum == trailUseEnum;
    }

    public static DynamicObject getDynamicObjectByNumber(Long modelId, Object number, String entityName) {
        QFilter modelFilter = new QFilter("model", "=", (Object)modelId);
        QFilter numberFilter = new QFilter("number", "=", number);
        return BusinessDataServiceHelper.loadSingleFromCache((String)entityName, (QFilter[])new QFilter[]{modelFilter, numberFilter});
    }

    public static boolean checkCanCutOrDelete(IModelCacheHelper modelCacheHelper, String memberNumber) {
        Dimension dimension = modelCacheHelper.getDimension(SysDimensionEnum.AuditTrail.getNumber());
        Member member = dimension.getMember(null, memberNumber);
        String use = member.getAuditTrailUse();
        if (AuditTrailUseEnum.REPORT_EDIT.getCode().equals(use)) {
            Member parentMember = dimension.getMember(null, member.getParentNumber());
            List<Member> children = parentMember.getChildren();
            int reportEditCount = 0;
            int decomposeCount = 0;
            for (Member child : children) {
                if (AuditTrailUseEnum.REPORT_EDIT.getCode().equals(child.getAuditTrailUse())) {
                    ++reportEditCount;
                    continue;
                }
                if (!AuditTrailUseEnum.DECOMPOSE.getCode().equals(child.getAuditTrailUse())) continue;
                ++decomposeCount;
            }
            return decomposeCount <= 0 || reportEditCount != 1;
        }
        return true;
    }
}

