/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.common.utils;

import com.alibaba.fastjson.JSON;
import java.util.Collection;
import java.util.EventObject;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Supplier;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.OrmLocaleValue;
import kd.bos.dataentity.resource.promptenum.MultiLangEnumBridge;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.IPageCache;
import kd.bos.form.control.Control;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.Search;
import kd.bos.form.control.TreeView;
import kd.bos.form.control.events.SearchEnterListener;
import kd.bos.form.control.events.TreeNodeClickListener;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.events.AfterF7SelectListener;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.list.BillList;
import kd.epm.eb.common.cache.IModelCacheHelper;
import kd.epm.eb.common.cache.ModelCacheContext;
import kd.epm.eb.common.utils.NewEbAppUtil;
import kd.epm.eb.common.utils.OperationLogUtil;
import kd.epm.eb.common.utils.StringUtils;

public interface CommonMethod {
    default public void addF7SelectListener(BeforeF7SelectListener listener, String ... keys) {
        IFormView iFormView = this.getView();
        if (iFormView != null) {
            for (String key : keys) {
                BasedataEdit basedataEdit = (BasedataEdit)iFormView.getControl(key);
                if (basedataEdit == null) continue;
                basedataEdit.addBeforeF7SelectListener(listener);
            }
        }
    }

    default public void addAfterF7SelectListener(AfterF7SelectListener listener, String ... controlKeys) {
        IFormView iFormView = this.getView();
        if (iFormView != null) {
            for (String controlKey : controlKeys) {
                BasedataEdit basedataEdit = (BasedataEdit)iFormView.getControl(controlKey);
                if (basedataEdit == null) continue;
                basedataEdit.addAfterF7SelectListener(listener);
            }
        }
    }

    default public void addSearchListener(SearchEnterListener searchEnterListener, String ... keys) {
        IFormView iFormView = this.getView();
        if (iFormView != null) {
            for (String key : keys) {
                Search searchCtrl = (Search)iFormView.getControl(key);
                if (searchCtrl == null) continue;
                searchCtrl.addEnterListener(searchEnterListener);
            }
        }
    }

    default public void addTreeNodeClickListener(TreeNodeClickListener listener, String key) {
        TreeView treeView;
        IFormView iFormView = this.getView();
        if (iFormView != null && (treeView = (TreeView)iFormView.getControl(key)) != null) {
            treeView.addTreeNodeClickListener(listener);
        }
    }

    default public <T> T getValue(String key, String propName) {
        IDataModel dataModel = this.getView().getModel();
        Object val = dataModel.getValue(key);
        if (propName != null) {
            if (val instanceof OrmLocaleValue && "string".equals(propName)) {
                val = ((OrmLocaleValue)val).getLocaleValue();
            } else if (val instanceof DynamicObject) {
                val = ((DynamicObject)val).get(propName);
            }
        }
        return (T)val;
    }

    default public <T> T getEntryValue(String key, String propName, int row) {
        return this.getEntryValue("", key, propName, row);
    }

    default public <T> T getFocusEntryValue(String entryKey, String key, String propName) {
        return this.getEntryValue(entryKey, key, propName, -1);
    }

    default public <T> T getEntryValue(String entryKey, String key, String propName, int row) {
        if (row == -1) {
            EntryGrid entryGrid = (EntryGrid)this.getView().getControl(entryKey);
            row = entryGrid == null ? 0 : entryGrid.getEntryState().getFocusRow();
        }
        IDataModel dataModel = this.getView().getModel();
        Object val = dataModel.getValue(key, row);
        if (propName != null) {
            if (val instanceof OrmLocaleValue && "string".equals(propName)) {
                val = ((OrmLocaleValue)val).getLocaleValue();
            } else if (val instanceof DynamicObject) {
                val = ((DynamicObject)val).get(propName);
            }
        }
        return (T)val;
    }

    default public IModelCacheHelper getIModelCacheHelper() {
        return ModelCacheContext.getOrCreate(this.getModelId());
    }

    default public Long getModelId() {
        return 0L;
    }

    public IFormView getView();

    public IPageCache getPageCache();

    default public <T> T getCustomFormParam(String paramName) {
        return (T)this.getView().getFormShowParameter().getCustomParam(paramName);
    }

    default public void removeCache(String cacheKey) {
        this.getPageCache().remove(cacheKey);
    }

    default public <T> void putCache(String cacheKey, T t) {
        String jsonStr = SerializationUtils.toJsonString(t);
        this.getPageCache().put(cacheKey, jsonStr);
    }

    default public <T> T getCache(String cacheKey, Class<?> valueType, Supplier<T> defaultValue) {
        IPageCache pageCache = this.getPageCache();
        if (pageCache == null) {
            return defaultValue.get();
        }
        String content = pageCache.get(cacheKey);
        if (StringUtils.isEmpty(content)) {
            return defaultValue.get();
        }
        return (T)SerializationUtils.fromJsonString((String)content, valueType);
    }

    default public <T> T getCache(String cacheKey, Class<?> valueType) {
        return (T)this.getCache(cacheKey, valueType, () -> null);
    }

    default public <T> void putBase64Cache(String cacheKey, T t) {
        String toBase64 = SerializationUtils.serializeToBase64(t);
        this.getPageCache().put(cacheKey, toBase64);
    }

    default public <T> T getBase64Cache(String cacheKey) {
        return (T)this.getBase64Cache(cacheKey, () -> null);
    }

    default public <T> T getBase64Cache(String cacheKey, Supplier<T> defaultValue) {
        IPageCache pageCache = this.getPageCache();
        if (pageCache == null) {
            return defaultValue.get();
        }
        String content = pageCache.get(cacheKey);
        if (StringUtils.isEmpty(content)) {
            return defaultValue.get();
        }
        return (T)SerializationUtils.deSerializeFromBase64((String)content);
    }

    default public boolean isEmptyStr(String str) {
        return StringUtils.isEmpty(str);
    }

    default public boolean isEmptyColl(Collection collection) {
        return collection == null || collection.isEmpty();
    }

    default public boolean isNotEmptyColl(Collection collection) {
        return !this.isEmptyColl(collection);
    }

    default public boolean isEmpty(Object value) {
        if (value == null) {
            return true;
        }
        if (value instanceof String) {
            return StringUtils.isEmpty((String)value);
        }
        if (value instanceof Long) {
            return value.equals(0L);
        }
        if (value instanceof Collection) {
            return ((Collection)value).isEmpty();
        }
        if (value instanceof Map) {
            return ((Map)value).isEmpty();
        }
        return false;
    }

    default public boolean notEmpty(Object value) {
        return !this.isEmpty(value);
    }

    default public void setBgMarkOnSetView(IFormView formView) {
        IPageCache pageCache = formView.getPageCache();
        String newEbFormSing = pageCache.get("newEbForm");
        if (StringUtils.isNotEmpty(newEbFormSing)) {
            return;
        }
        boolean isNewEbForm = NewEbAppUtil.isNewEbApp(formView);
        this.markNewEbForm(isNewEbForm);
    }

    default public boolean isNewEbForm() {
        boolean result = false;
        IFormView view = this.getView();
        if (view != null) {
            String formSign = this.getView().getPageCache().get("newEbForm");
            result = "true".equals(formSign);
        }
        return result;
    }

    default public String getBizCtrlRangeKey() {
        return "";
    }

    default public String getBizModelKey() {
        return "";
    }

    default public String getModelFieldKey() {
        return "";
    }

    default public void setBgDefaultField() {
        boolean triggerPropChange = this.triggerPropChange();
        this.setBgDefaultField(triggerPropChange, false);
    }

    default public void setBgDefaultField(boolean triggerPropChange, boolean ignoreAfter) {
        if (this.isNewEbForm()) {
            String bizCtrlRangeKey = this.getBizCtrlRangeKey();
            this.setBgDefaultBCR(bizCtrlRangeKey, triggerPropChange);
            String bizModelKey = this.getBizModelKey();
            this.setBgDefaultBM(bizModelKey, triggerPropChange);
            this.getView().getModel().setDataChanged(false);
            if (!ignoreAfter) {
                this.afterSetBgDefaultField();
            }
        }
    }

    default public void setBgDefaultBCR(String fieldKey, boolean triggerPropChange) {
        this.setBgDefaultFieldVal("eb_businessmodel", fieldKey, triggerPropChange);
    }

    default public void setBgDefaultBM(String fieldKey, boolean triggerPropChange) {
        this.setBgDefaultFieldVal("eb_dataset", fieldKey, triggerPropChange);
    }

    default public void setBgDefaultFieldVal(String baseDataFormKey, String fieldKey, boolean triggerPropChange) {
        if (StringUtils.isNotEmpty(fieldKey)) {
            Long modelId = this.getModelId();
            IFormView formView = this.getView();
            DynamicObject dataEntity = formView.getModel().getDataEntity();
            Object currentVal = dataEntity.get(fieldKey);
            formView.setVisible(Boolean.valueOf(false), new String[]{fieldKey});
            if (currentVal == null) {
                DynamicObject val = NewEbAppUtil.getDefaultObj(baseDataFormKey, modelId);
                if (triggerPropChange) {
                    formView.getModel().setValue(fieldKey, (Object)val);
                } else {
                    dataEntity.set(fieldKey, (Object)val);
                }
            }
        }
    }

    default public void afterSetBgDefaultField() {
    }

    default public boolean triggerPropChange() {
        return false;
    }

    default public void markNewEbForm(boolean isNewEbForm) {
        this.getView().getPageCache().put("newEbForm", String.valueOf(isNewEbForm));
    }

    default public void setBgMarkBeforeBindData() {
        String modelFieldKey = this.getModelFieldKey();
        if (this.notEmpty(modelFieldKey) && !this.isNewEbForm() && NewEbAppUtil.isNewEbModel(this.getModelId())) {
            this.markNewEbForm(true);
        }
    }

    default public void dealModelChanged4Bg(PropertyChangedArgs args) {
        String modelFieldKey = this.getModelFieldKey();
        String propertyName = args.getProperty().getName();
        if (this.notEmpty(modelFieldKey) && modelFieldKey.equals(propertyName)) {
            long modelId = 0L;
            Object newValue = args.getChangeSet()[0].getNewValue();
            if (newValue != null) {
                modelId = ((DynamicObject)newValue).getLong("id");
            }
            Long newModelId = args.getChangeSet()[0].getOldValue() == null ? 0L : modelId;
            boolean preIsNewEbForm = this.isNewEbForm();
            boolean nowIsNewEbForm = NewEbAppUtil.isNewEbModel(newModelId);
            if (nowIsNewEbForm) {
                if (!preIsNewEbForm) {
                    this.markNewEbForm(true);
                }
                this.setBgDefaultField(true, true);
            } else if (preIsNewEbForm && newModelId != 0L) {
                this.markNewEbForm(false);
                String bizCtrlRangeKey = this.getBizCtrlRangeKey();
                String bizModelKey = this.getBizModelKey();
                this.getView().setVisible(Boolean.valueOf(true), new String[]{bizCtrlRangeKey, bizModelKey});
            }
        }
    }

    default public void addSpecialParam(FormShowParameter formShowParameter) {
        Object specialAppId = this.getView().getFormShowParameter().getCustomParam("app_special");
        if (specialAppId != null) {
            formShowParameter.setCustomParam("app_special", specialAppId);
        }
    }

    default public boolean existSpecialParam() {
        Object specialAppId = this.getView().getFormShowParameter().getCustomParam("app_special");
        return specialAppId != null;
    }

    default public String getClickCtrlKey(EventObject evt) {
        return ((Control)evt.getSource()).getKey();
    }

    default public <T> T getOrCacheObjWithDef(T obj, T globalObj, String cacheKey, boolean byJson, Class<?> objClass, boolean isBigObject) {
        if ((obj = this.getOrCacheObj(obj, globalObj, cacheKey, byJson, objClass, isBigObject)) == null) {
            try {
                obj = objClass.newInstance();
            }
            catch (IllegalAccessException | InstantiationException e) {
                throw new RuntimeException(e);
            }
        }
        return obj;
    }

    default public <T> T getOrCacheObj(T obj, T globalObj, String cacheKey, boolean byJson, Class<?> objClass, boolean isBigObject) {
        if (obj == null) {
            if (globalObj == null) {
                String cacheStr = isBigObject ? this.getView().getPageCache().getBigObject(cacheKey) : this.getView().getPageCache().get(cacheKey);
                if (this.notEmpty(cacheStr)) {
                    obj = byJson ? SerializationUtils.fromJsonString((String)cacheStr, objClass) : SerializationUtils.deSerializeFromBase64((String)cacheStr);
                }
            } else {
                obj = globalObj;
            }
        } else {
            String cacheStr = byJson ? JSON.toJSONString(obj) : SerializationUtils.serializeToBase64(obj);
            if (isBigObject) {
                this.getView().getPageCache().putBigObject(cacheKey, cacheStr);
            } else {
                this.getView().getPageCache().put(cacheKey, cacheStr);
            }
        }
        return obj;
    }

    default public void addObjOpLog(String opName, MultiLangEnumBridge opNameBridge, Object numberListInfo) {
        String formNumber = this.getBaseFormKey();
        this.addObjOpLog(formNumber, opName, opNameBridge, numberListInfo);
    }

    default public void addObjOpLog(String formNumber, String opName, MultiLangEnumBridge opNameBridge, Object numberListInfo) {
        IFormView view;
        String numStr = numberListInfo == null ? "" : numberListInfo.toString();
        String bizAppId = this.getBizAppId();
        if (this.isEmpty(bizAppId) && (view = this.getView()) != null) {
            bizAppId = view.getFormShowParameter().getFormConfig().getBizAppNumber();
        }
        MultiLangEnumBridge opDescBridge = new MultiLangEnumBridge("\u7f16\u53f7%1$s\uff0c%2$s\u6210\u529f\u3002", "CommonMethod_0", "epm-eb-common");
        OperationLogUtil.log(bizAppId, formNumber, "", "", opNameBridge, opDescBridge, new String[]{numStr, opName});
    }

    default public String getBaseFormKey() {
        IFormView view = this.getView();
        if (view == null) {
            return "";
        }
        Control billListAp = view.getControl("billlistap");
        String formNumber = billListAp instanceof BillList ? ((BillList)billListAp).getEntityId() : view.getFormShowParameter().getFormId();
        return formNumber;
    }

    default public String getBizAppId() {
        return "eb";
    }

    default public void cacheDimViewId(Long viewId, String f7Key) {
        boolean updated = false;
        Map<String, Long> viewIdKeyMap = this.getDimViewIdsFromCache();
        if (this.isEmpty(viewId)) {
            if (viewIdKeyMap.remove(f7Key) != null) {
                updated = true;
            }
        } else {
            viewIdKeyMap.put(f7Key, viewId);
            updated = true;
        }
        if (updated) {
            this.cacheDimViewIds(viewIdKeyMap);
        }
    }

    default public void cacheDimViewIds(Map<String, Long> viewIdKeyMap) {
        if (this.notEmpty(viewIdKeyMap)) {
            this.getView().getPageCache().put("DimViewIdF7KeyMap", SerializationUtils.toJsonString(viewIdKeyMap));
        }
    }

    default public Long getDimViewIdFromCache(String f7Key) {
        return this.getDimViewIdsFromCache().get(f7Key);
    }

    default public Map<String, Long> getDimViewIdsFromCache() {
        IFormView view = this.getView();
        String paramStr = view.getPageCache().get("DimViewIdF7KeyMap");
        Map viewIdKeyMap = this.isEmpty(paramStr) ? new HashMap(16) : (Map)SerializationUtils.fromJsonString((String)paramStr, HashMap.class);
        return viewIdKeyMap;
    }
}

