/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.common.utils;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.algo.RowMeta;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.entity.tree.TreeNode;
import kd.bos.exception.KDBizException;
import kd.bos.exception.KDException;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.IPageCache;
import kd.bos.form.ShowType;
import kd.bos.form.StyleCss;
import kd.bos.form.control.TreeView;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.plugin.FormViewPluginProxy;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.ORM;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.epm.eb.common.constant.BgFormConstant;
import kd.epm.eb.common.enums.ApplicationTypeEnum;
import kd.epm.eb.common.enums.ShowTypeEnum;
import kd.epm.eb.common.pojo.SqlObj;
import kd.epm.eb.common.utils.LogSignHelper;
import kd.epm.eb.common.utils.NewEbAppUtil;
import kd.epm.eb.common.utils.ObjectSerialUtil;
import kd.epm.eb.common.utils.QFBuilder;
import kd.epm.eb.common.utils.StringUtils;
import org.jetbrains.annotations.NotNull;

public class CommonServiceHelper {
    public static final Log log = LogFactory.getLog(CommonServiceHelper.class);

    public static ApplicationTypeEnum queryApp(IFormView view) {
        ApplicationTypeEnum app = ApplicationTypeEnum.EB;
        String appNumber = view.getFormShowParameter().getAppId();
        if (kd.bos.util.StringUtils.isEmpty((String)appNumber)) {
            return app;
        }
        return ApplicationTypeEnum.getEnumByNumber(appNumber, view);
    }

    public static ApplicationTypeEnum queryEBApp(IFormView view) {
        String appNumber = view.getFormShowParameter().getAppId();
        if (kd.bos.util.StringUtils.isEmpty((String)appNumber)) {
            return ApplicationTypeEnum.EB;
        }
        return ApplicationTypeEnum.getEnumByNumber(appNumber, view);
    }

    public static List<Map<String, Object>> transDataSet(DataSet ds) {
        if (ds == null || ds.isEmpty()) {
            return Collections.emptyList();
        }
        LinkedList<Map<String, Object>> rst = new LinkedList<Map<String, Object>>();
        RowMeta rowMeta = ds.getRowMeta();
        int fieldCount = rowMeta.getFieldCount();
        String[] metas = new String[fieldCount];
        for (int index = 0; index < fieldCount; ++index) {
            metas[index] = rowMeta.getFieldName(index).toLowerCase();
        }
        while (ds.hasNext()) {
            rst.add(CommonServiceHelper.transDataSetRow(metas, ds.next()));
        }
        return rst;
    }

    private static Map<String, Object> transDataSetRow(String[] metas, Row row) {
        int fieldCount = metas.length;
        LinkedHashMap<String, Object> rowMap = new LinkedHashMap<String, Object>(fieldCount);
        for (int index = 0; index < fieldCount; ++index) {
            rowMap.put(metas[index], row.get(index));
        }
        return rowMap;
    }

    public static Map<String, Object> transDataSetRow(RowMeta rowMeta, Row row) {
        int fieldCount = rowMeta.getFieldCount();
        LinkedHashMap<String, Object> rowObjs = new LinkedHashMap<String, Object>(fieldCount);
        for (int index = 0; index < fieldCount; ++index) {
            rowObjs.put(rowMeta.getFieldName(index).toLowerCase(), row.get(index));
        }
        return rowObjs;
    }

    public static List<Object> transDataSetByField(DataSet ds, String field) {
        LinkedList<Object> rst = new LinkedList<Object>();
        if (ds == null || ds.isEmpty()) {
            return rst;
        }
        for (Row row : ds) {
            rst.add(row.get(field));
        }
        return rst;
    }

    public static Map<String, Object> transDataMap(DataSet ds) {
        if (ds == null) {
            return null;
        }
        HashMap<String, Object> rst = null;
        int count = ds.getRowMeta().getFieldCount();
        if (ds.hasNext()) {
            Row row = ds.next();
            rst = new HashMap<String, Object>(count);
            for (int index = 0; index < count; ++index) {
                rst.put(ds.getRowMeta().getFieldName(index).toLowerCase(), row.get(index));
            }
        }
        return rst;
    }

    public static Map<String, Object> transDataMap(DataSet ds, Row row) {
        if (ds == null || row == null) {
            return null;
        }
        int count = ds.getRowMeta().getFieldCount();
        HashMap<String, Object> rst = new HashMap<String, Object>(count);
        for (int index = 0; index < count; ++index) {
            rst.put(ds.getRowMeta().getFieldName(index).toLowerCase(), row.get(index));
        }
        return rst;
    }

    public static Map<String, Object> transDataMap(String[] fields, DynamicObject object) {
        if (fields == null || object == null) {
            return null;
        }
        int count = fields.length;
        HashMap<String, Object> rst = new HashMap<String, Object>(count);
        for (int index = 0; index < count; ++index) {
            rst.put(fields[index], object.get(index));
        }
        return rst;
    }

    public static void showErrorInfoForm(IFormView view, List<String> errorInfo, String caption) {
        FormShowParameter showParam = new FormShowParameter();
        showParam.setFormId("eb_errorinfo");
        showParam.setCustomParam("errorInfo", errorInfo);
        if (caption == null || caption.equals("")) {
            caption = ResManager.loadKDString((String)"\u9519\u8bef\u5217\u8868", (String)"CommonServiceHelper_0", (String)"epm-eb-common", (Object[])new Object[0]);
        }
        showParam.setCaption(caption);
        showParam.getOpenStyle().setShowType(ShowType.Modal);
        view.showForm(showParam);
    }

    public static void showErrorInfoFormWithTitle(IFormView view, List<String> errorInfo, String caption, String title) {
        CommonServiceHelper.showErrorInfoFormWithTitle(view, errorInfo, caption, title, false);
    }

    public static void showErrorInfoFormWithTitle(IFormView view, List<String> errorInfo, String caption, String title, boolean isSimpleMessage) {
        CommonServiceHelper.showErrorInfoFormWithTitle(view, errorInfo, caption, title, isSimpleMessage, true);
    }

    public static void showErrorInfoFormWithTitle(IFormView view, List<String> errorInfo, String caption, String title, boolean isSimpleMessage, boolean showseq) {
        FormShowParameter showParam = new FormShowParameter();
        showParam.setFormId("eb_errorinfo");
        showParam.setCustomParam("errorInfo", errorInfo);
        showParam.setCustomParam("title", (Object)title);
        showParam.setCustomParam("simpleMessage", (Object)isSimpleMessage);
        showParam.setCustomParam("showseq", (Object)showseq);
        if (caption == null || caption.equals("")) {
            caption = ResManager.loadKDString((String)"\u9519\u8bef\u5217\u8868", (String)"CommonServiceHelper_0", (String)"epm-eb-common", (Object[])new Object[0]);
        }
        showParam.setCaption(caption);
        showParam.getOpenStyle().setShowType(ShowType.Modal);
        view.showForm(showParam);
    }

    public static int searchTreeNode(IPageCache pageCache, TreeView treeView, String treeNodeRootCacheKey, String searchInfo) {
        CommonServiceHelper.cleanSearchCache(treeNodeRootCacheKey, pageCache);
        if (searchInfo == null || searchInfo.toLowerCase().trim().equals("")) {
            return 1;
        }
        searchInfo = searchInfo.toLowerCase().trim();
        TreeNode treeRoot = (TreeNode)SerializationUtils.fromJsonString((String)pageCache.get(treeNodeRootCacheKey), TreeNode.class);
        ArrayList<String> matchedNodeIds = new ArrayList<String>();
        CommonServiceHelper.searchTreeNodeIds(treeRoot, searchInfo, matchedNodeIds);
        if (matchedNodeIds.isEmpty()) {
            return 2;
        }
        int currentMatchedNodeIndex = 0;
        TreeNode node = treeRoot.getTreeNode((String)matchedNodeIds.get(currentMatchedNodeIndex), 20);
        node.setColor("blue");
        treeView.deleteAllNodes();
        treeView.addNode(treeRoot);
        treeView.showNode(node.getId());
        pageCache.put(treeNodeRootCacheKey + "_currentMatchedIndex", String.valueOf(currentMatchedNodeIndex));
        pageCache.put(treeNodeRootCacheKey + "_matchedNodeIds", ObjectSerialUtil.toByteSerialized(matchedNodeIds));
        pageCache.put(treeNodeRootCacheKey + "_info", searchInfo);
        return 3;
    }

    public static void cleanSearchCache(String treeNodeRootCacheKey, IPageCache pageCache) {
        pageCache.remove(treeNodeRootCacheKey + "_currentMatchedIndex");
        pageCache.remove(treeNodeRootCacheKey + "_matchedNodeIds");
        pageCache.remove(treeNodeRootCacheKey + "_info");
    }

    public static int nextOrBeforeMatchNode(IPageCache pageCache, TreeView treeView, String treeNodeRootCacheKey, boolean beforeOrNext) {
        if (pageCache.get(treeNodeRootCacheKey + "_info") == null) {
            return 1;
        }
        String idsStr = pageCache.get(treeNodeRootCacheKey + "_matchedNodeIds");
        if (idsStr != null) {
            TreeNode treeRoot = (TreeNode)SerializationUtils.fromJsonString((String)pageCache.get(treeNodeRootCacheKey), TreeNode.class);
            List matchedNodeIds = (List)ObjectSerialUtil.deSerializedBytes(idsStr);
            int currentMatchedNodeIndex = 0;
            currentMatchedNodeIndex = beforeOrNext ? Integer.parseInt(pageCache.get(treeNodeRootCacheKey + "_currentMatchedIndex")) - 1 : Integer.parseInt(pageCache.get(treeNodeRootCacheKey + "_currentMatchedIndex")) + 1;
            if (currentMatchedNodeIndex >= matchedNodeIds.size() || currentMatchedNodeIndex < 0) {
                return 2;
            }
            String nextNodeId = (String)matchedNodeIds.get(currentMatchedNodeIndex);
            TreeNode node = treeRoot.getTreeNode(nextNodeId, 20);
            node.setColor("blue");
            treeView.deleteAllNodes();
            treeView.addNode(treeRoot);
            treeView.showNode(node.getId());
            pageCache.put(treeNodeRootCacheKey + "_currentMatchedIndex", String.valueOf(currentMatchedNodeIndex));
        }
        return 3;
    }

    public static void searchTreeNodeIds(TreeNode node, String searchInfo, List<String> matchedNodeIds) {
        List childs = node.getChildren();
        if (childs != null) {
            childs.forEach(childNode -> {
                String text = childNode.getText().toLowerCase();
                if (text.contains(searchInfo)) {
                    matchedNodeIds.add(childNode.getId());
                }
                CommonServiceHelper.searchTreeNodeIds(childNode, searchInfo, matchedNodeIds);
            });
        }
    }

    public static DynamicObject getDynamicObject(String entityKey, String prop, Object propVal, String selectFields) {
        QFBuilder qb = new QFBuilder();
        qb.add(prop, "=", propVal);
        DynamicObject obj = BusinessDataServiceHelper.loadSingle((String)entityKey, (String)selectFields, (QFilter[])qb.toArrays());
        ORM orm = ORM.create();
        DynamicObject modelDy = orm.newDynamicObject(entityKey);
        String[] props = selectFields.split(",");
        if (obj == null) {
            return modelDy;
        }
        for (String propKey : props) {
            modelDy.set(propKey, obj.get(propKey));
        }
        return modelDy;
    }

    public static DynamicObject getDynamicObject(String entityKey, String selectFields, String propStr, Object ... propVals) {
        String[] props = propStr.trim().split(",");
        if (props.length != propVals.length) {
            return null;
        }
        QFBuilder qfBuilder = new QFBuilder();
        for (int index = 0; index < props.length; ++index) {
            qfBuilder.add(props[index], "=", propVals[index]);
        }
        DynamicObject obj = QueryServiceHelper.queryOne((String)entityKey, (String)selectFields, (QFilter[])qfBuilder.toArrays());
        return obj;
    }

    public static <T> T getValueFromDB(String entityKey, String selectField, String propStr, Object ... propVals) {
        Object val = null;
        DynamicObject obj = CommonServiceHelper.getDynamicObject(entityKey, selectField, propStr, propVals);
        if (obj != null) {
            val = obj.get(selectField);
        }
        return (T)val;
    }

    public static int getMaxDseqOfSameLevel(String entityKey, Long parentId, QFBuilder qfBuilder) {
        QFBuilder qb = new QFBuilder();
        qb.add("parent", "=", parentId);
        if (qfBuilder != null) {
            qb.add(qfBuilder.toList());
        }
        int maxDseq = 0;
        try (DataSet dataSet = QueryServiceHelper.queryDataSet((String)"getMaxDseqOfSameLevel", (String)entityKey, (String)"dseq", (QFilter[])qb.toArrays(), null);){
            for (Row row : dataSet) {
                int dseq = row.getInteger("dseq");
                if (dseq <= maxDseq) continue;
                maxDseq = dseq;
            }
        }
        return maxDseq;
    }

    public static void updateParentIsLeaf(String entityKey, Long parentId) {
        boolean hasChild = QueryServiceHelper.exists((String)entityKey, (QFilter[])new QFilter[]{new QFilter("parent", "=", (Object)parentId)});
        DynamicObject parentObj = BusinessDataServiceHelper.loadSingle((Object)parentId, (String)entityKey, (String)"isleaf");
        if (parentObj != null) {
            parentObj.set("isleaf", (Object)(!hasChild ? 1 : 0));
            SaveServiceHelper.update((DynamicObject)parentObj);
        }
    }

    public static void showConfirmForm(List<String> errorInfo, AbstractFormPlugin plugin, String caption, String title, String callBackId) {
        FormShowParameter showParam = new FormShowParameter();
        showParam.setFormId("eb_confirmform");
        showParam.setCustomParam("errorInfo", errorInfo);
        showParam.setCustomParam("title", (Object)title);
        showParam.setCloseCallBack(new CloseCallBack((IFormPlugin)plugin, callBackId));
        if (caption != null && !caption.equals("")) {
            showParam.setCaption(caption);
        }
        showParam.getOpenStyle().setShowType(ShowType.Modal);
        plugin.getView().showForm(showParam);
    }

    public static int[] changeIntArrays(Collection<Integer> collection) {
        if (collection != null) {
            int[] newArrays = new int[collection.size()];
            int c = 0;
            for (int i : collection) {
                newArrays[c++] = i;
            }
            return newArrays;
        }
        return null;
    }

    public static List<Integer> buildIntArrays(int rowCount) {
        ArrayList<Integer> rowIndexs = new ArrayList<Integer>(rowCount);
        for (int i = 0; i < rowCount; ++i) {
            rowIndexs.add(i);
        }
        return rowIndexs;
    }

    public static void handleLogBySign(Log log, String key, Supplier<String> logStrSupplier, String groupNum, String logSign) {
        if (LogSignHelper.needLog(groupNum, logSign)) {
            CommonServiceHelper.handleLog(log, key, logStrSupplier.get());
        }
    }

    public static void handleLog(Log log, String key, String logStr) {
        CommonServiceHelper.handleLog(log, key, logStr, -1);
    }

    public static void handleLog(Log log, String key, String logStr, int cutLength) {
        if (logStr == null) {
            return;
        }
        if (cutLength < 0) {
            cutLength = 8000;
        }
        int i = 0;
        int beginIndex = 0;
        int endIndex = cutLength;
        int allLength = logStr.length();
        while (endIndex <= allLength) {
            String substring = logStr.substring(beginIndex, endIndex);
            log.info(key + ":part" + i + ":" + substring);
            beginIndex = endIndex;
            endIndex += cutLength;
            ++i;
        }
        endIndex = allLength;
        log.info(key + ":part" + i + ":" + logStr.substring(beginIndex, endIndex));
    }

    public static String getStackTraceStr(Throwable e) {
        StackTraceElement[] arr = e.getStackTrace();
        StringBuilder sb = new StringBuilder();
        sb.append(e.getMessage()).append("\r\n");
        for (StackTraceElement ele : arr) {
            sb.append(ele.toString()).append("\r\n");
        }
        return sb.toString();
    }

    public static void dealExceptionNoShowForm(IFormView formView, String exceptionKey, Throwable ex) {
        if (exceptionKey != null) {
            log.error(exceptionKey, ex);
        } else {
            log.error(CommonServiceHelper.getStackTraceStr(ex));
        }
    }

    public static void dealException(AbstractFormPlugin formPlugin, String exceptionKey, Throwable ex) {
        if (formPlugin != null) {
            CommonServiceHelper.dealException(formPlugin.getView(), exceptionKey, ex);
        }
    }

    public static void dealException(IFormView formView, String exceptionKey, Throwable ex) {
        if (formView == null || ex == null) {
            return;
        }
        if (ex instanceof KDBizException) {
            throw (KDBizException)ex;
        }
        if (exceptionKey != null) {
            log.error(exceptionKey, ex);
        } else {
            log.error(CommonServiceHelper.getStackTraceStr(ex));
        }
        FormShowParameter showParameter = new FormShowParameter();
        showParameter.setFormId("epm_error");
        showParameter.getOpenStyle().setShowType(ShowType.Modal);
        StyleCss css = new StyleCss();
        css.setWidth("460px");
        css.setHeight("290px");
        showParameter.getOpenStyle().setInlineStyleCss(css);
        showParameter.setCustomParam("TRACE_ID", (Object)RequestContext.get().getTraceId());
        formView.showForm(showParameter);
    }

    public static String[] changeStringArrays(Collection<String> collection) {
        if (collection != null) {
            String[] newStringArrays = new String[collection.size()];
            int c = 0;
            for (String str : collection) {
                newStringArrays[c++] = str;
            }
            return newStringArrays;
        }
        return null;
    }

    public static Set<String> changeLongNumToSet(String longNumber) {
        HashSet<String> result = new HashSet<String>(16);
        CommonServiceHelper.changeLongNumToList(longNumber, result, true);
        return result;
    }

    public static void changeLongNumToList(String longNumber, Collection<String> collection, boolean containsSel) {
        block4: {
            if (!kd.bos.util.StringUtils.isNotEmpty((String)longNumber)) break block4;
            String[] numbers = longNumber.split("!");
            if (containsSel) {
                for (String num : numbers) {
                    collection.add(num);
                }
            } else {
                for (int i = 0; i < numbers.length - 1; ++i) {
                    collection.add(numbers[i]);
                }
            }
        }
    }

    public static <T extends IFormPlugin> T getFormPlugin(IFormView formView, Class pluginClass) {
        IFormPlugin target = null;
        if (formView != null) {
            FormViewPluginProxy curproxy = (FormViewPluginProxy)formView.getService(FormViewPluginProxy.class);
            String className = pluginClass.getName();
            for (IFormPlugin plugin : curproxy.getPlugIns()) {
                if (!className.equals(plugin.getClass().getName())) continue;
                target = plugin;
                break;
            }
        }
        return (T)target;
    }

    public static List<String> getDescartes(int stepCount, List<List<String>> dimMembNums) {
        ArrayList<String> result = new ArrayList<String>(dimMembNums.size());
        int count = 1;
        for (List<String> membNums : dimMembNums) {
            int index = stepCount / count;
            result.add(membNums.get(index %= membNums.size()));
            count *= membNums.size();
        }
        if (stepCount > count) {
            return null;
        }
        return result;
    }

    public static <T> void buildDescartes(List<List<T>> items, Function<List<T>, Boolean> descartesConsumer) {
        int count;
        ArrayList<T> result = new ArrayList<T>(items.size());
        int stepCount = 0;
        do {
            count = 1;
            for (List<T> itemList : items) {
                int index = stepCount / count;
                result.add(itemList.get(index %= itemList.size()));
                count *= itemList.size();
            }
            if (descartesConsumer.apply(result).booleanValue()) break;
            result.clear();
        } while (++stepCount < count);
    }

    public static String buildShowText(String number, String name, ShowTypeEnum showType) {
        if (number == null) {
            number = "";
        }
        if (name == null) {
            name = "";
        }
        if (showType == ShowTypeEnum.NUMBER) {
            return number;
        }
        if (showType == ShowTypeEnum.NAME) {
            return name;
        }
        return name + "(" + number + ")";
    }

    public static void queryDataSet(String algoKey, String entryKey, String selFields, QFilter qFilter, Consumer<Row> rowConsumer) {
        CommonServiceHelper.queryDataSet(algoKey, entryKey, selFields, Collections.singletonList(qFilter), rowConsumer);
    }

    public static void queryDataSet(String algoKey, String entryKey, String selFields, List<QFilter> qFilters, Consumer<Row> rowConsumer) {
        if (algoKey == null) {
            algoKey = "queryDataSet";
        }
        try (DataSet dataSet = QueryServiceHelper.queryDataSet((String)algoKey, (String)entryKey, (String)selFields, (QFilter[])qFilters.toArray(new QFilter[1]), null);){
            for (Row row : dataSet) {
                rowConsumer.accept(row);
            }
        }
    }

    public static void queryDataSetByDB(String algoKey, String sql, Object[] params, Consumer<Row> rowConsumer) {
        if (algoKey == null) {
            algoKey = "queryDataSetByDB";
        }
        try (DataSet dataSet = DB.queryDataSet((String)algoKey, (DBRoute)BgFormConstant.DBROUTE, (String)sql, (Object[])params);){
            for (Row row : dataSet) {
                rowConsumer.accept(row);
            }
        }
    }

    public static void queryDataSetByDB(String algoKey, SqlObj sqlObj, Consumer<Row> rowConsumer) {
        CommonServiceHelper.queryDataSetByDB(algoKey, sqlObj.getSql(), sqlObj.getParamValues(), rowConsumer);
    }

    public static void executeEpmDB(SqlObj sqlObj) {
        CommonServiceHelper.executeEpmDB(sqlObj.getSql(), sqlObj.getParamValues());
    }

    public static void executeEpmDB(String sql, Object[] paramVal) {
        DB.execute((DBRoute)BgFormConstant.DBROUTE, (String)sql, (Object[])paramVal);
    }

    public static String getBizAppId4BGRP(IFormView formView, Long modelId) {
        String appId = NewEbAppUtil.getSpecialApp(formView);
        if (StringUtils.isNotEmpty(appId) && ApplicationTypeEnum.BGRP.getAppnum().equals(appId)) {
            if (modelId != null && modelId != 0L) {
                appId = ApplicationTypeEnum.BGRP.getAppnum();
            }
        } else {
            appId = formView.getFormShowParameter().getAppId();
        }
        return appId;
    }

    public static IFormView getParentView(@NotNull IFormView view) {
        try {
            return view.getParentView();
        }
        catch (KDException e) {
            return view.getViewNoPlugin(view.getFormShowParameter().getParentPageId());
        }
    }
}

