/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.common.utils;

import java.io.Serializable;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import kd.bos.dataentity.resource.ResManager;
import kd.epm.eb.common.ebcommon.common.util.ObjectSerialUtil;
import kd.epm.eb.common.utils.CommonShowDetailEntry;
import kd.epm.eb.common.utils.JSONUtils;
import kd.epm.eb.common.utils.StringUtils;

public class CommonShowDetail
implements Serializable {
    private static final long serialVersionUID = -326667555717296272L;
    public static final String METADATA = "eb_bgcommonshowlist";
    public static final String DETAIL_DATA = "detaildata";
    public static final String DETAIL_TITLE = "detailtitle";
    public static final String DETAIL_TYPE_TITLE = "detailtypetitle";
    public static final String DETAIL_COMPRESS = "detailcompress";
    private String showAlias = null;
    private Map<String, String> aliasMap = new HashMap<String, String>(10);
    private Map<String, CommonShowDetailEntry> entryMap = new LinkedHashMap<String, CommonShowDetailEntry>(10);

    protected CommonShowDetail() {
    }

    public CommonShowDetail(String showAlias) {
        this.showAlias = showAlias;
    }

    public void setShowAlias(String showAlias) {
        this.showAlias = showAlias;
    }

    public String getShowAlias() {
        return this.showAlias;
    }

    public Map<String, String> getAliasMap() {
        return this.aliasMap;
    }

    public Map<String, CommonShowDetailEntry> getEntryMap() {
        return this.entryMap;
    }

    public CommonShowDetailEntry getEntry(String key, String alias) {
        CommonShowDetailEntry entry = this.getEntryMap().get(key);
        if (entry == null) {
            entry = new CommonShowDetailEntry();
            this.getEntryMap().put(key, entry);
            this.aliasMap.put(key, alias);
        }
        return entry;
    }

    public String getShowMessage() {
        if (this.getEntryMap().isEmpty()) {
            return "";
        }
        for (CommonShowDetailEntry entry : this.getEntryMap().values()) {
            if (entry.getDatas().isEmpty()) continue;
            Object[] rowdata = entry.getDatas().get(0);
            StringBuilder msg = new StringBuilder();
            String split = ",";
            for (int i = 0; i < entry.getColumns().size(); ++i) {
                if (entry.getHideColumnKey().contains(entry.getColumns().get(i).getColumnKey()) || entry.getNoShowMsgColumnKey().contains(entry.getColumns().get(i).getColumnKey()) || entry.getNullNoShowMsgColumnKey().contains(entry.getColumns().get(i).getColumnKey()) && rowdata[i] == null) continue;
                if (msg.length() > 0) {
                    msg.append(split);
                }
                msg.append(ResManager.loadResFormat((String)"%1\uff1a%2", (String)"ControlLog_Show", (String)"epm-eb-business", (Object[])new Object[]{entry.getColumns().get(i).getColumnAlias(), rowdata[i]}));
            }
            if (entry.getDatas().size() > 1) {
                msg.append("...");
            }
            if (msg.length() <= 0) continue;
            return msg.toString();
        }
        return "";
    }

    public boolean isEmpty() {
        if (this.getEntryMap().isEmpty()) {
            return true;
        }
        for (CommonShowDetailEntry entry : this.getEntryMap().values()) {
            if (entry.getDatas().isEmpty()) continue;
            return false;
        }
        return true;
    }

    public static String compressDetail(Object detail) {
        return ObjectSerialUtil.compress4GZip(JSONUtils.toString(detail));
    }

    public static String unCompressDetail(String detail) {
        if (StringUtils.isEmpty(detail)) {
            return detail;
        }
        return ObjectSerialUtil.uncompress(detail.substring(6));
    }
}

