/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.common.utils;

import com.alibaba.fastjson.JSONObject;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Supplier;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.cache.ThreadCache;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.property.IntegerProp;
import kd.bos.exception.KDBizException;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.epm.eb.common.analysereport.pojo.VarExportContext;
import kd.epm.eb.common.analysereport.pojo.VarImportContext;
import kd.epm.eb.common.decompose.entity.AdjustParam;
import kd.epm.eb.common.model.BizModel;
import kd.epm.eb.common.model.Dimension;
import kd.epm.eb.common.model.Member;
import kd.epm.eb.common.params.ParamEnum;
import kd.epm.eb.common.params.ParamQueryServiceHelper;
import kd.epm.eb.common.utils.BgDimensionServiceHelper;
import kd.epm.eb.common.utils.ModelUtils;
import kd.epm.eb.common.utils.QFBuilder;
import kd.epm.eb.common.utils.StringUtils;

public class CommonUtils {
    public static final String VERSION_CONTRAST_COLOR = "versioncontrastcolor";
    public static final String DEFAULT_VERSION_CONTRAST_COLOR = "red";
    public static final String VERSION_CONTRAST_MAX_TOKEN = "maxtoken";
    public static final String VERSION_CONTRAST_MAX_LOOP = "maxloopcount";

    public static Member getMemberByNumber(Dimension dimension, long modelId, String dimMemNumber) {
        String selectFiled = "id,name,number,longnumber,isleaf";
        QFBuilder qfBuilder = new QFBuilder();
        qfBuilder.add(new QFilter("model", "=", (Object)modelId));
        qfBuilder.add(new QFilter("dimension", "=", (Object)dimension.getId()));
        qfBuilder.add(new QFilter("number", "=", (Object)dimMemNumber));
        DynamicObject dynamicObject = QueryServiceHelper.queryOne((String)dimension.getMemberModel(), (String)selectFiled, (QFilter[])qfBuilder.toArrays());
        Member _member = null;
        if (dynamicObject != null) {
            _member = new Member(dynamicObject.getLong("id"), dynamicObject.getString("name"), dynamicObject.getString("number"));
            _member.setLeaf(dynamicObject.getBoolean("isleaf"));
            _member.setLongNumber(dynamicObject.getString("longnumber"));
        }
        return _member;
    }

    public static Boolean hasBusinessModel(Long id) {
        DynamicObject model_new = ModelUtils.getModel(id);
        String reporttype = model_new.getString("reporttype");
        if ("7".equals(reporttype) || "6".equals(reporttype)) {
            return true;
        }
        return false;
    }

    public static boolean isBgmdModel(Long id) {
        DynamicObject model_new = ModelUtils.getModel(id);
        String reporttype = model_new.getString("reporttype");
        return reporttype.equals("7");
    }

    public static boolean isBgModel(Long id) {
        DynamicObject model_new = ModelUtils.getModel(id);
        String reporttype = model_new.getString("reporttype");
        return "6".equals(reporttype);
    }

    public static List<String> getAllDimNumber(Long modelId) {
        List<Dimension> allDimension = CommonUtils.getAllDimension(modelId);
        ArrayList<String> allDimNumber = new ArrayList<String>(16);
        for (Dimension dimension : allDimension) {
            allDimNumber.add(dimension.getNumber());
        }
        return allDimNumber;
    }

    public static List<Dimension> getAllDimension(Long modelId) {
        ArrayList<Dimension> list;
        block14: {
            list = new ArrayList<Dimension>(16);
            try (DataSet rows = QueryServiceHelper.queryDataSet((String)"epm", (String)"epm_dimension", (String)"id,name,number", (QFilter[])new QFilter[]{new QFilter("model", "=", (Object)modelId)}, (String)"dseq");){
                if (rows != null) {
                    Row row = null;
                    while (rows.hasNext()) {
                        row = rows.next();
                        list.add(new Dimension(row.getLong("id"), row.getString("name"), row.getString("number")));
                    }
                    break block14;
                }
                throw new KDBizException(ResManager.loadKDString((String)"\u5f53\u524d\u4f53\u7cfb\u7ef4\u5ea6\u4e0d\u5b58\u5728\u3002", (String)"CommonUtils_0", (String)"epm-eb-common", (Object[])new Object[0]));
            }
        }
        return list;
    }

    public static Long getBussnessModel(Long modelId) {
        long aLong;
        QFBuilder builder = new QFBuilder();
        builder.add(new QFilter("model", "=", (Object)modelId));
        String fields = "id,model.id,businessmodel.id,entryentity.id,entryentity.dimensionid";
        DynamicObject dynamicObject = QueryServiceHelper.queryOne((String)"eb_bgmcontroldimension", (String)fields, (QFilter[])builder.toArrays());
        if (dynamicObject != null && (aLong = dynamicObject.getLong("businessmodel.id")) != 0L) {
            return aLong;
        }
        return 0L;
    }

    public static BizModel getModel(String modelNumber) {
        BizModel bizModel = null;
        String selectFiled = "id,name,number,shownumber";
        QFBuilder qfBuilder = new QFBuilder();
        qfBuilder.add(new QFilter("shownumber", "=", (Object)modelNumber));
        DynamicObjectCollection objectDynamicObject = QueryServiceHelper.query((String)"epm_model", (String)selectFiled, (QFilter[])qfBuilder.toArrays());
        if (objectDynamicObject != null && objectDynamicObject.size() > 0) {
            if (objectDynamicObject.size() > 1) {
                throw new KDBizException(ResManager.loadKDString((String)"\u5b58\u5728\u4e24\u4e2a\u76f8\u540c\u7f16\u7801\u7684\u4f53\u7cfb,\u8bf7\u786e\u8ba4\u6570\u636e\u7684\u6b63\u786e\u6027\u3002", (String)"CommonUtils_1", (String)"epm-eb-common", (Object[])new Object[0]));
            }
        } else {
            throw new KDBizException(ResManager.loadKDString((String)"\u4f53\u7cfb\u4e0d\u5b58\u5728\uff0c\u8bf7\u68c0\u67e5\u4f53\u7cfb\u7f16\u7801\u3002", (String)"CommonUtils_2", (String)"epm-eb-common", (Object[])new Object[0]));
        }
        bizModel = new BizModel((DynamicObject)objectDynamicObject.get(0));
        bizModel.setDimension(BgDimensionServiceHelper.getDimensionByModel(bizModel.getId()));
        return bizModel;
    }

    public static DynamicObject getModel_d(String modelNumber) {
        Object bizModel = null;
        String selectFiled = "id,name,number,shownumber,reporttype,datasource";
        QFBuilder qfBuilder = new QFBuilder();
        qfBuilder.add(new QFilter("shownumber", "=", (Object)modelNumber));
        DynamicObjectCollection objectDynamicObject = QueryServiceHelper.query((String)"epm_model", (String)selectFiled, (QFilter[])qfBuilder.toArrays());
        if (objectDynamicObject != null && objectDynamicObject.size() > 0) {
            if (objectDynamicObject.size() > 1) {
                throw new KDBizException(ResManager.loadKDString((String)"\u5b58\u5728\u4e24\u4e2a\u76f8\u540c\u7f16\u7801\u7684\u4f53\u7cfb,\u8bf7\u786e\u8ba4\u6570\u636e\u7684\u6b63\u786e\u6027\u3002", (String)"CommonUtils_1", (String)"epm-eb-common", (Object[])new Object[0]));
            }
            return (DynamicObject)objectDynamicObject.get(0);
        }
        throw new KDBizException(ResManager.loadKDString((String)"\u4f53\u7cfb\u4e0d\u5b58\u5728\uff0c\u8bf7\u68c0\u67e5\u4f53\u7cfb\u7f16\u7801\u3002", (String)"CommonUtils_2", (String)"epm-eb-common", (Object[])new Object[0]));
    }

    public static Map<Long, Long> getAllBusmodelandDataset(Long modelId) {
        HashMap<Long, Long> map = new HashMap<Long, Long>(16);
        QFBuilder qfBuilder = new QFBuilder();
        qfBuilder.add(new QFilter("model", "=", (Object)modelId));
        DynamicObjectCollection query = QueryServiceHelper.query((String)"eb_dataset", (String)"id,businessmodel,model", (QFilter[])qfBuilder.toArrays());
        for (DynamicObject dynamicObject : query) {
            map.put(dynamicObject.getLong("id"), dynamicObject.getLong("businessmodel"));
        }
        return map;
    }

    public static AdjustParam getAdjustParam(Long modelId) {
        AdjustParam adjustParam = new AdjustParam();
        JSONObject paramMap = ParamQueryServiceHelper.getJSON(modelId, ParamEnum.BG010);
        if (paramMap != null) {
            adjustParam.setModelId(modelId);
            if (paramMap.get((Object)"adjust") != null) {
                adjustParam.setAdjust((Boolean)paramMap.get((Object)"adjust"));
            } else {
                adjustParam.setAdjust(false);
            }
            if (paramMap.get((Object)"approveeditnoleafcell") != null) {
                adjustParam.setApproveeditnoleafcell((Boolean)paramMap.get((Object)"approveeditnoleafcell"));
            } else {
                adjustParam.setApproveeditnoleafcell(false);
            }
            if (paramMap.get((Object)"adjustleaf") != null) {
                adjustParam.setAdjustleaf((Boolean)paramMap.get((Object)"adjustleaf"));
            }
            adjustParam.setApproveedit(true);
            String adjustnotleaf = "";
            if (paramMap.get((Object)"adjustnotleaf") != null) {
                adjustnotleaf = (String)paramMap.get((Object)"adjustnotleaf");
            }
            if (StringUtils.isNotEmpty(adjustnotleaf)) {
                String[] dims = adjustnotleaf.split(",");
                ArrayList<String> dimList = new ArrayList<String>(dims.length);
                for (String dim : dims) {
                    if (!kd.bos.dataentity.utils.StringUtils.isNotEmpty((CharSequence)dim)) continue;
                    dimList.add(dim);
                }
                adjustParam.setDims(dimList);
            }
        }
        return adjustParam;
    }

    public static boolean approveAdjust(Long modelId) {
        return ParamQueryServiceHelper.getChildBoolean(modelId, ParamEnum.BG010, "adjust");
    }

    public static boolean editNoLeafCell(Long modelId) {
        return ParamQueryServiceHelper.getBoolean(modelId, ParamEnum.BG014);
    }

    public static boolean btnReCalcVisible(Long modelId) {
        return ParamQueryServiceHelper.getBoolean(modelId, ParamEnum.BG017);
    }

    public static boolean lastSelectPageMem(Long modelId) {
        return ParamQueryServiceHelper.getBoolean(modelId, ParamEnum.BG049);
    }

    public static boolean exportFormatValue(Long modelId) {
        return ParamQueryServiceHelper.getBoolean(modelId, ParamEnum.BG056);
    }

    public static boolean approveEditNoLeafCell(Long modelId) {
        return ParamQueryServiceHelper.getChildBoolean(modelId, ParamEnum.BG010, "approveeditnoleafcell");
    }

    public static String getReportColorType(Long modelId) {
        return ParamQueryServiceHelper.getChildString(modelId, ParamEnum.BG015, "reportcolor");
    }

    public static String getVersionContrastColor(Long modelId) {
        String color = ParamQueryServiceHelper.getChildString(modelId, ParamEnum.BG057, VERSION_CONTRAST_COLOR);
        if (StringUtils.isEmpty(color)) {
            color = DEFAULT_VERSION_CONTRAST_COLOR;
        }
        return color;
    }

    public static int getVersionContrastMaxToken() {
        int value = ParamQueryServiceHelper.getChildInt(0L, ParamEnum.BG058, VERSION_CONTRAST_MAX_TOKEN);
        if (value <= 0) {
            value = 5000;
        }
        return value;
    }

    public static int getVersionContrastLoog() {
        int value = ParamQueryServiceHelper.getChildInt(0L, ParamEnum.BG058, VERSION_CONTRAST_MAX_LOOP);
        if (value <= 0) {
            value = 5;
        }
        return value;
    }

    public static String filterSpecialCharacter(String val, String replace) {
        if (kd.bos.dataentity.utils.StringUtils.isNotEmpty((CharSequence)val)) {
            String regEx = "[\\\\\\[\\]\"{};]";
            CharSequence[] split = val.split(regEx);
            return String.join((CharSequence)replace, split);
        }
        return val;
    }

    public static <T> T getMetaDataFieldDefaultValue(String formId, String fieldKey, Supplier<T> supplier) {
        IntegerProp integerProp;
        Object defValue;
        MainEntityType dataEntityType = EntityMetadataCache.getDataEntityType((String)formId);
        DynamicProperty property = dataEntityType.getProperty(fieldKey);
        if (property == null) {
            return supplier.get();
        }
        if (property instanceof IntegerProp && (defValue = (integerProp = (IntegerProp)property).getDefValue()) != null) {
            return (T)defValue;
        }
        Object defaultValue = property.getDefaultValue();
        if (defaultValue == null) {
            return supplier.get();
        }
        return (T)defaultValue;
    }

    public static boolean checkVBudDataPerm(Long modelId, boolean checkF7) {
        ParamEnum paramEnum = checkF7 ? ParamEnum.BG037 : ParamEnum.BG038;
        return ParamQueryServiceHelper.getBoolean(modelId, paramEnum);
    }

    public static boolean checkBcmJCDataPerm(Long modelId, boolean isSetting) {
        ParamEnum paramEnum = isSetting ? ParamEnum.BG047 : ParamEnum.BG048;
        return ParamQueryServiceHelper.getBoolean(modelId, paramEnum);
    }

    public static boolean integraitonFilterswitch(Long modelId) {
        return ParamQueryServiceHelper.getBoolean(modelId, ParamEnum.BG028);
    }

    public static Integer integraitonOrgPageSize(Long modelId) {
        return ParamQueryServiceHelper.getInt(modelId, ParamEnum.BG036);
    }

    public static VarExportContext getVarExportContext() {
        return (VarExportContext)ThreadCache.get((Object)"VarExportContext");
    }

    public static void removeVarExportContext() {
        ThreadCache.remove((Object)"VarExportContext");
    }

    public static void putVarExportContext(VarExportContext varExportContext) {
        ThreadCache.put((Object)"VarExportContext", (Object)varExportContext);
    }

    public static VarImportContext getVarImportContext() {
        return (VarImportContext)ThreadCache.get((Object)"VarImportContext");
    }

    public static void removeVarImportContext() {
        ThreadCache.remove((Object)"VarImportContext");
    }

    public static void putVarImportContext(VarImportContext varExportContext) {
        ThreadCache.put((Object)"VarImportContext", (Object)varExportContext);
    }

    public static boolean applybillruleswitch(Long modelId) {
        return ParamQueryServiceHelper.getBoolean(modelId, ParamEnum.BG042);
    }
}

