/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.common.utils;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.text.DecimalFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.HashSet;
import java.util.Iterator;
import java.util.concurrent.TimeUnit;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import kd.bos.context.RequestContext;
import kd.bos.exception.BosErrorCode;
import kd.bos.exception.KDBizException;
import kd.bos.orm.query.QEmptyValue;
import kd.epm.eb.common.utils.StringUtils;
import kd.epm.eb.common.utils.convert.Convert;

public class ConvertUtils {
    private static final DateTimeFormatter dtf1 = DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss");
    private static final DateTimeFormatter dtf2 = DateTimeFormatter.ofPattern("yyyy/MM/dd HH:mm:ss");
    private static final DateTimeFormatter df2 = DateTimeFormatter.ofPattern("yyyy/MM/dd");
    private static final DateTimeFormatter DF_DATE = DateTimeFormatter.ofPattern("yyyy-MM-dd");
    private static final String OA_MATCHES = "/OADate\\(-?\\d+\\)/";
    private static Date OABaseDate = null;
    private static final String OADATE_STR = "/OADate(%d)/";

    public static BigDecimal toDecimal(Object numeric) {
        if (numeric == null) {
            return null;
        }
        BigDecimal value = null;
        if (numeric instanceof BigDecimal) {
            value = (BigDecimal)numeric;
        } else if (numeric instanceof Double) {
            Double doubleValue = (Double)numeric;
            if (!doubleValue.isInfinite() && !doubleValue.isNaN()) {
                value = new BigDecimal(doubleValue.toString());
            }
        } else if (numeric instanceof Number) {
            value = new BigDecimal(numeric.toString());
        } else {
            try {
                value = new BigDecimal(numeric.toString().trim());
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return value;
    }

    public static Date toDate(Object value) {
        if (value == null) {
            return null;
        }
        Date datetime = null;
        if (value instanceof Date) {
            datetime = (Date)value;
        } else if (value instanceof Long) {
            datetime = new Date((Long)value);
        } else if (value instanceof String) {
            LocalDate ld2;
            LocalDateTime ldt;
            try {
                ldt = LocalDateTime.parse((String)value, dtf1);
                datetime = Date.from(ldt.atZone(ZoneId.systemDefault()).toInstant());
            }
            catch (Exception ex) {
                try {
                    ld2 = LocalDate.parse((String)value);
                    if (ld2 != null) {
                        datetime = Date.from(ld2.atStartOfDay(ZoneId.systemDefault()).toInstant());
                    }
                }
                catch (Exception ld2) {
                    // empty catch block
                }
            }
            if (datetime == null) {
                try {
                    ldt = LocalDateTime.parse((String)value, dtf2);
                    datetime = Date.from(ldt.atZone(ZoneId.systemDefault()).toInstant());
                }
                catch (Exception ex) {
                    try {
                        ld2 = LocalDate.parse((String)value, df2);
                        if (ld2 != null) {
                            datetime = Date.from(ld2.atStartOfDay(ZoneId.systemDefault()).toInstant());
                        }
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
            }
            if (datetime == null) {
                try {
                    long time = Long.parseLong((String)value);
                    datetime = new Date(time);
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
        }
        return datetime;
    }

    public static Date from(String OADate) {
        Pattern pattern;
        Matcher matcher;
        if (StringUtils.isEmpty(OADate)) {
            return null;
        }
        if (OADate.matches(OA_MATCHES) && (matcher = (pattern = Pattern.compile("-?\\d+")).matcher(OADate)).find()) {
            double dateValue = Double.parseDouble(matcher.group());
            double mantissa = dateValue - (double)((long)dateValue);
            double hour = mantissa * 24.0;
            double min = (hour - (double)((long)hour)) * 60.0;
            double sec = (min - (double)((long)min)) * 60.0;
            try {
                SimpleDateFormat myFormat = new SimpleDateFormat("dd MM yyyy");
                Date baseDate = myFormat.parse("30 12 1899");
                Calendar c = Calendar.getInstance();
                c.setTime(baseDate);
                c.add(5, (int)dateValue);
                c.add(10, (int)hour);
                c.add(12, (int)min);
                c.add(13, (int)sec);
                return c.getTime();
            }
            catch (ParseException parseException) {
                // empty catch block
            }
        }
        return null;
    }

    public static String convertToOADate(Date date) {
        if (date == null || OABaseDate == null) {
            return null;
        }
        Calendar calendar = Calendar.getInstance(RequestContext.get().getLang().getLocale());
        calendar.setTime(date);
        Long days = TimeUnit.DAYS.convert(date.getTime() - OABaseDate.getTime(), TimeUnit.MILLISECONDS);
        Double oaDate = (double)days.longValue() + (double)calendar.get(11) / 24.0 + (double)calendar.get(12) / 1440.0 + (double)calendar.get(13) / 86400.0;
        return String.format(OADATE_STR, oaDate.intValue());
    }

    public static String toString(Date date) {
        if (date == null) {
            return null;
        }
        LocalDateTime localDateTime = date.toInstant().atZone(ZoneId.systemDefault()).toLocalDateTime();
        return localDateTime.format(dtf1);
    }

    public static String toDateString(Date date) {
        if (date == null) {
            return null;
        }
        LocalDateTime localDateTime = date.toInstant().atZone(ZoneId.systemDefault()).toLocalDateTime();
        return localDateTime.format(DF_DATE);
    }

    public static Long toLong(Object obj) {
        if (obj == null) {
            return 0L;
        }
        if (obj instanceof Long) {
            return (Long)obj;
        }
        try {
            return Long.valueOf(obj.toString());
        }
        catch (Throwable ex) {
            throw new KDBizException(ex, BosErrorCode.conversionFailed, new Object[0]);
        }
    }

    public static boolean equalValue(Object value1, Object value2) {
        if (value2 instanceof QEmptyValue) {
            return value1 == null;
        }
        if (value1 == null && value2 == null || value1 == value2) {
            return true;
        }
        if (value1 == null && value2 != null || value1 != null && value2 == null) {
            return false;
        }
        if (value1 instanceof Double) {
            return ((Double)value1).compareTo(Convert.toDouble(value2)) == 0;
        }
        if (value1 instanceof String) {
            return value1.equals(Convert.toStr(value2));
        }
        if (value1 instanceof BigDecimal) {
            return ((BigDecimal)value1).compareTo(Convert.toBigDecimal(value2)) == 0;
        }
        if (value1 instanceof Long) {
            return ((Long)value1).compareTo(Convert.toLong(value2)) == 0;
        }
        if (value1 instanceof Integer) {
            return ((Integer)value1).compareTo(Convert.toInt(value2)) == 0;
        }
        if (value1 instanceof Date) {
            return value1.equals(ConvertUtils.toDate(value2));
        }
        if (value1 instanceof BigInteger) {
            return ((BigInteger)value1).compareTo(Convert.toBigInteger(value2)) == 0;
        }
        if (value1 instanceof Boolean) {
            return ((Boolean)value1).compareTo(Convert.toBool(value2)) == 0;
        }
        return value1.equals(value2);
    }

    public static int compareValue(Object value1, Object value2) {
        if (value1 == value2 || value1 == null && value2 == null) {
            return 0;
        }
        if (value1 != null && value2 == null) {
            return 1;
        }
        if (value1 == null && value2 != null) {
            return -1;
        }
        if (value1 instanceof Double) {
            return ((Double)value1).compareTo(Convert.toDouble(value2));
        }
        if (value1 instanceof String) {
            if (value2 instanceof Date) {
                Date d1 = ConvertUtils.toDate(value1);
                Date d2 = (Date)value2;
                return d1 == null ? -1 : (d1.after(d2) ? 1 : (d1.before(d2) ? -1 : 0));
            }
            return ((String)value1).compareTo(Convert.toStr(value2));
        }
        if (value1 instanceof BigDecimal) {
            return ((BigDecimal)value1).compareTo(Convert.toBigDecimal(value2));
        }
        if (value1 instanceof Long) {
            if (value2 instanceof Date) {
                Date d1 = ConvertUtils.toDate(value1);
                Date d2 = (Date)value2;
                return d1 == null ? -1 : (d1.after(d2) ? 1 : (d1.before(d2) ? -1 : 0));
            }
            return ((Long)value1).compareTo(Convert.toLong(value2));
        }
        if (value1 instanceof Integer) {
            return ((Integer)value1).compareTo(Convert.toInt(value2));
        }
        if (value1 instanceof Date) {
            return ((Date)value1).compareTo(ConvertUtils.toDate(value2));
        }
        if (value1 instanceof BigInteger) {
            return ((BigInteger)value1).compareTo(Convert.toBigInteger(value2));
        }
        if (value1 instanceof Boolean) {
            return ((Boolean)value1).compareTo(Convert.toBool(value2));
        }
        return 0;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static boolean contains(Object value1, Object value2) {
        if (value1 == null) return false;
        if (value2 == null) {
            return false;
        }
        if (value1 instanceof String) {
            if (value2 instanceof Collection) {
                Object __value2;
                Collection _value2 = (Collection)value2;
                Iterator iterator = _value2.iterator();
                do {
                    if (!iterator.hasNext()) return false;
                } while (!ConvertUtils.contains(value1, __value2 = iterator.next()));
                return true;
            }
            if (((String)value1).indexOf(Convert.toStr(value2)) < 0) return false;
            return true;
        }
        if (!(value1 instanceof Collection)) return false;
        if (!(value2 instanceof Collection)) return ((Collection)value1).contains(value2);
        return ((Collection)value1).containsAll((Collection)value2);
    }

    public static boolean notContains(Object value1, Object value2) {
        if (value1 == null || value2 == null) {
            return false;
        }
        if (value1 instanceof String) {
            if (value2 instanceof Collection) {
                Collection _value2 = (Collection)value2;
                for (Object __value2 : _value2) {
                    if (!ConvertUtils.contains(value1, __value2)) continue;
                    return false;
                }
                return true;
            }
            return ((String)value1).indexOf(Convert.toStr(value2)) == -1;
        }
        if (value1 instanceof Collection) {
            if (value2 instanceof Collection) {
                return !((Collection)value1).containsAll((Collection)value2);
            }
            return !((Collection)value1).contains(value2);
        }
        return false;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static boolean in(Object value1, Object value2) {
        if (value1 == null || value2 == null) {
            return false;
        }
        if (value1 instanceof String) {
            if (!(value2 instanceof Collection)) return StringUtils.equals((String)value1, Convert.toStr(value2));
            Collection collection = (Collection)value2;
            for (Object value : collection) {
                if (!StringUtils.equals((String)value1, Convert.toStr(value))) continue;
                return true;
            }
            return false;
        } else {
            if (value1 instanceof Collection) {
                if (!(value2 instanceof Collection)) return false;
                return ((Collection)value2).containsAll((Collection)value1);
            }
            if (value2 instanceof Collection) {
                if (!(value1 instanceof Collection)) return ((Collection)value2).contains(value1);
                return ((Collection)value2).containsAll((Collection)value1);
            }
            if (!value2.getClass().isArray()) return false;
            HashSet<Object> objects = new HashSet<Object>(16);
            objects.addAll(Arrays.asList((Object[])value2));
            if (!value1.getClass().isArray()) return objects.contains(value1);
            HashSet<Object> child = new HashSet<Object>(16);
            child.addAll(Arrays.asList((Object[])value2));
            return objects.containsAll(child);
        }
    }

    public static boolean notIn(Object value1, Object value2) {
        return !ConvertUtils.in(value1, value2);
    }

    public static boolean isNull(Object value) {
        if (value == null) {
            return true;
        }
        if (value instanceof String) {
            return StringUtils.isEmpty((String)value);
        }
        if (value instanceof Collection) {
            return ((Collection)value).isEmpty();
        }
        return false;
    }

    public static int getIndex(String v1, String v2) {
        if (v1 == null || v2 == null) {
            return -1;
        }
        return v1.indexOf(v2);
    }

    public static String formatDouble(double value, int decimalPlaces) {
        StringBuilder sb = new StringBuilder();
        sb.append("0.");
        for (int i = 0; i < decimalPlaces; ++i) {
            sb.append("0");
        }
        DecimalFormat df = new DecimalFormat(sb.toString());
        return df.format(value);
    }

    static {
        try {
            OABaseDate = new SimpleDateFormat("dd MM yyyy").parse("30 12 1899");
        }
        catch (ParseException parseException) {
            // empty catch block
        }
    }
}

