/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.common.utils;

import java.util.concurrent.TimeUnit;
import kd.bos.algo.DataSet;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.DBServiceHelper;
import kd.bos.servicehelper.DispatchServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.epm.eb.common.cache.BcmCacheUpdateHelper;
import kd.epm.eb.common.cache.DimMembPermVerHelper;
import kd.epm.eb.common.cache.ModelCacheContext;
import kd.epm.eb.common.cache.control.BgControlCache;
import kd.epm.eb.common.cache.control.BgLockCacheServiceHelper;
import kd.epm.eb.common.constant.BgBaseConstant;
import kd.epm.eb.common.currencyConvert.CurrencyConvertCache;
import kd.epm.eb.common.enums.SysDimensionEnum;
import kd.epm.eb.common.eventbus.EventBusUtil;
import kd.epm.eb.common.eventbus.event.MemberChangeEvent;
import kd.epm.eb.common.utils.IDUtils;
import kd.epm.eb.common.utils.LogUtils;
import kd.epm.eb.common.utils.QFBuilder;
import kd.epm.eb.common.utils.StringUtils;
import kd.epm.eb.common.utils.cache.Cache;
import kd.epm.eb.common.utils.cache.ICache;
import kd.epm.eb.common.utils.threadpool.EBThreadPoolExecutor;
import org.jetbrains.annotations.NotNull;

public class CubeUtils {
    private static final Log log = LogFactory.getLog(CubeUtils.class);
    private static final String CACHE_MODEL_ID = "CACHE_MODEL_ID";
    public static final String CACHE_DIMENSION_VERSION_ID = "CACHE_DIMENSION_VERSION_ID";

    public static CubeUtils get() {
        return new CubeUtils();
    }

    public void checkMember(DynamicObject member) {
        if (member == null) {
            return;
        }
        this.checkMember(new DynamicObject[]{member});
    }

    public void checkMember(DynamicObject[] members) {
        if (members == null || members.length == 0) {
            return;
        }
        DynamicObject member = members[0];
        DynamicObject model = member.getDynamicObject("model");
        DynamicObject dimension = member.getDynamicObject("dimension");
        Long modelId = model.getLong("id");
        Long dimensionId = dimension.getLong("id");
        String dimensionNumber = dimension.getString("number");
        Long[] memberIds = new Long[]{member.getLong("id")};
        new Member().check(modelId, dimensionId, dimensionNumber, null, memberIds);
        if (SysDimensionEnum.Version.getNumber().equals(dimension.getString("number"))) {
            new Cube().check(modelId, memberIds);
        }
    }

    public void checkDimension(DynamicObject dimension, Long viewId) {
        if (dimension == null) {
            return;
        }
        Long modelId = dimension.getDynamicObject("model").getLong("id");
        Long dimensionId = dimension.getLong("id");
        this.checkDimension(modelId, dimensionId, viewId);
    }

    public void checkDimension(Long modelId, Long dimensionId) {
        this.checkDimension(modelId, dimensionId, null);
    }

    public void checkDimension(Long modelId, Long dimensionId, Long viewId) {
        if (modelId == null || modelId == 0L || dimensionId == null || dimensionId == 0L) {
            return;
        }
        new Dimension().check(modelId, dimensionId, viewId);
    }

    public void checkDimension(Long modelId, Long[] dimensionIds) {
        if (modelId == null || modelId == 0L || dimensionIds == null || dimensionIds.length == 0) {
            return;
        }
        new Dimension().check(modelId, dimensionIds);
    }

    public void deleteDimension(Long modelId, Long dimensionId) {
        if (modelId == null || modelId == 0L || dimensionId == null || dimensionId == 0L) {
            return;
        }
        new Dimension().delete(modelId, dimensionId);
    }

    public void checkDeleteDimension(Long modelId, Long datasetId, Long dimensionId) {
        if (modelId == null || modelId == 0L || dimensionId == null || dimensionId == 0L) {
            return;
        }
        new Dimension().checkDelete(modelId, datasetId, dimensionId);
    }

    public void checkBusModel(Long cubeId, Long busModelId) {
        if (cubeId == null || cubeId == 0L || busModelId == null || busModelId == 0L) {
            return;
        }
        new BusModel().check(cubeId, busModelId);
    }

    public void checkDeleteView(Long cubeId, Long dimensionId, Long viewId) {
        if (cubeId == null || cubeId == 0L || dimensionId == null || dimensionId == 0L || viewId == null || viewId == 0L) {
            return;
        }
        new View().checkDelete(cubeId, dimensionId, viewId);
    }

    public void deleteView(Long cubeId, Long dimensionId, Long viewId) {
        if (cubeId == null || cubeId == 0L || dimensionId == null || dimensionId == 0L || viewId == null || viewId == 0L) {
            return;
        }
        CubeUtils.updateDimensionVersion(cubeId, dimensionId);
        new View().delete(cubeId, dimensionId, viewId);
    }

    public void checkDataset(Long modelId, Long datasetId) {
        if (modelId == null || modelId == 0L || datasetId == null || datasetId == 0L) {
            return;
        }
        new Dataset().check(modelId, datasetId);
    }

    public void deleteDataSet(Long modelId, Long datasetId) {
        if (modelId == null || modelId == 0L || datasetId == null || datasetId == 0L) {
            return;
        }
        new Dataset().delete(modelId, datasetId);
    }

    public boolean checkDeleteDataSet(Long modelId, Long datasetId) {
        if (modelId == null || modelId == 0L || datasetId == null || datasetId == 0L) {
            return false;
        }
        new Dataset().checkDelete(modelId, datasetId);
        return true;
    }

    public void checkCube(Long modelId) {
        new Cube().check(modelId);
    }

    public void deleteCube(Long modelId) {
        if (modelId == null || modelId == 0L) {
            return;
        }
        new Cube().delete(modelId);
    }

    public void checkDeleteModel(DynamicObject model) {
        if (model == null) {
            return;
        }
        Long modelId = model.getLong("id");
        new Cube().checkDelete(modelId);
    }

    public static void updateCubeVersion(@NotNull Long cubeId) {
        CubeUtils.updateDimensionVersion(cubeId, null, null);
    }

    public static void updateDimensionVersion(@NotNull Long cubeId, @NotNull Long dimensionId) {
        CubeUtils.updateDimensionVersion(cubeId, dimensionId, null);
    }

    private static void updateDimensionVersion(Long cubeId, Long dimensionId, Long viewId) {
        CubeUtils.updateDimensionVersion(cubeId, dimensionId, viewId, true);
    }

    protected static void updateDimensionVersion(Long cubeId, Long dimensionId, Long viewId, boolean isUpdateModelVersion) {
        if (cubeId == null || cubeId == 0L) {
            return;
        }
        Long versionId = DBServiceHelper.genGlobalLongId();
        if (viewId != null && viewId != 0L) {
            CubeUtils.updateViewVersionNo(viewId, versionId);
        }
        if (dimensionId != null && dimensionId != 0L) {
            CubeUtils.updateDimensionVersionNo(dimensionId, versionId);
        }
        BcmCacheUpdateHelper.publishClearAllCacheByType(cubeId);
        if (isUpdateModelVersion) {
            CubeUtils.updateModelVersionNo(cubeId, versionId);
        }
        EventBusUtil.asyncPost(new MemberChangeEvent(cubeId, dimensionId, viewId));
    }

    private static void updateDimensionVersion(Long cubeId, Long[] dimensionIds) {
        if (cubeId == null || cubeId == 0L || dimensionIds == null || dimensionIds.length == 0) {
            return;
        }
        Long versionId = DBServiceHelper.genGlobalLongId();
        for (Long dimensionId : dimensionIds) {
            if (dimensionId == null || dimensionId == 0L) continue;
            CubeUtils.updateDimensionVersionNo(dimensionId, versionId);
        }
        BcmCacheUpdateHelper.publishClearAllCacheByType(cubeId);
        CubeUtils.updateModelVersionNo(cubeId, versionId);
    }

    public static String getCacheModelIdKey(@NotNull Long modelId) {
        return CACHE_MODEL_ID + modelId;
    }

    private static void updateModelVersionNo(@NotNull Long cubeId, @NotNull Long versionId) {
        ModelCacheContext.getCurrent().remove();
        log.info("updateVersion:updateModelVersionNo" + cubeId + versionId);
        try (TXHandle th = TX.notSupported();){
            try {
                DB.execute((DBRoute)BgBaseConstant.epm, (String)"update t_eb_model set fversion = ? where fid = ?", (Object[])new Object[]{versionId, cubeId});
                Cache.get().set(CubeUtils.getCacheModelIdKey(cubeId), versionId.toString(), 1, TimeUnit.HOURS);
            }
            catch (Exception e) {
                th.markRollback();
                log.error(e.getMessage());
                throw new KDBizException(e.getMessage());
            }
        }
    }

    public static void updateModelVersionNoByVersion(@NotNull Long cubeId, @NotNull Long versionId) {
        String cacheKey = CubeUtils.getCacheModelIdKey(cubeId);
        ICache cache = Cache.get();
        String versionStr = cache.get(cacheKey);
        if (StringUtils.isEmpty(versionStr)) {
            log.info("updateVersion:updateModelVersionNo" + cubeId + "-" + versionId);
            int re = 0;
            try (TXHandle th = TX.notSupported();){
                try {
                    re = DB.update((DBRoute)BgBaseConstant.epm, (String)"update t_eb_model set fversion = ? where fid = ? and fversion = ?", (Object[])new Object[]{versionId, cubeId, versionId});
                }
                catch (Exception e) {
                    th.markRollback();
                    log.error(e.getMessage());
                    throw new KDBizException(e.getMessage());
                }
            }
            if (re == 1 && StringUtils.isEmpty(versionStr = cache.get(cacheKey))) {
                cache.set(CACHE_MODEL_ID + cubeId, versionId.toString(), 1, TimeUnit.HOURS);
            }
        }
    }

    private static void updateDimensionVersionNo(Long dimensionId, Long versionId) {
        log.info("updateVersion:updateDimensionVersionNo" + dimensionId + versionId);
        try (TXHandle th = TX.notSupported();){
            try {
                DB.execute((DBRoute)BgBaseConstant.epm, (String)"update t_eb_dimension set fversion = ? where fid = ?", (Object[])new Object[]{versionId, dimensionId});
                CubeUtils.setDimensionVersionNo(dimensionId, versionId);
            }
            catch (Exception e) {
                th.markRollback();
                log.error(e.getMessage());
                throw new KDBizException(e.getMessage());
            }
        }
    }

    public static void setDimensionVersionNo(Long dimensionId, Long versionId) {
        Cache.get().set(CACHE_DIMENSION_VERSION_ID + dimensionId, versionId.toString(), 1, TimeUnit.HOURS);
    }

    public static Long getDimensionVersionNo(Long dimensionId) {
        String version = Cache.get().get(CACHE_DIMENSION_VERSION_ID + dimensionId);
        if (StringUtils.isEmpty(version)) {
            return -1L;
        }
        return Long.parseLong(version);
    }

    private static void updateViewVersionNo(Long viewId, Long versionId) {
        log.info("updateVersion:updateViewVersionNo" + viewId + versionId);
        try (TXHandle th = TX.notSupported();){
            try {
                DB.execute((DBRoute)BgBaseConstant.epm, (String)"update t_eb_dimensionview set fversion = ? where fid = ?", (Object[])new Object[]{versionId, viewId});
            }
            catch (Exception e) {
                th.markRollback();
                log.error(e.getMessage());
                throw new KDBizException(e.getMessage());
            }
        }
    }

    public static void clearCentralizedCache(Long modelId, Long dimensionId) {
        if (IDUtils.isNull(modelId) || IDUtils.isNull(dimensionId)) {
            return;
        }
        QFBuilder builder = new QFBuilder();
        builder.add(new QFilter("id", "=", (Object)dimensionId));
        builder.add(new QFilter("number", "=", (Object)SysDimensionEnum.Entity.getNumber()));
        if (QueryServiceHelper.exists((String)"epm_dimension", (QFilter[])builder.toArrays())) {
            DB.execute((DBRoute)BgBaseConstant.epm, (String)"update t_eb_centralized_range set fentityrangenumbers = ' ' where fid in (select fid from t_eb_centralized_entity where fmodel = ?)", (Object[])new Object[]{modelId});
            DB.execute((DBRoute)BgBaseConstant.epm, (String)"update t_eb_centralized_range set frangenumbers = ' ' where fid in (select fid from t_eb_centralized_entity where fmodel = ? and fdimension = 0)", (Object[])new Object[]{modelId});
            BgControlCache.clearCentralized(modelId);
        } else if (CubeUtils.checkRefDimensionByCentralized(modelId, dimensionId)) {
            BgControlCache.clearCentralized(modelId);
        }
        DB.execute((DBRoute)BgBaseConstant.epm, (String)"update t_eb_centralized_range set frangenumbers = ' ' where fid in (select fid from t_eb_centralized_entity where fmodel = ? and fdimension = ?)", (Object[])new Object[]{modelId, dimensionId});
        CurrencyConvertCache.getInstance().clearSchemeCacheForModelId(modelId);
    }

    private static boolean checkRefDimensionByCentralized(Long modelId, Long dimensionId) {
        if (IDUtils.isNull(modelId) || IDUtils.isNull(dimensionId)) {
            return false;
        }
        boolean re = false;
        try (DataSet ds = DB.queryDataSet((String)"queryCentralized", (DBRoute)BgBaseConstant.epm, (String)"select top 1 fid from t_eb_centralized_entity where fmodel = ? and fdimension = ?", (Object[])new Object[]{modelId, dimensionId});){
            if (ds != null && ds.hasNext()) {
                re = true;
            }
        }
        return re;
    }

    static class BusModel {
        BusModel() {
        }

        public void check(Long cubeId, Long busModelId) {
            EBThreadPoolExecutor.executeOnce(() -> DispatchServiceHelper.invokeBizService((String)"epm", (String)"eb", (String)"OlapCheckService", (String)"checkBusModel", (Object[])new Object[]{cubeId, busModelId}), "checkBusModel");
        }
    }

    static class View {
        View() {
        }

        public void check(Long cubeId, Long dimensionId, Long viewId) {
            EBThreadPoolExecutor.executeOnce(() -> DispatchServiceHelper.invokeBizService((String)"epm", (String)"eb", (String)"OlapCheckService", (String)"checkView", (Object[])new Object[]{cubeId, dimensionId, viewId}), "checkView");
        }

        public void checkDelete(Long cubeId, Long dimensionId, Long viewId) {
            DispatchServiceHelper.invokeBizService((String)"epm", (String)"eb", (String)"OlapCheckService", (String)"checkDeleteView", (Object[])new Object[]{cubeId, dimensionId, viewId});
        }

        public void delete(Long cubeId, Long dimensionId, Long viewId) {
            EBThreadPoolExecutor.executeOnce(() -> DispatchServiceHelper.invokeBizService((String)"epm", (String)"eb", (String)"OlapCheckService", (String)"deleteView", (Object[])new Object[]{cubeId, dimensionId, viewId}), "checkView");
        }
    }

    static class Cube {
        Cube() {
        }

        public void check(Long modelId) {
            this.syncCheck(modelId, (Long)null);
        }

        public void check(Long modelId, Long datasetId) {
            this.syncCheck(modelId, datasetId);
        }

        public void check(Long modelId, Long[] versionIds) {
            this.syncCheck(modelId, versionIds);
        }

        public void delete(Long modelId) {
            this.syncDelete(modelId);
        }

        public void checkDelete(Long modelId) {
            if (modelId == null || modelId == 0L) {
                return;
            }
            DispatchServiceHelper.invokeBizService((String)"epm", (String)"eb", (String)"OlapCheckService", (String)"checkDeleteCube", (Object[])new Object[]{modelId});
        }

        private void syncCheck(Long cubeId, Long datasetId) {
            if (cubeId == null || cubeId == 0L) {
                return;
            }
            EBThreadPoolExecutor.executeOnce(() -> DispatchServiceHelper.invokeBizService((String)"epm", (String)"eb", (String)"OlapCheckService", (String)"checkCube", (Object[])new Object[]{cubeId, datasetId}), "checkCube");
        }

        private void syncCheck(Long cubeId, Long[] versionIds) {
            if (cubeId == null || cubeId == 0L || versionIds == null || versionIds.length == 0) {
                return;
            }
            EBThreadPoolExecutor.executeOnce(() -> DispatchServiceHelper.invokeBizService((String)"epm", (String)"eb", (String)"OlapCheckService", (String)"checkCube", (Object[])new Object[]{cubeId, null, versionIds}), "checkCube");
        }

        private void syncDelete(Long cubeId) {
            if (cubeId == null || cubeId == 0L) {
                return;
            }
            EBThreadPoolExecutor.executeOnce(() -> DispatchServiceHelper.invokeBizService((String)"epm", (String)"eb", (String)"OlapCheckService", (String)"deleteCube", (Object[])new Object[]{cubeId}), "deleteCube");
        }
    }

    static class Dataset {
        Dataset() {
        }

        public void check(Long cubeId, Long datasetId) {
            EBThreadPoolExecutor.executeOnce(() -> DispatchServiceHelper.invokeBizService((String)"epm", (String)"eb", (String)"OlapCheckService", (String)"checkDataset", (Object[])new Object[]{cubeId, datasetId}), "checkDataset");
        }

        public void delete(Long cubeId, Long datasetId) {
            this.syncDelete(cubeId, datasetId);
        }

        public void checkDelete(Long cubeId, Long datasetId) {
            if (cubeId == null || cubeId == 0L || datasetId == null || datasetId == 0L) {
                return;
            }
            DispatchServiceHelper.invokeBizService((String)"epm", (String)"eb", (String)"OlapCheckService", (String)"checkDeleteDataset", (Object[])new Object[]{cubeId, datasetId});
        }

        public void syncDelete(Long cubeId, Long datasetId) {
            if (cubeId == null || cubeId == 0L || datasetId == null || datasetId == 0L) {
                return;
            }
            EBThreadPoolExecutor.executeOnce(() -> DispatchServiceHelper.invokeBizService((String)"epm", (String)"eb", (String)"OlapCheckService", (String)"deleteDataset", (Object[])new Object[]{cubeId, datasetId}), "deleteDataset");
        }
    }

    static class Dimension {
        Dimension() {
        }

        public void check(Long modelId, Long dimensionId, Long viewId) {
            if (modelId == null || modelId == 0L || dimensionId == null || dimensionId == 0L) {
                return;
            }
            CubeUtils.updateDimensionVersion(modelId, dimensionId, viewId, true);
            DimMembPermVerHelper.updateVer4MembChanged(viewId, modelId, dimensionId, "afterBatViewMembChanged");
            this.sync(modelId, dimensionId, viewId);
            CubeUtils.clearCentralizedCache(modelId, dimensionId);
            BgLockCacheServiceHelper.reloadCacheByView(modelId, dimensionId, viewId);
        }

        public void check(Long modelId, Long[] dimensionIds) {
            if (modelId == null || modelId == 0L || dimensionIds == null || dimensionIds.length == 0) {
                return;
            }
            CubeUtils.updateDimensionVersion(modelId, dimensionIds);
            this.sync(modelId, dimensionIds);
        }

        public void delete(Long modelId, Long dimensionId) {
            if (modelId == null || modelId == 0L || dimensionId == null || dimensionId == 0L) {
                return;
            }
            CubeUtils.updateDimensionVersion(modelId, null, null);
            this.syncDelete(modelId, dimensionId);
        }

        public void checkDelete(Long modelId, Long datasetId, Long dimensionId) {
            if (modelId == null || modelId == 0L || dimensionId == null || dimensionId == 0L) {
                return;
            }
            DispatchServiceHelper.invokeBizService((String)"epm", (String)"eb", (String)"OlapCheckService", (String)"checkDeleteDimension", (Object[])new Object[]{modelId, datasetId, dimensionId});
        }

        private void sync(Long modelId, Long dimensionId, Long viewId) {
            if (modelId == null || modelId == 0L || dimensionId == null || dimensionId == 0L) {
                return;
            }
            EBThreadPoolExecutor.executeOnce(() -> DispatchServiceHelper.invokeBizService((String)"epm", (String)"eb", (String)"OlapCheckService", (String)"checkDimension", (Object[])new Object[]{modelId, dimensionId, viewId}), "checkDimension");
        }

        private void sync(Long modelId, Long[] dimensionIds) {
            if (modelId == null || modelId == 0L || dimensionIds == null || dimensionIds.length == 0) {
                return;
            }
            EBThreadPoolExecutor.executeOnce(() -> DispatchServiceHelper.invokeBizService((String)"epm", (String)"eb", (String)"OlapCheckService", (String)"checkDimension", (Object[])new Object[]{modelId, dimensionIds}), "checkDimension");
        }

        private void syncDelete(Long modelId, Long dimensionId) {
            if (modelId == null || modelId == 0L || dimensionId == null || dimensionId == 0L) {
                return;
            }
        }
    }

    static class Member {
        Member() {
        }

        public void check(Long modelId, Long dimensionId, String dimensionNumber, Long viewId, Long[] memberIds) {
            if (modelId == null || modelId == 0L || dimensionId == null || dimensionId == 0L || memberIds == null || memberIds.length == 0) {
                return;
            }
            CubeUtils.updateDimensionVersion(modelId, dimensionId, viewId, false);
            this.sync(modelId, dimensionId, viewId, memberIds);
            CubeUtils.clearCentralizedCache(modelId, dimensionId);
            DimMembPermVerHelper.updateVer4MembChanged(viewId, modelId, dimensionId, "afterBatViewMembChanged");
            BgLockCacheServiceHelper.reloadCacheByView(modelId, dimensionId, viewId);
        }

        public void delete(Long modelId, Long dimensionId, Long viewId, Long[] memberIds) {
            if (modelId == null || modelId == 0L || dimensionId == null || dimensionId == 0L || memberIds == null || memberIds.length == 0) {
                return;
            }
            CubeUtils.updateDimensionVersion(modelId, dimensionId, viewId, false);
            this.syncDelete(modelId, dimensionId, viewId, memberIds);
            CubeUtils.clearCentralizedCache(modelId, dimensionId);
            DimMembPermVerHelper.updateVer4MembChanged(viewId, modelId, dimensionId, "afterBatViewMembChanged");
            BgLockCacheServiceHelper.reloadCacheByView(modelId, dimensionId, viewId);
        }

        public void checkDelete(Long modelId, Long dimensionId, Long viewId, Long[] memberIds) {
            if (modelId == null || modelId == 0L || dimensionId == null || dimensionId == 0L || memberIds == null || memberIds.length == 0) {
                return;
            }
            DispatchServiceHelper.invokeBizService((String)"epm", (String)"eb", (String)"OlapMemberService", (String)"checkDeleteMember", (Object[])new Object[]{modelId, dimensionId, viewId, memberIds});
        }

        private void sync(Long modelId, Long dimensionId, Long viewId, Long[] memberIds) {
            if (modelId == null || modelId == 0L || dimensionId == null || dimensionId == 0L || memberIds == null || memberIds.length == 0) {
                return;
            }
            EBThreadPoolExecutor.executeOnce(() -> {
                long begin = System.nanoTime();
                try {
                    DispatchServiceHelper.invokeBizService((String)"epm", (String)"eb", (String)"OlapMemberService", (String)"checkMember", (Object[])new Object[]{modelId, dimensionId, viewId, memberIds});
                }
                finally {
                    log.info("budget-olap-log : end checkDimension. use = " + LogUtils.use(begin));
                }
            }, "checkMember");
        }

        private void syncDelete(Long modelId, Long dimensionId, Long viewId, Long[] memberIds) {
            if (modelId == null || modelId == 0L || dimensionId == null || dimensionId == 0L || memberIds == null || memberIds.length == 0) {
                return;
            }
            EBThreadPoolExecutor.executeOnce(() -> {
                long begin = System.nanoTime();
                try {
                    DispatchServiceHelper.invokeBizService((String)"epm", (String)"eb", (String)"OlapMemberService", (String)"deleteMember", (Object[])new Object[]{modelId, dimensionId, viewId, memberIds});
                }
                finally {
                    log.info("budget-olap-log : end deleteMember. use = " + LogUtils.use(begin));
                }
            }, "deleteMember");
        }
    }
}

