/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.common.utils;

import java.util.concurrent.TimeUnit;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.context.RequestContext;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.SqlBuilder;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.epm.eb.common.cache.threadlocal.EpmThreadLocalUtils;
import kd.epm.eb.common.constant.BgBaseConstant;
import kd.epm.eb.common.utils.IDUtils;
import kd.epm.eb.common.utils.SqlBatchUtils;
import kd.epm.eb.common.utils.StringUtils;
import kd.epm.eb.common.utils.cache.Cache;

public class DataSourceUtils {
    public static final Log log = LogFactory.getLog(DataSourceUtils.class);
    private static final String DATACENTER_ACCOUNT_PARAM = "OPEN-DATASOURCE-ACCOUNT";

    public static String getAccountId() {
        return RequestContext.get().getAccountId();
    }

    public static boolean verifyAccount(Long dataSourceId, String accountId) {
        return EpmThreadLocalUtils.verifyAccountId(dataSourceId, accountId);
    }

    public static boolean $verifyAccountByPrivate(Long dataSourceId, String accountId) {
        if (IDUtils.isNull(dataSourceId) || StringUtils.isEmpty(accountId) || "0".equals(accountId)) {
            return true;
        }
        boolean verify = true;
        String cacheKey = "OPEN-DATASOURCE-ACCOUNT-" + dataSourceId;
        String verify_Cache_AccountId = Cache.get().get(cacheKey);
        if (verify_Cache_AccountId == null) {
            try {
                boolean isVerifyAccount = false;
                if (SqlBatchUtils.hasTable("T_EB_PARAM")) {
                    SqlBuilder sql = new SqlBuilder();
                    sql.append("select fid, fvalue from t_eb_param where fnumber = ?", new Object[]{DATACENTER_ACCOUNT_PARAM});
                    try (DataSet ds = DB.queryDataSet((String)"queryParams", (DBRoute)BgBaseConstant.epm, (SqlBuilder)sql);){
                        if (ds != null && ds.hasNext()) {
                            Row row = ds.next();
                            isVerifyAccount = StringUtils.equals("1", row.getString("fvalue"));
                        }
                    }
                }
                if (isVerifyAccount) {
                    verify = StringUtils.equals(DataSourceUtils.getAccountId(), accountId);
                }
            }
            catch (Exception ex) {
                log.error("queryParams-error:", (Throwable)ex);
            }
            Cache.get().set(cacheKey, String.valueOf(verify), 5, TimeUnit.MINUTES);
        } else {
            verify = Boolean.parseBoolean(verify_Cache_AccountId);
        }
        return verify;
    }
}

