/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.common.utils;

import java.util.HashSet;
import java.util.List;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;

public class DataUploadServiceHelper {
    public static final String FIELDS = "id, name, number,state, srcbusinessmodel, trgbusinessmodel, model, entryentity.srcdimtext, entryentity.srcdimnumber, entryentity.srcdimview, entryentity.trgdimtext, entryentity.trgdimnumber, entryentity.trgdimview,accountentryentity.srcaccount, accountentryentity.trgaccount, accountentryentity.entrystatus, accountentryentity.startdate, accountentryentity.enddate, description";
    public static final String DIMFIELDS = "id, entryentity.srcdimtext, entryentity.srcdimmemshow, entryentity.srcdimmembertype, entryentity.srcdimmemnumber, entryentity.srcdimnumber, entryentity.srcdimview, entryentity.trgdimtext, entryentity.trgdimnumber,entryentity.trgdimmemshow, entryentity.trgdimmembertype, entryentity.trgdimmemnumber, entryentity.trgdimview";
    public static final String ACCOUNTFIELDS = "id, accountentryentity.srcaccount, accountentryentity.trgaccount, accountentryentity.entrystatus, accountentryentity.startdate,accountentryentity.enddate";
    private static final DataUploadServiceHelper instance = new DataUploadServiceHelper();

    private DataUploadServiceHelper() {
    }

    public static DataUploadServiceHelper getInstance() {
        return instance;
    }

    public DynamicObject[] getSchemeListByIds(List<Long> ids, Long modelId) {
        QFilter qf1 = new QFilter("id", "in", ids);
        QFilter qf2 = new QFilter("model", "=", (Object)modelId);
        DynamicObject[] dataSchemeList = BusinessDataServiceHelper.load((String)"eb_datauploadscheme", (String)"name, id, state, enable", (QFilter[])new QFilter[]{qf1.and(qf2)}, (String)"id desc");
        return dataSchemeList;
    }

    public DynamicObject[] getSchemeByName(String name, Long modelId, String state) {
        QFilter qf1 = new QFilter("name", "=", (Object)name);
        QFilter qf2 = new QFilter("model", "=", (Object)modelId);
        QFilter qf3 = new QFilter("state", "=", (Object)state);
        DynamicObject[] dataSchemeList = BusinessDataServiceHelper.load((String)"eb_datauploadscheme", (String)"name, id, state, enable", (QFilter[])new QFilter[]{qf1.and(qf2).and(qf3)});
        return dataSchemeList;
    }

    public DynamicObject busModelIsExit(Long busModelId) {
        QFilter qf1 = new QFilter("id", "=", (Object)busModelId);
        DynamicObject dynamicObject = QueryServiceHelper.queryOne((String)"eb_businessmodel", (String)"id", (QFilter[])new QFilter[]{qf1});
        return dynamicObject;
    }

    public DynamicObjectCollection getSchemeListByModel(Long model) {
        QFilter qf1 = new QFilter("model", "=", (Object)model);
        DynamicObjectCollection dyList = QueryServiceHelper.query((String)"eb_datauploadscheme", (String)"id, name, number, srcbusinessmodel, trgbusinessmodel", (QFilter[])new QFilter[]{qf1});
        return dyList;
    }

    public Set<String> querySchemeLogByNumbers(List<String> numbers, Long model) {
        QFilter qf = new QFilter("number", "in", numbers);
        QFilter qf2 = new QFilter("model", "=", (Object)model);
        DynamicObjectCollection query = QueryServiceHelper.query((String)"eb_datauploadlog", (String)"id, number, name", (QFilter[])new QFilter[]{qf.and(qf2)});
        HashSet<String> dimNumber = new HashSet<String>(16);
        if (query != null && query.size() > 0) {
            for (DynamicObject dy : query) {
                dimNumber.add(dy.getString("number"));
            }
        }
        return dimNumber;
    }

    public DynamicObjectCollection querySchemeLogByNumber(String number, Long modelId) {
        QFilter qf = new QFilter("number", "=", (Object)number);
        QFilter qf1 = new QFilter("model", "=", (Object)modelId);
        DynamicObjectCollection query = QueryServiceHelper.query((String)"eb_datauploadlog", (String)"id, number, name", (QFilter[])new QFilter[]{qf.and(qf1)});
        return query;
    }

    public DynamicObject querySchemeById(Long id, Long modelId) {
        QFilter qf = new QFilter("id", "=", (Object)id);
        QFilter qf1 = new QFilter("model", "=", (Object)modelId);
        DynamicObject query = QueryServiceHelper.queryOne((String)"eb_datauploadscheme", (String)"id, number, name, srcbusinessmodel, trgbusinessmodel, description, state, enable, model,taskstatus,org,period", (QFilter[])new QFilter[]{qf.and(qf1)});
        return query;
    }

    public DynamicObjectCollection querySchemeDimMapById(Long id, Long modelId) {
        QFilter qf = new QFilter("id", "=", (Object)id);
        QFilter qf1 = new QFilter("model", "=", (Object)modelId);
        DynamicObjectCollection query = QueryServiceHelper.query((String)"eb_datauploadscheme", (String)DIMFIELDS, (QFilter[])new QFilter[]{qf.and(qf1)});
        return query;
    }

    public DynamicObjectCollection querySchemeAccMapById(Long id, Long modelId) {
        QFilter qf = new QFilter("id", "=", (Object)id);
        QFilter qf1 = new QFilter("model", "=", (Object)modelId);
        DynamicObjectCollection query = QueryServiceHelper.query((String)"eb_datauploadscheme", (String)ACCOUNTFIELDS, (QFilter[])new QFilter[]{qf.and(qf1)}, (String)"accountentryentity.seq");
        return query;
    }
}

