/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.common.utils;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.SqlBuilder;
import kd.bos.lang.Lang;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.epm.eb.common.cache.impl.Dataset;
import kd.epm.eb.common.cache.impl.Dimension;
import kd.epm.eb.common.cache.impl.Member;
import kd.epm.eb.common.constant.BgBaseConstant;
import kd.epm.eb.common.enums.SysDimensionEnum;
import kd.epm.eb.common.model.MemberEntity;
import kd.epm.eb.common.shrek.controller.ShrekOlapServiceHelper;
import kd.epm.eb.common.utils.CommonServiceHelper;
import kd.epm.eb.common.utils.IDUtils;
import kd.epm.eb.common.utils.ModelServiceHelper;
import kd.epm.eb.common.utils.NewEbAppUtil;
import kd.epm.eb.common.utils.QFBuilder;
import kd.epm.eb.common.utils.base.LanguageUtils;
import kd.epm.eb.common.utils.convert.Convert;
import kd.epm.eb.common.utils.viewgroup.ViewGroupServiceHelper;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.jetbrains.annotations.NotNull;

public class DatasetServiceHelper {
    private static final DatasetServiceHelper instance = new DatasetServiceHelper();

    private DatasetServiceHelper() {
    }

    public static DatasetServiceHelper getInstance() {
        return instance;
    }

    public static DynamicObject loadDatasets(Long datasetId) {
        return DatasetServiceHelper.loadDatasets(datasetId, "id, name, number");
    }

    public static DynamicObjectCollection loadDatasets(Long[] datasetIds) {
        return DatasetServiceHelper.loadDatasets(datasetIds, "id, name, number");
    }

    public static DynamicObject loadDatasets(Long datasetId, String selectors) {
        if (datasetId == null || datasetId == 0L) {
            return null;
        }
        QFBuilder builder = new QFBuilder();
        builder.add(new QFilter("id", "=", (Object)datasetId));
        return BusinessDataServiceHelper.loadSingleFromCache((String)"eb_dataset", (String)selectors, (QFilter[])builder.toArray());
    }

    public static DynamicObjectCollection loadDatasets(Long[] datasetIds, String selectors) {
        if (datasetIds == null || datasetIds.length == 0) {
            return null;
        }
        QFBuilder builder = new QFBuilder();
        builder.add(new QFilter("id", "in", Arrays.asList(datasetIds)));
        DynamicObjectCollection collection = null;
        Map datasets = BusinessDataServiceHelper.loadFromCache((String)"eb_dataset", (String)selectors, (QFilter[])builder.toArray());
        if (datasets != null) {
            collection = new DynamicObjectCollection();
            collection.addAll(datasets.values());
        }
        return collection;
    }

    public static Long[] queryDatasetIds(Long cubeId) {
        if (cubeId == null || cubeId == 0L) {
            return null;
        }
        LinkedList<Long> datasetIds = new LinkedList<Long>();
        try (DataSet ds = DB.queryDataSet((String)"dataset", (DBRoute)DBRoute.of((String)"epm"), (String)"select fid from t_eb_dataset where fmodel = ?", (Object[])new Object[]{cubeId});){
            if (ds != null) {
                Row row = null;
                while (ds.hasNext()) {
                    row = ds.next();
                    datasetIds.add(row.getLong("fid"));
                }
            }
        }
        return datasetIds.toArray(new Long[datasetIds.size()]);
    }

    public static List<Long> queryDatasetIds(@NotNull Long modelId, @NotNull Long dimensionId) {
        LinkedList<Long> datasets = new LinkedList<Long>();
        String sql = "select distinct a.fid from t_eb_dataset a left join t_eb_datasetdim b on a.fid = b.fid where a.fmodel = ? and b.fdatasetdim = ?";
        try (DataSet ds = DB.queryDataSet((String)"queryDatasetIds", (DBRoute)BgBaseConstant.epm, (String)sql, (Object[])new Object[]{modelId, dimensionId});){
            if (ds != null) {
                for (Row row : ds) {
                    datasets.add(row.getLong("fid"));
                }
            }
        }
        return datasets;
    }

    public Long queryBizModelByAccountId(Long accountId) {
        Long datasetId = this.queryDatasetByAccountId(accountId);
        return this.queryBizmodelByDatasetId(datasetId);
    }

    public Long[] queryAppSceneByBizmodelId(Long bizmodelid) {
        if (bizmodelid == null || bizmodelid == 0L) {
            return new Long[0];
        }
        LinkedList<Long> appSceneIds = new LinkedList<Long>();
        try (DataSet ds = DB.queryDataSet((String)"dataset", (DBRoute)DBRoute.of((String)"epm"), (String)"select fappscenarioid from t_eb_scenarioentry where fid = ?", (Object[])new Object[]{bizmodelid});){
            if (ds != null) {
                Row row = null;
                while (ds.hasNext()) {
                    row = ds.next();
                    appSceneIds.add(row.getLong("fappscenarioid"));
                }
            }
        }
        return appSceneIds.toArray(new Long[appSceneIds.size()]);
    }

    public Long queryBizmodelByDatasetId(Long datasetId) {
        if (datasetId == null || datasetId == 0L) {
            return null;
        }
        Long bizmodelid = null;
        try (DataSet ds = DB.queryDataSet((String)"dataset", (DBRoute)DBRoute.of((String)"epm"), (String)"select fbizmodelid from t_eb_dataset where fid = ?", (Object[])new Object[]{datasetId});){
            if (ds != null) {
                Row row = ds.next();
                bizmodelid = row.getLong("fbizmodelid");
            }
        }
        return bizmodelid;
    }

    public Long queryDatasetByAccountId(Long accountId) {
        if (accountId == null || accountId == 0L) {
            return null;
        }
        Long datasetId = null;
        try (DataSet ds = DB.queryDataSet((String)"dataset", (DBRoute)DBRoute.of((String)"epm"), (String)"select fdataset from t_eb_structofaccount where fid = ?", (Object[])new Object[]{accountId});){
            if (ds != null) {
                Row row = ds.next();
                datasetId = row.getLong("fdataset");
            }
        }
        return datasetId;
    }

    public List<Member> listAccountByDatasetId(List<Long> datasetIds) {
        if (datasetIds == null || datasetIds.isEmpty()) {
            return Collections.emptyList();
        }
        String collect = datasetIds.stream().map(Convert::toStr).collect(Collectors.joining(","));
        ArrayList<Member> accMembers = new ArrayList<Member>(10);
        String sql = "select fid,fnumber,fdataset from t_eb_structofaccount where fdataset in (" + collect + ")";
        try (DataSet ds = DB.queryDataSet((String)this.getClass().getName(), (DBRoute)DBRoute.of((String)"epm"), (String)sql, null);){
            while (ds.hasNext()) {
                Row row = ds.next();
                Member member = new Member();
                member.setId(row.getLong("fid"));
                member.setNumber(row.getString("fnumber"));
                member.setDatasetId(row.getLong("fdataset"));
                accMembers.add(member);
            }
        }
        return accMembers;
    }

    public Dataset getDataSet(Long datasetId) {
        if (datasetId == null || datasetId == 0L) {
            return null;
        }
        DynamicObject dynamicObject = DatasetServiceHelper.loadDatasets(datasetId);
        if (dynamicObject != null) {
            Dataset dataSet = new Dataset();
            dataSet.setId(dynamicObject.getLong("id"));
            dataSet.setName(dynamicObject.getString("name"));
            dataSet.setNumber(dynamicObject.getString("number"));
            return dataSet;
        }
        return null;
    }

    public Dataset queryDataSetByAccountId(Long accountId) {
        if (accountId == null || accountId == 0L) {
            return null;
        }
        QFilter qFilter = new QFilter("id", "=", (Object)accountId);
        DynamicObject dynamicObject = QueryServiceHelper.queryOne((String)SysDimensionEnum.Account.getMemberTreemodel(), (String)"dataset,dataset.name,dataset.number", (QFilter[])qFilter.toArray());
        if (dynamicObject != null) {
            Dataset dataSet = new Dataset();
            dataSet.setId(dynamicObject.getLong("dataset"));
            dataSet.setName(dynamicObject.getString("dataset.name"));
            dataSet.setNumber(dynamicObject.getString("dataset.number"));
            return dataSet;
        }
        return null;
    }

    public List<kd.epm.eb.common.model.Dimension> listDimensionByAccountId(Long accountId, Long modelId) {
        if (accountId == null || accountId == 0L || modelId == null || modelId == 0L) {
            return Collections.emptyList();
        }
        Long datasetId = this.queryDatasetByAccountId(accountId);
        return this.listDimensionByDatasetId(datasetId);
    }

    public List<kd.epm.eb.common.model.Dimension> listDimensionByDatasetId(Long datasetId) {
        if (datasetId == null || datasetId == 0L) {
            return Collections.emptyList();
        }
        List<kd.epm.eb.common.model.Dimension> dimensions1 = this.listDimensionIgnoreViewByDatasetId(datasetId);
        if (dimensions1.isEmpty()) {
            return Collections.emptyList();
        }
        Long bizmodel = this.queryBizmodelByDatasetId(datasetId);
        List<kd.epm.eb.common.model.Dimension> dimension2 = this.listDimensionBybizmodelId(bizmodel);
        if (dimension2.isEmpty()) {
            return dimensions1;
        }
        Map<Long, Long> collect = dimension2.stream().collect(Collectors.toMap(kd.epm.eb.common.model.Dimension::getId, kd.epm.eb.common.model.Dimension::getViewId));
        for (kd.epm.eb.common.model.Dimension dimension : dimensions1) {
            Long viewId = collect.get(dimension.getId());
            if (viewId == null) continue;
            dimension.setViewId(viewId);
        }
        return dimensions1;
    }

    public List<kd.epm.eb.common.model.Dimension> listDimensionByDatasetId_Exec(Long datasetId) {
        if (datasetId == null || datasetId == 0L) {
            return Collections.emptyList();
        }
        List<kd.epm.eb.common.model.Dimension> dimensions1 = this.listDimensionIgnoreViewByDatasetId_Exec(datasetId);
        if (dimensions1.isEmpty()) {
            return Collections.emptyList();
        }
        Long bizmodel = this.queryBizmodelByDatasetId(datasetId);
        List<kd.epm.eb.common.model.Dimension> dimension2 = this.listDimensionBybizmodelId(bizmodel);
        if (dimension2.isEmpty()) {
            return dimensions1;
        }
        Map<Long, Long> collect = dimension2.stream().collect(Collectors.toMap(kd.epm.eb.common.model.Dimension::getId, kd.epm.eb.common.model.Dimension::getViewId));
        for (kd.epm.eb.common.model.Dimension dimension : dimensions1) {
            Long viewId = collect.get(dimension.getId());
            if (viewId == null) continue;
            dimension.setViewId(viewId);
        }
        return dimensions1;
    }

    public List<kd.epm.eb.common.model.Dimension> listDimensionBybizmodelId(Long bizmodelId) {
        if (bizmodelId == null || bizmodelId == 0L) {
            return Collections.emptyList();
        }
        ArrayList<kd.epm.eb.common.model.Dimension> dimensionList = new ArrayList<kd.epm.eb.common.model.Dimension>(16);
        QFBuilder builder = new QFBuilder();
        builder.add("id", "=", bizmodelId);
        DynamicObjectCollection dynamicObjects = QueryServiceHelper.query((String)"eb_businessmodel", (String)"id,viewentry.dimension,viewentry.viewgroup.defaultview", (QFilter[])builder.toArray());
        if (CollectionUtils.isNotEmpty((Collection)dynamicObjects)) {
            for (DynamicObject dynamicObject : dynamicObjects) {
                kd.epm.eb.common.model.Dimension dimension = new kd.epm.eb.common.model.Dimension(dynamicObject.getLong("viewentry.dimension"));
                dimension.setViewId(dynamicObject.getLong("viewentry.viewgroup.defaultview"));
                dimensionList.add(dimension);
            }
        }
        return dimensionList;
    }

    public Long getBizModelIdByDataSetId(Long dataSetId) {
        if (dataSetId == null || dataSetId == 0L) {
            return null;
        }
        QFilter qFilter = new QFilter("id", "=", (Object)dataSetId);
        DynamicObject dynamicObject = QueryServiceHelper.queryOne((String)"eb_dataset", (String)"businessmodel", (QFilter[])qFilter.toArray());
        if (dynamicObject != null) {
            return dynamicObject.getLong("businessmodel");
        }
        return null;
    }

    public List<Dataset> getDataSetObjByBizModelId(Long bizModelId) {
        if (bizModelId == null || bizModelId == 0L) {
            return Collections.emptyList();
        }
        ArrayList<Dataset> dataSetIds = new ArrayList<Dataset>(16);
        try (DataSet ds = DB.queryDataSet((String)"dataset", (DBRoute)DBRoute.of((String)"epm"), (String)"select fid,fnumber,fname from t_eb_dataset where fbizmodelid = ? order by fcreatedate", (Object[])new Object[]{bizModelId});){
            while (ds.hasNext()) {
                Row row = ds.next();
                Dataset obj = new Dataset();
                obj.setId(row.getLong("fid"));
                obj.setName(row.getString("fname"));
                obj.setNumber(row.getString("fnumber"));
                dataSetIds.add(obj);
            }
        }
        return dataSetIds;
    }

    public List<Long> getDataSetIdByBizModelId(Long bizModelId) {
        if (bizModelId == null || bizModelId == 0L) {
            return Collections.emptyList();
        }
        ArrayList<Long> dataSetIds = new ArrayList<Long>(16);
        try (DataSet ds = DB.queryDataSet((String)"dataset", (DBRoute)DBRoute.of((String)"epm"), (String)"select fid from t_eb_dataset where fbizmodelid = ?", (Object[])new Object[]{bizModelId});){
            while (ds.hasNext()) {
                Row row = ds.next();
                dataSetIds.add(row.getLong("fid"));
            }
        }
        return dataSetIds;
    }

    public static List<Long> getDataSetIdByBusModelIds(Set<Long> busModelIds) {
        if (busModelIds == null || busModelIds.isEmpty()) {
            return Collections.emptyList();
        }
        SqlBuilder sql = new SqlBuilder();
        sql.append("select fid from t_eb_dataset where ", new Object[0]).appendIn("fbizmodelid", busModelIds.toArray());
        ArrayList<Long> dataSetIds = new ArrayList<Long>(16);
        try (DataSet ds = DB.queryDataSet((String)"dataset", (DBRoute)BgBaseConstant.epm, (SqlBuilder)sql);){
            if (ds != null) {
                for (Row row : ds) {
                    dataSetIds.add(row.getLong("fid"));
                }
            }
        }
        return dataSetIds;
    }

    private List<kd.epm.eb.common.model.Dimension> listDimensionIgnoreViewByDatasetId(Long datasetId) {
        if (datasetId == null || datasetId == 0L) {
            return Collections.emptyList();
        }
        StringBuilder sbSql = new StringBuilder().append("select a.fid as id,a.fnumber,a.fshortnumber,a.fmembermodel,a.fmodelid fmodelid,a.fdseq as seq from t_eb_dimension a ").append("left join t_eb_datasetdim b ON a.fid = b.fdatasetdim ").append("where b.fid = ?");
        ArrayList<kd.epm.eb.common.model.Dimension> dimList = new ArrayList<kd.epm.eb.common.model.Dimension>();
        try (DataSet ds = DB.queryDataSet((String)"dataset", (DBRoute)DBRoute.of((String)"epm"), (String)sbSql.toString(), (Object[])new Object[]{datasetId});){
            while (ds.hasNext()) {
                Row next = ds.next();
                kd.epm.eb.common.model.Dimension dimension = new kd.epm.eb.common.model.Dimension(next.getLong("id"));
                dimension.setModelId(next.getLong("fmodelid"));
                dimension.setNumber(next.getString("fnumber"));
                dimension.setShortNumber(next.getString("fshortnumber"));
                dimension.setMemberModel(next.getString("fmembermodel"));
                dimension.setSeq(next.getInteger("seq"));
                dimList.add(dimension);
            }
        }
        if (CollectionUtils.isNotEmpty(dimList)) {
            SqlBuilder sbSql2 = new SqlBuilder().append("select fid,fname from t_eb_dimension_l", new Object[0]).append("where flocaleid = ?", new Object[]{LanguageUtils.getLang(Lang.zh_CN).name()}).append("and", new Object[0]).appendIn("fid", dimList.stream().map(kd.epm.eb.common.model.Dimension::getId).distinct().toArray());
            HashMap<Long, String> dimNameMap = new HashMap<Long, String>(16);
            Throwable throwable = null;
            try (DataSet ds = DB.queryDataSet((String)"dimLong", (DBRoute)DBRoute.of((String)"epm"), (SqlBuilder)sbSql2);){
                while (ds.hasNext()) {
                    Row next = ds.next();
                    dimNameMap.put(next.getLong("fid"), next.getString("fname"));
                }
            }
            catch (Throwable throwable2) {
                Throwable throwable3 = throwable2;
                throw throwable2;
            }
            for (kd.epm.eb.common.model.Dimension dimension : dimList) {
                dimension.setName(dimNameMap.getOrDefault(dimension.getId(), ""));
            }
        }
        return dimList;
    }

    private List<kd.epm.eb.common.model.Dimension> listDimensionIgnoreViewByDatasetId_Exec(Long datasetId) {
        if (datasetId == null || datasetId == 0L) {
            return Collections.emptyList();
        }
        StringBuilder sbSql = new StringBuilder().append("select a.fid as id,a.fnumber,a.fshortnumber,a.fmembermodel,a.fmodelid fmodelid,l.fname as name,a.fdseq as seq from t_eb_dimension a ").append("LEFT JOIN t_eb_dimension_l l ON a.fid = l.fid and l.FLOCALEID = ? ").append("left join t_eb_datasetdim b ON a.fid = b.fdatasetdim ").append("where b.fid = ?");
        ArrayList<kd.epm.eb.common.model.Dimension> dimList = new ArrayList<kd.epm.eb.common.model.Dimension>();
        try (DataSet ds = DB.queryDataSet((String)"dataset", (DBRoute)DBRoute.of((String)"epm"), (String)sbSql.toString(), (Object[])new Object[]{LanguageUtils.getLang(Lang.zh_CN).name(), datasetId});){
            while (ds.hasNext()) {
                Row next = ds.next();
                kd.epm.eb.common.model.Dimension dimension = new kd.epm.eb.common.model.Dimension(next.getLong("id"));
                dimension.setModelId(next.getLong("fmodelid"));
                dimension.setName(next.getString("name"));
                dimension.setNumber(next.getString("fnumber"));
                dimension.setShortNumber(next.getString("fshortnumber"));
                dimension.setMemberModel(next.getString("fmembermodel"));
                dimension.setSeq(next.getInteger("seq"));
                dimList.add(dimension);
            }
        }
        return dimList;
    }

    public static List<Dimension> getRefDim(Long datasetId, List<Dimension> dimensions) {
        LinkedList<Dimension> refDims = new LinkedList<Dimension>();
        if (datasetId == null || datasetId == 0L) {
            return refDims;
        }
        Set<String> refDimNumbers = DatasetServiceHelper.getRefDimNumber(datasetId);
        if (refDimNumbers != null) {
            for (Dimension dimension : dimensions) {
                if (!refDimNumbers.contains(dimension.getNumber())) continue;
                refDims.add(dimension);
            }
        }
        return refDims;
    }

    public static Set<String> getRefDimNumber(Long datasetId) {
        if (datasetId == null || datasetId == 0L) {
            return null;
        }
        String sql = "select fnumber from t_eb_dimension where fid in (select fdatasetdim from t_eb_datasetdim where fid = ?)";
        Object[] params = new Object[]{datasetId};
        List<Map<String, Object>> _refDims = null;
        DataSet ds = DB.queryDataSet((String)"queryDatasetRefDim", (DBRoute)BgBaseConstant.epm, (String)sql, (Object[])params);
        Object object = null;
        try {
            _refDims = CommonServiceHelper.transDataSet(ds);
        }
        catch (Throwable throwable) {
            object = throwable;
            throw throwable;
        }
        finally {
            if (ds != null) {
                if (object != null) {
                    try {
                        ds.close();
                    }
                    catch (Throwable throwable) {
                        ((Throwable)object).addSuppressed(throwable);
                    }
                } else {
                    ds.close();
                }
            }
        }
        if (_refDims == null || _refDims.isEmpty()) {
            return null;
        }
        HashSet<String> refDimNumbers = new HashSet<String>(_refDims.size());
        refDimNumbers.add(SysDimensionEnum.Account.getNumber());
        for (Map map : _refDims) {
            refDimNumbers.add((String)map.get("fnumber"));
        }
        return refDimNumbers;
    }

    public static List<kd.epm.eb.common.model.Dimension> getRefDim1(Long datasetId, List<kd.epm.eb.common.model.Dimension> dimensions) {
        LinkedList<kd.epm.eb.common.model.Dimension> refDims = new LinkedList<kd.epm.eb.common.model.Dimension>();
        if (datasetId == null || datasetId == 0L) {
            return refDims;
        }
        Set<String> refDimNumbers = DatasetServiceHelper.getRefDimNumber(datasetId);
        if (refDimNumbers != null) {
            for (kd.epm.eb.common.model.Dimension dimension : dimensions) {
                if (!refDimNumbers.contains(dimension.getNumber())) continue;
                refDims.add(dimension);
            }
        }
        return refDims;
    }

    public static Long getViewIdByBusModelIdOfDim(Long busModelId, String dimNum) {
        if (busModelId != null && !busModelId.equals(0L)) {
            QFBuilder qb = new QFBuilder("id", "=", busModelId);
            qb.add("viewentry.dimension.number", "=", dimNum);
            DynamicObject obj = QueryServiceHelper.queryOne((String)"eb_businessmodel", (String)"viewentry.viewgroup.defaultview as defaultView", (QFilter[])qb.toArrays());
            if (obj != null) {
                return obj.getLong("defaultView");
            }
        }
        return 0L;
    }

    public static Long getBusModelIdByDataset(Long datasetId) {
        if (datasetId == null || datasetId == 0L) {
            return null;
        }
        DynamicObject bizModel = DatasetServiceHelper.getBusModelObjByDataset(datasetId);
        if (bizModel != null) {
            return bizModel.getLong("id");
        }
        return null;
    }

    public static DynamicObject getBusModelObjByDataset(Long datasetId) {
        if (datasetId == null || datasetId == 0L) {
            return null;
        }
        DynamicObject dataset = BusinessDataServiceHelper.loadSingleFromCache((Object)datasetId, (String)"eb_dataset", (String)"businessmodel");
        if (dataset != null) {
            return dataset.getDynamicObject("businessmodel");
        }
        return null;
    }

    public static List<Dataset> getDatasets(DynamicObject model, Long viewId) {
        List<Dataset> datasets = new ArrayList<Dataset>(10);
        long modelId = model.getLong("id");
        if (ModelServiceHelper.isEBModel(model)) {
            datasets.add(new Dataset(modelId, model.getString("shownumber")));
        } else if (ShrekOlapServiceHelper.needDMLOlap(model)) {
            List<Dataset> allDatasets = DatasetServiceHelper.getAllDatasets(modelId);
            if (viewId != null && viewId != 0L) {
                datasets = DatasetServiceHelper.getDatasetsByViewId(modelId, viewId);
                Set collect = allDatasets.stream().map(Dataset::getId).collect(Collectors.toSet());
                datasets = datasets.stream().filter(dataset -> collect.contains(dataset.getId())).collect(Collectors.toList());
            } else {
                datasets = allDatasets;
            }
        }
        return datasets;
    }

    public static List<Dataset> getDatasets(DynamicObject model, String dimNumber, Long viewId, Long datasetId) {
        List<Dataset> datasets;
        Long modelId = model.getLong("id");
        if (ModelServiceHelper.isEBModel(model)) {
            datasets = Collections.singletonList(new Dataset(modelId, model.getString("shownumber")));
        } else if (NewEbAppUtil.isNewEbModel(model)) {
            DynamicObject datasetObj = NewEbAppUtil.getDefaultObj("eb_dataset", modelId);
            datasets = Collections.singletonList(Dataset.of(datasetObj));
        } else if (SysDimensionEnum.Account.getNumber().equals(dimNumber)) {
            DynamicObject datasetObj = BusinessDataServiceHelper.loadSingle((Object)datasetId, (String)"eb_dataset", (String)"id,number");
            datasets = Collections.singletonList(Dataset.of(datasetObj));
        } else {
            datasets = SysDimensionEnum.dimHasView(dimNumber) ? DatasetServiceHelper.getDatasetsByViewId(modelId, viewId) : DatasetServiceHelper.getAllDatasets(modelId);
        }
        return datasets;
    }

    public static List<Dataset> getDatasetsForDelete(DynamicObject model, String dimNum) {
        List<Dataset> datasets = new ArrayList<Dataset>(10);
        long modelId = model.getLong("id");
        if (ModelServiceHelper.isEBModel(model)) {
            datasets.add(new Dataset(modelId, model.getString("shownumber")));
        } else if (ShrekOlapServiceHelper.needDMLOlap(model)) {
            datasets = DatasetServiceHelper.getAllDatasets(modelId, dimNum);
        }
        return datasets;
    }

    public static List<Dataset> getDatasetsForModify(DynamicObject model, String dimNum) {
        List<Dataset> datasets = new ArrayList<Dataset>(10);
        long modelId = model.getLong("id");
        if (ModelServiceHelper.isEBModel(model)) {
            datasets.add(new Dataset(modelId, model.getString("shownumber")));
        } else if (ShrekOlapServiceHelper.needDMLOlap(model)) {
            datasets = DatasetServiceHelper.getAllDatasets(modelId, dimNum);
        }
        return datasets;
    }

    public static List<Dataset> getDatasets(DynamicObject model, String dimNumber) {
        List<Dataset> datasets = new ArrayList<Dataset>(10);
        long modelId = model.getLong("id");
        if (ModelServiceHelper.isEBModel(model)) {
            datasets.add(new Dataset(modelId, model.getString("shownumber")));
        } else if (ShrekOlapServiceHelper.needDMLOlap(model)) {
            datasets = SysDimensionEnum.dimHasView(dimNumber) ? DatasetServiceHelper.getDefaultViewDatasets(modelId, dimNumber) : DatasetServiceHelper.getAllDatasets(modelId);
        }
        return datasets;
    }

    public static List<Dataset> getAllDatasets(Long modelId, String dimNumber) {
        if (modelId == null || modelId == 0L) {
            return Collections.emptyList();
        }
        ArrayList<Dataset> datasets = new ArrayList<Dataset>(16);
        String sql = "select DISTINCT a.fid fid,a.fnumber number from t_eb_dataset a left join t_eb_datasetdim b on a.fid = b.fid left join t_eb_dimension c on b.fdatasetdim = c.fid where a.fmodel = ? and c.fnumber = ?";
        try (DataSet ds = DB.queryDataSet((String)"getAllDatasets", (DBRoute)BgBaseConstant.epm, (String)sql, (Object[])new Object[]{modelId, dimNumber});){
            if (ds != null) {
                for (Row row : ds) {
                    datasets.add(new Dataset(row.getLong("fid"), row.getString("number")));
                }
            }
        }
        return datasets;
    }

    public static List<Dataset> getAllDatasets(Long modelId) {
        if (modelId == null || modelId == 0L) {
            return Collections.emptyList();
        }
        ArrayList<Dataset> datasets = new ArrayList<Dataset>(16);
        String sql = "select fnumber,fid from t_eb_dataset where fmodel = ?";
        try (DataSet ds = DB.queryDataSet((String)"getAllDatasets", (DBRoute)BgBaseConstant.epm, (String)sql, (Object[])new Object[]{modelId});){
            while (ds != null && ds.hasNext()) {
                Row row = ds.next();
                datasets.add(new Dataset(row.getLong("fid"), row.getString("fnumber")));
            }
        }
        return datasets;
    }

    public static Map<Long, List<Dataset>> getAllDatasets(List<Long> modelIds) {
        if (modelIds == null || modelIds.size() == 0) {
            return Collections.emptyMap();
        }
        HashMap<Long, List<Dataset>> datasetMap = new HashMap<Long, List<Dataset>>(16);
        SqlBuilder sql = new SqlBuilder();
        sql.append("select fid,fnumber,fmodel from t_eb_dataset where ", new Object[0]).appendIn("fmodel", modelIds.toArray());
        try (DataSet ds = DB.queryDataSet((String)"getAllDatasets", (DBRoute)BgBaseConstant.epm, (SqlBuilder)sql);){
            if (ds != null) {
                for (Row row : ds) {
                    List datasets = datasetMap.computeIfAbsent(row.getLong("fmodel"), f -> new ArrayList());
                    Dataset dataset = new Dataset(row.getLong("fid"), row.getString("fnumber"));
                    datasets.add(dataset);
                }
            }
        }
        return datasetMap;
    }

    public static List<Dataset> getDefaultViewDatasets(Long modelId, String dimensionNumber) {
        if (modelId == null || modelId == 0L || StringUtils.isBlank((String)dimensionNumber)) {
            return Collections.emptyList();
        }
        Long dimensionId = null;
        try (DataSet ds = DB.queryDataSet((String)"queryDimId", (DBRoute)BgBaseConstant.epm, (String)"select fid from t_eb_dimension where fmodelid = ? and fnumber = ?", (Object[])new Object[]{modelId, dimensionNumber});){
            if (ds != null && ds.hasNext()) {
                dimensionId = ds.next().getLong("fid");
            }
        }
        if (dimensionId == null || dimensionId == 0L) {
            return Collections.emptyList();
        }
        SqlBuilder sql = new SqlBuilder();
        sql.append("select fid,fviewgroupid from t_eb_viewentry where fdimensionid = ?", new Object[]{dimensionId});
        LinkedHashSet<Long> bizModelIds = new LinkedHashSet<Long>();
        try (DataSet ds = DB.queryDataSet((String)"queryBizModelId", (DBRoute)BgBaseConstant.epm, (SqlBuilder)sql);){
            if (ds != null) {
                for (Row row : ds) {
                    if (!IDUtils.isNotEmptyLong(row.getLong("fviewgroupid")).booleanValue()) continue;
                    bizModelIds.add(row.getLong("fid"));
                }
            }
        }
        if (bizModelIds.isEmpty()) {
            return Collections.emptyList();
        }
        sql = new SqlBuilder();
        sql.append("select distinct t1.fid, t1.fnumber from t_eb_dataset t1 left join t_eb_datasetdim t2 on t2.fid = t1.fid where t1.fmodel = ? and ", new Object[]{modelId});
        sql.appendIn("t1.fbizmodelid", bizModelIds.toArray());
        sql.append(" and t2.fdatasetdim = ?", new Object[]{dimensionId});
        LinkedList<Dataset> datasets = new LinkedList<Dataset>();
        DataSet ds = DB.queryDataSet((String)"getDefaultViewDatasets", (DBRoute)BgBaseConstant.epm, (SqlBuilder)sql);
        Object object = null;
        try {
            if (ds != null) {
                for (Row row : ds) {
                    datasets.add(new Dataset(row.getLong("fid"), row.getString("fnumber")));
                }
            }
        }
        catch (Throwable throwable) {
            object = throwable;
            throw throwable;
        }
        finally {
            if (ds != null) {
                if (object != null) {
                    try {
                        ds.close();
                    }
                    catch (Throwable throwable) {
                        ((Throwable)object).addSuppressed(throwable);
                    }
                } else {
                    ds.close();
                }
            }
        }
        return datasets;
    }

    public static List<Dataset> getDatasetsByViewId(Long modelId, Long viewId) {
        if (IDUtils.isNull(modelId) || IDUtils.isNull(viewId)) {
            return Collections.emptyList();
        }
        Long viewGroupId = ViewGroupServiceHelper.getInstance().getViewGroupByViewId(viewId);
        LinkedList<Dataset> datasets = new LinkedList<Dataset>();
        String sql = "select distinct t1.fid, t1.fnumber  from t_eb_dataset t1  join t_eb_viewentry t2 on t1.fbizmodelid = t2.fid  where t1.fmodel = ? and t2.fviewgroupid = ?";
        try (DataSet ds = DB.queryDataSet((String)"getDatasetsByViewId", (DBRoute)BgBaseConstant.epm, (String)sql, (Object[])new Object[]{modelId, viewGroupId});){
            if (ds != null) {
                for (Row row : ds) {
                    datasets.add(new Dataset(row.getLong("fid"), row.getString("fnumber")));
                }
            }
        }
        return datasets;
    }

    @Deprecated
    public static List<Long> getAnalyzeViewIdByBaseViewId(Long viewId) {
        if (viewId == null || viewId == 0L) {
            return Collections.emptyList();
        }
        ArrayList<Long> analyzeViews = new ArrayList<Long>(16);
        analyzeViews.add(viewId);
        return analyzeViews;
    }

    public DynamicObject getTemplate(long datasetId) {
        List<DynamicObject> templates = this.getTemplate(Collections.singleton(datasetId));
        if (templates.isEmpty()) {
            return null;
        }
        return templates.get(0);
    }

    public List<DynamicObject> getTemplate(Collection<Long> datasetIds) {
        if (datasetIds.isEmpty()) {
            return Collections.emptyList();
        }
        QFilter qFilter = new QFilter("dataset", "in", datasetIds);
        String sql = "id, number, name, data, templatetype, dataset, varbaseforeb, templatecatalog,model.id";
        DynamicObjectCollection list = QueryServiceHelper.query((String)"eb_templateentity", (String)sql, (QFilter[])qFilter.toArray());
        return new ArrayList<DynamicObject>((Collection<DynamicObject>)list);
    }

    public Set<Long> queryDataSetsByDimId(Long dimensionId) {
        if (dimensionId == null || dimensionId == 0L) {
            return null;
        }
        HashSet<Long> dataSetIds = new HashSet<Long>();
        try (DataSet ds = DB.queryDataSet((String)"dataset", (DBRoute)DBRoute.of((String)"epm"), (String)"select fid from t_eb_datasetdim where fdatasetdim = ?", (Object[])new Object[]{dimensionId});){
            for (Row row : ds) {
                dataSetIds.add(row.getLong("fid"));
            }
        }
        return dataSetIds;
    }

    public MemberEntity getMetricByAccount(Long accountId) {
        DynamicObject accountObj = BusinessDataServiceHelper.loadSingle((Object)accountId, (String)SysDimensionEnum.Account.getMemberTreemodel());
        DynamicObjectCollection refMetric = accountObj.getDynamicObjectCollection("entryentity");
        MemberEntity metricEntity = null;
        if (refMetric.size() > 0) {
            DynamicObject firstMetric = ((DynamicObject)refMetric.get(0)).getDynamicObject("metric");
            metricEntity = new MemberEntity(firstMetric.getLong("id"), 0L, firstMetric.getString("name"), firstMetric.getString("number"), 0, 0);
            metricEntity.getOtherData().put("isAgg", firstMetric.getBoolean("isagg"));
        }
        return metricEntity;
    }

    public List<DynamicObject> getTemplateByIds(Collection<Long> templateIds) {
        if (templateIds.isEmpty()) {
            return Collections.emptyList();
        }
        QFilter qFilter = new QFilter("id", "in", templateIds);
        String sql = "id, number, name, data, templatetype, dataset, varbaseforeb, templatecatalog,model.id";
        DynamicObjectCollection list = QueryServiceHelper.query((String)"eb_templateentity", (String)sql, (QFilter[])qFilter.toArray());
        return new ArrayList<DynamicObject>((Collection<DynamicObject>)list);
    }

    public static Map<Long, Set<Long>> getDataSettDimMap(Long bizModelId) {
        HashMap<Long, Set<Long>> result = new HashMap<Long, Set<Long>>(16);
        String sql = "select fdatasetdim,fid from t_eb_datasetdim where fid in( select fid from t_eb_dataset where fbizmodelid = ?)";
        try (DataSet ds = DB.queryDataSet((String)"getDataSettDimMap", (DBRoute)DBRoute.of((String)"epm"), (String)sql, (Object[])new Object[]{bizModelId});){
            for (Row row : ds) {
                Long datasetId = row.getLong("fid");
                Long dimId = row.getLong("fdatasetdim");
                result.computeIfAbsent(datasetId, key -> new HashSet(16)).add(dimId);
            }
        }
        return result;
    }

    public static List<Long> getDatasetByDimFilter(Long bizModelId, Set<Long> filterDimIds) {
        Map<Long, Set<Long>> dataSettDimMap = DatasetServiceHelper.getDataSettDimMap(bizModelId);
        LinkedList<Long> datasetIds = new LinkedList<Long>();
        dataSettDimMap.forEach((datasetId, dimIds) -> {
            if (dimIds.containsAll(filterDimIds)) {
                datasetIds.add((Long)datasetId);
            }
        });
        return datasetIds;
    }
}

