/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.common.utils;

import java.math.BigDecimal;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.Month;
import java.time.YearMonth;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.TimeZone;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.epm.eb.common.utils.ConvertUtils;
import kd.epm.eb.common.utils.StringUtils;
import org.apache.poi.ss.usermodel.DateUtil;

public class DateTimeUtils {
    private static final Log log = LogFactory.getLog(DateTimeUtils.class);
    public static final DateTimeFormatter DEFAULT_FORMAT = DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss");
    private static final List<String> dateFormat = Arrays.asList("yyyy-MM-dd HH:mm:ss.S", "yyyy-MM-dd HH:mm:ss.SS", "yyyy-MM-dd HH:mm:ss.SSS", "EEE MMM dd HH:mm:ss zzz yyyy", "yyyy/MM/dd", "yyyy/MM/dd HH:mm:ss", "yyyy/MM/dd HH:mm:ss.S", "yyyy/MM/dd HH:mm:ss.SS", "yyyy/MM/dd HH:mm:ss.SSS");

    public static LocalDateTime parse(Date date) {
        if (date == null) {
            throw new NullPointerException("date is null.");
        }
        Instant instant = date.toInstant();
        return instant.atZone(ZoneId.systemDefault()).toLocalDateTime();
    }

    public static String format(LocalDateTime localDateTime) {
        return DateTimeUtils.format(localDateTime, null);
    }

    public static String format(LocalDateTime localDateTime, DateTimeFormatter formatter) {
        if (localDateTime == null) {
            return "null";
        }
        if (formatter == null) {
            return localDateTime.format(DateTimeFormatter.BASIC_ISO_DATE);
        }
        return localDateTime.format(formatter);
    }

    public static String formatFromStr(String dateStr) {
        String result = dateStr;
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        try {
            if (StringUtils.isEmpty(dateStr)) {
                return result;
            }
            Date parse = simpleDateFormat.parse(dateStr);
            result = simpleDateFormat.format(parse);
        }
        catch (ParseException exp) {
            log.warn(exp.getMessage());
            try {
                SimpleDateFormat sdf1 = new SimpleDateFormat("EEE MMM dd HH:mm:ss z yyyy", Locale.ENGLISH);
                result = simpleDateFormat.format(sdf1.parse(dateStr));
            }
            catch (Exception exception) {
                log.warn(exception.getMessage());
            }
        }
        return result;
    }

    public static Date parseToDate(String dateString) {
        return DateTimeUtils.parseToDate(dateString, false);
    }

    public static Date parseToDate(String dateString, Boolean isFromExcel) {
        Date date;
        block2: {
            date = null;
            try {
                BigDecimal time = ConvertUtils.toDecimal(dateString);
                date = isFromExcel.booleanValue() ? DateTimeUtils.getTimeInExcel_new(time) : ConvertUtils.toDate(time.longValue());
            }
            catch (Exception e) {
                date = ConvertUtils.toDate(dateString);
                if (date != null) break block2;
                date = DateTimeUtils.parseToDateWithPattern(dateString, 0);
            }
        }
        return date;
    }

    private static Date getTimeInExcel_new(BigDecimal time) {
        return DateUtil.getJavaDate((double)time.doubleValue());
    }

    public static Date parseToDateWithPattern(String dateString, int formatIndex) {
        if (formatIndex >= dateFormat.size()) {
            return null;
        }
        Date date = null;
        DateTimeFormatter df = null;
        df = formatIndex == 3 ? DateTimeFormatter.ofPattern(dateFormat.get(formatIndex), Locale.US) : DateTimeFormatter.ofPattern(dateFormat.get(formatIndex));
        try {
            LocalDateTime ldt = LocalDateTime.parse(dateString, df);
            date = Date.from(ldt.atZone(ZoneId.systemDefault()).toInstant());
        }
        catch (Exception ex) {
            try {
                LocalDate ld = LocalDate.parse(dateString);
                if (ld != null) {
                    date = Date.from(ld.atStartOfDay(ZoneId.systemDefault()).toInstant());
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (date == null) {
            return DateTimeUtils.parseToDateWithPattern(dateString, formatIndex + 1);
        }
        return date;
    }

    public static Map<String, Date> getTodayTime() {
        Date startTime = DateTimeUtils.getStartTime();
        Date endTime = DateTimeUtils.getEndTime();
        HashMap<String, Date> map = new HashMap<String, Date>(2);
        map.put("startDate", startTime);
        map.put("endDate", endTime);
        return map;
    }

    public static Map<String, Date> getThisWeekTime() {
        Date startTime = DateTimeUtils.getBeginDayOfWeek();
        Date endTime = DateTimeUtils.getEndDayOfWeek();
        HashMap<String, Date> map = new HashMap<String, Date>(2);
        map.put("startDate", startTime);
        map.put("endDate", endTime);
        return map;
    }

    public static Map<String, Date> getThisMonthTime() {
        Date monthStartTime = DateTimeUtils.getMonthStartTime();
        Date monthEndTime = DateTimeUtils.getMonthEndTime();
        HashMap<String, Date> map = new HashMap<String, Date>(2);
        map.put("startDate", monthStartTime);
        map.put("endDate", monthEndTime);
        return map;
    }

    public static Date getBeginDayOfWeek() {
        Date date = new Date();
        Calendar cal = Calendar.getInstance();
        cal.setTime(date);
        int dayofweek = cal.get(7);
        if (dayofweek == 1) {
            dayofweek += 7;
        }
        cal.add(5, 2 - dayofweek);
        return DateTimeUtils.getDayStartTime(cal.getTime());
    }

    public static Date getEndDayOfWeek() {
        Calendar cal = Calendar.getInstance();
        cal.setTime(DateTimeUtils.getBeginDayOfWeek());
        cal.add(7, 6);
        Date weekEndSta = cal.getTime();
        return DateTimeUtils.getDayEndTime(weekEndSta);
    }

    public static Map getLastMonthTime() {
        Date startTime = DateTimeUtils.getLastMonthStartTime();
        Date endTime = DateTimeUtils.getLastMonthEndTime();
        HashMap<String, Date> map = new HashMap<String, Date>();
        map.put("startDate", startTime);
        map.put("endDate", endTime);
        return map;
    }

    public static Map<String, Date> getLastThreeMonthTime() {
        Date endTime = DateTimeUtils.getEndTime();
        Date dayStartTime = DateTimeUtils.getDayStartTimeOffsetOfMonth(endTime, -3);
        HashMap<String, Date> map = new HashMap<String, Date>();
        map.put("startDate", dayStartTime);
        map.put("endDate", endTime);
        return map;
    }

    private static Date getStartTime() {
        Calendar todayStart = Calendar.getInstance();
        todayStart.set(11, 0);
        todayStart.set(12, 0);
        todayStart.set(13, 0);
        todayStart.set(14, 0);
        return todayStart.getTime();
    }

    private static Date getEndTime() {
        Calendar todayEnd = Calendar.getInstance();
        todayEnd.set(10, 23);
        todayEnd.set(12, 59);
        todayEnd.set(13, 59);
        todayEnd.set(14, 999);
        return todayEnd.getTime();
    }

    public static Date getMonthStartTime() {
        Long currentTime = System.currentTimeMillis();
        String timeZone = "GMT+8:00";
        Calendar calendar = Calendar.getInstance();
        calendar.setTimeZone(TimeZone.getTimeZone(timeZone));
        calendar.setTimeInMillis(currentTime);
        calendar.add(1, 0);
        calendar.add(2, 0);
        calendar.set(5, 1);
        calendar.set(11, 0);
        calendar.set(12, 0);
        calendar.set(13, 0);
        calendar.set(14, 0);
        return calendar.getTime();
    }

    public static Date getMonthEndTime() {
        Long currentTime = System.currentTimeMillis();
        String timeZone = "GMT+8:00";
        Calendar calendar = Calendar.getInstance();
        calendar.setTimeZone(TimeZone.getTimeZone(timeZone));
        calendar.setTimeInMillis(currentTime);
        calendar.add(1, 0);
        calendar.add(2, 0);
        calendar.set(5, calendar.getActualMaximum(5));
        calendar.set(11, 23);
        calendar.set(12, 59);
        calendar.set(13, 59);
        calendar.set(14, 999);
        return calendar.getTime();
    }

    public static Date getLastMonthStartTime() {
        Long currentTime = System.currentTimeMillis();
        String timeZone = "GMT+8:00";
        Calendar calendar = Calendar.getInstance();
        calendar.setTimeZone(TimeZone.getTimeZone(timeZone));
        calendar.setTimeInMillis(currentTime);
        calendar.add(1, 0);
        calendar.add(2, -1);
        calendar.set(5, 1);
        calendar.set(11, 0);
        calendar.set(12, 0);
        calendar.set(13, 0);
        calendar.set(14, 0);
        return calendar.getTime();
    }

    public static Date getLastMonthEndTime() {
        Long currentTime = System.currentTimeMillis();
        String timeZone = "GMT+8:00";
        Calendar calendar = Calendar.getInstance();
        calendar.setTimeZone(TimeZone.getTimeZone(timeZone));
        calendar.setTimeInMillis(currentTime);
        calendar.add(1, 0);
        calendar.add(2, -1);
        calendar.set(5, calendar.getActualMaximum(5));
        calendar.set(11, 23);
        calendar.set(12, 59);
        calendar.set(13, 59);
        calendar.set(14, 999);
        return calendar.getTime();
    }

    public static Date getDayStartTime(Date d) {
        Calendar calendar = Calendar.getInstance();
        if (null != d) {
            calendar.setTime(d);
        }
        calendar.set(calendar.get(1), calendar.get(2), calendar.get(5), 0, 0, 0);
        calendar.set(14, 0);
        return calendar.getTime();
    }

    public static Date getDayStartTime(String source) {
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
        Date date = null;
        try {
            date = sdf.parse(source);
        }
        catch (ParseException e) {
            log.error("getDayStartTime:{}", (Object)source);
            return null;
        }
        Calendar calendar = Calendar.getInstance();
        if (null != date) {
            calendar.setTime(date);
        }
        calendar.set(calendar.get(1), calendar.get(2), calendar.get(5), 0, 0, 0);
        calendar.set(14, 0);
        return calendar.getTime();
    }

    public static Date getDayStartTimeOffsetOfMonth(Date d, int offset) {
        Calendar calendar = Calendar.getInstance();
        if (null != d) {
            calendar.setTime(d);
        }
        calendar.set(calendar.get(1), calendar.get(2), calendar.get(5), 0, 0, 0);
        calendar.add(2, offset);
        calendar.set(14, 0);
        return calendar.getTime();
    }

    public static Date getDayEndTime(Date d) {
        Calendar calendar = Calendar.getInstance();
        if (null != d) {
            calendar.setTime(d);
        }
        calendar.set(calendar.get(1), calendar.get(2), calendar.get(5), 23, 59, 59);
        calendar.set(14, 999);
        return calendar.getTime();
    }

    public static Date getDayEndTime(String source) {
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
        Date date = null;
        try {
            date = sdf.parse(source);
        }
        catch (ParseException e) {
            log.error("getDayEndTime \uff1a{}", (Object)source);
            return null;
        }
        Calendar calendar = Calendar.getInstance();
        if (null != date) {
            calendar.setTime(date);
        }
        calendar.set(calendar.get(1), calendar.get(2), calendar.get(5), 23, 59, 59);
        calendar.set(14, 0);
        return calendar.getTime();
    }

    public static Date getCurrentDate() {
        LocalDateTime localDateTime = LocalDateTime.now();
        ZoneId zone = ZoneId.systemDefault();
        Instant instant = localDateTime.atZone(zone).toInstant();
        return Date.from(instant);
    }

    public static Map<String, Date> getThisQuarter() {
        LocalDate today = LocalDate.now();
        int quarter = (today.getMonthValue() - 1) / 3 + 1;
        Month startMonth = Month.of((quarter - 1) * 3 + 1);
        Month endMonth = Month.of(startMonth.getValue() + 2);
        YearMonth startOfYearQuarter = YearMonth.of(today.getYear(), startMonth);
        LocalDate startOfQuarter = startOfYearQuarter.atDay(1);
        YearMonth endOfYearQuarter = YearMonth.of(today.getYear(), endMonth);
        LocalDate endOfQuarter = endOfYearQuarter.atEndOfMonth();
        String timeZone = "GMT+8:00";
        TimeZone timeZone1 = TimeZone.getTimeZone(timeZone);
        Instant instant = startOfQuarter.atStartOfDay().atZone(timeZone1.toZoneId()).toInstant();
        Date startDate = DateTimeUtils.getDayStartTime(Date.from(instant));
        Instant endInstant = endOfQuarter.atStartOfDay().atZone(timeZone1.toZoneId()).toInstant();
        Date endDate = DateTimeUtils.getDayEndTime(Date.from(endInstant));
        HashMap<String, Date> map = new HashMap<String, Date>();
        map.put("startDate", startDate);
        map.put("endDate", endDate);
        return map;
    }

    public static Map<String, Date> getThisYear() {
        LocalDate today = LocalDate.now();
        LocalDate startOfYear = LocalDate.of(today.getYear(), 1, 1);
        LocalDate endOfYear = LocalDate.of(today.getYear(), 12, 31);
        String timeZone = "GMT+8:00";
        TimeZone timeZone1 = TimeZone.getTimeZone(timeZone);
        Instant instant = startOfYear.atStartOfDay().atZone(timeZone1.toZoneId()).toInstant();
        Date startDate = DateTimeUtils.getDayStartTime(Date.from(instant));
        Instant endInstant = endOfYear.atStartOfDay().atZone(timeZone1.toZoneId()).toInstant();
        Date endDate = DateTimeUtils.getDayEndTime(Date.from(endInstant));
        HashMap<String, Date> map = new HashMap<String, Date>();
        map.put("startDate", startDate);
        map.put("endDate", endDate);
        return map;
    }
}

