/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.common.utils;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;

public class DimMembers
implements Iterator<String[]> {
    private List<String> dimensions = new ArrayList<String>();
    private List<List<String>> allMembers = new ArrayList<List<String>>();
    private int[] indexes = new int[0];
    private int[] sizes = new int[0];
    private boolean hasNext = true;

    public void addDimension(String dimension) {
        this.dimensions.add(dimension);
    }

    public List<String> getDimensions() {
        return this.dimensions;
    }

    public void addMembers(List<String> members) {
        if (members == null) {
            return;
        }
        this.allMembers.add(members);
        this.indexes = new int[this.allMembers.size()];
        this.sizes = new int[this.allMembers.size()];
        int in = this.allMembers.size();
        for (int i = 0; i < in; ++i) {
            this.indexes[i] = 0;
            this.sizes[i] = this.allMembers.get(i).size();
        }
    }

    public void addMembers(String dimension, List<String> members) {
        if (dimension == null || members == null) {
            return;
        }
        this.addDimension(dimension);
        this.addMembers(members);
    }

    @Override
    public boolean hasNext() {
        if (this.sizes.length == 0 || !this.hasNext) {
            return false;
        }
        boolean hasNext = true;
        int in = this.sizes.length;
        for (int i = 0; i < in; ++i) {
            if (this.indexes[i] < this.sizes[i]) continue;
            hasNext = false;
            break;
        }
        return hasNext;
    }

    @Override
    public String[] next() {
        String[] members;
        if (this.hasNext()) {
            members = new String[this.allMembers.size()];
            int in = members.length;
            for (int i = 0; i < in; ++i) {
                members[i] = this.allMembers.get(i).get(this.indexes[i]);
            }
        } else {
            throw new NoSuchElementException();
        }
        this.moveDown();
        return members;
    }

    private void moveDown() {
        for (int i = this.indexes.length - 1; i >= 0; --i) {
            if (this.indexes[i] < this.sizes[i] - 1) {
                int n = i;
                this.indexes[n] = this.indexes[n] + 1;
                break;
            }
            if (this.indexes[i] != this.sizes[i] - 1) continue;
            if (i > 0) {
                int j;
                boolean hasMove = false;
                for (j = i - 1; j >= 0; --j) {
                    if (this.indexes[j] >= this.sizes[j] - 1) continue;
                    hasMove = true;
                    break;
                }
                if (!hasMove) continue;
                int n = j;
                this.indexes[n] = this.indexes[n] + 1;
                for (int x = j + 1; x < this.indexes.length; ++x) {
                    this.indexes[x] = 0;
                }
                break;
            }
            this.hasNext = false;
        }
    }

    @Override
    public void remove() {
        throw new RuntimeException("cant remove object");
    }

    public void clear() {
        this.indexes = new int[0];
        this.sizes = new int[0];
        this.allMembers.clear();
        this.hasNext = true;
    }

    public void reset() {
        this.hasNext = true;
        int in = this.indexes.length;
        for (int i = 0; i < in; ++i) {
            this.indexes[i] = 0;
        }
    }
}

