/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.common.utils;

import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.SqlBuilder;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.epm.eb.common.cache.IModelCacheHelper;
import kd.epm.eb.common.cache.ModelCacheContext;
import kd.epm.eb.common.cache.impl.Model;
import kd.epm.eb.common.cache.impl.View;
import kd.epm.eb.common.constant.BgBaseConstant;
import kd.epm.eb.common.enums.SysDimensionEnum;
import kd.epm.eb.common.utils.CollectionUtils;
import kd.epm.eb.common.utils.IDUtils;
import kd.epm.eb.common.utils.QFBuilder;
import kd.epm.eb.common.utils.StringUtils;
import kd.epm.eb.common.utils.viewgroup.ViewGroupServiceHelper;

public class DimensionViewServiceHelper {
    private static final Log log = LogFactory.getLog(DimensionViewServiceHelper.class);
    private static final DimensionViewServiceHelper instance = new DimensionViewServiceHelper();

    private DimensionViewServiceHelper() {
    }

    public static DimensionViewServiceHelper getInstance() {
        return instance;
    }

    public List<Long> queryViewIdsByMemberId(List<Long> memberIds) {
        ArrayList<Long> ids = new ArrayList<Long>(16);
        DataSet dataSet = QueryServiceHelper.queryDataSet((String)"DimensionViewServiceHelp.queryViewIdsByMemberId", (String)"eb_viewmember", (String)"id", (QFilter[])new QFilter[]{new QFilter("memberid", "in", memberIds)}, (String)"");
        if (!dataSet.isEmpty()) {
            for (Row row : dataSet) {
                ids.add(row.getLong("id"));
            }
        }
        return ids;
    }

    public List<Long> queryViewIdsByMemberId(Long ... memberIds) {
        ArrayList<Long> ids = new ArrayList<Long>(16);
        DataSet dataSet = QueryServiceHelper.queryDataSet((String)"DimensionViewServiceHelp.queryViewIdsByMemberId", (String)"eb_viewmember", (String)"id", (QFilter[])new QFilter[]{new QFilter("memberid", "in", (Object)memberIds)}, (String)"");
        if (!dataSet.isEmpty()) {
            for (Row row : dataSet) {
                ids.add(row.getLong("id"));
            }
        }
        return ids;
    }

    public Map<Long, Long> queryViewGroupIdByDimIds(List<Long> dimIds) {
        HashMap<Long, Long> ids = new HashMap<Long, Long>(16);
        QFilter qFilter = new QFilter("source", "=", (Object)"1");
        QFilter qFilter1 = new QFilter("dimension", "in", dimIds);
        QFilter qFilter2 = new QFilter("defaultview", "is not null", (Object)"");
        qFilter2.and(new QFilter("defaultview", "!=", (Object)0L));
        QFilter qFilter3 = new QFilter("type", "=", (Object)"1");
        DataSet dataSet = QueryServiceHelper.queryDataSet((String)"DimensionViewServiceHelp.queryViewGroupIdByDimIds", (String)"eb_dimensionview_group", (String)"id,dimension", (QFilter[])new QFilter[]{qFilter, qFilter1, qFilter2, qFilter3}, (String)"");
        if (!dataSet.isEmpty()) {
            for (Row row : dataSet) {
                ids.put(row.getLong("dimension"), row.getLong("id"));
            }
        }
        for (Long dimId : dimIds) {
            ids.putIfAbsent(dimId, 0L);
        }
        return ids;
    }

    public Long queryBaseViewId(Long modelId, Long dimensionId) {
        QFBuilder qfBuilder = new QFBuilder("model", "=", modelId);
        qfBuilder.add("dimension", "=", dimensionId);
        qfBuilder.add("source", "=", "1");
        DynamicObject object = BusinessDataServiceHelper.loadSingle((String)"eb_dimensionview", (String)"id", (QFilter[])qfBuilder.toArray());
        if (object != null) {
            return object.getLong("id");
        }
        return 0L;
    }

    public boolean isBaseView(Long viewId) {
        if (viewId == null || viewId == 0L) {
            return true;
        }
        DynamicObject object = BusinessDataServiceHelper.loadSingle((Object)viewId, (String)"eb_dimensionview", (String)"source");
        if (object != null) {
            return "1".equals(object.getString("source"));
        }
        return true;
    }

    public Long queryBaseViewIdByNumber(Long modelId, String dimnumber) {
        QFBuilder qfBuilder = new QFBuilder("model", "=", modelId);
        qfBuilder.add("dimension.number", "=", dimnumber);
        qfBuilder.add("source", "=", "1");
        Long viewId = 0L;
        DynamicObject object = QueryServiceHelper.queryOne((String)"eb_dimensionview", (String)"id", (QFilter[])qfBuilder.toArray());
        if (object != null) {
            viewId = object.getLong("id");
        }
        return viewId;
    }

    public Map<String, String> queryCTFormula(Long viewId, Long modelId) {
        HashMap<String, String> map = new HashMap<String, String>();
        QFilter qFilter = new QFilter("model", "=", (Object)modelId);
        QFilter qFilter1 = new QFilter("entryentity_formul.formulview", "=", (Object)viewId);
        DataSet dataSet = QueryServiceHelper.queryDataSet((String)"DimensionViewServiceHelp.queryFormula", (String)"epm_changetypemembertree", (String)"id,entryentity_formul.formulaname", (QFilter[])new QFilter[]{qFilter, qFilter1}, (String)"");
        for (Row row : dataSet) {
            if (!StringUtils.isNotEmpty(row.getString("entryentity_formul.formulaname"))) continue;
            map.put(row.getString("id"), row.getString("entryentity_formul.formulaname"));
        }
        return map;
    }

    public Long getChangeTypeViewId(Long id) {
        DynamicObject object = QueryServiceHelper.queryOne((String)"epm_changetypemembertree", (String)"view", (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)id)});
        if (object != null) {
            return object.getLong("view");
        }
        return 0L;
    }

    public Map<String, Long> getViewIdByNumber(Long modelId, Long dimensionId, List<String> numbers) {
        IModelCacheHelper modelCacheHelper = ModelCacheContext.getOrCreate(modelId);
        Model modelObj = modelCacheHelper.getModelobj();
        if (modelObj.isModelByEB()) {
            return new HashMap<String, Long>(16);
        }
        QFilter qFilter = new QFilter("model", "=", (Object)modelId);
        QFilter qFilter1 = new QFilter("dimension", "=", (Object)dimensionId);
        QFilter qFilter2 = new QFilter("number", "in", numbers);
        DynamicObjectCollection query = QueryServiceHelper.query((String)"eb_dimensionview", (String)"id, number", (QFilter[])new QFilter[]{qFilter, qFilter1, qFilter2});
        if (CollectionUtils.isEmpty(query)) {
            return new HashMap<String, Long>(16);
        }
        return query.stream().collect(Collectors.toMap(e -> e.getString("number"), e -> e.getLong("id")));
    }

    public Map<Long, DynamicObject> getViewInfoById(List<Long> viewIds) {
        QFilter qFilter = new QFilter("id", "in", viewIds);
        DynamicObjectCollection query = QueryServiceHelper.query((String)"eb_dimensionview", (String)"id, number, name, dimension", (QFilter[])qFilter.toArray());
        if (CollectionUtils.isEmpty(query)) {
            return new HashMap<Long, DynamicObject>(16);
        }
        return query.stream().collect(Collectors.toMap(e -> e.getLong("id"), e -> e, (o1, o2) -> o1));
    }

    public DynamicObject getViewInfo(Long viewId) {
        QFilter qFilter = new QFilter("id", "=", (Object)viewId);
        return BusinessDataServiceHelper.loadSingle((String)"eb_dimensionview", (String)"id, number, name", (QFilter[])qFilter.toArray());
    }

    public static Map<String, Long> getViewIds(Map<String, Long> dimViews, String partition) {
        if (dimViews == null || partition == null) {
            return dimViews;
        }
        HashMap<String, Long> viewIds = new HashMap<String, Long>(16);
        Set<String> viewKeySet = dimViews.keySet();
        dimViews.forEach((k, v) -> {
            if (!k.contains("_")) {
                if (StringUtils.isEmpty(partition) || viewKeySet.stream().noneMatch(key -> key.startsWith(k + "_"))) {
                    viewIds.put((String)k, (Long)v);
                }
            } else if (k.contains("_") && k.endsWith(partition)) {
                viewIds.put(k.substring(0, k.indexOf("_")), (Long)v);
            }
        });
        return viewIds;
    }

    public static Long getViewId(Map<String, Long> dimViews, String dimNumber, String partition) {
        return DimensionViewServiceHelper.getViewId(dimViews, null, dimNumber, partition);
    }

    public static Long getViewId(Map<String, Long> dimensionViews, Long dataSetId, String dimNumber, String partition) {
        Long viewId = null;
        if (View.NoViewDimNums.contains(dimNumber)) {
            return viewId;
        }
        if (dimensionViews == null || dimensionViews.isEmpty()) {
            if (IDUtils.isNotNull(dataSetId)) {
                viewId = DimensionViewServiceHelper.getViewId(dataSetId, dimNumber);
            }
        } else if (dimNumber != null && partition != null && dimensionViews.containsKey(dimNumber + "_" + partition)) {
            viewId = dimensionViews.get(dimNumber + "_" + partition);
        } else if (dimNumber != null && dimensionViews.containsKey(dimNumber)) {
            viewId = dimensionViews.get(dimNumber);
        } else if (dataSetId != null) {
            viewId = DimensionViewServiceHelper.getViewId(dataSetId, dimNumber);
        }
        return viewId;
    }

    public static Long getViewId(Long dataSet, String dimensionNumber) {
        return DimensionViewServiceHelper.getViewId(dataSet, dimensionNumber, true);
    }

    public static Long getViewId(Long dataSet, String dimensionNumber, boolean isAll) {
        if (dimensionNumber == null || IDUtils.isNull(dataSet)) {
            return 0L;
        }
        DynamicObject modelId = QueryServiceHelper.queryOne((String)"eb_dataset", (String)"model.id", (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)dataSet)});
        if (modelId == null) {
            return 0L;
        }
        IModelCacheHelper modelCacheHelper = ModelCacheContext.getOrCreate(modelId.getLong("model.id"));
        if (modelCacheHelper == null) {
            return 0L;
        }
        return modelCacheHelper.getViewByDataSetAndDimNumber(dataSet, dimensionNumber);
    }

    public static Map<Long, String> getViewIdNumberByModelId(Long modelId) {
        HashMap<Long, String> result = new HashMap<Long, String>(16);
        String selectFields = "id,number";
        DynamicObjectCollection dys = QueryServiceHelper.query((String)"eb_dimensionview", (String)selectFields, (QFilter[])new QFilter[]{new QFilter("model", "=", (Object)modelId)});
        for (DynamicObject object : dys) {
            result.put(object.getLong("id"), object.getString("number"));
        }
        return result;
    }

    public static Map<String, Long> getViewIdByBusModelId(Long busModelId) {
        if (IDUtils.isNull(busModelId)) {
            return Collections.emptyMap();
        }
        HashMap viewIds = Maps.newHashMapWithExpectedSize((int)32);
        String selectFields = "viewentry.dimension.number as dimnumber, viewentry.view as viewId";
        QFilter filter = new QFilter("id", "=", (Object)busModelId);
        DynamicObjectCollection dys = QueryServiceHelper.query((String)"eb_businessmodel", (String)selectFields, (QFilter[])filter.toArray());
        if (dys != null) {
            for (DynamicObject dy : dys) {
                viewIds.put(dy.getString("dimnumber"), dy.getLong("viewId"));
            }
        }
        return viewIds;
    }

    public static Long getViewIdByBusModelId(Long busModelId, String dimensionNumber) {
        Long viewId = null;
        if (dimensionNumber == null || !DimensionViewServiceHelper.hasView(dimensionNumber)) {
            return 0L;
        }
        ArrayList<QFilter> filters = new ArrayList<QFilter>(16);
        filters.add(new QFilter("id", "=", (Object)busModelId));
        filters.add(new QFilter("viewentry.dimension.number", "=", (Object)dimensionNumber));
        String selectFields = "viewentry.view as viewId";
        DynamicObject dy = QueryServiceHelper.queryOne((String)"eb_businessmodel", (String)selectFields, (QFilter[])filters.toArray(new QFilter[0]));
        if (dy != null) {
            viewId = dy.getLong("viewId");
        }
        return viewId;
    }

    public static boolean hasView(String dimensionNumber) {
        return DimensionViewServiceHelper.hasView(dimensionNumber, true);
    }

    public static boolean hasView(String dimensionNumber, boolean checkChangeType) {
        SysDimensionEnum sysDimension = SysDimensionEnum.getEnumByNumber(dimensionNumber);
        if (sysDimension == null) {
            return true;
        }
        return SysDimensionEnum.Entity == sysDimension || checkChangeType && SysDimensionEnum.ChangeType == sysDimension || SysDimensionEnum.InternalCompany == sysDimension;
    }

    public static Set<Long> queryAnalyseViewIdByUse(long modelId, long editViewId, long dimId) {
        DynamicObject object;
        QFilter qFilter = new QFilter("model", "=", (Object)modelId);
        QFilter qFilter1 = new QFilter("baseview", "=", (Object)editViewId);
        QFilter qFilter2 = new QFilter("usage", "=", (Object)"1");
        QFilter qFilter3 = new QFilter("dimension", "=", (Object)dimId);
        if (editViewId == 0L && (object = QueryServiceHelper.queryOne((String)"eb_dimensionview", (String)"id", (QFilter[])new QFilter[]{qFilter, qFilter3, new QFilter("source", "=", (Object)"1")})) != null) {
            qFilter1 = new QFilter("baseview", "=", (Object)object.getLong("id"));
        }
        List analyseViewIds = QueryServiceHelper.queryPrimaryKeys((String)"eb_dimensionview", (QFilter[])new QFilter[]{qFilter, qFilter1, qFilter2}, (String)"", (int)1000);
        return new HashSet<Long>(IDUtils.toLongs(analyseViewIds));
    }

    @Deprecated
    public static Map<Long, String> getAnalyseViews(Long modelId, Long viewId) {
        if (IDUtils.isNull(viewId)) {
            return Collections.emptyMap();
        }
        LinkedHashMap<Long, String> analyseViews = new LinkedHashMap<Long, String>();
        SqlBuilder sql = new SqlBuilder();
        sql.append("select fid, fnumber from t_eb_dimensionview where fmodelid = ? and fparentid = ? and fusage = ?", new Object[]{modelId, viewId, Character.valueOf('1')});
        try (DataSet ds = DB.queryDataSet((String)"queryAnalyseView", (DBRoute)BgBaseConstant.epm, (SqlBuilder)sql);){
            if (ds != null) {
                for (Row row : ds) {
                    analyseViews.put(row.getLong("fid"), row.getString("fnumber"));
                }
            }
        }
        return analyseViews;
    }

    public static Long queryViewIdByMemberId(Long modelId, Long businessModel, Long dimensionid, Long viewGroupId, Set<Long> memberIds, Long viewId) {
        Set<Long> allViewByGroupId;
        if (IDUtils.isNull(businessModel)) {
            return null;
        }
        if (memberIds == null || memberIds.isEmpty()) {
            return null;
        }
        if (IDUtils.isNull(modelId) || IDUtils.isNull(dimensionid)) {
            log.warn("modelId or dimensionId is null.");
            return null;
        }
        SqlBuilder sql = new SqlBuilder();
        sql.append("select fmemberid, fviewid from t_eb_viewmember where ", new Object[0]);
        sql.append("fmodelid = ?", new Object[]{modelId});
        sql.append(" and fdimensionid = ?", new Object[]{dimensionid});
        if (IDUtils.isNotNull(businessModel) && IDUtils.isNotNull(viewGroupId) && CollectionUtils.isNotEmpty(allViewByGroupId = ViewGroupServiceHelper.getInstance().getAllViewByGroupId(Collections.singletonList(viewGroupId)))) {
            sql.append(" and ", new Object[0]).appendIn("fviewid", allViewByGroupId.toArray());
        }
        sql.append(" and ", new Object[0]).appendIn("fmemberid", memberIds.toArray());
        HashMap viewMemberMap = Maps.newHashMapWithExpectedSize((int)16);
        DataSet ds = DB.queryDataSet((String)"queryViewId", (DBRoute)BgBaseConstant.epm, (SqlBuilder)sql);
        Object object = null;
        try {
            if (ds != null) {
                for (Row row : ds) {
                    Set set = viewMemberMap.computeIfAbsent(row.getLong("fviewid"), f -> Sets.newHashSet());
                    set.add(row.getLong("fmemberid"));
                }
            }
        }
        catch (Throwable throwable) {
            object = throwable;
            throw throwable;
        }
        finally {
            if (ds != null) {
                if (object != null) {
                    try {
                        ds.close();
                    }
                    catch (Throwable throwable) {
                        ((Throwable)object).addSuppressed(throwable);
                    }
                } else {
                    ds.close();
                }
            }
        }
        HashSet viewIds = Sets.newHashSetWithExpectedSize((int)16);
        for (Map.Entry entry : viewMemberMap.entrySet()) {
            if (!((Set)entry.getValue()).containsAll(memberIds)) continue;
            viewIds.add(entry.getKey());
        }
        if (!viewIds.isEmpty()) {
            if (viewIds.contains(viewId)) {
                return viewId;
            }
        } else {
            return null;
        }
        viewId = (Long)viewIds.iterator().next();
        return viewId;
    }

    public static Set<Long> getViewsByViewId(Long viewId) {
        DynamicObject viewgroup;
        DynamicObject dynamicObject;
        HashSet<Long> viewIds = new HashSet<Long>(16);
        if (IDUtils.isNotEmptyLong(viewId).booleanValue() && (dynamicObject = BusinessDataServiceHelper.loadSingle((Object)viewId, (String)"eb_dimensionview")) != null && (viewgroup = dynamicObject.getDynamicObject("viewgroup")) != null) {
            DynamicObjectCollection views;
            String type = viewgroup.getString("type");
            long sourceGroupId = "1".equals(type) ? viewgroup.getLong("id") : viewgroup.getLong("parent.id");
            HashSet ids = Sets.newHashSet((Object[])new Long[]{sourceGroupId});
            DynamicObjectCollection query = QueryServiceHelper.query((String)"eb_dimensionview_group", (String)"id", (QFilter[])new QFilter("parent", "=", (Object)sourceGroupId).toArray());
            if (CollectionUtils.isNotEmpty(query)) {
                query.forEach(x -> ids.add(x.getLong("id")));
            }
            if (CollectionUtils.isNotEmpty(views = QueryServiceHelper.query((String)"eb_dimensionview", (String)"id", (QFilter[])new QFilter("viewgroup", "in", (Object)ids).toArray()))) {
                views.forEach(viewObj -> viewIds.add(viewObj.getLong("id")));
            }
        }
        return viewIds;
    }
}

