/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.common.utils;

import com.google.common.collect.Lists;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.entity.EntryType;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.servicehelper.operation.SaveServiceHelper;

public class DynamicObjectUtils {
    public static final Log log = LogFactory.getLog(DynamicObjectUtils.class);
    private static final int DEFAULT_DYNAMIC_OBJECT_SIZE = 5000;
    private static final int MAX_BATCH_SIZE = 100000;

    public static void save(List<DynamicObject> objects) {
        List<DynamicObject>[] batchObjects;
        if (objects == null || objects.isEmpty()) {
            return;
        }
        for (List<DynamicObject> batchObject : batchObjects = DynamicObjectUtils.getBatchObjects(objects, 5000)) {
            if (batchObject == null || batchObject.isEmpty()) continue;
            SaveServiceHelper.save((DynamicObject[])batchObject.toArray(new DynamicObject[0]));
        }
    }

    public static void update(List<DynamicObject> objects) {
        List<DynamicObject>[] batchObjects;
        if (objects == null || objects.isEmpty()) {
            return;
        }
        for (List<DynamicObject> batchObject : batchObjects = DynamicObjectUtils.getBatchObjects(objects, 5000)) {
            if (batchObject == null || batchObject.isEmpty()) continue;
            SaveServiceHelper.update((DynamicObject[])batchObject.toArray(new DynamicObject[0]));
        }
    }

    public static void save(DynamicObject[] objects) {
        if (objects == null || objects.length == 0) {
            return;
        }
        DynamicObject[][] batchObjects = DynamicObjectUtils.getBatchObjects(objects, 5000);
        if (batchObjects != null) {
            for (DynamicObject[] batchObject : batchObjects) {
                DynamicObject[] _tmpSave = batchObject;
                if (_tmpSave == null || _tmpSave.length <= 0) continue;
                SaveServiceHelper.save((DynamicObject[])_tmpSave);
            }
        }
    }

    public static <T> List<T>[] getBatchObjects(List<T> objects, int batchSize) {
        if (objects == null || objects.isEmpty()) {
            return new List[0];
        }
        int count = (objects.size() - 1) / batchSize + 1;
        int fromIndex = 0;
        int toIndex = Math.min(batchSize, objects.size());
        List[] batchObjects = new List[count];
        for (int index = 0; index < count; ++index) {
            batchObjects[index] = objects.subList(fromIndex, toIndex);
            fromIndex += batchSize;
            if ((toIndex += batchSize) <= objects.size()) continue;
            toIndex = objects.size();
        }
        return batchObjects;
    }

    public static <T> List<Collection<T>> getBatchObjects(Collection<T> objects) {
        return DynamicObjectUtils.getBatchObjects(objects, 100000);
    }

    public static <T> List<Collection<T>> getBatchObjects(Collection<T> objects, int batchSize) {
        if (objects == null || objects.isEmpty()) {
            return Collections.emptyList();
        }
        int _batchSize = batchSize <= 0 || batchSize > 100000 ? 100000 : batchSize;
        int count = (objects.size() - 1) / batchSize + 1;
        List result = objects instanceof List ? Lists.partition((List)((List)objects), (int)count) : ((Stream)Stream.iterate(0, n -> n + 1).limit(count).parallel()).map(a -> objects.stream().skip((long)a.intValue() * (long)_batchSize).limit(_batchSize).collect(Collectors.toList())).filter(b -> !b.isEmpty()).collect(Collectors.toList());
        return result;
    }

    public static DynamicObject[][] getBatchObjects(DynamicObject[] objects, int batchSize) {
        if (objects == null || objects.length == 0) {
            return null;
        }
        int count = (objects.length - 1) / batchSize + 1;
        int fromIndex = 0;
        int toIndex = Math.min(batchSize, objects.length);
        DynamicObject[][] batchObjects = new DynamicObject[count][0];
        for (int index = 0; index < count; ++index) {
            DynamicObject[] _objects = new DynamicObject[toIndex];
            System.arraycopy(objects, fromIndex, _objects, 0, toIndex);
            batchObjects[index] = _objects;
            toIndex = (fromIndex += batchSize) + batchSize <= objects.length ? batchSize : objects.length - fromIndex;
        }
        return batchObjects;
    }

    public static IDataEntityProperty getEntityProperty(DynamicObject dynamicObject, String longNumber) {
        if (dynamicObject == null) {
            return null;
        }
        if (!longNumber.contains(".")) {
            Map<String, IDataEntityProperty> dataEntityPropertyMap = dynamicObject.getDataEntityType().getProperties().stream().collect(Collectors.toMap(k -> k.getName(), v -> v));
            return dataEntityPropertyMap.get(longNumber);
        }
        String[] split = longNumber.split("\\.");
        DynamicObjectCollection dynamicObjectCollection = dynamicObject.getDynamicObjectCollection(split[0]);
        if (dynamicObjectCollection != null) {
            return dynamicObjectCollection.getDynamicObjectType().getProperty(split[1]);
        }
        return null;
    }

    public static String getDisplayName(IDataEntityProperty property) {
        StringBuilder sb = new StringBuilder(property.getDisplayName().toString());
        IDataEntityType parent = property.getParent();
        while (parent instanceof EntryType) {
            sb.insert(0, parent.getDisplayName() + ".");
            parent = parent.getParent();
        }
        return sb.toString();
    }
}

