/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.common.utils;

import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.clr.DataEntityPropertyCollection;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.property.IFieldHandle;
import kd.epm.eb.common.utils.StringUtils;

public class EntityUtils {
    public static String getEntityNumber(DynamicObject object) {
        if (object == null || object.getDataEntityType() == null) {
            return null;
        }
        String entityNumber = object.getDataEntityType().getName();
        return entityNumber;
    }

    public static Map<String, Set<String>> getSourceIds(DynamicObject object) {
        HashMap source = Maps.newHashMapWithExpectedSize((int)10);
        if (object == null || object.getDataEntityType() == null) {
            return source;
        }
        String entityNumber = EntityUtils.getEntityNumber(object);
        if ("er_dailyreimbursebill".equalsIgnoreCase(entityNumber)) {
            EntityUtils.dailyReimburseBill(object, source);
        } else if ("er_tripreimbursebill".equalsIgnoreCase(entityNumber)) {
            EntityUtils.tripReimburseBill(object, source);
        } else if ("er_dailyloanbill".equalsIgnoreCase(entityNumber)) {
            EntityUtils.dailyLoanBill(object, source);
        } else if ("er_publicreimbursebill".equalsIgnoreCase(entityNumber)) {
            EntityUtils.publicReimburseBill(object, source);
        }
        return source;
    }

    public static Object getPropValue(DynamicObject object, String propName) {
        if (object == null || object.getDataEntityType() == null || StringUtils.isEmpty(propName)) {
            return null;
        }
        Object obj = null;
        DataEntityPropertyCollection props = object.getDataEntityType().getProperties();
        if (props != null) {
            int in = props.size();
            for (int i = 0; i < in; ++i) {
                IDataEntityProperty prop = (IDataEntityProperty)props.get(i);
                if (!prop.getName().equals(propName)) continue;
                obj = object.get(prop);
                break;
            }
        }
        return obj;
    }

    private static void dailyReimburseBill(DynamicObject object, Map<String, Set<String>> source) {
        DynamicObjectCollection lks;
        Set billIds;
        DynamicObjectCollection entries;
        if (object == null || source == null) {
            return;
        }
        Object _obj = EntityUtils.getPropValue(object, "writeoffapply");
        if (_obj instanceof DynamicObjectCollection && !(entries = (DynamicObjectCollection)_obj).isEmpty()) {
            billIds = source.computeIfAbsent("er_dailyapplybill", k -> Sets.newHashSetWithExpectedSize((int)10));
            for (DynamicObject entry : entries) {
                _obj = EntityUtils.getPropValue(entry, "writeoffapply_lk");
                if (!(_obj instanceof DynamicObjectCollection)) continue;
                lks = (DynamicObjectCollection)_obj;
                for (DynamicObject lk : lks) {
                    billIds.add(lk.getString("writeoffapply_lk_sbillid"));
                }
            }
        }
        if ((_obj = EntityUtils.getPropValue(object, "writeoffmoney")) instanceof DynamicObjectCollection && !(entries = (DynamicObjectCollection)_obj).isEmpty()) {
            billIds = source.computeIfAbsent("er_dailyloanbill", k -> Sets.newHashSetWithExpectedSize((int)10));
            for (DynamicObject entry : entries) {
                _obj = EntityUtils.getPropValue(entry, "writeoffmoney_lk");
                if (!(_obj instanceof DynamicObjectCollection)) continue;
                lks = (DynamicObjectCollection)_obj;
                for (DynamicObject lk : lks) {
                    billIds.add(lk.getString("writeoffmoney_lk_sbillid"));
                }
            }
        }
        if ((_obj = EntityUtils.getPropValue(object, "easbudgetbillid")) instanceof String) {
            billIds = source.computeIfAbsent("EAS_BILL", k -> Sets.newHashSetWithExpectedSize((int)10));
            billIds.add((String)_obj);
        }
    }

    private static void tripReimburseBill(DynamicObject object, Map<String, Set<String>> source) {
        DynamicObjectCollection entries;
        if (object == null || source == null) {
            return;
        }
        Object _obj = EntityUtils.getPropValue(object, "sourcebillid");
        if (_obj instanceof Long || _obj instanceof String) {
            String sourceId = _obj.toString();
            Set billIds = source.computeIfAbsent("er_dailyapplybill", k -> Sets.newHashSetWithExpectedSize((int)10));
            billIds.add(sourceId);
        }
        if ((_obj = EntityUtils.getPropValue(object, "clearloanentry")) instanceof DynamicObjectCollection && !(entries = (DynamicObjectCollection)_obj).isEmpty()) {
            Set billIds = source.computeIfAbsent("er_dailyloanbill", k -> Sets.newHashSetWithExpectedSize((int)10));
            for (DynamicObject entry : entries) {
                _obj = EntityUtils.getPropValue(entry, "clearloanentry_lk");
                if (!(_obj instanceof DynamicObjectCollection)) continue;
                DynamicObjectCollection lks = (DynamicObjectCollection)_obj;
                for (DynamicObject lk : lks) {
                    billIds.add(lk.getString("clearloanentry_lk_sbillid"));
                }
            }
        }
    }

    private static void dailyLoanBill(DynamicObject object, Map<String, Set<String>> source) {
        Set billIds;
        DynamicObjectCollection entries;
        if (object == null || source == null) {
            return;
        }
        Object _obj = EntityUtils.getPropValue(object, "expenseentryentity");
        if (_obj instanceof DynamicObjectCollection && !(entries = (DynamicObjectCollection)_obj).isEmpty()) {
            billIds = source.computeIfAbsent("er_dailyapplybill", k -> Sets.newHashSetWithExpectedSize((int)10));
            for (DynamicObject entry : entries) {
                _obj = EntityUtils.getPropValue(entry, "expenseentryentity_lk");
                if (!(_obj instanceof DynamicObjectCollection)) continue;
                DynamicObjectCollection lks = (DynamicObjectCollection)_obj;
                for (DynamicObject lk : lks) {
                    billIds.add(lk.getString("expenseentryentity_lk_sbillid"));
                }
            }
        }
        if ((_obj = EntityUtils.getPropValue(object, "easbudgetbillid")) instanceof String) {
            billIds = source.computeIfAbsent("EAS_BILL", k -> Sets.newHashSetWithExpectedSize((int)10));
            billIds.add((String)_obj);
        }
    }

    private static void publicReimburseBill(DynamicObject object, Map<String, Set<String>> source) {
        DynamicObjectCollection lks;
        Set billIds;
        DynamicObjectCollection entries;
        if (object == null || source == null) {
            return;
        }
        Object _obj = EntityUtils.getPropValue(object, "writeoffmoney");
        if (_obj instanceof DynamicObjectCollection && !(entries = (DynamicObjectCollection)_obj).isEmpty()) {
            billIds = source.computeIfAbsent("er_dailyloanbill", k -> Sets.newHashSetWithExpectedSize((int)10));
            for (DynamicObject entry : entries) {
                _obj = EntityUtils.getPropValue(entry, "writeoffmoney_lk");
                if (!(_obj instanceof DynamicObjectCollection)) continue;
                lks = (DynamicObjectCollection)_obj;
                for (DynamicObject lk : lks) {
                    billIds.add(lk.getString("writeoffmoney_lk_sbillid"));
                }
            }
        }
        if ((_obj = EntityUtils.getPropValue(object, "writeoffapply")) instanceof DynamicObjectCollection && !(entries = (DynamicObjectCollection)_obj).isEmpty()) {
            billIds = source.computeIfAbsent("er_dailyapplybill", k -> Sets.newHashSetWithExpectedSize((int)10));
            for (DynamicObject entry : entries) {
                _obj = EntityUtils.getPropValue(entry, "writeoffapply_lk");
                if (!(_obj instanceof DynamicObjectCollection)) continue;
                lks = (DynamicObjectCollection)_obj;
                for (DynamicObject lk : lks) {
                    billIds.add(lk.getString("writeoffapply_lk_sbillid"));
                }
            }
        }
    }

    public static void setDataWithOutPropertychanged(IDataModel dataModel, String controlkey, Object value) {
        if (dataModel != null && StringUtils.isNotEmpty(controlkey)) {
            DynamicObject dataEntity = dataModel.getDataEntity();
            dataEntity.beginInit();
            IDataEntityProperty property = dataModel.getProperty(controlkey);
            if (property != null) {
                if (property instanceof IFieldHandle) {
                    ((IFieldHandle)property).setFieldValue(dataModel, (Object)dataEntity, value);
                } else {
                    property.setValueFast((Object)dataEntity, value);
                }
                dataEntity.endInit();
                dataEntity.getLastDirty().set(property.getOrdinal(), true);
            }
        }
    }
}

