/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.common.utils;

import com.google.common.base.Preconditions;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.Map;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.epm.eb.common.utils.Point;
import kd.epm.eb.common.utils.RangeModel;
import org.apache.poi.hssf.usermodel.HSSFCell;
import org.apache.poi.hssf.usermodel.HSSFCellStyle;
import org.apache.poi.hssf.usermodel.HSSFDataFormat;
import org.apache.poi.hssf.usermodel.HSSFFont;
import org.apache.poi.hssf.usermodel.HSSFRow;
import org.apache.poi.hssf.usermodel.HSSFSheet;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.Comment;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.util.CellRangeAddress;
import org.apache.poi.xssf.streaming.SXSSFWorkbook;
import org.apache.poi.xssf.usermodel.XSSFCell;
import org.apache.poi.xssf.usermodel.XSSFCellStyle;
import org.apache.poi.xssf.usermodel.XSSFDataFormat;
import org.apache.poi.xssf.usermodel.XSSFFont;
import org.apache.poi.xssf.usermodel.XSSFRow;
import org.apache.poi.xssf.usermodel.XSSFSheet;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;

public class ExcelUtils {
    private static final Log log = LogFactory.getLog(ExcelUtils.class);
    private static final int ZeroCharValue = 48;

    public static int pos2X(String pos) {
        int colAxisIndex = ExcelUtils.getColAxisIndex(pos);
        return ExcelUtils.pos2X(pos, colAxisIndex);
    }

    private static int pos2X(String pos, int colAxisIndex) {
        int count = -1;
        for (int i = 0; i < colAxisIndex; ++i) {
            char c = pos.charAt(i);
            count = c >= 'a' && c <= 'z' ? (int)((double)count + (double)(c - 96) * Math.pow(26.0, colAxisIndex - 1 - i)) : (int)((double)count + (double)(c - 64) * Math.pow(26.0, colAxisIndex - 1 - i));
        }
        return count;
    }

    public static int pos2Y(String pos) {
        int colAxisIndex = ExcelUtils.getColAxisIndex(pos);
        return ExcelUtils.pos2Y(pos, colAxisIndex);
    }

    private static int pos2Y(String pos, int colAxisIndex) {
        int result = 0;
        int j = 1;
        for (int i = pos.length() - 1; i >= colAxisIndex; --i) {
            char c = pos.charAt(i);
            if (c >= '0' && c <= '9') {
                result += (c - 48) * j;
            } else {
                throw new KDBizException(ResManager.loadResFormat((String)"\u8868\u683c\u5750\u6807\u65e0\u6548\uff0c\u201c%1\u201d\u3002", (String)"ExcelUtils_0", (String)"epm-eb-common", (Object[])new Object[]{pos}));
            }
            j *= 10;
        }
        return result - 1;
    }

    private static int getColAxisIndex(String pos) {
        if (pos.length() > 1 && Character.isLetter(pos.charAt(0)) && !Character.isLetter(pos.charAt(1))) {
            return 1;
        }
        for (int index = 2; index < pos.length(); ++index) {
            if (Character.isLetter(pos.charAt(index))) continue;
            return index;
        }
        throw new KDBizException(ResManager.loadResFormat((String)"\u8868\u683c\u5750\u6807\u65e0\u6548\uff0c\u201c%1\u201d\u3002", (String)"ExcelUtils_0", (String)"epm-eb-common", (Object[])new Object[]{pos}));
    }

    @Deprecated
    public static int[] pos2XY(String pos) {
        int[] xy = new int[2];
        int colAxisIndex = ExcelUtils.getColAxisIndex(pos);
        xy[0] = ExcelUtils.pos2X(pos, colAxisIndex);
        xy[1] = ExcelUtils.pos2Y(pos, colAxisIndex);
        return xy;
    }

    public static Point pos2Point(String pos) {
        int colAxisIndex = ExcelUtils.getColAxisIndex(pos);
        return new Point(ExcelUtils.pos2X(pos, colAxisIndex), ExcelUtils.pos2Y(pos, colAxisIndex));
    }

    public static Point pos2Point(String pos, boolean needEndPoint) {
        Point result;
        String[] points = pos.split(":");
        if (points.length != 2) {
            throw new KDBizException(pos + " is not a range");
        }
        if (needEndPoint) {
            int colAxisIndex = ExcelUtils.getColAxisIndex(points[1]);
            result = new Point(ExcelUtils.pos2X(points[1], colAxisIndex), ExcelUtils.pos2Y(points[1], colAxisIndex));
        } else {
            int colAxisIndex = ExcelUtils.getColAxisIndex(points[0]);
            result = new Point(ExcelUtils.pos2X(points[0], colAxisIndex), ExcelUtils.pos2Y(points[0], colAxisIndex));
        }
        return result;
    }

    public static boolean isOverlap(String rec1, String rec2) {
        RangeModel a = new RangeModel(rec1);
        RangeModel b = new RangeModel(rec2);
        return Math.max(a.getXStart(), b.getXStart()) <= Math.min(a.getXEnd(), b.getXEnd()) && Math.max(a.getYStart(), b.getYStart()) <= Math.min(a.getYEnd(), b.getYEnd());
    }

    public static boolean isInDimRange(RangeModel a, RangeModel b) {
        return b.getX_start() <= a.getX_start() && b.getX_end() >= a.getX_end() && b.getY_start() <= a.getY_start() && b.getY_end() >= a.getY_end();
    }

    public static String xy2Pos(int x, int y) {
        Preconditions.checkArgument((x >= 0 ? 1 : 0) != 0, (Object)ResManager.loadResFormat((String)"\u8868\u683c\u5750\u6807\u65e0\u6548!", (String)"ExcelUtils_3", (String)"epm-eb-common", (Object[])new Object[0]));
        String xAxis = ExcelUtils.int2pos(x);
        return xAxis + (y + 1);
    }

    public static String int2pos(int intVal) {
        if (intVal < 0) {
            return null;
        }
        ++intVal;
        char[] tmp = new char[30];
        int i = 29;
        while (i >= 0) {
            int q = intVal / 26;
            int r = intVal % 26;
            if (r < 1) {
                r = 26;
                --q;
            }
            tmp[i--] = (char)(65 + r - 1);
            if (q == 0) break;
            intVal = q;
        }
        return new String(tmp, ++i, tmp.length - i);
    }

    public static String checkPosValidata(String startPos, String endPos, String dataPos) {
        int startPosX = ExcelUtils.pos2X(startPos);
        int startPosY = ExcelUtils.pos2Y(startPos);
        int endPosX = ExcelUtils.pos2X(endPos);
        int endPosY = ExcelUtils.pos2Y(endPos);
        int dataPosX = ExcelUtils.pos2X(dataPos);
        int dataPosY = ExcelUtils.pos2Y(dataPos);
        StringBuilder msg = new StringBuilder();
        if (endPosX < startPosX || endPosY < startPosY) {
            msg.append(ResManager.loadKDString((String)"\u533a\u57df\u8303\u56f4\u65e0\u6548\uff0c\u7ed3\u675f\u5355\u5143\u683c\u5fc5\u987b\u5728\u5f00\u59cb\u5355\u5143\u683c\u53f3\u4e0b\u65b9\u3002", (String)"ExcelUtils_1", (String)"epm-eb-common", (Object[])new Object[0]));
        } else if (dataPosX < startPosX || dataPosY < startPosY || dataPosX > endPosX || dataPosY > endPosY) {
            msg.append(ResManager.loadKDString((String)"\u8d77\u59cb\u5355\u5143\u683c\u4e0d\u5728\u533a\u57df\u8303\u56f4\u5185\u3002", (String)"ExcelUtils_2", (String)"epm-eb-common", (Object[])new Object[0]));
        }
        return msg.toString();
    }

    public static void xlsx2xls(SXSSFWorkbook xssfWb, HSSFWorkbook workbookNew) {
        InputStream inputStream = null;
        XSSFWorkbook workbookOld = null;
        try (ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();){
            xssfWb.write((OutputStream)byteArrayOutputStream);
            byteArrayOutputStream.flush();
            inputStream = new ByteArrayInputStream(byteArrayOutputStream.toByteArray());
            workbookOld = new XSSFWorkbook(inputStream);
            ExcelUtils.xlsx2xls(workbookOld, workbookNew);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        finally {
            try {
                if (workbookOld != null) {
                    workbookOld.close();
                }
                if (inputStream != null) {
                    inputStream.close();
                }
            }
            catch (IOException e) {
                log.error(e.getMessage(), (Throwable)e);
            }
        }
    }

    public static void xlsx2xls(XSSFWorkbook workbookOld, HSSFWorkbook workbookNew) {
        workbookNew.setMissingCellPolicy(workbookOld.getMissingCellPolicy());
        HashMap<Integer, HSSFCellStyle> styleMap = new HashMap<Integer, HSSFCellStyle>(16);
        for (int i = 0; i < workbookOld.getNumberOfSheets(); ++i) {
            XSSFSheet sheetOld = workbookOld.getSheetAt(i);
            HSSFSheet sheetNew = workbookNew.createSheet(sheetOld.getSheetName());
            ExcelUtils.transform(workbookOld, workbookNew, sheetOld, sheetNew, styleMap);
        }
    }

    private static void transform(XSSFWorkbook workbookOld, HSSFWorkbook workbookNew, XSSFSheet sheetOld, HSSFSheet sheetNew, Map<Integer, HSSFCellStyle> styleMap) {
        int i;
        sheetNew.setDisplayFormulas(sheetOld.isDisplayFormulas());
        sheetNew.setDisplayGridlines(sheetOld.isDisplayGridlines());
        sheetNew.setDisplayGuts(sheetOld.getDisplayGuts());
        sheetNew.setDisplayRowColHeadings(sheetOld.isDisplayRowColHeadings());
        sheetNew.setDisplayZeros(sheetOld.isDisplayZeros());
        sheetNew.setFitToPage(sheetOld.getFitToPage());
        sheetNew.setHorizontallyCenter(sheetOld.getHorizontallyCenter());
        sheetNew.setMargin((short)3, sheetOld.getMargin((short)3));
        sheetNew.setMargin((short)5, sheetOld.getMargin((short)5));
        sheetNew.setMargin((short)4, sheetOld.getMargin((short)4));
        sheetNew.setMargin((short)0, sheetOld.getMargin((short)0));
        sheetNew.setMargin((short)1, sheetOld.getMargin((short)1));
        sheetNew.setMargin((short)2, sheetOld.getMargin((short)2));
        sheetNew.setPrintGridlines(sheetOld.isPrintGridlines());
        sheetNew.setRightToLeft(sheetOld.isRightToLeft());
        sheetNew.setRowSumsBelow(sheetOld.getRowSumsBelow());
        sheetNew.setRowSumsRight(sheetOld.getRowSumsRight());
        sheetNew.setVerticallyCenter(sheetOld.getVerticallyCenter());
        int lastColumn = 0;
        for (Row row : sheetOld) {
            HSSFRow rowNew = sheetNew.createRow(row.getRowNum());
            lastColumn = ExcelUtils.transform(lastColumn, workbookOld, workbookNew, (XSSFRow)row, rowNew, styleMap);
        }
        for (i = 0; i < lastColumn; ++i) {
            sheetNew.setColumnWidth(i, sheetOld.getColumnWidth(i));
            sheetNew.setColumnHidden(i, sheetOld.isColumnHidden(i));
        }
        for (i = 0; i < sheetOld.getNumMergedRegions(); ++i) {
            CellRangeAddress merged = sheetOld.getMergedRegion(i);
            sheetNew.addMergedRegion(merged);
        }
    }

    private static int transform(int lastColumn, XSSFWorkbook workbookOld, HSSFWorkbook workbookNew, XSSFRow rowOld, HSSFRow rowNew, Map<Integer, HSSFCellStyle> styleMap) {
        rowNew.setHeight(rowOld.getHeight());
        for (Cell cell : rowOld) {
            HSSFCell cellNew = rowNew.createCell(cell.getColumnIndex());
            ExcelUtils.transform(workbookOld, workbookNew, (XSSFCell)cell, cellNew, styleMap);
        }
        return Math.max(lastColumn, rowOld.getLastCellNum());
    }

    private static void transform(XSSFWorkbook workbookOld, HSSFWorkbook workbookNew, XSSFCell cellOld, HSSFCell cellNew, Map<Integer, HSSFCellStyle> styleMap) {
        cellNew.setCellComment((Comment)cellOld.getCellComment());
        Integer hash = cellOld.getCellStyle().hashCode();
        if (!styleMap.containsKey(hash)) {
            ExcelUtils.transform(workbookOld, workbookNew, hash, cellOld.getCellStyle(), workbookNew.createCellStyle(), styleMap);
        }
        cellNew.setCellStyle(styleMap.get(hash));
        switch (cellOld.getCellType()) {
            case BLANK: {
                break;
            }
            case BOOLEAN: {
                cellNew.setCellValue(cellOld.getBooleanCellValue());
                break;
            }
            case ERROR: {
                cellNew.setCellValue((double)cellOld.getErrorCellValue());
                break;
            }
            case FORMULA: {
                cellNew.setCellValue(cellOld.getCellFormula());
                break;
            }
            case NUMERIC: {
                cellNew.setCellValue(cellOld.getNumericCellValue());
                break;
            }
            case STRING: {
                cellNew.setCellValue(cellOld.getStringCellValue());
            }
        }
    }

    private static void transform(XSSFWorkbook workbookOld, HSSFWorkbook workbookNew, Integer hash, XSSFCellStyle styleOld, HSSFCellStyle styleNew, Map<Integer, HSSFCellStyle> styleMap) {
        styleNew.setAlignment(styleOld.getAlignment());
        styleNew.setVerticalAlignment(styleOld.getVerticalAlignment());
        styleNew.setBorderBottom(styleOld.getBorderBottom());
        styleNew.setBorderLeft(styleOld.getBorderLeft());
        styleNew.setBorderRight(styleOld.getBorderRight());
        styleNew.setBorderTop(styleOld.getBorderTop());
        styleNew.setTopBorderColor(styleOld.getTopBorderColor());
        styleNew.setBottomBorderColor(styleOld.getTopBorderColor());
        styleNew.setLeftBorderColor(styleOld.getLeftBorderColor());
        styleNew.setRightBorderColor(styleOld.getRightBorderColor());
        styleNew.setDataFormat(ExcelUtils.transform(workbookOld, workbookNew, styleOld.getDataFormat()));
        styleNew.setFillBackgroundColor(styleOld.getFillBackgroundColor());
        styleNew.setFillForegroundColor(styleOld.getFillForegroundColor());
        styleNew.setFont(ExcelUtils.transform(workbookNew, styleOld.getFont()));
        styleNew.setHidden(styleOld.getHidden());
        styleNew.setIndention(styleOld.getIndention());
        styleNew.setLocked(styleOld.getLocked());
        styleNew.setWrapText(styleOld.getWrapText());
        styleMap.put(hash, styleNew);
    }

    private static short transform(XSSFWorkbook workbookOld, HSSFWorkbook workbookNew, short index) {
        XSSFDataFormat formatOld = workbookOld.createDataFormat();
        HSSFDataFormat formatNew = workbookNew.createDataFormat();
        return formatNew.getFormat(formatOld.getFormat(index));
    }

    private static HSSFFont transform(HSSFWorkbook workbookNew, XSSFFont fontOld) {
        HSSFFont fontNew = workbookNew.createFont();
        fontNew.setBold(fontOld.getBold());
        fontNew.setCharSet(fontOld.getCharSet());
        fontNew.setColor(fontOld.getColor());
        fontNew.setFontName(fontOld.getFontName());
        fontNew.setFontHeight(fontOld.getFontHeight());
        fontNew.setItalic(fontOld.getItalic());
        fontNew.setStrikeout(fontOld.getStrikeout());
        fontNew.setTypeOffset(fontOld.getTypeOffset());
        fontNew.setUnderline(fontOld.getUnderline());
        return fontNew;
    }
}

