/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.common.utils;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import java.io.IOException;
import java.io.Writer;
import java.text.DateFormat;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.epm.eb.common.utils.MaxLengthSegmentedStringWriter;
import org.apache.commons.lang3.StringUtils;

public class JSONUtils {
    private static final Log log = LogFactory.getLog(JSONUtils.class);
    public static final ObjectMapper mapper = new ObjectMapper();
    public static final JavaType strType = JSONUtils.getMapper().getTypeFactory().constructType(String.class);

    public static ObjectMapper getMapper() {
        return mapper;
    }

    public static String toString(Object obj, int maxLength) {
        MaxLengthSegmentedStringWriter sw = new MaxLengthSegmentedStringWriter(mapper.getFactory()._getBufferRecycler(), maxLength);
        try {
            mapper.writeValue((Writer)sw, obj);
        }
        catch (JsonProcessingException ex) {
            log.error("toJSONString error:", (Throwable)ex);
        }
        catch (IOException ex) {
            log.error("toJSONString error:", (Throwable)ex);
        }
        return sw.getAndClear();
    }

    public static String toString(Object object) {
        String jsonStr = null;
        try {
            jsonStr = mapper.writeValueAsString(object);
        }
        catch (Throwable ex) {
            log.error("toJSONString error:", ex);
        }
        return jsonStr;
    }

    public static String toJson(Object object, DateFormat format) {
        ObjectMapper mapper = new ObjectMapper();
        mapper.setDateFormat(format);
        String jsonStr = null;
        try {
            jsonStr = mapper.writeValueAsString(object);
        }
        catch (Throwable ex) {
            log.error("toJSONString error:", ex);
        }
        return jsonStr;
    }

    public static <T> T parse(String jsonStr, Class<T> valueType) {
        if (jsonStr == null || jsonStr.trim().length() == 0) {
            return null;
        }
        try {
            return (T)mapper.readValue(jsonStr, valueType);
        }
        catch (IOException ex) {
            log.error("parse JSONString error:", (Throwable)ex);
            return null;
        }
    }

    public static <T> T parse(String jsonStr, Class<T> valueType, DateFormat format) {
        if (StringUtils.isBlank((CharSequence)jsonStr)) {
            return null;
        }
        mapper.setDateFormat(format);
        try {
            return (T)mapper.readValue(jsonStr, valueType);
        }
        catch (Exception e) {
            log.error("parse JSONString error:", (Throwable)e);
            throw new KDBizException("Json parse error:" + e.getMessage());
        }
    }

    public static <T> T parse(String jsonStr, JavaType javaType) {
        if (jsonStr == null || jsonStr.trim().length() == 0 || javaType == null) {
            return null;
        }
        try {
            return (T)mapper.readValue(jsonStr, javaType);
        }
        catch (IOException ex) {
            log.error("parse JSONString error:", (Throwable)ex);
            return null;
        }
    }

    static {
        mapper.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
        mapper.configure(SerializationFeature.FAIL_ON_EMPTY_BEANS, false);
        mapper.configure(DeserializationFeature.USE_BIG_DECIMAL_FOR_FLOATS, true);
    }
}

