/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.common.utils;

import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.epm.eb.common.cache.factory.CacheGenFactory;

public class LogSignHelper {
    private static final String cacheKey = "eb_logSign_allKeys";

    public static Set<String> getLogSignByGropNum(String groupNum) {
        Set keys = LogSignHelper.getAllSignFromCache().getOrDefault(groupNum, new HashSet(16));
        return Collections.unmodifiableSet(keys);
    }

    public static Map<String, Set<String>> getAllSignFromCache() {
        return CacheGenFactory.getCommonCache().getOrLoad(cacheKey, () -> {
            Map record = BusinessDataServiceHelper.loadFromCache((String)"eb_logsign", (String)"logsign,groupnum", (QFilter[])new QFilter("status", "=", (Object)Character.valueOf('A')).toArray());
            HashMap result = new HashMap(16);
            record.forEach((id, obj) -> result.computeIfAbsent(obj.getString("groupnum"), key -> new HashSet(16)).add(obj.getString("logsign")));
            return result;
        });
    }

    public static void cleanCache() {
        CacheGenFactory.getCommonCache().invalidateByKey(cacheKey);
    }

    public static boolean needLog(String groupNum, String key) {
        return LogSignHelper.getLogSignByGropNum(groupNum).contains(key);
    }
}

