/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.common.utils;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import kd.epm.eb.common.utils.ControlLog;
import kd.epm.eb.common.utils.LogUtils;

public class LogStats
implements Serializable {
    private static final long serialVersionUID = 4889400904164924048L;
    private List<LogItem> items = Collections.synchronizedList(new LinkedList());
    private String tag;
    private long begin;
    private long end = this.begin = System.nanoTime();
    private Map<String, Long> useTime = new HashMap<String, Long>(10);
    private Map<String, Long> startTime = new HashMap<String, Long>(10);
    private String prev = null;
    private List<String> logs = null;
    private List<ControlLog> controllogs = null;

    public LogStats(String tag) {
        this.tag = tag;
    }

    public void add(String logStr) {
        this.add(logStr, true);
    }

    public void addInfo(String logStr) {
        this.add(logStr, false);
    }

    public void add(String logStr, boolean showTime) {
        if (logStr == null || logStr.trim().isEmpty()) {
            return;
        }
        LogItem item = new LogItem(logStr, showTime, this.end);
        this.items.add(item);
        if (showTime) {
            this.end = item.getTime();
        }
    }

    public String toString() {
        StringBuilder log = new StringBuilder();
        if (this.tag != null) {
            log.append(this.tag).append("\r\n");
        }
        log.append("all-use-time = ").append(LogUtils.use(this.begin)).append("ms.").append("\r\n");
        ArrayList<LogItem> _logs = new ArrayList<LogItem>(this.items);
        for (LogItem item : _logs) {
            log.append(item.toString()).append("\r\n");
        }
        return log.toString();
    }

    public void logTime(String logKey) {
        if (this.prev != null) {
            Long _useTime = System.currentTimeMillis() - this.startTime.get(this.prev);
            Long oldUseTime = this.useTime.get(this.prev);
            if (oldUseTime != null) {
                _useTime = _useTime + oldUseTime;
            }
            this.useTime.put(this.prev, _useTime);
        }
        this.startTime.put(logKey, System.currentTimeMillis());
        this.prev = logKey;
    }

    public List<String> getLogs() {
        return this.logs;
    }

    public void setLogs(List<String> logs) {
        this.logs = logs != null ? logs : Collections.synchronizedList(new ArrayList(100));
    }

    public List<ControlLog> getControllogs() {
        return this.controllogs;
    }

    public void setControllogs(List<ControlLog> controllogs) {
        this.controllogs = controllogs != null ? controllogs : Collections.synchronizedList(new ArrayList(100));
    }

    public static boolean isNeedDetailLog(LogStats stats) {
        return stats != null && stats.getControllogs() != null;
    }

    public static class LogItem
    implements Serializable {
        private String logStr;
        private boolean showTime;
        private long time;
        private long before;

        public LogItem(String logStr, boolean showTime, long before) {
            this.logStr = logStr;
            this.showTime = showTime;
            this.before = before;
            this.time = System.nanoTime();
        }

        public long getTime() {
            return this.time;
        }

        public String toString() {
            if (this.showTime) {
                return this.logStr + "; use = " + LogUtils.use(this.before, this.time) + "ms.";
            }
            return this.logStr;
        }
    }
}

