/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.common.utils;

import java.util.concurrent.TimeUnit;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;

public class LogUtils {
    public static final String BUDGET_LOG_TAG = "budget-log : ";
    public static final String BGOLAP_LOG_TAG = "budget-olap-log : ";
    public static final String BGRULE_LOG_TAG = "budget-bizrule-log : ";
    public static final String BGCONTROL_LOG_TAG = "budget-control-log : ";
    public static final String BGCONTROL_LOCK_LOG_TAG = "budget-control-lock-log : ";
    public static final String BGCONTROL_WRITEOFF_LOG_TAG = "control-write-log : ";
    public static final String BGSCRIPT_LOG_TAG = "budget-script-log : ";
    public static final String BGDATA_LOG_TAG = "budget-data-log : ";
    public static final String BGCACHE_LOG_TAG = "budget-cache-log : ";
    public static final String BUDGET_MODEL_INIT_LOG = "budget-model-init-log : ";
    public static final String BUDGET_CALC_LOG = "budget-calc-log : ";
    public static final String ASYNC_COMPOTE = ":epm-saveReportCalBizRule:";
    public static final String BUDGET_SHREK_LOG = "budget-shrek-log : ";
    public static final String BG_CURRENCY_CONVERT_LOG = "bg-currency-convert-log : ";
    public static final String REPORT_OPER_TAG = "budget-oper-log : ";
    public static final String BUDGET_UPDATE_TAG = "budget-update-log : ";
    public static final String BUDGET_OlAP_TAG_NEW = "budget-olap-log-new:";
    public static final String BUDGET_ROLL_LOG = "budget-roll-log:";
    public static final String CUBE_API_LOG = "budget-api-log:";
    public static final String BUDGET_UPGRADE_LOG = "budget-upgrade-log:";
    public static final String BUDGET_EXAMINE_LOG = "budget-examine_log:";
    public static final String MEMBER_QUOTE_LOG = "member-quote-log:";
    public static final String MEMBER_LOG = "member-log:";
    public static final String FACTORY_CHECK_LOG = "budget-factory-check-log:";
    public static final String BGCONTROLWARNING_LOG_TAG = "budget-control-warning-log : ";
    public static final String TREE_LOG_TAG = "budget-tree-log : ";
    public static final String EXPORT_LOG_TAG = "budget-export-log : ";
    public static final String SERIALIZE_TAG = "budget-serialize-log : ";
    public static final String TEMPLATE_TAG = "budget-template-log : ";
    private Log log = null;
    private StringBuffer sb = new StringBuffer();
    private long begin;
    private long previous;
    private static final long WARNING1 = 5000L;
    private static final long WARNING2 = 10000L;
    private static final long WARNING3 = 15000L;
    private static final String WARNING1_INFO = "warning 1 script";
    private static final String WARNING2_INFO = "warning 2 script";
    private static final String WARNING3_INFO = "warning 3 script";

    public static LogUtils getInstance(Class<?> clazz) {
        return new LogUtils(clazz);
    }

    public LogUtils(Class<?> clazz) {
        this.log = LogFactory.getLog(clazz);
    }

    private String getTag(String tag) {
        return tag != null ? tag : BGCONTROL_LOG_TAG;
    }

    public void begin(String tag, String logStr) {
        this.previous = this.begin = System.nanoTime();
        this.sb.setLength(0);
        this.sb.append(this.getTag(tag)).append(logStr).append("\r\n");
    }

    public void add(String logStr) {
        long time = System.nanoTime();
        this.sb.append(logStr).append("\r\n").append(" use = ").append(LogUtils.use(this.previous)).append("ms.").append("\r\n");
        this.previous = time;
    }

    public void end(String logStr) {
        long use = LogUtils.use(this.begin);
        this.sb.append(logStr).append("\r\n");
        if (use >= 15000L) {
            this.sb.append(WARNING3_INFO);
        } else if (use >= 10000L) {
            this.sb.append(WARNING2_INFO);
        } else if (use >= 5000L) {
            this.sb.append(WARNING1_INFO);
        }
        this.sb.append(" all use = ").append(use).append("ms.");
        this.log.info(this.sb.toString());
    }

    public void info(String tag, String logStr) {
        this.log.info(this.getTag(tag) + logStr);
    }

    public void error(String tag, Throwable ex) {
        this.log.error(this.getTag(tag), ex);
    }

    public void error(String tag, String logStr) {
        this.log.error(this.getTag(tag) + logStr);
    }

    public void error(String tag, String logStr, Throwable ex) {
        if (logStr != null) {
            this.log.error(this.getTag(tag) + logStr, ex);
        } else {
            this.log.error(this.getTag(tag), ex);
        }
    }

    public void warn(String tag, Throwable ex) {
        if (this.log.isWarnEnabled()) {
            this.log.warn(this.getTag(tag), ex);
        }
    }

    public void warn(String tag, String logStr) {
        if (this.log.isWarnEnabled()) {
            this.log.warn(this.getTag(tag) + logStr);
        }
    }

    public void debug(String tag, String logStr) {
        if (this.log.isDebugEnabled()) {
            this.log.debug(this.getTag(tag) + logStr);
        }
    }

    public static long use(long begin) {
        return TimeUnit.NANOSECONDS.toMillis(System.nanoTime() - begin);
    }

    public static long use(long begin, long end) {
        return TimeUnit.NANOSECONDS.toMillis(end - begin);
    }
}

