/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.common.utils;

import com.google.common.collect.Sets;
import java.math.BigInteger;
import java.util.Comparator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import java.util.stream.Stream;

public class MapUtils {
    public static <K, V extends Comparable<? super V>> Map<K, V> sortByValueAsc(Map<K, V> map) {
        LinkedHashMap result = new LinkedHashMap();
        Stream st = map.entrySet().stream();
        st.sorted(Comparator.comparing(e -> (Comparable)e.getValue())).forEach(e -> {
            Comparable cfr_ignored_0 = (Comparable)result.put(e.getKey(), e.getValue());
        });
        return result;
    }

    public static void mergeMap(Map<String, Set<String>> srcMap, Map<String, Set<String>> tarMap) {
        if (srcMap == null || srcMap.isEmpty()) {
            return;
        }
        srcMap.forEach((k, v) -> {
            Set sets = tarMap.computeIfAbsent((String)k, val -> Sets.newHashSetWithExpectedSize((int)v.size()));
            sets.addAll(v);
        });
    }

    public static <K, V> boolean contains(Map<K, V> srcMap, Map<K, V> destMap) {
        if (srcMap == null || srcMap.isEmpty()) {
            return true;
        }
        if (destMap == null || destMap.isEmpty()) {
            return false;
        }
        for (Map.Entry<K, V> entry : srcMap.entrySet()) {
            V value = destMap.get(entry.getKey());
            if (value == entry.getValue() || value.equals(entry.getValue())) continue;
            return false;
        }
        return true;
    }

    public static BigInteger calcDescartes(Map<String, Set<String>> memberMap) {
        BigInteger sum = BigInteger.ONE;
        for (Set<String> members : memberMap.values()) {
            sum = sum.multiply(BigInteger.valueOf(members.size()));
        }
        return sum;
    }
}

