/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.common.utils;

import com.fasterxml.jackson.core.util.BufferRecycler;
import com.fasterxml.jackson.core.util.TextBuffer;
import java.io.Writer;

public class MaxLengthSegmentedStringWriter
extends Writer {
    private final TextBuffer _buffer;
    private int _maxLenth = 20000;

    public MaxLengthSegmentedStringWriter(BufferRecycler br, int maxLength) {
        this._buffer = new TextBuffer(br);
        this._maxLenth = maxLength;
    }

    @Override
    public Writer append(char c) {
        if (this.checkLength()) {
            return this;
        }
        this.write(c);
        return this;
    }

    @Override
    public Writer append(CharSequence csq) {
        if (this.checkLength()) {
            return this;
        }
        String str = csq.toString();
        this._buffer.append(str, 0, str.length());
        return this;
    }

    @Override
    public Writer append(CharSequence csq, int start, int end) {
        if (this.checkLength()) {
            return this;
        }
        String str = csq.subSequence(start, end).toString();
        this._buffer.append(str, 0, str.length());
        return this;
    }

    @Override
    public void close() {
    }

    @Override
    public void flush() {
    }

    @Override
    public void write(char[] cbuf) {
        if (this.checkLength()) {
            return;
        }
        this._buffer.append(cbuf, 0, cbuf.length);
    }

    @Override
    public void write(char[] cbuf, int off, int len) {
        if (this.checkLength()) {
            return;
        }
        this._buffer.append(cbuf, off, len);
    }

    @Override
    public void write(int c) {
        if (this.checkLength()) {
            return;
        }
        this._buffer.append((char)c);
    }

    @Override
    public void write(String str) {
        if (this.checkLength()) {
            return;
        }
        this._buffer.append(str, 0, str.length());
    }

    @Override
    public void write(String str, int off, int len) {
        if (this.checkLength()) {
            return;
        }
        this._buffer.append(str, off, len);
    }

    private boolean checkLength() {
        return this._buffer.size() > this._maxLenth;
    }

    public String getAndClear() {
        String result = this._buffer.contentsAsString();
        this._buffer.releaseBuffers();
        return result;
    }
}

