/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.common.utils.MemberF7;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.exception.KDBizException;
import kd.bos.form.FormConfig;
import kd.bos.form.FormMetadataCache;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.query.QFilterUtil;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.epm.eb.common.cache.DimMembPermHelper;
import kd.epm.eb.common.cache.IModelCacheHelper;
import kd.epm.eb.common.cache.ModelCacheContext;
import kd.epm.eb.common.cache.impl.Dimension;
import kd.epm.eb.common.cache.impl.Member;
import kd.epm.eb.common.cache.impl.Model;
import kd.epm.eb.common.cache.impl.View;
import kd.epm.eb.common.entity.memberF7.BaseDataInfo;
import kd.epm.eb.common.entity.memberF7.BaseF7Parameter;
import kd.epm.eb.common.entity.memberF7.LeftTreeF7Parameter;
import kd.epm.eb.common.enums.SysDimensionEnum;
import kd.epm.eb.common.enums.dimensionEnums.MemberSourceEnum;
import kd.epm.eb.common.permission.enums.DimMembPermType;
import kd.epm.eb.common.utils.IDUtils;
import kd.epm.eb.common.utils.QFBuilder;

public class MemberF7ServiceHelper {
    private boolean isGetLookUpList = false;

    public static MemberF7ServiceHelper getInstance() {
        return new MemberF7ServiceHelper();
    }

    public void setGetLookUpList(String sourceMethod) {
        this.isGetLookUpList = "getLookUpList".equals(sourceMethod);
    }

    public void setListShowParameterByF7(ListShowParameter showParameter, BaseDataInfo baseInfo, BaseF7Parameter f7Parameter, boolean changeQFilter) {
        this.setBaseDataQfilters(showParameter, baseInfo, f7Parameter, changeQFilter);
        this.handleAccountDataSet(showParameter, baseInfo, f7Parameter);
        String formId = "epm_lefttreerightlistf7";
        if (f7Parameter instanceof LeftTreeF7Parameter) {
            formId = "epm_lefttreerightlistf7";
            showParameter.setBillFormId(baseInfo.getMemberKey());
        }
        showParameter.setFormId(formId);
        showParameter.setCustomParam("baseDataInfo", (Object)SerializationUtils.serializeToBase64((Object)baseInfo));
        showParameter.setCustomParam("f7Parameter", (Object)SerializationUtils.serializeToBase64((Object)f7Parameter));
        showParameter.setCaption(ResManager.loadResFormat((String)"%1\u6210\u5458\u5217\u8868", (String)"MemberF7ServiceHelper_0", (String)"epm-eb-common", (Object[])new Object[]{baseInfo.getDimName()}));
    }

    public BaseDataInfo getBaseDataInfoByBusModel(long busModelId, String dimNum, BaseF7Parameter f7Parameter) {
        BaseDataInfo baseDataInfo = new BaseDataInfo();
        baseDataInfo.setBusModelId(busModelId);
        DynamicObject object = BusinessDataServiceHelper.loadSingleFromCache((String)"eb_businessmodel", (String)"model,viewentry.dimension,viewentry.view", (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)busModelId)});
        if (object != null) {
            long viewId;
            baseDataInfo.setModelId(object.getLong("model.id"));
            DynamicObjectCollection entryentity = object.getDynamicObjectCollection("viewentry");
            List collect = entryentity.stream().filter(e -> dimNum != null && dimNum.equals(e.getString("dimension.number"))).collect(Collectors.toList());
            if (collect.size() == 0) {
                throw new KDBizException(ResManager.loadKDString((String)"\u5728\u6240\u9009\u4e1a\u52a1\u6a21\u578b\u4e2d\uff0c\u672a\u627e\u5230\u76f8\u5e94\u7684\u7ef4\u5ea6\u3002", (String)"MemberF7ServiceHelper_1", (String)"epm-eb-common", (Object[])new Object[0]));
            }
            DynamicObject dynamicObject = (DynamicObject)collect.get(0);
            DynamicObject dimension = dynamicObject.getDynamicObject("dimension");
            String dimNumber = dimension.getString("number");
            baseDataInfo.setDimId(dimension.getLong("id"));
            baseDataInfo.setDimName(dimension.getString("name"));
            baseDataInfo.setDimNumber(dimNumber);
            DynamicObject view = dynamicObject.getDynamicObject("view");
            long l = viewId = f7Parameter.getViewId() == null ? 0L : f7Parameter.getViewId();
            if (viewId != 0L && (view = BusinessDataServiceHelper.loadSingleFromCache((Object)viewId, (String)"eb_dimensionview")) == null) {
                throw new KDBizException(ResManager.loadResFormat((String)"\u672a\u627e\u5230\u4f20\u9012\u7684\u89c6\u56fe\uff0cID\u4e3a\u201c%1\u201d\u3002", (String)"MemberF7ServiceHelper_2", (String)"epm-eb-common", (Object[])new Object[]{viewId}));
            }
            if (view != null) {
                viewId = view.getLong("id");
                baseDataInfo.setViewId(viewId);
                baseDataInfo.setMemberKey("eb_viewmember");
            } else {
                baseDataInfo.setMemberKey(dimension.getString("membermodel"));
            }
        } else {
            throw new KDBizException(ResManager.loadKDString((String)"\u672a\u627e\u5230\u6240\u9009\u62e9\u7684\u6570\u636e\u96c6\u3002", (String)"MemberF7ServiceHelper_3", (String)"epm-eb-common", (Object[])new Object[0]));
        }
        return baseDataInfo;
    }

    public void setBaseDataQfilters(ListShowParameter showParameter, BaseDataInfo info, BaseF7Parameter f7Parameter, boolean changeQFilter) {
        List qFilters = showParameter.getListFilterParameter().getQFilters();
        if (f7Parameter.isKeepTree()) {
            qFilters.clear();
            f7Parameter.getqFilters().clear();
            qFilters.add(new QFilter("status", "=", (Object)"C"));
            qFilters.add(new QFilter("enable", "=", (Object)"1"));
            if (this.isGetLookUpList()) {
                if (changeQFilter) {
                    qFilters.removeIf(q -> "enable".equalsIgnoreCase(q.getProperty()));
                    qFilters.add(new QFilter("enable", "=", (Object)"1").or("number", "=", (Object)"BudgetOccupation"));
                }
                if (f7Parameter.isOnlyLeaf()) {
                    qFilters.add(new QFilter("isleaf", "=", (Object)"1"));
                } else if (f7Parameter.isNotLeaf()) {
                    qFilters.add(new QFilter("isleaf", "=", (Object)"0"));
                } else if (f7Parameter.getOptionalNumber() != null) {
                    qFilters.add(new QFilter("number", "in", f7Parameter.getOptionalNumber()));
                }
            }
        } else if (f7Parameter.isOpenByButto()) {
            qFilters.clear();
            if (changeQFilter) {
                qFilters.add(new QFilter("enable", "=", (Object)"1").or("number", "=", (Object)"BudgetOccupation"));
            } else {
                qFilters.add(new QFilter("enable", "=", (Object)"1"));
            }
            qFilters.add(new QFilter("status", "=", (Object)"C"));
            qFilters.addAll(f7Parameter.getqFilters());
        }
        if (IDUtils.isNull(info.getViewId())) {
            qFilters.add(new QFilter("membersource", "!=", (Object)MemberSourceEnum.ANALYZE_VIEW.getIndex()));
        }
        if (SysDimensionEnum.AuditTrail.getNumber().equals(info.getDimNumber()) && !f7Parameter.isQueryDecompose()) {
            qFilters.add(new QFilter("use", "!=", (Object)"40"));
        }
        qFilters.add(new QFilter("model", "=", (Object)info.getModelId()));
        qFilters.add(new QFilter("dimension", "=", (Object)info.getDimId()));
        if (f7Parameter.isCheckPerm()) {
            Set<Long> readPermMembIds = DimMembPermHelper.getPermMembIds(info.getDimNumber(), info.getModelId(), (Long)info.getBusModelId(), (Long)info.getViewId(), DimMembPermType.READ, true);
            if (readPermMembIds == null) {
                return;
            }
            IModelCacheHelper orCreate = ModelCacheContext.getOrCreate(info.getModelId());
            Dimension dimension = orCreate.getDimension(info.getDimId());
            View view = dimension.getView(f7Parameter.getViewId());
            List<Member> members = view != null ? view.getMemberByIds(readPermMembIds) : dimension.getMemberByIds(readPermMembIds);
            Set<Object> numbers = members == null ? new HashSet(16) : members.stream().map(m -> m.getNumber()).collect(Collectors.toSet());
            ModelCacheContext.remove();
            Set<String> numbersQfilter = this.getNumbersQfilter(qFilters);
            if (!numbersQfilter.isEmpty()) {
                numbers.retainAll(numbersQfilter);
            }
            qFilters.add(new QFilter("number", "in", numbers));
        }
    }

    public void handleAccountDataSet(ListShowParameter showParameter, BaseDataInfo baseDataInfo, BaseF7Parameter f7Parameter) {
        IModelCacheHelper modelCache = ModelCacheContext.getOrCreate(baseDataInfo.getModelId());
        Model model = modelCache.getModelobj();
        if (model.isModelByEB()) {
            return;
        }
        if ("Account".equals(baseDataInfo.getDimNumber())) {
            List<Long> dataSetIds = f7Parameter.getDataSetIds();
            if (dataSetIds.size() == 0) {
                ArrayList<QFilter> qFilters = new ArrayList<QFilter>(4);
                qFilters.add(new QFilter("model", "=", (Object)baseDataInfo.getModelId()));
                if (baseDataInfo.isExistBusModel()) {
                    qFilters.add(new QFilter("businessmodel", "=", (Object)baseDataInfo.getBusModelId()));
                }
                Map query = BusinessDataServiceHelper.loadFromCache((String)"eb_dataset", (String)"id,number", (QFilter[])qFilters.toArray(new QFilter[0]));
                dataSetIds.addAll(query.values().stream().filter(dynamicObject -> "default".equalsIgnoreCase(dynamicObject.getString("number"))).map(dynamicObject -> dynamicObject.getLong("id")).collect(Collectors.toSet()));
                dataSetIds.addAll(query.values().stream().filter(dynamicObject -> !"default".equalsIgnoreCase(dynamicObject.getString("number"))).map(dynamicObject -> dynamicObject.getLong("id")).collect(Collectors.toSet()));
            }
            if (this.isGetLookUpList()) {
                showParameter.getListFilterParameter().getQFilters().add(new QFilter("dataset", "in", dataSetIds));
            }
        }
    }

    public void setPlugin(BaseDataInfo baseInfo, ListShowParameter showParameter) {
        IModelCacheHelper modelCache = ModelCacheContext.getOrCreate(baseInfo.getModelId());
        Model model = modelCache.getModelobj();
        if (model.isModelByEB()) {
            return;
        }
        FormConfig formConfig = FormMetadataCache.getFormConfig((String)"epm_lefttreerightlistf7");
        if ("Account".equals(baseInfo.getDimNumber())) {
            formConfig.getPlugins().clear();
            showParameter.setFormConfig(formConfig);
            showParameter.addCustPlugin("kd.epm.eb.formplugin.memberf7.memberF7New.dimensionCata.LeftTreeF7OfAccount");
        }
    }

    public void setDisplayForTextButton(ListShowParameter showParameter, List<Object> echoIds, BaseDataInfo baseInfo) {
        this.setListSelectedRowCollection(echoIds, showParameter, baseInfo);
    }

    private void setListSelectedRowCollection(Object value, ListShowParameter showParameter, BaseDataInfo baseInfo) {
        List<Object> viewMemberids = this.getViewMemberids(value, baseInfo);
        ListSelectedRowCollection listSelectedRowCollection = showParameter.getListSelectedRowCollection();
        if (listSelectedRowCollection.size() > 0) {
            viewMemberids.addAll(this.getViewMemberids(listSelectedRowCollection, baseInfo));
        }
        listSelectedRowCollection.clear();
        if (viewMemberids.size() == 0) {
            return;
        }
        if (!showParameter.isMultiSelect()) {
            listSelectedRowCollection.add((Object)new ListSelectedRow(viewMemberids.get(0)));
        } else {
            for (Object memberid : viewMemberids) {
                listSelectedRowCollection.add((Object)new ListSelectedRow(memberid));
            }
        }
    }

    private List<Object> getViewMemberids(Object value, BaseDataInfo baseInfo) {
        ArrayList<Object> ids = new ArrayList<Object>(10);
        if (value == null) {
            return ids;
        }
        if (value instanceof DynamicObject) {
            ids.add(((DynamicObject)value).get("id"));
        } else if (value instanceof DynamicObjectCollection) {
            for (DynamicObject object : (DynamicObjectCollection)value) {
                ids.add(object.get("fbasedataid_id"));
            }
        } else if (value instanceof ListSelectedRowCollection) {
            for (ListSelectedRow listSelectedRow : (ListSelectedRowCollection)value) {
                ids.add(listSelectedRow.getPrimaryKeyValue());
            }
        } else if (value instanceof List) {
            ids.addAll((List)value);
        }
        if (ids.isEmpty()) {
            return ids;
        }
        if (IDUtils.isNull(baseInfo.getViewId())) {
            return ids;
        }
        QFBuilder qf = new QFBuilder("model", "=", baseInfo.getModelId());
        qf.add("dimension", "=", baseInfo.getDimId());
        qf.add("view", "=", baseInfo.getViewId());
        qf.add("memberid", "in", ids);
        Map map = BusinessDataServiceHelper.loadFromCache((String)"eb_viewmember", (String)"id", (QFilter[])qf.toArray());
        return new ArrayList<Object>(map.keySet());
    }

    public boolean isGetLookUpList() {
        return this.isGetLookUpList;
    }

    private Set<String> getNumbersQfilter(List<QFilter> qFilters) {
        HashSet<String> numbers = new HashSet<String>(16);
        qFilters.removeIf(q -> {
            Object[] ob;
            List nests;
            if ("number".equals(q.getProperty()) && "in".equals(q.getCP()) && ((nests = q.getNests(false)) == null || nests.size() == 0) && (ob = QFilterUtil.getWithoutDuplicateInValues((Object)q.getValue())) != null && ob.length > 0) {
                for (Object o : ob) {
                    numbers.add(o.toString());
                }
                return true;
            }
            return false;
        });
        return numbers;
    }
}

