/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.common.utils;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.exception.KDBizException;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.TimeServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.epm.eb.common.cache.IModelCacheHelper;
import kd.epm.eb.common.cache.ModelCacheContext;
import kd.epm.eb.common.cache.impl.Dataset;
import kd.epm.eb.common.cache.impl.Dimension;
import kd.epm.eb.common.cache.impl.Model;
import kd.epm.eb.common.cache.propertycache.MemberPropCacheService;
import kd.epm.eb.common.enums.AggOprtEnum;
import kd.epm.eb.common.enums.DataTypeEnum;
import kd.epm.eb.common.enums.StorageTypeEnum;
import kd.epm.eb.common.enums.SysDimensionEnum;
import kd.epm.eb.common.enums.dimensionEnums.MemberSourceEnum;
import kd.epm.eb.common.enums.dimensionEnums.MetricDataTypeEnum;
import kd.epm.eb.common.eventbus.event.VirtualMemberAddEvent;
import kd.epm.eb.common.model.BizModel;
import kd.epm.eb.common.model.Member;
import kd.epm.eb.common.mq.publisher.VirtualMemberAddPublisher;
import kd.epm.eb.common.shrek.service.ShrekConfigServiceHelper;
import kd.epm.eb.common.shrek.service.ShrekCubeServiceHelper;
import kd.epm.eb.common.utils.BgDimensionServiceHelper;
import kd.epm.eb.common.utils.CollectionUtils;
import kd.epm.eb.common.utils.CommonServiceHelper;
import kd.epm.eb.common.utils.CubeUtils;
import kd.epm.eb.common.utils.DatasetServiceHelper;
import kd.epm.eb.common.utils.GlobalIdUtil;
import kd.epm.eb.common.utils.IDUtils;
import kd.epm.eb.common.utils.MetaUtils;
import kd.epm.eb.common.utils.QFBuilder;
import kd.epm.eb.common.utils.StringUtils;
import kd.epm.eb.common.utils.UserUtils;
import org.jetbrains.annotations.NotNull;

public class MemberServiceHelper {
    public static final String FIELDS = "id, name, number, longnumber, parent, isleaf, dimension.id";
    private static final String SELECT_FIELDS = "id,number,longnumber,isinnerorg";
    private static final String LONG_NUMBER_FIELD = "longnumber";
    private static final String IS_INNER_ORG_FIELD = "isinnerorg";
    private static final String LIKE_SUFFIX = "!%";
    private static final int DEFAULT_LONG_NUMBER_SIZE = 10;
    private static final Set<String> ENTITY_MODEL = new HashSet<String>(){
        {
            this.add("epm_entitymembertree");
            this.add("eb_viewmember");
        }
    };

    public static DynamicObject[] queryAllChildrenByLongNumber(Long modelId, Long dimensionId, List<String> longNumbers, String fields, String memberModel) {
        if (IDUtils.isNull(modelId) || IDUtils.isNull(dimensionId) || CollectionUtils.isEmpty(longNumbers)) {
            return new DynamicObject[0];
        }
        LinkedList objects = Lists.newLinkedList();
        List batchObject = Lists.partition(longNumbers, (int)2000);
        QFBuilder builder = new QFBuilder();
        for (List entry : batchObject) {
            builder.clear();
            builder.add("model", "=", modelId);
            builder.add("dimension", "=", dimensionId);
            QFilter filter = null;
            for (String _longNumber : entry) {
                if (filter == null) {
                    filter = new QFilter(LONG_NUMBER_FIELD, "like", (Object)(_longNumber + '!' + '%'));
                    continue;
                }
                filter.or(LONG_NUMBER_FIELD, "like", (Object)(_longNumber + '!' + '%'));
            }
            builder.add(filter);
            objects.addAll(Arrays.asList(BusinessDataServiceHelper.load((String)memberModel, (String)fields, (QFilter[])builder.toArrays())));
        }
        return objects.toArray(new DynamicObject[0]);
    }

    public static DynamicObject[] queryViewAllChildrenByLongNumber(Long modelId, Long dimensionId, Long viewId, List<String> longNumbers, String fields) {
        if (IDUtils.isNull(modelId) || IDUtils.isNull(dimensionId) || IDUtils.isNull(viewId) || CollectionUtils.isEmpty(longNumbers)) {
            return new DynamicObject[0];
        }
        LinkedList objects = Lists.newLinkedList();
        List batchObject = Lists.partition(longNumbers, (int)2000);
        QFBuilder builder = new QFBuilder();
        for (List entry : batchObject) {
            builder.clear();
            builder.add("model", "=", modelId);
            builder.add("dimension", "=", dimensionId);
            builder.add("view", "=", viewId);
            QFilter filter = null;
            for (String _longNumber : entry) {
                if (filter == null) {
                    filter = new QFilter(LONG_NUMBER_FIELD, "like", (Object)(_longNumber + '!' + '%'));
                    continue;
                }
                filter.or(LONG_NUMBER_FIELD, "like", (Object)(_longNumber + '!' + '%'));
            }
            builder.add(filter);
            objects.addAll(Arrays.asList(BusinessDataServiceHelper.load((String)"eb_viewmember", (String)fields, (QFilter[])builder.toArrays())));
        }
        return objects.toArray(new DynamicObject[0]);
    }

    public static Collection<Map<String, Object>> queryAllChildSet(Long modelId, String dimensionNumber, Long parentId, String fields, String orderBys) {
        List<Map<String, Object>> datas;
        block29: {
            datas = new ArrayList<Map<String, Object>>();
            if (modelId == null || modelId == 0L || StringUtils.isEmpty(dimensionNumber)) {
                return datas;
            }
            kd.epm.eb.common.model.Dimension dimesnion = null;
            Map<String, Object> object = BgDimensionServiceHelper.queryDimension(modelId, dimensionNumber);
            if (object != null) {
                dimesnion = kd.epm.eb.common.model.Dimension.loadFromMap(object);
            }
            if (dimesnion == null || dimesnion.getId() == 0L) {
                return datas;
            }
            QFBuilder builder = new QFBuilder();
            builder.add(new QFilter("model", "=", (Object)modelId));
            builder.add(new QFilter("dimension", "=", (Object)dimesnion.getId()));
            builder.add(new QFilter("id", "=", (Object)parentId));
            String longNumber = null;
            try (DataSet ds = QueryServiceHelper.queryDataSet((String)"memberQueryDataSet", (String)dimesnion.getMemberModel(), (String)LONG_NUMBER_FIELD, (QFilter[])builder.toArrays(), null, (int)1);){
                if (ds != null && ds.hasNext()) {
                    Row row = ds.next();
                    longNumber = row.getString(LONG_NUMBER_FIELD);
                }
                if (!StringUtils.isNotEmpty(longNumber)) break block29;
                builder.clear();
                builder.add(new QFilter("model", "=", (Object)modelId));
                builder.add(new QFilter(LONG_NUMBER_FIELD, "=", (Object)longNumber).or(new QFilter(LONG_NUMBER_FIELD, "like", (Object)(longNumber + LIKE_SUFFIX))));
                try (DataSet dss = QueryServiceHelper.queryDataSet((String)"memberQueryDataSet", (String)dimesnion.getMemberModel(), (String)(StringUtils.isNotEmpty(fields) ? fields : FIELDS), (QFilter[])builder.toArrays(), (String)orderBys);){
                    if (dss != null) {
                        datas = CommonServiceHelper.transDataSet(dss);
                    }
                }
            }
        }
        return datas;
    }

    public static Map<String, Map<String, Member>> queryMemberByNumber(Long modelId, Map<String, kd.epm.eb.common.model.Dimension> dimensionMap, Map<String, Long> views, Map<String, Set<String>> numberMap) {
        if (modelId == null || dimensionMap == null || dimensionMap.isEmpty() || numberMap == null || numberMap.isEmpty()) {
            return Collections.emptyMap();
        }
        return null;
    }

    public static Map<String, Map<String, kd.epm.eb.common.cache.impl.Member>> queryByNumber(BizModel bizModel, Map<String, kd.epm.eb.common.model.Dimension> dimensionMap, Map<String, Set<String>> numberMap) {
        Long modelId = bizModel.getId();
        Map<String, Long> views = bizModel.getView();
        Long businessModel = bizModel.getControlBusModelId();
        if (modelId == null || dimensionMap == null || dimensionMap.isEmpty() || numberMap == null || numberMap.isEmpty()) {
            return Collections.emptyMap();
        }
        HashMap members = Maps.newHashMapWithExpectedSize((int)numberMap.size());
        IModelCacheHelper modelCache = ModelCacheContext.getOrCreate(modelId);
        Map<String, List<Long>> viewGroupViewsByBusModel = modelCache.getViewGroupViewsByBusModel(businessModel);
        for (Map.Entry<String, Set<String>> entry : numberMap.entrySet()) {
            kd.epm.eb.common.model.Dimension dimension = dimensionMap.get(entry.getKey());
            Long defaultViewId = modelCache.getViewByBusModelAndDimNumber(businessModel, dimension.getNumber());
            List<Long> viewIds = viewGroupViewsByBusModel.get(dimension.getNumber());
            if (viewIds != null) {
                for (Long viewId : viewIds) {
                    List<kd.epm.eb.common.cache.impl.Member> memberSet = modelCache.getMembers(entry.getKey(), viewId, (Collection<String>)entry.getValue());
                    if (memberSet == null || memberSet.isEmpty()) continue;
                    Map membersMap = members.getOrDefault(entry.getKey(), new HashMap());
                    for (kd.epm.eb.common.cache.impl.Member member : memberSet) {
                        if (!membersMap.containsKey(member.getNumber())) {
                            if (defaultViewId != null && defaultViewId != 0L && !defaultViewId.equals(viewId)) {
                                member.setLongNumber(member.getNumber());
                            }
                            membersMap.put(member.getNumber(), member);
                            continue;
                        }
                        if (defaultViewId == null || !defaultViewId.equals(viewId)) continue;
                        membersMap.put(member.getNumber(), member);
                    }
                    members.put(entry.getKey(), membersMap);
                }
                continue;
            }
            List<kd.epm.eb.common.cache.impl.Member> memberSet = modelCache.getMembers(entry.getKey(), null, (Collection<String>)entry.getValue());
            Map<String, kd.epm.eb.common.cache.impl.Member> memberMaps = memberSet.stream().collect(Collectors.toMap(k -> k.getNumber(), v -> v));
            members.put(entry.getKey(), memberMaps);
        }
        return members;
    }

    public static Map<String, Map<String, Object>> queryByNums(Long modelId, kd.epm.eb.common.model.Dimension dimension, Long viewId, Set<String> numbers) {
        return MemberServiceHelper.queryByNums(modelId, dimension, viewId, numbers, FIELDS, null);
    }

    public static Map<String, Map<String, Object>> queryByNums(Long modelId, kd.epm.eb.common.model.Dimension dimension, Long viewId, Set<String> numbers, String fields, List<QFilter> filters) {
        if (modelId == null || dimension == null || numbers == null || numbers.isEmpty()) {
            return Collections.emptyMap();
        }
        QFBuilder builder = new QFBuilder();
        builder.add(new QFilter("model", "=", (Object)modelId));
        builder.add(new QFilter("dimension", "=", (Object)dimension.getId()));
        if (viewId != null && viewId != 0L) {
            builder.add(new QFilter("view", "=", (Object)viewId));
        }
        builder.add(new QFilter("number", "in", numbers));
        if (filters != null && !filters.isEmpty()) {
            builder.add(filters);
        }
        String memberModel = dimension.getMemberModel();
        if (viewId != null && viewId != 0L) {
            memberModel = "eb_viewmember";
            fields = "id, name, number, longnumber, parent, isleaf, dimension.id, memberid";
        }
        HashMap members = Maps.newHashMapWithExpectedSize((int)numbers.size());
        try (DataSet ds = QueryServiceHelper.queryDataSet((String)"queryMemberByNumber", (String)memberModel, (String)fields, (QFilter[])builder.toArrays(), null);){
            if (ds != null) {
                List<Map<String, Object>> _members = CommonServiceHelper.transDataSet(ds);
                if (viewId != null && viewId != 0L) {
                    for (Map map : _members) {
                        Object _memberId = map.get("memberid");
                        if (_memberId instanceof String) {
                            map.put("id", Long.valueOf((String)_memberId));
                            continue;
                        }
                        map.put("id", _memberId);
                    }
                }
                for (Map map : _members) {
                    members.put((String)map.get("number"), map);
                }
            }
        }
        IModelCacheHelper modelCacheHelper = ModelCacheContext.getOrCreate(modelId);
        kd.epm.eb.common.cache.impl.Member rootMember = modelCacheHelper.getRootMember(dimension.getNumber(), viewId);
        if (!members.containsKey(rootMember.getNumber())) {
            HashMap<String, Object> mem = new HashMap<String, Object>();
            mem.put("id", String.valueOf(rootMember.getId()));
            mem.put("name", rootMember.getName());
            mem.put("number", rootMember.getNumber());
            mem.put(LONG_NUMBER_FIELD, rootMember.getLongNumber());
            mem.put("parent", rootMember.getParentId());
            mem.put("isleaf", rootMember.isLeaf());
            members.put(rootMember.getNumber(), mem);
        }
        return members;
    }

    public static Map<String, Map<Object, DynamicObject>> queryByIds(Map<String, kd.epm.eb.common.model.Dimension> dimensionMap, Map<String, Set<Long>> memberIdsMap) {
        if (dimensionMap == null || dimensionMap.isEmpty() || memberIdsMap == null || memberIdsMap.isEmpty()) {
            return new HashMap<String, Map<Object, DynamicObject>>();
        }
        Map.Entry<String, Set<Long>> entry2 = null;
        Map<Object, DynamicObject> memberMap = null;
        kd.epm.eb.common.model.Dimension dimension = null;
        HashMap members = Maps.newHashMapWithExpectedSize((int)memberIdsMap.size());
        for (Map.Entry<String, Set<Long>> entry2 : memberIdsMap.entrySet()) {
            dimension = dimensionMap.get(entry2.getKey());
            if (dimension == null) {
                throw new KDBizException("query member error(dimension is null). dimension number = " + entry2.getKey());
            }
            memberMap = MemberServiceHelper.queryByIds(dimension, entry2.getValue());
            if (memberMap == null) continue;
            members.put(entry2.getKey(), memberMap);
        }
        return members;
    }

    public static Map<Object, DynamicObject> queryByIds(kd.epm.eb.common.model.Dimension dimension, Set<Long> ids) {
        if (dimension == null || ids == null || ids.isEmpty()) {
            return null;
        }
        QFBuilder builder = new QFBuilder();
        builder.add(new QFilter("id", "in", ids));
        return BusinessDataServiceHelper.loadFromCache((String)dimension.getMemberModel(), (QFilter[])builder.toArrays());
    }

    public static Map<Object, DynamicObject> queryByIds(String dimensionNumber, Set<Long> ids) {
        if (StringUtils.isEmpty(dimensionNumber) || ids == null || ids.isEmpty()) {
            return null;
        }
        QFBuilder builder = new QFBuilder();
        builder.add(new QFilter("id", "in", ids));
        return BusinessDataServiceHelper.loadFromCache((String)SysDimensionEnum.getMemberTreemodelByNumber(dimensionNumber), (QFilter[])builder.toArrays());
    }

    public static Map<String, Map<String, Member>> queryUserDefinedSysMember(BizModel bizModel) {
        HashMap<String, Map<String, Member>> userMembers = new HashMap<String, Map<String, Member>>();
        if (bizModel == null) {
            return userMembers;
        }
        String userDefined = null;
        QFBuilder builder = new QFBuilder();
        builder.add(new QFilter("model", "=", (Object)bizModel.getId()));
        userDefined = "epm_userdefinedmembertree";
        builder.add(new QFilter("membersource", "=", (Object)Character.valueOf('1')));
        Map members = BusinessDataServiceHelper.loadFromCache((String)userDefined, (String)FIELDS, (QFilter[])builder.toArrays());
        if (members != null && !members.isEmpty()) {
            Member member = null;
            Map<String, Member> memberMap = null;
            for (DynamicObject object : members.values()) {
                member = Member.loadFromDynamicObject(object);
                if (userMembers.containsKey(member.getDimension().getNumber())) {
                    memberMap = (Map)userMembers.get(member.getDimension().getNumber());
                } else {
                    memberMap = new HashMap();
                    userMembers.put(member.getDimension().getNumber(), memberMap);
                }
                memberMap.put(member.getNumber(), member);
            }
        }
        return userMembers;
    }

    public static List<Map<String, Object>> queryNoneMember(Long cubeId) {
        List<Map<String, Object>> _members;
        LinkedList<Map<String, Object>> members = new LinkedList<Map<String, Object>>();
        QFBuilder builder = new QFBuilder();
        builder.add(new QFilter("model", "=", (Object)cubeId));
        builder.add(new QFilter("membersource", "=", (Object)"1"));
        builder.add(new QFilter("isleaf", "=", (Object)"1"));
        try (DataSet ds = QueryServiceHelper.queryDataSet((String)"queryNoneMember", (String)"epm_userdefinedmembertree", (String)"id, number, dimension.number", (QFilter[])builder.toArrays(), null);){
            _members = CommonServiceHelper.transDataSet(ds);
            if (_members != null && !_members.isEmpty()) {
                members.addAll(_members);
            }
        }
        builder.clear();
        builder.add(new QFilter("model", "=", (Object)cubeId));
        builder.add(new QFilter("number", "=", (Object)"VNone"));
        ds = QueryServiceHelper.queryDataSet((String)"queryNoneMember", (String)SysDimensionEnum.Version.getMemberTreemodel(), (String)"id, number, dimension.number", (QFilter[])builder.toArrays(), null);
        var4_4 = null;
        try {
            _members = CommonServiceHelper.transDataSet(ds);
            if (_members != null && !_members.isEmpty()) {
                members.addAll(_members);
            }
        }
        catch (Throwable _members2) {
            var4_4 = _members2;
            throw _members2;
        }
        finally {
            if (ds != null) {
                if (var4_4 != null) {
                    try {
                        ds.close();
                    }
                    catch (Throwable _members2) {
                        var4_4.addSuppressed(_members2);
                    }
                } else {
                    ds.close();
                }
            }
        }
        builder.clear();
        builder.add(new QFilter("model", "=", (Object)cubeId));
        builder.add(new QFilter("number", "=", (Object)"CNone"));
        ds = QueryServiceHelper.queryDataSet((String)"queryNoneMember", (String)SysDimensionEnum.Currency.getMemberTreemodel(), (String)"id, number, dimension.number", (QFilter[])builder.toArrays(), null);
        var4_4 = null;
        try {
            _members = CommonServiceHelper.transDataSet(ds);
            if (_members != null && !_members.isEmpty()) {
                members.addAll(_members);
            }
        }
        catch (Throwable _members3) {
            var4_4 = _members3;
            throw _members3;
        }
        finally {
            if (ds != null) {
                if (var4_4 != null) {
                    try {
                        ds.close();
                    }
                    catch (Throwable _members3) {
                        var4_4.addSuppressed(_members3);
                    }
                } else {
                    ds.close();
                }
            }
        }
        builder.clear();
        builder.add(new QFilter("model", "=", (Object)cubeId));
        builder.add(new QFilter("number", "=", (Object)"ICNone"));
        ds = QueryServiceHelper.queryDataSet((String)"queryNoneMember", (String)SysDimensionEnum.InternalCompany.getMemberTreemodel(), (String)"id, number, dimension.number", (QFilter[])builder.toArrays(), null);
        var4_4 = null;
        try {
            _members = CommonServiceHelper.transDataSet(ds);
            if (_members != null && !_members.isEmpty()) {
                members.addAll(_members);
            }
        }
        catch (Throwable throwable) {
            var4_4 = throwable;
            throw throwable;
        }
        finally {
            if (ds != null) {
                if (var4_4 != null) {
                    try {
                        ds.close();
                    }
                    catch (Throwable throwable) {
                        var4_4.addSuppressed(throwable);
                    }
                } else {
                    ds.close();
                }
            }
        }
        return members;
    }

    public static Map<String, Long> queryNoneMemberIds(Long cubeId) {
        HashMap<String, Long> memberMap = new HashMap<String, Long>();
        if (cubeId == null || cubeId == 0L) {
            return memberMap;
        }
        List<Map<String, Object>> members = MemberServiceHelper.queryNoneMember(cubeId);
        if (members != null) {
            for (Map<String, Object> member : members) {
                memberMap.put((String)member.get("dimension.number"), (Long)member.get("id"));
            }
        }
        return Collections.unmodifiableMap(memberMap);
    }

    public static Map<String, Set<String>> getDefaultMember() {
        HashMap<String, Set<String>> memberMap = new HashMap<String, Set<String>>();
        return memberMap;
    }

    public static Set<String> getAggregateMember(Long modelId) {
        HashSet<String> memberSet = new HashSet<String>();
        if (modelId == null || modelId == 0L) {
            return memberSet;
        }
        QFBuilder builder = new QFBuilder();
        builder.add(new QFilter("model", "=", (Object)modelId));
        builder.add(new QFilter("isagg", "=", (Object)"1"));
        try (DataSet ds = QueryServiceHelper.queryDataSet((String)"queryMetricAggMember", (String)SysDimensionEnum.Metric.getMemberTreemodel(), (String)"id, number,isagg", (QFilter[])builder.toArrays(), null);){
            if (ds != null) {
                Row row = null;
                while (ds.hasNext()) {
                    row = ds.next();
                    memberSet.add(row.getString("number"));
                }
            }
        }
        return memberSet;
    }

    public static Set<String> getNotAggregateMemberByAccount(Long modelId) {
        HashSet<String> memberSet = new HashSet<String>();
        if (modelId == null || modelId == 0L) {
            return memberSet;
        }
        HashSet<String> filter = new HashSet<String>();
        filter.add(MetricDataTypeEnum.TEXT.getIndex());
        filter.add(MetricDataTypeEnum.DATE.getIndex());
        filter.add(MetricDataTypeEnum.RATE.getIndex());
        filter.add(MetricDataTypeEnum.ENUM.getIndex());
        QFBuilder builder = new QFBuilder();
        builder.add(new QFilter("model", "=", (Object)modelId));
        builder.add(new QFilter("datatype", "in", filter));
        try (DataSet ds = QueryServiceHelper.queryDataSet((String)"queryMetricAggMember", (String)SysDimensionEnum.Account.getMemberTreemodel(), (String)"id, number", (QFilter[])builder.toArrays(), null);){
            if (ds != null) {
                Row row = null;
                while (ds.hasNext()) {
                    row = ds.next();
                    memberSet.add(row.getString("number"));
                }
            }
        }
        return memberSet;
    }

    public static Set<String> getAggregateMemberByMetric(Long modelId) {
        HashSet<String> memberSet = new HashSet<String>();
        if (modelId == null || modelId == 0L) {
            return memberSet;
        }
        HashSet<String> filter = new HashSet<String>();
        filter.add(MetricDataTypeEnum.CURRENCY.getIndex());
        filter.add(MetricDataTypeEnum.NONMONETARY.getIndex());
        QFBuilder builder = new QFBuilder();
        builder.add(new QFilter("model", "=", (Object)modelId));
        builder.add(new QFilter("datatype", "in", filter));
        try (DataSet ds = QueryServiceHelper.queryDataSet((String)"queryMetric", (String)SysDimensionEnum.Metric.getMemberTreemodel(), (String)"id, number", (QFilter[])builder.toArrays(), null);){
            if (ds != null) {
                Row row = null;
                while (ds.hasNext()) {
                    row = ds.next();
                    memberSet.add(row.getString("number"));
                }
            }
        }
        return memberSet;
    }

    public static String getMdx(String longNumber) {
        if (longNumber == null) {
            throw new KDBizException(ResManager.loadKDString((String)"\u7ef4\u5ea6\u6210\u5458\u7684\u957f\u7f16\u7801\u4e0d\u5141\u8bb8\u4e3a\u7a7a\u3002", (String)"MemberServiceHelper_0", (String)"epm-eb-common", (Object[])new Object[0]));
        }
        String mdxNumber = null;
        String[] strings = longNumber.split("!");
        if (strings != null) {
            StringBuilder mdx = new StringBuilder();
            int in = strings.length;
            for (int i = 0; i < in; ++i) {
                mdx.append("`").append(strings[i]).append("`").append(".");
            }
            if (mdx.length() > 0) {
                mdx.setLength(mdx.length() - 1);
            }
            mdxNumber = mdx.toString();
        } else {
            mdxNumber = "`" + longNumber + "`";
        }
        return mdxNumber;
    }

    public static Set<String> getNotAggMember(Long cubeId, IModelCacheHelper modelCacheHelper) {
        HashSet<String> notAgg;
        block6: {
            block5: {
                if (cubeId == null || cubeId == 0L) {
                    return null;
                }
                notAgg = new HashSet<String>();
                if (modelCacheHelper == null) break block5;
                List<Dimension> dimensionList = modelCacheHelper.getDimensionList();
                for (Dimension temp : dimensionList) {
                    Dimension dimension = modelCacheHelper.getDimension(temp.getNumber());
                    if (dimension == null) continue;
                    for (kd.epm.eb.common.cache.impl.Member member : dimension.getLeafMembers()) {
                        String hasAgg = member.getPropertyValue("hasAgg");
                        String aggType = member.getPropertyValue("aggType");
                        if (StringUtils.isNotEmpty(hasAgg)) {
                            if (member.hasAgg()) continue;
                            notAgg.add(member.getNumber());
                            continue;
                        }
                        if (!StringUtils.isNotEmpty(aggType) || !aggType.equals("5")) continue;
                        notAgg.add(member.getNumber());
                    }
                }
                break block6;
            }
            QFBuilder builder = new QFBuilder();
            builder.add(new QFilter("model", "=", (Object)cubeId));
            builder.add(new QFilter("isagg", "=", (Object)Character.valueOf('0')));
            Map metrics = BusinessDataServiceHelper.loadFromCache((String)SysDimensionEnum.Metric.getMemberTreemodel(), (String)"number", (QFilter[])builder.toArrays());
            if (metrics == null) break block6;
            for (DynamicObject metric : metrics.values()) {
                notAgg.add(metric.getString("number"));
            }
        }
        return notAgg;
    }

    public static Set<String> getOtherMember(Long cubeId, IModelCacheHelper modelCacheHelper) {
        return MemberServiceHelper.getOtherMember(cubeId, modelCacheHelper, true);
    }

    public static Set<Long> getOtherMemberIds(Long cubeId, IModelCacheHelper modelCacheHelper) {
        return MemberServiceHelper.getOtherMember(cubeId, modelCacheHelper, false);
    }

    private static Set getOtherMember(Long cubeId, IModelCacheHelper modelCacheHelper, boolean isReturnNumber) {
        LinkedHashSet<Object> returnSet;
        block7: {
            HashSet<String> dataType;
            block6: {
                returnSet = new LinkedHashSet<Object>();
                if (cubeId == null || cubeId == 0L) {
                    return returnSet;
                }
                dataType = new HashSet<String>();
                dataType.add(DataTypeEnum.TXT.getOIndex());
                dataType.add(DataTypeEnum.DATETP.getOIndex());
                dataType.add(DataTypeEnum.ENUMTP.getOIndex());
                if (modelCacheHelper == null) break block6;
                Dimension dimension = modelCacheHelper.getDimension(SysDimensionEnum.Metric.getNumber());
                if (dimension == null) break block7;
                for (kd.epm.eb.common.cache.impl.Member member : dimension.getLeafMembers()) {
                    if (!dataType.contains(member.getDatatype())) continue;
                    if (isReturnNumber) {
                        returnSet.add(member.getNumber());
                        continue;
                    }
                    returnSet.add(member.getId());
                }
                break block7;
            }
            QFBuilder builder = new QFBuilder();
            builder.add(new QFilter("model", "=", (Object)cubeId));
            builder.add(new QFilter("datatype", "in", dataType));
            Map metrics = BusinessDataServiceHelper.loadFromCache((String)SysDimensionEnum.Metric.getMemberTreemodel(), (String)"id, number", (QFilter[])builder.toArrays());
            if (metrics != null) {
                for (DynamicObject metric : metrics.values()) {
                    if (isReturnNumber) {
                        returnSet.add(metric.getString("number"));
                        continue;
                    }
                    returnSet.add(metric.getLong("id"));
                }
            }
        }
        return returnSet;
    }

    public static Set<String> longNumberTokenizer(String longNumber) {
        HashSet<String> nodeNumberSet = new HashSet<String>(16);
        String[] split = longNumber.split("!");
        int splitLength = split.length;
        if (splitLength < 3) {
            return nodeNumberSet;
        }
        for (int i = 1; i < splitLength; ++i) {
            if (i == splitLength - 1) continue;
            nodeNumberSet.add(split[i]);
        }
        return nodeNumberSet;
    }

    public static Map<String, Boolean> checkEntityMemberPathInnerOrg(Long modelId, String entityModelNumber, String longNumber) {
        HashSet<String> longNumberSet = new HashSet<String>(16);
        longNumberSet.add(longNumber);
        return MemberServiceHelper.checkEntityMembersPathInnerOrg(modelId, entityModelNumber, longNumberSet);
    }

    public static Map<String, Boolean> checkEntityMembersPathInnerOrg(Long modelId, String entityNumber, Set<String> longNumberSet) {
        boolean bol;
        boolean bl = bol = IDUtils.isNull(modelId) || !ENTITY_MODEL.contains(entityNumber) || longNumberSet.isEmpty();
        if (bol) {
            throw new KDBizException(ResManager.loadKDString((String)"\u53c2\u6570\u9519\u8bef\uff0c\u67e5\u8be2\u5931\u8d25\u3002", (String)"MemberServiceHelper_1", (String)"epm-eb-common", (Object[])new Object[0]));
        }
        QFilter modelFilter = new QFilter("model", "=", (Object)modelId);
        QFilter existsChildFilter = new QFilter(LONG_NUMBER_FIELD, "like", (Object)SysDimensionEnum.Entity.getNumber().concat(LIKE_SUFFIX));
        QFBuilder qfBuilder = new QFBuilder();
        qfBuilder.add(modelFilter).add(existsChildFilter);
        if (!QueryServiceHelper.exists((String)entityNumber, (QFilter[])qfBuilder.toArray())) {
            return new HashMap<String, Boolean>();
        }
        QFilter isLeafFilter = new QFilter("isleaf", "=", (Object)true);
        if (longNumberSet.size() < 10) {
            return MemberServiceHelper.simpleCheckNumber(entityNumber, longNumberSet, modelId, isLeafFilter, qfBuilder);
        }
        qfBuilder.clear();
        qfBuilder.add(modelFilter).add(isLeafFilter);
        DynamicObjectCollection allLeafChildDy = QueryServiceHelper.query((String)entityNumber, (String)"id, longnumber", (QFilter[])qfBuilder.toArray());
        HashSet<String> set = new HashSet<String>();
        for (DynamicObject dy : allLeafChildDy) {
            set.add(dy.getString(LONG_NUMBER_FIELD));
        }
        HashSet<String> childSet = new HashSet<String>(16);
        set.forEach(str -> {
            if (longNumberSet.contains(str)) {
                childSet.add((String)str);
            }
        });
        DynamicObjectCollection childDy = MemberServiceHelper.queryParent(childSet, qfBuilder, modelFilter, entityNumber);
        Map<String, Boolean> map = MemberServiceHelper.checkChildNumber(childDy, childSet);
        longNumberSet.removeAll(childSet);
        if (longNumberSet.isEmpty()) {
            return map;
        }
        DynamicObjectCollection parentDy = MemberServiceHelper.queryParent(longNumberSet, qfBuilder, modelFilter, entityNumber);
        Map<String, Boolean> map1 = MemberServiceHelper.checkParentNumber(entityNumber, parentDy, longNumberSet, modelFilter);
        map1.putAll(map);
        return map1;
    }

    private static Map<String, Boolean> simpleCheckNumber(String entityModelNumber, Set<String> longNumberSet, Long modelId, QFilter isleafFilter, QFBuilder qfBuilder) {
        HashMap<String, Boolean> resultMap = new HashMap<String, Boolean>(16);
        qfBuilder.clear();
        for (String longNumber : longNumberSet) {
            QFilter modelFilter = new QFilter("model", "=", (Object)modelId);
            QFilter longNumberFilter = new QFilter(LONG_NUMBER_FIELD, "=", (Object)longNumber);
            qfBuilder.add(modelFilter).add(longNumberFilter).add(isleafFilter);
            boolean isleafExists = QueryServiceHelper.exists((String)entityModelNumber, (QFilter[])qfBuilder.toArray());
            Set<String> nodeNumberSet = MemberServiceHelper.longNumberTokenizer(longNumber);
            QFilter orFilter = null;
            if (nodeNumberSet.isEmpty()) {
                modelFilter.and(LONG_NUMBER_FIELD, "like", (Object)longNumber.concat(LIKE_SUFFIX));
            } else {
                orFilter = new QFilter("number", "in", nodeNumberSet);
                if (!isleafExists) {
                    orFilter.or(LONG_NUMBER_FIELD, "like", (Object)longNumber.concat(LIKE_SUFFIX));
                }
            }
            if (orFilter != null) {
                modelFilter.and(orFilter);
            }
            modelFilter.and(IS_INNER_ORG_FIELD, "=", (Object)true);
            resultMap.put(longNumber, false);
        }
        return resultMap;
    }

    private static Map<String, Boolean> checkParentNumber(String entityModelNumber, DynamicObjectCollection dys, Set<String> numberSet, QFilter modelQFilter) {
        Map<String, Boolean> parentMap = MemberServiceHelper.checkNumber(dys, numberSet);
        QFilter innerorgFilter = new QFilter(IS_INNER_ORG_FIELD, "=", (Object)true);
        QFBuilder qfBuilder = new QFBuilder();
        for (String childNumber : numberSet) {
            QFilter longNumberFilter = new QFilter(LONG_NUMBER_FIELD, "like", (Object)childNumber.concat(LIKE_SUFFIX));
            qfBuilder.add(modelQFilter).add(longNumberFilter).add(innerorgFilter);
            boolean exists = QueryServiceHelper.exists((String)entityModelNumber, (QFilter[])qfBuilder.toArray());
            parentMap.merge(childNumber, exists, (a, b) -> b != false || a != false);
            qfBuilder.clear();
        }
        return parentMap;
    }

    private static Map<String, Boolean> checkChildNumber(DynamicObjectCollection query, Set<String> childSet) {
        return MemberServiceHelper.checkNumber(query, childSet);
    }

    private static Map<String, Boolean> checkNumber(DynamicObjectCollection dys, Set<String> numberSet) {
        HashMap<String, List> map = new HashMap<String, List>(16);
        if (dys.isEmpty()) {
            return new HashMap<String, Boolean>(8);
        }
        for (String childNumber : numberSet) {
            HashSet<String> tempSet = new HashSet<String>(16);
            String[] split = childNumber.split("!");
            int splitLength = split.length;
            if (splitLength < 3) continue;
            for (int i = 1; i < splitLength; ++i) {
                if (i == splitLength - 1) continue;
                tempSet.add(split[i]);
            }
            List orDefault = map.getOrDefault(childNumber, new ArrayList());
            List number = dys.stream().filter(dy -> tempSet.contains(dy.getString("number"))).collect(Collectors.toList());
            if (orDefault.isEmpty()) {
                orDefault.add(number.get(0));
                map.put(childNumber, orDefault);
                continue;
            }
            ((List)map.get(childNumber)).add(number.get(0));
        }
        HashMap<String, Boolean> numberMap = new HashMap<String, Boolean>(numberSet.size());
        Set entries = map.entrySet();
        for (Map.Entry entity : entries) {
            List value = (List)entity.getValue();
            long isinnerorg = value.stream().filter(dy -> dy.getBoolean(IS_INNER_ORG_FIELD)).count();
            numberMap.put((String)entity.getKey(), isinnerorg > 0L);
        }
        return numberMap;
    }

    private static Set<String> getParentNumberFromLongNumber(Set<String> longNumbers) {
        HashSet<String> numberSet = new HashSet<String>(16);
        for (String number : longNumbers) {
            String[] split = number.split("!");
            int splitLength = split.length;
            if (splitLength < 3) continue;
            for (int i = 1; i < splitLength; ++i) {
                if (i == splitLength - 1) continue;
                numberSet.add(split[i]);
            }
        }
        return numberSet;
    }

    public static DynamicObject getInnOrOutOrg(@NotNull Long modelId, boolean isInner) {
        QFBuilder builder = new QFBuilder();
        builder.add("model", "=", modelId);
        builder.add("number", "=", isInner ? "ICEntity" : "ICOEntity");
        return QueryServiceHelper.queryOne((String)"epm_icmembertree", (String)"id,longnumber,isleaf,dimension,model", (QFilter[])builder.toArrays());
    }

    public static Map<String, DynamicObject> getInnAndOutOrg(@NotNull Long modelId) {
        HashSet<String> numbers = new HashSet<String>();
        numbers.add("ICEntity");
        numbers.add("ICOEntity");
        QFBuilder builder = new QFBuilder();
        builder.add("model", "=", modelId);
        builder.add("number", "in", numbers);
        DynamicObjectCollection objs = QueryServiceHelper.query((String)"epm_icmembertree", (String)"id,number,longnumber,isleaf,dimension,model", (QFilter[])builder.toArrays());
        return objs.stream().collect(Collectors.toMap(obj -> obj.getString("number"), obj -> obj));
    }

    private static DynamicObjectCollection queryParent(Set<String> longNumberSet, QFBuilder qfBuilder, QFilter modelFilter, String entityModelNumber) {
        Set<String> tokenizer = MemberServiceHelper.getParentNumberFromLongNumber(longNumberSet);
        qfBuilder.clear();
        QFilter numberFilter = new QFilter("number", "in", tokenizer);
        qfBuilder.add(modelFilter).add(numberFilter);
        return QueryServiceHelper.query((String)entityModelNumber, (String)SELECT_FIELDS, (QFilter[])qfBuilder.toArray());
    }

    public static void memberNotExist(String dimNumber, String memNumber, Long viewId, String templateNum) {
        DynamicObject dynamicObject;
        if (IDUtils.isNotNull(viewId) && (dynamicObject = BusinessDataServiceHelper.loadSingleFromCache((Object)viewId, (String)"eb_dimensionview", (String)"name")) != null) {
            if (StringUtils.isNotEmpty(templateNum)) {
                throw new KDBizException(ResManager.loadResFormat((String)"\u7ef4\u5ea6[%1]\u4e2d\u7f16\u7801\u4e3a\uff1a%2 \u7684\u7ef4\u5ea6\u6210\u5458\u5728\u7ef4\u5ea6\u89c6\u56fe\uff1a%3 \u4e2d\u4e0d\u5b58\u5728\uff0c\u8bf7\u68c0\u67e5\u3002\u6a21\u677f\uff1a%4", (String)"MemberServiceHelper_4", (String)"epm-eb-common", (Object[])new Object[]{dimNumber, memNumber, dynamicObject.getString("name"), templateNum}));
            }
            throw new KDBizException(ResManager.loadResFormat((String)"\u7ef4\u5ea6[%1]\u4e2d\u7f16\u7801\u4e3a\uff1a%2 \u7684\u7ef4\u5ea6\u6210\u5458\u5728\u7ef4\u5ea6\u89c6\u56fe\uff1a%3 \u4e2d\u4e0d\u5b58\u5728\uff0c\u8bf7\u68c0\u67e5\u3002", (String)"MemberServiceHelper_2", (String)"epm-eb-common", (Object[])new Object[]{dimNumber, memNumber, dynamicObject.getString("name")}));
        }
        throw new KDBizException(ResManager.loadResFormat((String)"\u7ef4\u5ea6%1\u4e2d\u7f16\u7801\u4e3a\uff1a%2\u7684\u7ef4\u5ea6\u6210\u5458\u4e0d\u5b58\u5728\uff0c\u8bf7\u68c0\u67e5\u3002", (String)"MemberServiceHelper_3", (String)"epm-eb-common", (Object[])new Object[]{dimNumber, memNumber}));
    }

    public static kd.epm.eb.common.cache.impl.Member addCosmicMember(kd.epm.eb.common.cache.impl.Member member, Long dataSetId) {
        List<Dataset> datasets;
        DynamicObject cosmicMemberDy;
        Dimension dimension = member.getDimension();
        String number = member.getNumber() + "._inv";
        String dimensionNumber = dimension.getNumber();
        if (!MetaUtils.verifyMetaLength(SysDimensionEnum.getMemberTreemodelByNumber(dimensionNumber), "number", number)) {
            throw new KDBizException(ResManager.loadKDString((String)"\u7ef4\u5ea6\u6210\u5458\u7f16\u7801\u8fc7\u957f\uff0c\u4e0d\u5141\u8bb8\u5ba1\u6279\u8c03\u6574", (String)"Fn_4", (String)"epm-eb-formplugin", (Object[])new Object[0]));
        }
        Long dimensionId = dimension.getId();
        String memberModel = dimension.getMemberModel();
        Model model = dimension.getModel();
        Long modelId = model.getId();
        IModelCacheHelper modelCache = ModelCacheContext.getOrCreate(model.getId());
        Map<String, Long> viewsByDataSet = modelCache.getViewsByDataSet(dataSetId);
        Long viewId = viewsByDataSet.get(dimensionNumber);
        DynamicObject viewMemberDy = null;
        QFilter qFilter = new QFilter("model", "=", (Object)modelId);
        qFilter.and(new QFilter("dimension", "=", (Object)dimensionId));
        qFilter.and(new QFilter("number", "=", (Object)member.getNumber()));
        String fields = "id,view,level,longnumber";
        if (member.isAnalyzeMember()) {
            viewMemberDy = BusinessDataServiceHelper.loadSingle((String)"eb_viewmember", (String)fields, (QFilter[])qFilter.toArray());
            viewId = viewMemberDy.getLong("view_id");
        } else if (IDUtils.isNotNull(viewId)) {
            qFilter.and(new QFilter("view", "=", (Object)viewId));
            viewMemberDy = BusinessDataServiceHelper.loadSingle((String)"eb_viewmember", (String)fields, (QFilter[])qFilter.toArray());
        }
        kd.epm.eb.common.cache.impl.Member cosmicMember = modelCache.getMember(dimensionNumber, viewId, number);
        if (cosmicMember != null) {
            return cosmicMember;
        }
        Long userId = UserUtils.getUserId();
        Date now = TimeServiceHelper.now();
        kd.epm.eb.common.cache.impl.Member baseCosmicMember = dimension.getStructOfMember(number);
        if (baseCosmicMember == null) {
            DynamicObject memberDy = BusinessDataServiceHelper.loadSingle((Object)member.getId(), (String)memberModel);
            cosmicMemberDy = BusinessDataServiceHelper.newDynamicObject((String)memberModel);
            cosmicMemberDy.set("id", (Object)kd.epm.eb.common.ebcommon.common.util.GlobalIdUtil.genGlobalLongId());
            cosmicMemberDy.set("number", (Object)number);
            cosmicMemberDy.set("parent", (Object)member.getId());
            String name = memberDy.get("name") + "._inv";
            if (name.length() > 255) {
                name = name.substring(0, 255);
            }
            cosmicMemberDy.set("name", (Object)name);
            cosmicMemberDy.set("description", memberDy.get("description"));
            cosmicMemberDy.set("simplename", memberDy.get("simplename"));
            cosmicMemberDy.set("status", memberDy.get("status"));
            cosmicMemberDy.set("creator", (Object)userId);
            cosmicMemberDy.set("modifier", (Object)userId);
            cosmicMemberDy.set("createtime", (Object)now);
            cosmicMemberDy.set("modifytime", (Object)now);
            cosmicMemberDy.set("aggoprt", (Object)AggOprtEnum.ADD.getSign());
            cosmicMemberDy.set("storagetype", (Object)StorageTypeEnum.STORAGE.getIndex());
            cosmicMemberDy.set("model", memberDy.get("model"));
            cosmicMemberDy.set("dimension", memberDy.get("dimension"));
            cosmicMemberDy.set("level", (Object)(memberDy.getInt("level") + 1));
            cosmicMemberDy.set("dseq", (Object)1);
            cosmicMemberDy.set(LONG_NUMBER_FIELD, (Object)(memberDy.getString(LONG_NUMBER_FIELD) + '!' + number));
            cosmicMemberDy.set("isleaf", (Object)"1");
            cosmicMemberDy.set("enable", (Object)"0");
            cosmicMemberDy.set("disable", (Object)"1");
            cosmicMemberDy.set("disabledate", (Object)memberDy.getDate("disabledate"));
            cosmicMemberDy.set("membersource", (Object)MemberSourceEnum.COSMIC_INVISIBLE.getIndex());
            cosmicMemberDy.set("customvalues", memberDy.get("customvalues"));
            boolean hasProperty = false;
            if (SysDimensionEnum.Account.getNumber().equals(dimensionNumber)) {
                cosmicMemberDy.set("dataset", memberDy.get("dataset"));
                cosmicMemberDy.set("accounttype", memberDy.get("accounttype"));
                cosmicMemberDy.set("drcrdirect", memberDy.get("drcrdirect"));
                hasProperty = true;
            } else if (SysDimensionEnum.Entity.getNumber().equals(dimensionNumber)) {
                cosmicMemberDy.set("currency", memberDy.get("currency"));
                cosmicMemberDy.set("mergernode", (Object)Character.valueOf('0'));
                cosmicMemberDy.set(IS_INNER_ORG_FIELD, (Object)Character.valueOf('0'));
                cosmicMemberDy.set("isouterorg", (Object)Character.valueOf('0'));
                cosmicMemberDy.set("isexchangerate", (Object)Character.valueOf('0'));
                cosmicMemberDy.set("executor", (Object)0L);
                cosmicMemberDy.set("owner", (Object)0L);
                hasProperty = true;
            }
            if (!dimension.isPreset()) {
                cosmicMemberDy.set("datatype", memberDy.get("datatype"));
                hasProperty = true;
            }
            try {
                if (hasProperty) {
                    DynamicObjectCollection propertyentry = memberDy.getDynamicObjectCollection("propertyentry");
                    DynamicObjectCollection propertyentryCopy = cosmicMemberDy.getDynamicObjectCollection("propertyentry");
                    for (DynamicObject property : propertyentry) {
                        DynamicObject propertyCopy = new DynamicObject(propertyentryCopy.getDynamicObjectType());
                        propertyCopy.set("id", (Object)kd.epm.eb.common.ebcommon.common.util.GlobalIdUtil.genGlobalLongId());
                        propertyCopy.set("seq", property.get("seq"));
                        propertyCopy.set("propertyvalue", property.get("propertyvalue"));
                        propertyentryCopy.add((Object)propertyCopy);
                    }
                }
            }
            catch (Exception propertyentry) {
                // empty catch block
            }
            SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{cosmicMemberDy});
        } else {
            cosmicMemberDy = BusinessDataServiceHelper.loadSingle((Object)baseCosmicMember.getId(), (String)memberModel);
        }
        if (viewMemberDy != null) {
            DynamicObject viewMember = BusinessDataServiceHelper.newDynamicObject((String)"eb_viewmember");
            viewMember.set("id", (Object)GlobalIdUtil.genGlobalLongId());
            viewMember.set("number", cosmicMemberDy.get("number"));
            viewMember.set("name", cosmicMemberDy.get("name"));
            viewMember.set("parent", viewMemberDy.get("id"));
            viewMember.set("model", (Object)modelId);
            viewMember.set("dimension", (Object)dimensionId);
            viewMember.set("view", (Object)viewId);
            viewMember.set("membersource", (Object)MemberSourceEnum.COSMIC_INVISIBLE.getIndex());
            viewMember.set("isleaf", (Object)"1");
            viewMember.set("enable", (Object)"0");
            viewMember.set("disable", (Object)"1");
            viewMember.set("level", (Object)(viewMemberDy.getInt("level") + 1));
            viewMember.set("dseq", (Object)1);
            viewMember.set(LONG_NUMBER_FIELD, (Object)(viewMemberDy.getString(LONG_NUMBER_FIELD) + '!' + number));
            viewMember.set("memberid", cosmicMemberDy.get("id"));
            viewMember.set("aggoprt", (Object)AggOprtEnum.ADD.getSign());
            viewMember.set("modifydate", (Object)now);
            viewMember.set("modifier", (Object)userId);
            viewMember.set("status", (Object)"C");
            SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{viewMember});
        }
        CubeUtils.updateDimensionVersion(modelId, dimensionId, null, false);
        MemberPropCacheService.updateVersion(modelId, dimensionId);
        VirtualMemberAddEvent virtualMemberAddEvent = new VirtualMemberAddEvent();
        virtualMemberAddEvent.setModelId(modelId);
        virtualMemberAddEvent.putVirtualMemberMap(dimensionNumber, number);
        VirtualMemberAddPublisher.publishMessage(virtualMemberAddEvent);
        IModelCacheHelper modelCacheHelper = ModelCacheContext.getOrCreate(model.getId(), true);
        if (SysDimensionEnum.Account.getNumber().equals(dimensionNumber)) {
            DatasetServiceHelper datasetServiceHelper = DatasetServiceHelper.getInstance();
            Dataset dataSet = datasetServiceHelper.getDataSet(dataSetId);
            datasets = Collections.singletonList(dataSet);
        } else {
            datasets = DatasetServiceHelper.getAllDatasets(modelCacheHelper.getModelobj().getId());
        }
        for (Dataset dataset : datasets) {
            try {
                ShrekCubeServiceHelper.updateCube(modelCacheHelper.getModelobj(), dataset, modelCacheHelper, ShrekConfigServiceHelper.getBgMDConfig());
            }
            catch (Exception ex) {
                throw new KDBizException(ex.getMessage());
            }
        }
        return modelCacheHelper.getMember(dimensionNumber, viewId, number);
    }

    public static List<Long> getViewGroupViewsByViewId(Long viewId) {
        DynamicObject object = QueryServiceHelper.queryOne((String)"eb_dimensionview", (String)"viewgroup,viewgroup.parent", (QFilter[])new QFilter("id", "=", (Object)viewId).toArray());
        if (object != null) {
            DynamicObjectCollection query;
            ArrayList<Long> viewGroupIds = new ArrayList<Long>(2);
            viewGroupIds.add(object.getLong("viewgroup"));
            if (IDUtils.isNotEmptyLong(object.getLong("viewgroup.parent")).booleanValue()) {
                viewGroupIds.add(object.getLong("viewgroup.parent"));
            }
            if (CollectionUtils.isNotEmpty(query = QueryServiceHelper.query((String)"eb_dimensionview", (String)"id", (QFilter[])new QFilter("viewgroup", "in", viewGroupIds).or("viewgroup.parent", "in", viewGroupIds).toArray()))) {
                return query.stream().map(e -> e.getLong("id")).collect(Collectors.toList());
            }
        }
        return new ArrayList<Long>(0);
    }
}

