/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.common.utils;

import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.metadata.dynamicobject.DynamicProperty;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.property.TextProp;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import org.jetbrains.annotations.NotNull;

public class MetaUtils {
    public static int getMetaLength(@NotNull String entityNumber, @NotNull String metaName) {
        DynamicProperty _property;
        DynamicObject object = BusinessDataServiceHelper.newDynamicObject((String)entityNumber);
        if (object != null && (_property = object.getDynamicObjectType().getProperty(metaName)) instanceof TextProp) {
            return ((TextProp)_property).getMaxLenth();
        }
        return 50;
    }

    public static boolean verifyMetaLength(@NotNull DynamicObjectType dt, @NotNull String metaName, String metaValue) {
        if (metaValue == null || metaValue.isEmpty()) {
            return true;
        }
        int length = 50;
        DynamicProperty _property = dt.getProperty(metaName);
        if (_property instanceof TextProp) {
            length = ((TextProp)_property).getMaxLenth();
        }
        return metaValue.length() <= length;
    }

    public static boolean verifyMetaLength(@NotNull String entityNumber, @NotNull String metaName, String metaValue) {
        if (metaValue == null || metaValue.isEmpty()) {
            return true;
        }
        MainEntityType dt = EntityMetadataCache.getDataEntityType((String)entityNumber);
        return MetaUtils.verifyMetaLength((DynamicObjectType)dt, metaName, metaValue);
    }

    public static String limitMetaLength(@NotNull DynamicObjectType dt, @NotNull String metaName, @NotNull String metaValue) {
        int length = 50;
        DynamicProperty _property = dt.getProperty(metaName);
        if (_property instanceof TextProp) {
            length = ((TextProp)_property).getMaxLenth();
        }
        return metaValue.length() <= length ? metaValue : metaValue.substring(0, length);
    }
}

