/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.common.utils;

import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.math.BigDecimal;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.SqlBuilder;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.epm.eb.common.constant.BgBaseConstant;
import kd.epm.eb.common.enums.dimensionEnums.MetricDataTypeEnum;
import kd.epm.eb.common.utils.IDUtils;
import kd.epm.eb.common.utils.StringUtils;

public class MetricUtils {
    public static boolean isNumeric(String dataType) {
        return MetricDataTypeEnum.CURRENCY.getIndex().equals(dataType) || MetricDataTypeEnum.NONMONETARY.getIndex().equals(dataType) || MetricDataTypeEnum.RATE.getIndex().equals(dataType) || MetricDataTypeEnum.DIFF.getIndex().equals(dataType);
    }

    public static boolean isString(String dataType) {
        return MetricDataTypeEnum.TEXT.getIndex().equals(dataType) || MetricDataTypeEnum.DATE.getIndex().equals(dataType);
    }

    public static String decimal2FormatStr(Integer decimal) {
        StringBuilder fm = new StringBuilder("#,##0");
        if (decimal != null && decimal > 0) {
            fm.append(".");
            for (int i = 0; i < decimal; ++i) {
                fm.append("0");
            }
        }
        return fm.toString();
    }

    public static String decimal2FormatStr(Integer decimal, boolean noSep) {
        StringBuilder fm;
        StringBuilder stringBuilder = fm = noSep ? new StringBuilder("###0") : new StringBuilder("#,##0");
        if (decimal != null && decimal > 0) {
            fm.append(".");
            for (int i = 0; i < decimal; ++i) {
                fm.append("0");
            }
        }
        return fm.toString();
    }

    public static Integer formatStr2Decimal(String formatStr) {
        if (StringUtils.isNotEmpty(formatStr)) {
            if (formatStr.indexOf(".") > 0) {
                formatStr = formatStr.replaceAll("%", "");
                return formatStr.length() - formatStr.lastIndexOf(".") - 1;
            }
            return 0;
        }
        return null;
    }

    public static BigDecimal unitStr2BigDecimal(String unitStr) {
        if (unitStr != null && unitStr.indexOf("unit") >= 0) {
            return BigDecimal.TEN.pow(Integer.parseInt(unitStr.substring(unitStr.length() - 1, unitStr.length())));
        }
        return BigDecimal.ONE;
    }

    public static DynamicObjectCollection getMetrics(Long modelId, QFilter qFilter) {
        if (qFilter != null) {
            return QueryServiceHelper.query((String)"epm_metricmembertree", (String)"id,number,name,datatype,decimalnum", (QFilter[])new QFilter[]{new QFilter("model", "=", (Object)modelId).and(qFilter)});
        }
        return QueryServiceHelper.query((String)"epm_metricmembertree", (String)"id,number,name,datatype,decimalnum", (QFilter[])new QFilter[]{new QFilter("model", "=", (Object)modelId)});
    }

    public static DynamicObjectCollection getMetricsByDataType(Long modelId, Set<String> dataTypes) {
        return MetricUtils.getMetrics(modelId, new QFilter("datatype", "in", dataTypes));
    }

    public static DynamicObjectCollection getMetricsByNumber(Long modelId, Set<String> numbers) {
        return MetricUtils.getMetrics(modelId, new QFilter("number", "in", numbers));
    }

    public static DynamicObjectCollection getMetricStorageNoDetail(Long modelId) {
        return MetricUtils.getMetrics(modelId, new QFilter("storagenodetail", "=", (Object)true));
    }

    public static Set<String> getMetricNumbersStorageNoDetail(Long modelId) {
        HashSet<String> result = new HashSet<String>(16);
        try {
            DynamicObjectCollection dynamicObjects = MetricUtils.getMetricStorageNoDetail(modelId);
            if (dynamicObjects != null) {
                dynamicObjects.forEach(e -> result.add(e.getString("number")));
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return result;
    }

    public static Set<String> getMetricNumberHasAgg(Long modelId) {
        HashSet<String> result = new HashSet<String>(16);
        try {
            DynamicObjectCollection dynamicObjects = MetricUtils.getMetrics(modelId, new QFilter("isagg", "=", (Object)true));
            if (dynamicObjects != null) {
                dynamicObjects.forEach(e -> result.add(e.getString("number")));
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return result;
    }

    public static Map<Long, Set<String>> queryMetricByAccount(Long modelId) {
        if (IDUtils.isNull(modelId)) {
            return Collections.emptyMap();
        }
        SqlBuilder sql = new SqlBuilder();
        sql.append("select t.fid, m.fnumber  from t_eb_accountmetric t ", new Object[0]);
        sql.append("left join t_eb_structofmetric m on t.fmetric = m.fid ", new Object[0]);
        sql.append("where exists (select fid from t_eb_structofaccount where fmodelid = ? and fid = t.fid)", new Object[]{modelId});
        LinkedHashMap accountMap = Maps.newLinkedHashMap();
        try (DataSet ds = DB.queryDataSet((String)"queryMetricByAccount", (DBRoute)BgBaseConstant.epm, (SqlBuilder)sql);){
            if (ds != null) {
                for (Row row : ds) {
                    Set metrics = accountMap.computeIfAbsent(row.getLong("fid"), f -> Sets.newHashSet());
                    metrics.add(row.getString("fnumber"));
                }
            }
        }
        return accountMap;
    }
}

