/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.common.utils;

import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.exception.KDBizException;
import kd.bos.form.IFormView;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.epm.eb.common.cache.threadlocal.EpmThreadLocalUtils;
import kd.epm.eb.common.enums.ApplicationTypeEnum;
import kd.epm.eb.common.enums.SysDimensionEnum;
import kd.epm.eb.common.utils.CollectionUtils;
import kd.epm.eb.common.utils.IDUtils;
import kd.epm.eb.common.utils.UserUtils;

public class ModelServiceHelper {
    public static DynamicObject getOneModelByReportType(String selectFields, String reportType) {
        if (StringUtils.isEmpty((CharSequence)selectFields) || StringUtils.isEmpty((CharSequence)reportType)) {
            return null;
        }
        return QueryServiceHelper.queryOne((String)"epm_model", (String)selectFields, (QFilter[])new QFilter[]{new QFilter("reporttype", "=", (Object)reportType)});
    }

    public static Set<Long> getLimitedModelListByUser(ApplicationTypeEnum application) {
        return EpmThreadLocalUtils.getLimitedModelListByUser(application, UserUtils.getUserId());
    }

    public static Set<Long> $getLimitedModelListByUser(ApplicationTypeEnum application, Long userId) {
        Long _userId = userId;
        if (IDUtils.isNull(_userId)) {
            _userId = UserUtils.getUserId();
        }
        HashSet<Long> modelIds = new HashSet<Long>(256);
        Set<Long> groupIds = UserUtils.queryAllGroupByUserId(_userId);
        groupIds.add(_userId);
        QFilter filter = new QFilter("modelpermentry.eusers", "in", (Object)groupIds.toArray());
        if (application != null) {
            if (ApplicationTypeEnum.BGM == application) {
                filter.and(new QFilter("model.reporttype", "=", (Object)ApplicationTypeEnum.BGMD.getIndex()));
            } else if (ApplicationTypeEnum.BGC == application) {
                filter.and(new QFilter("model.reporttype", "=", (Object)ApplicationTypeEnum.EB.getIndex()).or(new QFilter("model.reporttype", "=", (Object)ApplicationTypeEnum.BG.getIndex())).or(new QFilter("model.reporttype", "=", (Object)ApplicationTypeEnum.BGMD.getIndex())));
            } else if (ApplicationTypeEnum.BGRP == application) {
                filter.and(new QFilter("model.reporttype", "=", (Object)ApplicationTypeEnum.BGMD.getIndex()).or(new QFilter("model.reporttype", "=", (Object)ApplicationTypeEnum.BG.getIndex())));
            } else if (ApplicationTypeEnum.BGBD == application) {
                filter.and(new QFilter("model.reporttype", "=", (Object)ApplicationTypeEnum.EB.getIndex()).or("model.reporttype", "=", (Object)ApplicationTypeEnum.BG.getIndex()).or("model.reporttype", "=", (Object)ApplicationTypeEnum.BGMD.getIndex()));
            } else {
                filter.and(new QFilter("model.reporttype", "=", (Object)application.getIndex()));
            }
        }
        QueryServiceHelper.query((String)"epm_modelperm", (String)"model", (QFilter[])new QFilter[]{filter}).forEach(p -> modelIds.add(p.getLong("model")));
        return modelIds;
    }

    public static boolean isModelManager(Long modelId) {
        Set<Long> ids = ModelServiceHelper.getLimitedModelListByUser(null);
        return ids.contains(modelId);
    }

    public static boolean isModelManager(Long modelId, ApplicationTypeEnum application) {
        Set<Long> ids = ModelServiceHelper.getLimitedModelListByUser(application);
        return ids.contains(modelId);
    }

    public static boolean isUserHasRootPermByModel(long userId, Long modelId) {
        if (System.getProperty("isGalaxySystem") != null && System.getProperty("isGalaxySystem").equalsIgnoreCase("true")) {
            return false;
        }
        Set<Long> groupIds = UserUtils.queryAllGroupByUserId(userId);
        groupIds.add(userId);
        QFilter filter1 = new QFilter("model", "=", (Object)modelId);
        Map modelPermObjs = BusinessDataServiceHelper.loadFromCache((String)"epm_modelperm", (String)"modelpermentry.eusers", (QFilter[])new QFilter[]{filter1});
        if (modelPermObjs != null) {
            for (DynamicObject modelPerm : modelPermObjs.values()) {
                DynamicObjectCollection permRow = modelPerm.getDynamicObjectCollection("modelpermentry");
                for (DynamicObject permObj : permRow) {
                    if (!groupIds.contains(permObj.getLong("eusers_id"))) continue;
                    return true;
                }
            }
        }
        return false;
    }

    public static ApplicationTypeEnum getModelApp(long modelId) {
        QFilter fmodelid = new QFilter("id", "=", (Object)modelId);
        QFilter[] filters = new QFilter[]{fmodelid};
        DynamicObject dcs = QueryServiceHelper.queryOne((String)"epm_model", (String)"reporttype", (QFilter[])filters);
        ApplicationTypeEnum app = null;
        if (dcs != null) {
            String reporttype = dcs.getString("reporttype");
            app = ApplicationTypeEnum.getEnumByIndex(reporttype);
        } else {
            dcs = QueryServiceHelper.queryOne((String)"epm_model", (String)"reporttype", (QFilter[])filters);
            String reporttype = dcs.getString("reporttype");
            app = ApplicationTypeEnum.getEnumByIndex(reporttype);
        }
        return app;
    }

    public static Set<Long> getManagersByModel(Long modelId) {
        return ModelServiceHelper.getManagersByModel(modelId, true, false);
    }

    public static Set<Long> getManagersByModel(Long modelId, boolean needRef, boolean needGroup) {
        HashSet<Long> userIds = new HashSet<Long>();
        HashSet<Long> userGroup = new HashSet<Long>();
        QueryServiceHelper.query((String)"epm_modelperm", (String)"modelpermentry.eusers as user,modelpermentry.etype as usertype", (QFilter[])new QFilter[]{new QFilter("model", "=", (Object)modelId)}).forEach(obj -> {
            userIds.add(obj.getLong("user"));
            if (!obj.getString("usertype").equals("bos_user")) {
                userGroup.add(obj.getLong("user"));
            }
        });
        if (!userGroup.isEmpty()) {
            if (needRef) {
                Set<Long> allChildUserGroups = UserUtils.getAllChildUserGroups(userGroup);
                userGroup.addAll(allChildUserGroups);
                QueryServiceHelper.query((String)"bos_usergroupstaff", (String)"user", (QFilter[])new QFilter[]{new QFilter("usergroup", "in", userGroup)}).forEach(obj -> {
                    Long userId = obj.getLong("user");
                    if (!userId.equals(0L)) {
                        userIds.add(obj.getLong("user"));
                    }
                });
            }
            if (needGroup) {
                userIds.addAll(userGroup);
            }
        }
        return userIds;
    }

    public static boolean isBGMDModel(Long modelId) {
        try {
            DynamicObject dy = BusinessDataServiceHelper.loadSingleFromCache((Object)modelId, (String)"epm_model", (String)"id,reporttype");
            String reportType = dy.getString("reporttype");
            return reportType.equals(ApplicationTypeEnum.BGMD.getIndex());
        }
        catch (Exception e) {
            throw new KDBizException(ResManager.loadKDString((String)"\u8be5\u4f53\u7cfb\u4e0d\u5b58\u5728\u6216\u672a\u5347\u7ea7\u3002", (String)"ModelServiceHelper_0", (String)"epm-eb-common", (Object[])new Object[0]));
        }
    }

    public static boolean isOldEbModel(Long modelId) {
        try {
            DynamicObject dy = BusinessDataServiceHelper.loadSingleFromCache((Object)modelId, (String)"epm_model", (String)"id,reporttype");
            String reportType = dy.getString("reporttype");
            return reportType.equals(ApplicationTypeEnum.EB.getIndex());
        }
        catch (Exception e) {
            throw new KDBizException(ResManager.loadKDString((String)"\u8be5\u4f53\u7cfb\u4e0d\u5b58\u5728\u6216\u672a\u5347\u7ea7\u3002", (String)"ModelServiceHelper_0", (String)"epm-eb-common", (Object[])new Object[0]));
        }
    }

    public static String getDimEntityKeyByDImNum(String dimNum) {
        String entryKey = null;
        SysDimensionEnum dimensionEnum = SysDimensionEnum.getEnumByNumber(dimNum);
        entryKey = dimensionEnum == null ? "epm_userdefinedmembertree" : dimensionEnum.getMemberTreemodel();
        return entryKey;
    }

    public static boolean isEBModel(DynamicObject model) {
        return ApplicationTypeEnum.EB.getIndex().equals(model.getString("reporttype"));
    }

    public static boolean isUpgradeInterceptModel(IFormView view) {
        String appId = view.getFormShowParameter().getAppId();
        return ApplicationTypeEnum.EB == ApplicationTypeEnum.getEnumByNumber(appId, view) || ApplicationTypeEnum.BG == ApplicationTypeEnum.getEnumByNumber(appId, view) || ApplicationTypeEnum.BGC == ApplicationTypeEnum.getEnumByNumber(appId, view) || ApplicationTypeEnum.BGBD == ApplicationTypeEnum.getEnumByNumber(appId, view);
    }

    public static Set<String> getModelManagerName(Long modelId) {
        HashSet<String> nameSet = new HashSet<String>(16);
        Set<Long> managersByModel = ModelServiceHelper.getManagersByModel(modelId);
        if (CollectionUtils.isEmpty(managersByModel)) {
            return nameSet;
        }
        try (DataSet dataSet = QueryServiceHelper.queryDataSet((String)"queryUser", (String)"bos_user", (String)"name", (QFilter[])new QFilter[]{new QFilter("id", "in", managersByModel)}, null);){
            for (Row next : dataSet) {
                nameSet.add(next.getString("name"));
            }
            HashSet<String> hashSet = nameSet;
            return hashSet;
        }
    }
}

