/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.common.utils;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.exception.KDBizException;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.epm.eb.common.model.BizModel;
import kd.epm.eb.common.utils.QFBuilder;

public class ModelUtils {
    public static final String FIELDS = "id, name, number, shownumber, reporttype, creator.id, creator.name, datasource,version";

    public static BizModel getBizModel(Long modelId) {
        return new BizModel(ModelUtils.getModel(modelId));
    }

    public static DynamicObject getModel(Long modelId) {
        if (modelId == 0L) {
            throw new KDBizException("model id is null.");
        }
        QFBuilder builder = new QFBuilder();
        builder.add(new QFilter("id", "=", (Object)modelId));
        QFilter[] filters = builder.toArrays();
        DynamicObject object = BusinessDataServiceHelper.loadSingleFromCache((String)"epm_model", (String)FIELDS, (QFilter[])filters);
        if (object == null) {
            object = BusinessDataServiceHelper.loadSingleFromCache((String)"bcm_model", (QFilter[])filters);
        }
        return object;
    }

    public static Map<Long, BizModel> getModel(Set<Long> modelIds) {
        if (modelIds == null || modelIds.isEmpty()) {
            throw new KDBizException("model id is null.");
        }
        HashMap<Long, BizModel> bizModelMap = new HashMap<Long, BizModel>();
        QFBuilder builder = new QFBuilder();
        builder.add(new QFilter("id", "in", modelIds));
        Map models = BusinessDataServiceHelper.loadFromCache((String)"bcm_model", (String)FIELDS, (QFilter[])builder.toArrays());
        models.values().forEach(model -> bizModelMap.put(model.getLong("id"), new BizModel((DynamicObject)model)));
        if (bizModelMap.size() < modelIds.size()) {
            HashSet<Long> tmpModelIds = new HashSet<Long>(modelIds.size());
            tmpModelIds.addAll(modelIds);
            tmpModelIds.removeAll(models.keySet());
            if (!tmpModelIds.isEmpty()) {
                builder.clear();
                builder.add(new QFilter("id", "in", tmpModelIds));
                models = BusinessDataServiceHelper.loadFromCache((String)"epm_model", (String)FIELDS, (QFilter[])builder.toArrays());
                models.values().forEach(model -> bizModelMap.put(model.getLong("id"), new BizModel((DynamicObject)model)));
            }
        }
        return bizModelMap;
    }

    public static String getDetailedPeriod(Long modelid) {
        DynamicObject dynamicObject = QueryServiceHelper.queryOne((String)"epm_model", (String)"id,isdetailtomonth,isdetailtoqrt,isdetailtohalfyear", (QFilter[])new QFilter("id", "=", (Object)modelid).toArray());
        String periodType = null;
        if (dynamicObject.getBoolean("isdetailtomonth")) {
            periodType = "1";
        } else if (dynamicObject.getBoolean("isdetailtoqrt")) {
            periodType = "2";
        } else if (dynamicObject.getBoolean("isdetailtohalfyear")) {
            periodType = "3";
        }
        return periodType;
    }

    public static void updateDataSourceState() {
    }
}

