/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.common.utils;

import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.exception.KDBizException;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.epm.eb.common.cache.IModelCacheHelper;
import kd.epm.eb.common.cache.impl.Dimension;
import kd.epm.eb.common.cache.impl.Member;
import kd.epm.eb.common.enums.SysDimensionEnum;
import kd.epm.eb.common.params.ParamEnum;
import kd.epm.eb.common.params.ParamQueryServiceHelper;
import kd.epm.eb.common.utils.CollectionUtils;
import kd.epm.eb.common.utils.IDUtils;
import kd.epm.eb.common.utils.QFBuilder;
import kd.epm.eb.common.utils.StringUtils;

public class NameCheckUtils {
    public static boolean checkNameExist(String entityNumber, Long id, String name) {
        return NameCheckUtils.checkNameExist(entityNumber, id, name, null);
    }

    public static boolean checkNameExist(String entityNumber, Long id, String name, List<QFilter> filters) {
        if (StringUtils.isEmpty(entityNumber)) {
            throw new KDBizException("entityNumber is null.");
        }
        if (StringUtils.isEmpty(name)) {
            throw new KDBizException("name is null.");
        }
        QFBuilder builder = new QFBuilder();
        if (id != null && id != 0L) {
            DynamicObjectCollection result;
            builder.add(new QFilter("id", "=", (Object)id));
            if (filters != null && !filters.isEmpty()) {
                builder.add(filters);
            }
            if ((result = QueryServiceHelper.query((String)entityNumber, (String)"id", (QFilter[])builder.toArrays())) == null || result.size() == 0) {
                return false;
            }
            if (result.size() == 1) {
                return id.longValue() != ((DynamicObject)result.get(0)).getLong("id");
            }
            return true;
        }
        builder.add(new QFilter("name", "=", (Object)name));
        if (filters != null && !filters.isEmpty()) {
            builder.add(filters);
        }
        return QueryServiceHelper.exists((String)entityNumber, (QFilter[])builder.toArrays());
    }

    public static boolean getViewExistNameBoolean(Dimension dimension, Long viewIdLong, Long memberIdLong, String memberNameString, Long dataSetId) {
        List<Member> memberList;
        if (SysDimensionEnum.Account.getNumber().equals(dimension.getNumber())) {
            if (dataSetId == null) {
                return false;
            }
            memberList = dimension.getAllMembersByDataSetId(dataSetId);
        } else {
            memberList = dimension.getAllMembers(viewIdLong);
        }
        if (CollectionUtils.isEmpty(memberList)) {
            return false;
        }
        for (Member member : memberList) {
            String nameString;
            if (memberIdLong != null && memberIdLong.equals(member.getId()) || (nameString = member.getName()) == null || !nameString.equals(memberNameString)) continue;
            return true;
        }
        return false;
    }

    public static boolean getViewExistNameBoolean(IModelCacheHelper modelCacheHelper, Long dimensionIdLong, Long viewIdLong, Long memberIdLong, String memberNameString, Long dataSetId) {
        Dimension dimension = modelCacheHelper.getDimension(dimensionIdLong);
        return NameCheckUtils.getViewExistNameBoolean(dimension, viewIdLong, memberIdLong, memberNameString, dataSetId);
    }

    public static void checkViewExistNameBoolean(IModelCacheHelper modelCacheHelper, Long dimensionIdLong, Long viewIdLong, Long memberIdLong, String memberNameString, Long dataSetId) {
        DynamicObjectCollection viewMemberDynamicObjectCollection;
        if (modelCacheHelper.getModelobj().isModelByEB() && !modelCacheHelper.getModelobj().isModelByNewEB()) {
            return;
        }
        boolean nameUniqueBoolean = modelCacheHelper.getModelobj().isModelByNewEB() ? ParamQueryServiceHelper.getBoolean(modelCacheHelper.getModelobj().getId(), ParamEnum.BG064) : ParamQueryServiceHelper.getBoolean(modelCacheHelper.getModelobj().getId(), ParamEnum.BG062);
        if (!nameUniqueBoolean) {
            return;
        }
        boolean viewExistNameBoolean = NameCheckUtils.getViewExistNameBoolean(modelCacheHelper, dimensionIdLong, viewIdLong, memberIdLong, memberNameString, dataSetId);
        if (viewExistNameBoolean) {
            throw new KDBizException(ResManager.loadKDString((String)"\u7ef4\u5ea6\u6210\u5458\u540d\u79f0\u5df2\u5b58\u5728\uff0c\u8bf7\u4fee\u6539\u6210\u5458\u540d\u79f0\u3002", (String)"DimensionMemberSaveValidator_35", (String)"epm-eb-cube", (Object[])new Object[0]));
        }
        if (IDUtils.isEmptyLong(memberIdLong).booleanValue()) {
            return;
        }
        QFilter qFilter = new QFilter("model", "=", (Object)modelCacheHelper.getModelobj().getId());
        qFilter.and("memberid", "=", (Object)memberIdLong);
        qFilter.and("dimension", "=", (Object)dimensionIdLong);
        if (viewIdLong != null && viewIdLong > 0L) {
            qFilter.and("view.id", "!=", (Object)viewIdLong);
        }
        if (CollectionUtils.isEmpty(viewMemberDynamicObjectCollection = QueryServiceHelper.query((String)"eb_viewmember", (String)"view.id", (QFilter[])qFilter.toArray()))) {
            return;
        }
        for (DynamicObject viewMemberDynamicObject : viewMemberDynamicObjectCollection) {
            long tempViewIdLong = viewMemberDynamicObject.getLong("view.id");
            boolean tempViewExistNameBoolean = NameCheckUtils.getViewExistNameBoolean(modelCacheHelper, dimensionIdLong, tempViewIdLong, memberIdLong, memberNameString, dataSetId);
            if (!tempViewExistNameBoolean) continue;
            throw new KDBizException(ResManager.loadKDString((String)"\u7ef4\u5ea6\u6210\u5458\u540d\u79f0\u5df2\u5b58\u5728\uff0c\u8bf7\u4fee\u6539\u6210\u5458\u540d\u79f0\u3002", (String)"DimensionMemberSaveValidator_35", (String)"epm-eb-cube", (Object[])new Object[0]));
        }
    }
}

