/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.common.utils;

import com.google.common.collect.Sets;
import java.util.Arrays;
import java.util.List;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.epm.eb.common.enums.ApplicationScenarioEnum;
import kd.epm.eb.common.enums.ApplicationTypeEnum;
import kd.epm.eb.common.utils.StringUtils;

public class NewEbAppUtil {
    public static final Set<String> newEbFormKeys = Sets.newHashSet((Object[])new String[]{"eb_ebrptschemelist_nbg", "eb_templatelist_nbg", "eb_bizrulegrouplist2_nbg", "eb_examinelist_nbg", "epm_dimensionmanager_nbg"});
    public static final String newEbFormSign = "newEbForm";
    public static final String realParentPageId = "RealParentPageId";
    public static final String specialAppId = "app_special";
    private static final List<String> specialNewEbPage = Arrays.asList("bgm_adjustrule", "eb_approvebill", "eb_currconvertupdate", "bgm_adjustbill", "bgm_adjpstbill", "eb_approvaltypelist_new", "eb_centralrela_setting", "eb_bailorg_modify", "bgc_recipientmapping", "bgc_controlwarnningscheme", "eb_predict_param", "bgm_rptpreparation", "eb_executeanalyselist", "bgm_report_share_list", "eb_execanalysereport", "eb_diffanalysis", "eb_relexecuterecord", "eb_approvebill_manage");
    public static final Set<String> bgrpNewEbPage = Sets.newHashSet((Object[])new String[]{"bgm_rptpreparation", "eb_approvebill", "eb_execanalysereport", "eb_diffanalysis", "eb_relexecuterecord", "eb_executeanalyselist", "bgm_report_share_list", "bgm_adjustbill", "bgm_adjpstbill"});
    public static final Set<String> bgrpEbModelPage = Sets.newHashSet((Object[])new String[]{"eb_executetask", "eb_approvebill", "eb_execanalysereport", "eb_diffanalysis", "eb_relexecuterecord", "bgm_rptpreparation", "bgm_report_share_list", "eb_executeanalyselist", "bgm_adjustbill", "bgm_adjpstbill"});
    public static final List<String> allEbPage = Arrays.asList("bgc_controlwarnningscheme", "bgc_controlwarnningscheme", "bgc_recipientmapping");

    public static boolean isNewEbForm(IFormView view) {
        if (view == null) {
            return false;
        }
        FormShowParameter formShowParameter = view.getFormShowParameter();
        String formId = formShowParameter.getFormId();
        String newEb = (String)formShowParameter.getCustomParam(newEbFormSign);
        String cacheSign = view.getPageCache().get(newEbFormSign);
        return "true".equals(newEb) || newEbFormKeys.contains(formId) || "true".equals(cacheSign);
    }

    public static boolean isNewEbApp(IFormView view) {
        boolean result = false;
        if (view != null) {
            String appNum = view.getFormShowParameter().getAppId();
            if ((ApplicationTypeEnum.EB.getAppnum().equals(appNum) || ApplicationTypeEnum.BGBD.getAppnum().equals(appNum) || ApplicationTypeEnum.BGC.getAppnum().equals(appNum)) && !(result = NewEbAppUtil.isNewEbForm(view))) {
                String parentPageId = (String)view.getFormShowParameter().getCustomParam(realParentPageId);
                if (StringUtils.isEmpty(parentPageId)) {
                    parentPageId = view.getFormShowParameter().getParentPageId();
                }
                IFormView parentView = view.getViewNoPlugin(parentPageId);
                result = NewEbAppUtil.isNewEbForm(parentView);
            }
        }
        return result;
    }

    public static boolean isSpecialBGRPApp(IFormView view) {
        Object specialApp = view.getFormShowParameter().getCustomParam(specialAppId);
        if (specialApp == null) {
            return false;
        }
        return ApplicationTypeEnum.BGRP.getAppnum().equals(specialApp.toString());
    }

    public static String getSpecialApp(IFormView view) {
        Object specialApp = view.getFormShowParameter().getCustomParam(specialAppId);
        if (specialApp == null) {
            return null;
        }
        return specialApp.toString();
    }

    public static Long getDefaultDatasetId(Long modelId) {
        DynamicObject defaultObj = NewEbAppUtil.getDefaultObj("eb_dataset", modelId);
        return defaultObj == null ? 0L : defaultObj.getLong("id");
    }

    public static DynamicObject getDefaultObj(String formKey, Long modelId) {
        return NewEbAppUtil.getDefaultObj(formKey, modelId, null, null);
    }

    public static DynamicObject getDefaultObj(String formKey, Long modelId, String specialProperty, QFilter qFilter) {
        StringBuilder selectProperty = new StringBuilder("id,number,name");
        if (StringUtils.isNotEmpty(specialProperty)) {
            selectProperty.append((CharSequence)selectProperty).append(",").append(specialProperty);
        }
        QFilter qf = new QFilter("model", "=", (Object)modelId);
        if (qFilter != null) {
            qf.and(qFilter);
        }
        if ("eb_applicationscenario".equals(formKey)) {
            qf.and("number", "=", (Object)ApplicationScenarioEnum.YEARBUDGET.getNumber());
        }
        return BusinessDataServiceHelper.loadSingleFromCache((String)formKey, (String)selectProperty.toString(), (QFilter[])new QFilter[]{qf});
    }

    public static boolean isNewEbModel(Long modelId) {
        return NewEbAppUtil.checkAppByModel(modelId, ApplicationTypeEnum.BG);
    }

    public static boolean isNewEbModel(DynamicObject model) {
        return StringUtils.equals(ApplicationTypeEnum.BG.getIndex(), model.getString("reporttype"));
    }

    public static boolean isOldEbModel(Long modelId) {
        return NewEbAppUtil.checkAppByModel(modelId, ApplicationTypeEnum.EB);
    }

    public static boolean checkAppByModel(Long modelId, ApplicationTypeEnum application) {
        if (modelId == null || modelId == 0L) {
            return false;
        }
        DynamicObject modelObj = BusinessDataServiceHelper.loadSingleFromCache((Object)modelId, (String)"epm_model", (String)"reporttype");
        return modelObj != null && application.getIndex().equals(modelObj.getString("reporttype"));
    }

    public static boolean isNewEbPage(String entityId) {
        return entityId.endsWith("_nbg") || specialNewEbPage.contains(entityId);
    }
}

