/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.common.utils;

import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import kd.bos.algo.DataSet;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.ILocaleString;
import kd.bos.dataentity.entity.OrmLocaleValue;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.exception.KDBizException;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.epm.eb.common.cache.impl.Dimension;
import kd.epm.eb.common.enums.SysDimensionEnum;
import kd.epm.eb.common.pojo.NumberTipTypeEnum;
import kd.epm.eb.common.utils.CommonServiceHelper;
import kd.epm.eb.common.utils.StringUtils;

public class NumberCheckUtils {
    public static final String other = "other";
    public static final String all = "all";
    public static final String none = "none";
    public static final String NULL = "null";
    public static final Set<String> dimentionStringStringSet = Sets.newHashSet((Object[])new String[]{SysDimensionEnum.Entity.getNumber(), SysDimensionEnum.Version.getNumber(), SysDimensionEnum.AuditTrail.getNumber(), SysDimensionEnum.ChangeType.getNumber(), SysDimensionEnum.InternalCompany.getNumber(), SysDimensionEnum.DataType.getNumber(), SysDimensionEnum.Metric.getNumber()});

    public static boolean checkNumber(String number) {
        if (!StringUtils.isEmpty(number)) {
            String regEx = number.length() == 1 ? "^[a-zA-Z0-9]" : "^[a-zA-Z0-9](?!.*?\\.\\.)[-a-zA-Z0-9_.]+$";
            Pattern pattern = Pattern.compile(regEx);
            Matcher matcher = pattern.matcher(number);
            return matcher.matches();
        }
        return false;
    }

    public static boolean checkName(String name) {
        if (!StringUtils.isEmpty(name)) {
            String regEx = name.length() == 1 ? "^[a-zA-Z0-9\\u4e00-\\u9fa5]" : "^[a-zA-Z0-9\\u4e00-\\u9fa5](?!.*?\\.\\.)[a-zA-Z0-9_()\\u4e00-\\u9fa5.-]*$";
            Pattern pattern = Pattern.compile(regEx);
            Matcher matcher = pattern.matcher(name);
            return matcher.matches();
        }
        return false;
    }

    public static String checkNumberRule(String number) {
        if (number == null || StringUtils.isEmpty(number.trim())) {
            return ResManager.loadKDString((String)"\u7f16\u7801\u4e0d\u5141\u8bb8\u4e3a\u7a7a\u3002", (String)"DimensionMemberSaveValidator_15", (String)"epm-eb-cube", (Object[])new Object[0]);
        }
        if (!NumberCheckUtils.checkNumber(number)) {
            return ResManager.loadKDString((String)"\u201c\u7f16\u7801\u201d\u5e94\u9075\u5b88\u4ee5\u4e0b\u89c4\u5219\uff1a", (String)"DimensionMemberSaveValidator_1", (String)"epm-eb-cube", (Object[])new Object[0]) + "\r\n" + ResManager.loadKDString((String)"1\u3001\u53ea\u80fd\u4f7f\u7528\u534a\u89d2\u5b57\u7b26\uff1b", (String)"DimensionMemberSaveValidator_2", (String)"epm-eb-cube", (Object[])new Object[0]) + "\r\n" + ResManager.loadKDString((String)"2\u3001\u53ea\u80fd\u4f7f\u7528\u6570\u5b57\u3001\u5b57\u6bcd\u3001\u5c0f\u6570\u70b9\u3001\u4e0b\u5212\u7ebf\u548c\u51cf\u53f7\u7ec4\u6210\uff0c\u5e76\u4e14\u53ea\u80fd\u7531\u6570\u5b57\u3001\u5b57\u6bcd\u5f00\u5934\uff1b", (String)"DimensionMemberSaveValidator_3", (String)"epm-eb-cube", (Object[])new Object[0]) + "\r\n" + ResManager.loadKDString((String)"3\u3001\u4e24\u4e2a\u5c0f\u6570\u70b9\u4e4b\u95f4\u5fc5\u987b\u7531\u5176\u5b83\u5b57\u7b26\u9694\u5f00\u3002", (String)"DimensionMemberSaveValidator_18", (String)"epm-eb-cube", (Object[])new Object[0]);
        }
        return "";
    }

    public static void checkNameRule(ILocaleString name) {
        if (name == null) {
            throw new KDBizException(ResManager.loadKDString((String)"\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"DimensionMemberSaveValidator_13", (String)"epm-eb-cube", (Object[])new Object[0]));
        }
        if (name instanceof OrmLocaleValue) {
            OrmLocaleValue _name = (OrmLocaleValue)name;
            Set languages = _name.keySet();
            for (String _language : languages) {
                NumberCheckUtils.checkNameRule(_name.get((Object)_language));
            }
        }
    }

    public static void checkNameRule(String name) {
        if (name == null || StringUtils.isEmpty(name.trim())) {
            throw new KDBizException(ResManager.loadKDString((String)"\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"DimensionMemberSaveValidator_13", (String)"epm-eb-cube", (Object[])new Object[0]));
        }
        if (NumberCheckUtils.checkName(name)) {
            return;
        }
        throw new KDBizException(ResManager.loadKDString((String)"\u201c\u540d\u79f0\u201d\u5e94\u9075\u5b88\u4ee5\u4e0b\u89c4\u5219\uff1a", (String)"DimensionMemberSaveValidator_14", (String)"epm-eb-cube", (Object[])new Object[0]) + "\r\n" + ResManager.loadKDString((String)"1\u3001\u53ea\u80fd\u4f7f\u7528\u534a\u89d2\u5b57\u7b26\uff1b", (String)"DimensionMemberSaveValidator_2", (String)"epm-eb-cube", (Object[])new Object[0]) + "\r\n" + ResManager.loadKDString((String)"2\u3001\u53ea\u80fd\u4f7f\u7528\u6570\u5b57\u3001\u5b57\u6bcd\u3001\u5c0f\u6570\u70b9\u3001\u4e0b\u5212\u7ebf\u3001\u6c49\u5b57\u3001\u51cf\u53f7\u3001\u5c0f\u62ec\u53f7\u7b49\u7ec4\u6210\uff0c\u5e76\u4e14\u53ea\u80fd\u7531\u6570\u5b57\u3001\u5b57\u6bcd\u3001\u6c49\u5b57\u5f00\u5934\uff1b", (String)"DimensionMemberSaveValidator_20", (String)"epm-eb-cube", (Object[])new Object[0]) + "\r\n" + ResManager.loadKDString((String)"3\u3001\u4e24\u4e2a\u5c0f\u6570\u70b9\u4e4b\u95f4\u5fc5\u987b\u7531\u5176\u5b83\u5b57\u7b26\u9694\u5f00\u3002", (String)"DimensionMemberSaveValidator_18", (String)"epm-eb-cube", (Object[])new Object[0]));
    }

    public static boolean checkNumberExist(String entityName, String newNumber, String pkid) {
        QFilter q1 = new QFilter("number", "=", (Object)newNumber);
        if (pkid != null && StringUtils.isNotEmpty(pkid)) {
            DynamicObjectCollection result = QueryServiceHelper.query((String)entityName, (String)"id", (QFilter[])new QFilter[]{q1});
            if (result == null || result.size() == 0) {
                return false;
            }
            if (result.size() == 1) {
                return !pkid.equals(((DynamicObject)result.get(0)).getString("id"));
            }
            return true;
        }
        return QueryServiceHelper.exists((String)entityName, (QFilter[])q1.toArray());
    }

    public static boolean checkNumberExist(String entityNumber, QFilter[] filters, Long id) {
        boolean re = true;
        if (StringUtils.isEmpty(entityNumber) || filters == null || filters.length == 0) {
            return re;
        }
        try (DataSet ds = QueryServiceHelper.queryDataSet((String)"checkNumber", (String)entityNumber, (String)"id", (QFilter[])filters, null);){
            Map<String, Object> obj;
            Object _id;
            List<Map<String, Object>> objs = CommonServiceHelper.transDataSet(ds);
            if (objs.size() == 0) {
                re = false;
            } else if (objs.size() == 1 && id != null && (_id = (obj = objs.get(0)).get("id")) instanceof Long) {
                re = id.compareTo((Long)_id) != 0;
            }
        }
        return re;
    }

    public static boolean checkShowNumberBoolean(Dimension dimension, String numberString) {
        if (StringUtils.isEmpty(numberString)) {
            return false;
        }
        String regExString = !dimension.isPreset() || dimentionStringStringSet.contains(dimension.getNumber()) ? (numberString.length() == 1 ? "^[a-zA-Z0-9\u3010\u3011]" : "^[a-zA-Z0-9\u3010\u3011](?!.*?\\.\\.)[-a-zA-Z0-9_.\u3010\u3011]+$") : (numberString.length() == 1 ? "^[a-zA-Z0-9]" : "^[a-zA-Z0-9](?!.*?\\.\\.)[-a-zA-Z0-9_.]+$");
        Pattern pattern = Pattern.compile(regExString);
        Matcher matcher = pattern.matcher(numberString);
        return matcher.matches();
    }

    public static String getNumberTipString(NumberTipTypeEnum numberTipTypeEnum, Boolean needInvTipBoolean, Boolean needOffsetentryTipBoolean) {
        StringBuilder stringBuilder = new StringBuilder();
        if (numberTipTypeEnum == null || NumberTipTypeEnum.CODE == numberTipTypeEnum) {
            stringBuilder.append(ResManager.loadKDString((String)"\u201c\u7f16\u7801\u201d\u5e94\u9075\u5b88\u4ee5\u4e0b\u89c4\u5219\uff1a", (String)"DimensionMemberSaveValidator_1", (String)"epm-eb-cube", (Object[])new Object[0]));
        } else if (NumberTipTypeEnum.INTERNAL_CODE == numberTipTypeEnum) {
            stringBuilder.append(ResManager.loadKDString((String)"\u201c\u5185\u7801\u201d\u5e94\u9075\u5b88\u4ee5\u4e0b\u89c4\u5219\uff1a", (String)"DimensionMemberSaveValidator_27", (String)"epm-eb-cube", (Object[])new Object[0]));
        }
        stringBuilder.append("\r\n");
        ArrayList<String> itemStringList = new ArrayList<String>(16);
        int numberInt = 0;
        if (NumberTipTypeEnum.INTERNAL_CODE == numberTipTypeEnum) {
            itemStringList.add(ResManager.loadResFormat((String)"%1\u3001\u201c\u5185\u7801\u201d\u4e3a\u7a7a\u5219\u53d6\u201c\u7f16\u7801\u201d\u7684\u503c\uff1b", (String)"DimensionMemberSaveValidator_28", (String)"epm-eb-cube", (Object[])new Object[]{++numberInt}));
        }
        itemStringList.add(ResManager.loadResFormat((String)"%1\u3001\u53ea\u80fd\u4f7f\u7528\u534a\u89d2\u5b57\u7b26\uff1b", (String)"DimensionMemberSaveValidator_29", (String)"epm-eb-cube", (Object[])new Object[]{++numberInt}));
        itemStringList.add(ResManager.loadResFormat((String)"%1\u3001\u53ea\u80fd\u4f7f\u7528\u6570\u5b57\u3001\u5b57\u6bcd\u3001\u5c0f\u6570\u70b9\u3001\u4e0b\u5212\u7ebf\u548c\u51cf\u53f7\u7ec4\u6210\uff0c\u5e76\u4e14\u53ea\u80fd\u7531\u6570\u5b57\u3001\u5b57\u6bcd\u5f00\u5934\uff1b", (String)"DimensionMemberSaveValidator_30", (String)"epm-eb-cube", (Object[])new Object[]{++numberInt}));
        itemStringList.add(ResManager.loadResFormat((String)"%1\u3001\u4e24\u4e2a\u5c0f\u6570\u70b9\u4e4b\u95f4\u5fc5\u987b\u7531\u5176\u5b83\u5b57\u7b26\u9694\u5f00\uff1b", (String)"DimensionMemberSaveValidator_31", (String)"epm-eb-cube", (Object[])new Object[]{++numberInt}));
        if (Boolean.TRUE.equals(needInvTipBoolean)) {
            itemStringList.add(ResManager.loadResFormat((String)"%1\u3001\u7f16\u7801\u4e0d\u80fd\u4ee5'._inv'\u7ed3\u5c3e\uff1b", (String)"DimensionMemberSaveValidator_32", (String)"epm-eb-cube", (Object[])new Object[]{++numberInt}));
        }
        itemStringList.add(ResManager.loadResFormat((String)"%1\u3001\u7ef4\u5ea6\u6210\u5458\u7f16\u7801\u4e0d\u80fd\u4f7f\u7528\u4fdd\u7559\u5b57\uff1a\u201call\u201d, \u201cnone\u201d, \u201cnull\u201d, \u201cother\u201d;", (String)"DimensionMemberSaveValidator_33", (String)"epm-eb-cube", (Object[])new Object[]{++numberInt}));
        if (Boolean.TRUE.equals(needOffsetentryTipBoolean)) {
            itemStringList.add(ResManager.loadResFormat((String)"%1\u3001\u7ec4\u7ec7\u7f16\u7801\u4e0d\u80fd\u4ee5\u7cfb\u7edf\u9884\u7559\u5b57\u7b26\u4e32offsetentry\u7ed3\u5c3e;", (String)"DimensionMemberSaveValidator_34", (String)"epm-eb-cube", (Object[])new Object[]{++numberInt}));
        }
        stringBuilder.append(String.join((CharSequence)"\r\n", itemStringList));
        stringBuilder.append("\r\n");
        stringBuilder.append(ResManager.loadKDString((String)"\u6ce8\u610f\uff1a\u82e5\u901a\u8fc7\u7f16\u7801\u89c4\u5219\u751f\u6210\u7f16\u7801\uff0c\u8bf7\u68c0\u67e5\u7f16\u7801\u89c4\u5219\u914d\u7f6e\u3002", (String)"DimensionMemberSaveValidator_16", (String)"epm-eb-cube", (Object[])new Object[0]));
        return stringBuilder.toString();
    }
}

