/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.common.utils;

import java.math.BigDecimal;

public final class NumberUtils {
    private static final BigDecimal MAX_VALUE = new BigDecimal("9999999999999");
    private static final BigDecimal MIN_VALUE = new BigDecimal("-9999999999999");

    public static boolean isNumber(String number) {
        if (number == null || number.length() == 0) {
            return false;
        }
        boolean re = true;
        int in = number.length();
        for (int i = 0; i < in && re; ++i) {
            char _char = number.charAt(i);
            if (i == 0) {
                if (_char == '-' || Character.isDigit(_char)) continue;
                re = false;
                continue;
            }
            if (Character.isDigit(_char)) continue;
            re = false;
        }
        return re;
    }

    public static BigDecimal toDecimal(String number) {
        if (number == null) {
            return null;
        }
        BigDecimal value = null;
        try {
            value = new BigDecimal(number);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return value;
    }

    public static BigDecimal toDecimal(Number number) {
        if (number == null) {
            return null;
        }
        BigDecimal value = null;
        if (number instanceof BigDecimal) {
            value = (BigDecimal)number;
        } else if (number instanceof Long) {
            value = new BigDecimal(Long.toString((Long)number));
        } else if (number instanceof Integer) {
            value = new BigDecimal(Integer.toString((Integer)number));
        } else {
            try {
                value = new BigDecimal(number.toString());
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        return value;
    }

    public static String int2Pos(int intVal) {
        if (intVal < 0) {
            return null;
        }
        ++intVal;
        char[] tmp = new char[30];
        int i = 29;
        while (i >= 0) {
            int Q = intVal / 26;
            int R = intVal % 26;
            if (R < 1) {
                R = 26;
                --Q;
            }
            tmp[i--] = (char)(65 + R - 1);
            if (Q == 0) break;
            intVal = Q;
        }
        return new String(tmp, ++i, tmp.length - i);
    }

    public static int[][] getDeepCloneIntArray(int[][] srcArray) {
        int[][] cloneArray = (int[][])srcArray.clone();
        for (int i = 0; i < srcArray.length; ++i) {
            int[] rowIntArray = srcArray[i];
            int[] rowCloneArray = new int[rowIntArray.length];
            System.arraycopy(rowIntArray, 0, rowCloneArray, 0, rowCloneArray.length);
            cloneArray[i] = rowCloneArray;
        }
        return cloneArray;
    }
}

