/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.common.utils;

import java.util.HashMap;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.metadata.dynamicobject.DynamicSimpleProperty;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.epm.eb.common.utils.JSONUtils;
import kd.epm.eb.common.utils.StringUtils;

public class ObjectSerializer {
    private static Log log = LogFactory.getLog(ObjectSerializer.class);

    public static String encoded(DynamicObject object) {
        if (object == null || object.getDataEntityType() == null) {
            return null;
        }
        HashMap<String, Object> valueMap = new HashMap<String, Object>();
        IDataEntityType dt = object.getDataEntityType();
        for (IDataEntityProperty prop : dt.getProperties()) {
            valueMap.put(prop.getName(), object.get(prop));
        }
        return JSONUtils.toString(valueMap);
    }

    public static DynamicObject decoded(String encoderStr) {
        if (StringUtils.isEmpty(encoderStr)) {
            return null;
        }
        DynamicObject object = null;
        Map obj = JSONUtils.parse(encoderStr, Map.class);
        if (obj instanceof Map) {
            Map valueMap = obj;
            object = ObjectSerializer.decoded(valueMap);
        }
        return object;
    }

    public static DynamicObject decoded(Map<String, Object> valueMap) {
        DynamicObject object = null;
        if (valueMap == null || valueMap.isEmpty()) {
            return object;
        }
        DynamicObjectType dt = new DynamicObjectType("PlainObject");
        object = new DynamicObject(dt);
        Map.Entry<String, Object> entry2 = null;
        String fieldName = null;
        Object fieldValue = null;
        for (Map.Entry<String, Object> entry2 : valueMap.entrySet()) {
            fieldName = entry2.getKey();
            fieldValue = entry2.getValue();
            if (fieldName == null || fieldValue == null) continue;
            DynamicSimpleProperty property = new DynamicSimpleProperty(fieldName, fieldValue.getClass(), null);
            dt.registerSimpleProperty(property);
            object.set((IDataEntityProperty)property, fieldValue);
        }
        return object;
    }
}

