/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.common.utils;

import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.OpBizRuleSetServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.epm.eb.common.utils.CacheServiceHelper;
import kd.epm.eb.common.utils.QFBuilder;
import kd.epm.eb.common.utils.StringUtils;

public class OpBizRuleUtils {
    private static final Log log = LogFactory.getLog(OpBizRuleUtils.class);

    public static void updateOpBizRule() {
        OpBizRuleUtils.updateOpBizRule(null);
    }

    public static void updateOpBizRule(Set<String> entityNumbers) {
        Map<String, Map<String, Set<String>>> bizRuleMap = OpBizRuleUtils.loadBizRules(entityNumbers);
        Map<String, Map<String, Map<String, Long>>> bosRuleMap = OpBizRuleUtils.loadBosRule(entityNumbers);
        OpBizRuleUtils.removeOpRuleSet(bosRuleMap);
        OpBizRuleUtils.upOpRuleSet(bizRuleMap);
        CacheServiceHelper.updateProcessByControl();
    }

    private static Map<String, Map<String, Set<String>>> loadBizRules(Set<String> entityNumbers) {
        String entityNumber = null;
        HashMap<String, Map<String, Set<String>>> bizRuleMap = new HashMap<String, Map<String, Set<String>>>();
        Map<String, Set<String>> ruleMap = null;
        Set<String> operSet = null;
        QFBuilder builder = new QFBuilder();
        builder.add(new QFilter("enable", "=", (Object)Character.valueOf('1')));
        String fields = "entryentity.id, entryentity.bill.fieldtable, entryentity.takeoperation, entryentity.runoperation, entryentity.returnoperation, entryentity.clearoperation";
        DynamicObjectCollection rules = QueryServiceHelper.query((String)"eb_bgcontrolprocess", (String)fields, (QFilter[])builder.toArrays());
        for (DynamicObject rule : rules) {
            String replace;
            String[] opers;
            entityNumber = rule.getString("entryentity.bill.fieldtable");
            if (entityNumbers != null && !entityNumbers.contains(entityNumber)) continue;
            ruleMap = OpBizRuleUtils.getRuleMap(bizRuleMap, entityNumber);
            if (StringUtils.isNotEmpty(rule.getString("entryentity.takeoperation")) && (opers = (replace = rule.getString("entryentity.takeoperation").replace("\uff0c", ",")).split(",")) != null) {
                operSet = OpBizRuleUtils.getOpers(ruleMap, "requestBudget");
                for (String operation : opers) {
                    operSet.add(operation.trim());
                }
            }
            if (StringUtils.isNotEmpty(rule.getString("entryentity.runoperation")) && (opers = (replace = rule.getString("entryentity.runoperation").replace("\uff0c", ",")).split(",")) != null) {
                operSet = OpBizRuleUtils.getOpers(ruleMap, "requestBudget");
                for (String operation : opers) {
                    operSet.add(operation.trim());
                }
            }
            if (StringUtils.isNotEmpty(rule.getString("entryentity.returnoperation")) && (opers = (replace = rule.getString("entryentity.returnoperation").replace("\uff0c", ",")).split(",")) != null) {
                operSet = OpBizRuleUtils.getOpers(ruleMap, "closeBudget");
                for (String operation : opers) {
                    operSet.add(operation.trim());
                }
            }
            if (!StringUtils.isNotEmpty(rule.getString("entryentity.clearoperation")) || (opers = (replace = rule.getString("entryentity.clearoperation").replace("\uff0c", ",")).split(",")) == null) continue;
            operSet = OpBizRuleUtils.getOpers(ruleMap, "returnBudget");
            for (String operation : opers) {
                operSet.add(operation.trim());
            }
        }
        return bizRuleMap;
    }

    private static Map<String, Set<String>> getRuleMap(Map<String, Map<String, Set<String>>> bizRuleMap, String bizObj) {
        if (bizRuleMap == null || bizObj == null) {
            throw new NullPointerException("rule or operation is null.");
        }
        Map<String, Set<String>> ruleMap = bizRuleMap.get(bizObj);
        if (ruleMap == null) {
            ruleMap = new HashMap<String, Set<String>>();
            bizRuleMap.put(bizObj, ruleMap);
        }
        return ruleMap;
    }

    private static Set<String> getOpers(Map<String, Set<String>> ruleMap, String rule) {
        if (ruleMap == null || rule == null) {
            throw new NullPointerException("rule or operation is null.");
        }
        Set<String> operSet = ruleMap.get(rule);
        if (operSet == null) {
            operSet = new HashSet<String>();
            ruleMap.put(rule, operSet);
        }
        return operSet;
    }

    private static Map<String, Map<String, Map<String, Long>>> loadBosRule(Set<String> entityNumbers) {
        String entityNumber = null;
        HashMap<String, Map<String, Map<String, Long>>> bosRuleMap = new HashMap<String, Map<String, Map<String, Long>>>();
        HashMap<String, HashMap<String, Long>> ruleMap = null;
        HashMap<String, Long> operMap = null;
        HashSet<String> types = new HashSet<String>();
        types.add("requestBudget");
        types.add("returnBudget");
        types.add("closeBudget");
        QFBuilder builder = new QFBuilder();
        builder.add(new QFilter("opbizrule", "in", types));
        DynamicObjectCollection opRules = QueryServiceHelper.query((String)"bos_opbizruleset", (String)"opbizrule, objecttype, entryentity.id, entryentity.operationkey", (QFilter[])builder.toArrays());
        for (DynamicObject opRule : opRules) {
            entityNumber = opRule.getString("objecttype");
            if (entityNumbers != null && !entityNumbers.contains(entityNumber)) continue;
            ruleMap = (HashMap<String, HashMap<String, Long>>)bosRuleMap.get(entityNumber);
            if (ruleMap == null) {
                ruleMap = new HashMap<String, HashMap<String, Long>>();
                bosRuleMap.put(entityNumber, ruleMap);
            }
            if ((operMap = (HashMap<String, Long>)ruleMap.get(opRule.getString("opbizrule"))) == null) {
                operMap = new HashMap<String, Long>();
                ruleMap.put(opRule.getString("opbizrule"), operMap);
            }
            operMap.put(opRule.getString("entryentity.operationkey"), opRule.getLong("entryentity.id"));
        }
        return bosRuleMap;
    }

    private static void upOpRuleSet(Map<String, Map<String, Set<String>>> bizRuleMap) {
        if (bizRuleMap == null || bizRuleMap.isEmpty()) {
            return;
        }
        String entityNumber = null;
        String rule = null;
        Map<String, Set<String>> ruleMap = null;
        Set<String> opers = null;
        Map.Entry<String, Map<String, Set<String>>> entry2 = null;
        Map.Entry<String, Set<String>> sEntry2 = null;
        for (Map.Entry<String, Map<String, Set<String>>> entry2 : bizRuleMap.entrySet()) {
            entityNumber = entry2.getKey();
            ruleMap = entry2.getValue();
            for (Map.Entry<String, Set<String>> sEntry2 : ruleMap.entrySet()) {
                rule = sEntry2.getKey();
                opers = sEntry2.getValue();
                if (entityNumber == null || rule == null || opers == null || opers.isEmpty()) continue;
                OpBizRuleSetServiceHelper.saveOpBizRuleSet((String)entityNumber, (String)rule, new ArrayList<String>(opers));
            }
        }
    }

    private static void removeOpRuleSet(Map<String, Map<String, Map<String, Long>>> bosRuleMap) {
        if (bosRuleMap == null || bosRuleMap.isEmpty()) {
            return;
        }
        for (Map.Entry<String, Map<String, Map<String, Long>>> entry : bosRuleMap.entrySet()) {
            String entityNumber = entry.getKey();
            OpBizRuleSetServiceHelper.deleteOpBizRuleSet((String)entityNumber, (String)"requestBudget");
            OpBizRuleSetServiceHelper.deleteOpBizRuleSet((String)entityNumber, (String)"returnBudget");
            OpBizRuleSetServiceHelper.deleteOpBizRuleSet((String)entityNumber, (String)"closeBudget");
        }
    }

    public static String checkOperation(String entityNumber) {
        if (StringUtils.isEmpty(entityNumber)) {
            return null;
        }
        HashSet<String> entityNumbers = new HashSet<String>();
        entityNumbers.add(entityNumber);
        return OpBizRuleUtils.checkOperation(entityNumbers);
    }

    public static String checkOperation(Set<String> entityNumbers) {
        if (entityNumbers == null || entityNumbers.isEmpty()) {
            return null;
        }
        Map<String, Map<String, Set<String>>> bizRules = OpBizRuleUtils.loadBizRules(entityNumbers);
        if (bizRules == null || bizRules.isEmpty()) {
            return null;
        }
        Map<String, Map<String, Map<String, Long>>> bosRules = OpBizRuleUtils.loadBosRule(entityNumbers);
        String entityNumber = null;
        String budgetOperation = null;
        Object billOperation = null;
        Map<String, Set<String>> budgetOperBiz = null;
        Map<String, Map<String, Long>> budgetOperBos = null;
        LinkedHashSet failNumbers = Sets.newLinkedHashSet();
        block0: for (Map.Entry<String, Map<String, Set<String>>> entityEntry : bizRules.entrySet()) {
            entityNumber = entityEntry.getKey();
            budgetOperBiz = entityEntry.getValue();
            if (budgetOperBiz == null || budgetOperBiz.isEmpty()) continue;
            budgetOperBos = bosRules.get(entityNumber);
            if (budgetOperBos == null || budgetOperBos.isEmpty()) {
                failNumbers.add(entityNumber);
                break;
            }
            for (Map.Entry<String, Set<String>> budgetOperEntry : budgetOperBiz.entrySet()) {
                budgetOperation = budgetOperEntry.getKey();
                if (budgetOperEntry.getValue() == null || budgetOperEntry.getValue().isEmpty()) continue;
                if (budgetOperBos.get(budgetOperation) == null) {
                    failNumbers.add(entityNumber);
                    continue block0;
                }
                budgetOperEntry.getValue().removeAll(budgetOperBos.get(budgetOperation).keySet());
                if (budgetOperEntry.getValue().isEmpty()) continue;
                failNumbers.add(entityNumber);
                continue block0;
            }
        }
        if (!failNumbers.isEmpty()) {
            if (entityNumbers.size() == 1) {
                return ResManager.loadKDString((String)"\u5355\u636e\u7684\u63a7\u5236\u8fc7\u7a0b\u65b9\u6848\u914d\u7f6e\u7684\u64cd\u4f5c\u4e0e\u64cd\u4f5c\u670d\u52a1\u6ce8\u518c\u7684\u64cd\u4f5c\u4e0d\u4e00\u81f4\uff0c\u8bf7\u68c0\u67e5\u3002", (String)"OpBizRuleUtils_01", (String)"epm-eb-common", (Object[])new Object[0]);
            }
            return ResManager.loadResFormat((String)"\u5355\u636e%1\u7684\u63a7\u5236\u8fc7\u7a0b\u65b9\u6848\u914d\u7f6e\u7684\u64cd\u4f5c\u4e0e\u64cd\u4f5c\u670d\u52a1\u6ce8\u518c\u7684\u64cd\u4f5c\u4e0d\u4e00\u81f4\uff0c\u8bf7\u68c0\u67e5\u3002", (String)"OpBizRuleUtils_02", (String)"epm-eb-common", (Object[])new Object[]{Arrays.toString(failNumbers.toArray())});
        }
        return null;
    }
}

