/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.common.utils;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.resource.promptenum.MultiLangEnumBridge;
import kd.bos.entity.AppMetadataCache;
import kd.bos.log.api.AppLogInfo;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.TimeServiceHelper;
import kd.bos.servicehelper.log.LogServiceHelper;
import kd.epm.eb.common.resource.ResUtils;
import kd.epm.eb.common.utils.ClassUtil;
import kd.epm.eb.common.utils.CommonServiceHelper;
import kd.epm.eb.common.utils.QFBuilder;
import kd.epm.eb.common.utils.UserUtils;
import kd.epm.eb.common.utils.pkgversioncheck.PkgVersionCheckService;
import kd.epm.epbs.business.log.trace.OlapTraceServiceHelper;
import org.jetbrains.annotations.NotNull;

public final class OperationLogUtil {
    private static final Log log = LogFactory.getLog(OperationLogUtil.class);
    private static final String OP_CLASS_NAME = "kd.bos.log.api.OpLogAppInfo";

    public static AppLogInfo buildLogInfo(String bizAppId, String bizEntityNumber, String keyWord, String opKey, @NotNull MultiLangEnumBridge opNameBridge, MultiLangEnumBridge opDescBridge, String[] opDescArgs, boolean status) {
        AppLogInfo logAppInfo = OperationLogUtil.buildLogInfo(opNameBridge.loadKDString(), ResUtils.load(opDescBridge, opDescArgs), bizAppId, bizEntityNumber);
        ClassUtil.executeMethod(logAppInfo, "setStatus", new Class[]{String.class}, new Object[]{status ? "1" : "0"});
        if (keyWord != null && keyWord.length() > 50) {
            keyWord = keyWord.substring(0, 50);
        }
        ClassUtil.executeMethod(logAppInfo, "setKeyWord", new Class[]{String.class}, new Object[]{keyWord});
        ClassUtil.executeMethod(logAppInfo, "setOpName", new Class[]{String.class, MultiLangEnumBridge.class}, new Object[]{opKey, opNameBridge});
        if (opDescBridge != null) {
            ClassUtil.executeMethod(logAppInfo, "setOpDesc", new Class[]{MultiLangEnumBridge.class, String[].class}, new Object[]{opDescBridge, opDescArgs});
        }
        return logAppInfo;
    }

    public static AppLogInfo buildLogInfo(String bizAppId, String bizEntityNumber, String keyWord, String opKey, @NotNull MultiLangEnumBridge opNameBridge, MultiLangEnumBridge opDescBridge, String[] opDescArgs) {
        return OperationLogUtil.buildLogInfo(bizAppId, bizEntityNumber, keyWord, opKey, opNameBridge, opDescBridge, opDescArgs, true);
    }

    public static AppLogInfo buildLogInfo(String opName, String opDescription, String bizAppId, String bizEntityNumber) {
        AppLogInfo logInfo = OperationLogUtil.createLogInfo();
        logInfo.setUserID(UserUtils.getUserId());
        logInfo.setBizAppID(bizAppId);
        logInfo.setBizObjID(bizEntityNumber);
        logInfo.setOrgID(Long.valueOf(RequestContext.get().getOrgId()));
        logInfo.setOpTime(TimeServiceHelper.now());
        logInfo.setClientType(RequestContext.get().getClient());
        logInfo.setClientIP(RequestContext.get().getLoginIP());
        logInfo.setClientName(RequestContext.get().getClient());
        logInfo.setOpName(opName);
        logInfo.setOpDescription(opDescription);
        if ("api".equals(logInfo.getClientType())) {
            String epmClient = ResManager.loadKDString((String)"EPM\u5ba2\u6237\u7aef", (String)"OperationLogUtil_0", (String)"epm-eb-common", (Object[])new Object[0]);
            logInfo.setClientType("web");
            logInfo.setClientName(epmClient);
            logInfo.setOpName(epmClient + logInfo.getOpName());
        }
        return logInfo;
    }

    private static AppLogInfo createLogInfo() {
        AppLogInfo logInfo;
        if (PkgVersionCheckService.getInstance().hasClass(OP_CLASS_NAME)) {
            try {
                Class<?> clazz = Class.forName(OP_CLASS_NAME);
                logInfo = (AppLogInfo)clazz.newInstance();
            }
            catch (Throwable ex) {
                logInfo = new AppLogInfo();
            }
        } else {
            logInfo = new AppLogInfo();
        }
        return logInfo;
    }

    public static void log(String bizId, String entityNumber, String opName, String opDescription) {
        OperationLogUtil.log(OperationLogUtil.buildLogInfo(opName, opDescription, AppMetadataCache.getAppInfo((String)bizId).getId(), entityNumber));
    }

    public static void log(String bizId, String entityNumber, String keyWord, String opKey, MultiLangEnumBridge opNameBridge) {
        OperationLogUtil.log(OperationLogUtil.buildLogInfo(AppMetadataCache.getAppInfo((String)bizId).getId(), entityNumber, keyWord, opKey, opNameBridge, null, null));
    }

    public static void log(String bizId, String entityNumber, String keyWord, String opKey, MultiLangEnumBridge opNameBridge, MultiLangEnumBridge opDescBridge, String[] opDescArgs) {
        OperationLogUtil.log(OperationLogUtil.buildLogInfo(AppMetadataCache.getAppInfo((String)bizId).getId(), entityNumber, keyWord, opKey, opNameBridge, opDescBridge, opDescArgs));
    }

    public static void log(String bizId, String entityNumber, String keyWord, String opKey, MultiLangEnumBridge opNameBridge, MultiLangEnumBridge opDescBridge, String[] opDescArgs, boolean status) {
        OperationLogUtil.log(OperationLogUtil.buildLogInfo(AppMetadataCache.getAppInfo((String)bizId).getId(), entityNumber, keyWord, opKey, opNameBridge, opDescBridge, opDescArgs, status));
    }

    public static void log(AppLogInfo logInfo) {
        if (logInfo == null) {
            return;
        }
        OperationLogUtil.log(Collections.singletonList(logInfo));
    }

    public static void debugLog(AppLogInfo logInfo) {
        if (logInfo == null) {
            return;
        }
        OperationLogUtil.$log(Collections.singletonList(logInfo), 1);
    }

    public static void log(AppLogInfo ... logs) {
        OperationLogUtil.log(Arrays.asList(logs));
    }

    public static void log(List<AppLogInfo> logs) {
        OperationLogUtil.$log(logs, 0);
    }

    private static void $log(List<AppLogInfo> logs, int debug) {
        try {
            LogServiceHelper.addBatchLog(logs);
        }
        catch (Throwable ex) {
            log.warn("write-log-error:", ex);
        }
        OlapTraceServiceHelper.setTraceLog(logs);
    }

    public static Map<String, List<Map<String, Object>>> query(Set<String> traceIds) {
        if (traceIds == null || traceIds.isEmpty()) {
            return Collections.emptyMap();
        }
        HashMap<String, List<Map<String, Object>>> logsMap = new HashMap<String, List<Map<String, Object>>>(traceIds.size());
        QFBuilder builder = new QFBuilder();
        builder.add("trace", "in", traceIds);
        try (DataSet ds = QueryServiceHelper.queryDataSet((String)"queryOperationLog", (String)"epm_operationlog", (String)"id,creater.name,createtime,trace,operation,description,entitynumber", (QFilter[])builder.toArray(), null);){
            if (ds != null) {
                for (Row row : ds) {
                    List logs = logsMap.computeIfAbsent(row.getString("trace"), f -> new ArrayList());
                    logs.add(CommonServiceHelper.transDataMap(ds, row));
                }
            }
        }
        return logsMap;
    }
}

