/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.common.utils;

import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.epm.eb.common.enums.RangeEnum;
import kd.epm.eb.common.enums.SysDimensionEnum;
import kd.epm.eb.common.utils.QFBuilder;

public class OrgMemberUtils {
    public static Map<Long, DynamicObject> getSelectOrgUnits(Long modelId, List<Object[]> selOrgs) {
        HashMap<Long, DynamicObject> orgUnitMap = new HashMap<Long, DynamicObject>();
        if (modelId == null || modelId == 0L || selOrgs == null || selOrgs.isEmpty()) {
            return orgUnitMap;
        }
        HashSet<Long> _orgUnitIds = new HashSet<Long>(selOrgs.size());
        HashMap<Long, DynamicObject> tmpMap = new HashMap<Long, DynamicObject>();
        DynamicObject orgUnit = null;
        for (Object[] selOrg : selOrgs) {
            _orgUnitIds.add((Long)selOrg[0]);
        }
        QFBuilder builder = new QFBuilder();
        builder.add(new QFilter("id", "in", _orgUnitIds));
        DynamicObjectCollection _orgUnits = QueryServiceHelper.query((String)SysDimensionEnum.Entity.getMemberTreemodel(), (String)"id, name, number, longnumber, level, parent, executor, owner", (QFilter[])builder.toArrays());
        if (_orgUnits != null && !_orgUnits.isEmpty()) {
            for (DynamicObject _org : _orgUnits) {
                tmpMap.put(_org.getLong("id"), _org);
            }
        }
        int rangeValue = 0;
        for (Object[] selOrg : selOrgs) {
            orgUnit = (DynamicObject)tmpMap.get((Long)selOrg[0]);
            rangeValue = Integer.parseInt((String)selOrg[1]);
            if (RangeEnum.ONLY.getIndex() == rangeValue) {
                orgUnitMap.putAll(OrgMemberUtils.getOnly(orgUnit));
                continue;
            }
            if (RangeEnum.DIRECTSUB_EXCLUDE.getIndex() == rangeValue) {
                orgUnitMap.putAll(OrgMemberUtils.getDirectSub(modelId, orgUnit, false));
                continue;
            }
            if (RangeEnum.DIRECTSUB.getIndex() == rangeValue) {
                orgUnitMap.putAll(OrgMemberUtils.getDirectSub(modelId, orgUnit, true));
                continue;
            }
            if (RangeEnum.ALL_EXCLUDE.getIndex() == rangeValue) {
                orgUnitMap.putAll(OrgMemberUtils.getAllChild(modelId, orgUnit, false));
                continue;
            }
            if (RangeEnum.ALL.getIndex() == rangeValue) {
                orgUnitMap.putAll(OrgMemberUtils.getAllChild(modelId, orgUnit, true));
                continue;
            }
            if (RangeEnum.PEERS_EXCLUDE.getIndex() == rangeValue) {
                orgUnitMap.putAll(OrgMemberUtils.getPeers(modelId, orgUnit, false));
                continue;
            }
            if (RangeEnum.PEERS.getIndex() == rangeValue) {
                orgUnitMap.putAll(OrgMemberUtils.getPeers(modelId, orgUnit, true));
                continue;
            }
            if (RangeEnum.ALL_DETAIL.getIndex() == rangeValue) {
                orgUnitMap.putAll(OrgMemberUtils.getAllChildByDetail(modelId, orgUnit));
                continue;
            }
            if (RangeEnum.ALL_NOTDETAIL.getIndex() != rangeValue) continue;
            orgUnitMap.putAll(OrgMemberUtils.getAllChildByNotDetail(modelId, orgUnit));
        }
        return orgUnitMap;
    }

    private static Map<Long, DynamicObject> getOnly(DynamicObject orgUnit) {
        HashMap<Long, DynamicObject> orgUnitMap = new HashMap<Long, DynamicObject>();
        if (orgUnit == null) {
            return orgUnitMap;
        }
        orgUnitMap.put(orgUnit.getLong("id"), orgUnit);
        return orgUnitMap;
    }

    public static Map<Long, DynamicObject> getDirectSub(Long modelId, DynamicObject orgUnit, boolean includeSelf) {
        HashMap<Long, DynamicObject> orgUnitMap = new HashMap<Long, DynamicObject>();
        if (orgUnit == null) {
            return orgUnitMap;
        }
        QFBuilder builder = new QFBuilder();
        builder.add(new QFilter("model", "=", (Object)modelId));
        builder.add(new QFilter("longnumber", "like", (Object)(orgUnit.get("longnumber") + "!" + "%")));
        builder.add(new QFilter("level", "=", (Object)(orgUnit.getInt("level") + 1)));
        DynamicObjectCollection childs = QueryServiceHelper.query((String)SysDimensionEnum.Entity.getMemberTreemodel(), (String)"id, number, name, executor, owner", (QFilter[])builder.toArrays());
        if (childs != null) {
            for (DynamicObject child : childs) {
                orgUnitMap.put(child.getLong("id"), child);
            }
        }
        if (includeSelf) {
            orgUnitMap.put(orgUnit.getLong("id"), orgUnit);
        } else {
            orgUnitMap.remove(orgUnit.getLong("id"));
        }
        return orgUnitMap;
    }

    public static Map<Long, DynamicObject> getAllChild(Long modelId, DynamicObject orgUnit, boolean includeSelf) {
        HashMap<Long, DynamicObject> orgUnitMap = new HashMap<Long, DynamicObject>();
        if (orgUnit == null) {
            return orgUnitMap;
        }
        QFBuilder builder = new QFBuilder();
        builder.add(new QFilter("model", "=", (Object)modelId));
        builder.add(new QFilter("longnumber", "like", (Object)(orgUnit.get("longnumber") + "!" + "%")));
        DynamicObjectCollection childs = QueryServiceHelper.query((String)SysDimensionEnum.Entity.getMemberTreemodel(), (String)"id, number, name, executor, owner", (QFilter[])builder.toArrays());
        if (childs != null) {
            for (DynamicObject child : childs) {
                orgUnitMap.put(child.getLong("id"), child);
            }
        }
        if (includeSelf) {
            orgUnitMap.put(orgUnit.getLong("id"), orgUnit);
        } else {
            orgUnitMap.remove(orgUnit.getLong("id"));
        }
        return orgUnitMap;
    }

    public static Map<Long, DynamicObject> getPeers(Long modelId, DynamicObject orgUnit, boolean includeSelf) {
        HashMap<Long, DynamicObject> orgUnitMap = new HashMap<Long, DynamicObject>();
        if (orgUnit == null) {
            return orgUnitMap;
        }
        QFBuilder builder = new QFBuilder();
        builder.add(new QFilter("model", "=", (Object)modelId));
        builder.add(new QFilter("parent", "=", (Object)orgUnit.getLong("parent")));
        builder.add(new QFilter("level", "=", (Object)orgUnit.getInt("level")));
        DynamicObjectCollection childs = QueryServiceHelper.query((String)SysDimensionEnum.Entity.getMemberTreemodel(), (String)"id, number, name, executor, owner", (QFilter[])builder.toArrays());
        if (childs != null) {
            for (DynamicObject child : childs) {
                if (child.getLong("id") == orgUnit.getLong("id")) continue;
                orgUnitMap.put(child.getLong("id"), child);
            }
        }
        if (includeSelf) {
            orgUnitMap.put(orgUnit.getLong("id"), orgUnit);
        } else {
            orgUnitMap.remove(orgUnit.getLong("id"));
        }
        return orgUnitMap;
    }

    private static Map<Long, DynamicObject> getAllChildByDetail(Long modelId, DynamicObject orgUnit) {
        HashMap<Long, DynamicObject> orgUnitMap = new HashMap<Long, DynamicObject>();
        if (orgUnit == null) {
            return orgUnitMap;
        }
        QFBuilder builder = new QFBuilder();
        builder.add(new QFilter("model", "=", (Object)modelId));
        builder.add(new QFilter("longnumber", "like", (Object)(orgUnit.get("longnumber") + "!" + "%")));
        builder.add(new QFilter("isleaf", "=", (Object)1));
        DynamicObjectCollection childs = QueryServiceHelper.query((String)SysDimensionEnum.Entity.getMemberTreemodel(), (String)"id, number, name, executor, owner", (QFilter[])builder.toArrays());
        if (childs != null) {
            for (DynamicObject child : childs) {
                orgUnitMap.put(child.getLong("id"), child);
            }
        }
        return orgUnitMap;
    }

    private static Map<Long, DynamicObject> getAllChildByNotDetail(Long modelId, DynamicObject orgUnit) {
        HashMap<Long, DynamicObject> orgUnitMap = new HashMap<Long, DynamicObject>();
        if (orgUnit == null) {
            return orgUnitMap;
        }
        QFBuilder builder = new QFBuilder();
        builder.add(new QFilter("model", "=", (Object)modelId));
        builder.add(new QFilter("longnumber", "like", (Object)(orgUnit.get("longnumber") + "!" + "%")));
        builder.add(new QFilter("isleaf", "=", (Object)0));
        DynamicObjectCollection childs = QueryServiceHelper.query((String)SysDimensionEnum.Entity.getMemberTreemodel(), (String)"id, number, name, executor, owner", (QFilter[])builder.toArrays());
        if (childs != null) {
            for (DynamicObject child : childs) {
                orgUnitMap.put(child.getLong("id"), child);
            }
        }
        return orgUnitMap;
    }
}

