/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.common.utils;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.algo.DataSet;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.org.model.OrgViewTypeEnum;
import kd.epm.eb.common.model.BizOrgUnit;
import kd.epm.eb.common.utils.CommonServiceHelper;
import kd.epm.eb.common.utils.QFBuilder;
import kd.epm.eb.common.utils.StringUtils;

public class OrgUtils {
    public static final String ORG_STRUCTURE_FIELDS = "id, org.id, org.number, org.name, longnumber, isleaf, parent";

    public static DynamicObject getOrgUnit(String entityNumber, String orgUnitType, Long id) {
        return OrgUtils.getOrgUnit(entityNumber, orgUnitType, id, null);
    }

    public static Map<String, Object> queryOrgUnitMap(String entityNumber, String orgUnitType, Long id) {
        return OrgUtils.queryOrgUnitMap(entityNumber, orgUnitType, id, null);
    }

    public static DynamicObject getOrgUnit(String entityNumber, String orgUnitType, Long id, String fields) {
        if (id == null || id == 0L) {
            return null;
        }
        QFBuilder builder = new QFBuilder();
        builder.add(new QFilter("org", "=", (Object)id));
        builder.add(new QFilter("view", "=", (Object)Long.parseLong(orgUnitType)));
        return OrgUtils.getOrgUnit(entityNumber, builder, fields);
    }

    public static Map<String, Object> queryOrgUnitMap(String entityNumber, String orgUnitType, Long id, String fields) {
        if (id == null || id == 0L) {
            return null;
        }
        QFBuilder builder = new QFBuilder();
        builder.add(new QFilter("org", "=", (Object)id));
        builder.add(new QFilter("view", "=", (Object)Long.parseLong(orgUnitType)));
        return OrgUtils.queryOrgUnitMap(entityNumber, builder, fields);
    }

    public static DynamicObject getOrgUnit(String entityNumber, QFBuilder builder) {
        return OrgUtils.getOrgUnit(entityNumber, builder, null);
    }

    public static DynamicObject getOrgUnit(String entityNumber, QFBuilder builder, String fields) {
        if (StringUtils.isEmpty(entityNumber) || builder == null) {
            return null;
        }
        return BusinessDataServiceHelper.loadSingleFromCache((String)entityNumber, (String)(StringUtils.isEmpty(fields) ? ORG_STRUCTURE_FIELDS : fields), (QFilter[])builder.toArrays());
    }

    public static Map<String, Object> queryOrgUnitMap(String entityNumber, QFBuilder builder, String fields) {
        Map<String, Object> orgUnitMap = null;
        if (StringUtils.isEmpty(entityNumber) || builder == null) {
            return null;
        }
        try (DataSet ds = QueryServiceHelper.queryDataSet((String)"queryOrgUnitMap", (String)entityNumber, (String)(StringUtils.isEmpty(fields) ? ORG_STRUCTURE_FIELDS : fields), (QFilter[])builder.toArrays(), null, (int)1);){
            if (ds != null && ds.hasNext()) {
                orgUnitMap = CommonServiceHelper.transDataMap(ds);
            }
        }
        return orgUnitMap;
    }

    public static DynamicObjectCollection getOrgUnitsByNumber(String entityNumber, Integer orgUnitType, Collection<String> numbers) {
        DynamicObjectCollection orgUnits = new DynamicObjectCollection();
        if (numbers == null || numbers.isEmpty()) {
            return orgUnits;
        }
        QFBuilder builder = new QFBuilder();
        builder.add(new QFilter("org.number", "in", numbers));
        builder.add(new QFilter("view", "=", (Object)orgUnitType));
        orgUnits = OrgUtils.getOrgUnits(entityNumber, builder, ORG_STRUCTURE_FIELDS);
        return orgUnits;
    }

    public static DynamicObjectCollection getOrgUnits(String entityNumber, QFBuilder builder, String fields) {
        DynamicObjectCollection orgUnits = new DynamicObjectCollection();
        if (StringUtils.isEmpty(entityNumber) || builder == null) {
            return orgUnits;
        }
        Map _orgUnits = BusinessDataServiceHelper.loadFromCache((String)entityNumber, (String)(StringUtils.isEmpty(fields) ? ORG_STRUCTURE_FIELDS : fields), (QFilter[])builder.toArrays());
        if (_orgUnits != null && !_orgUnits.isEmpty()) {
            orgUnits.addAll(_orgUnits.values());
        }
        return orgUnits;
    }

    public static Map<String, DynamicObject> getOrgUnitMapByNums(String entityNumber, Integer orgUnitType, Collection<String> numbers) {
        HashMap<String, DynamicObject> objectMap = new HashMap<String, DynamicObject>();
        if (StringUtils.isEmpty(entityNumber) || orgUnitType == null || numbers == null || numbers.isEmpty()) {
            return objectMap;
        }
        DynamicObjectCollection objects = OrgUtils.getOrgUnitsByNumber(entityNumber, orgUnitType, numbers);
        for (DynamicObject object : objects) {
            objectMap.put(object.getString("org.number"), object);
        }
        return objectMap;
    }

    public static Collection<Map<String, Object>> queryOrgUnits(String entityNumber, QFBuilder builder) {
        List<Map<String, Object>> orgUnits = new ArrayList<Map<String, Object>>();
        if (builder == null) {
            return orgUnits;
        }
        try (DataSet ds = QueryServiceHelper.queryDataSet((String)"queryOrgUnits", (String)entityNumber, (String)ORG_STRUCTURE_FIELDS, (QFilter[])builder.toArrays(), (String)"longnumber");){
            if (ds != null) {
                orgUnits = CommonServiceHelper.transDataSet(ds);
            }
        }
        return orgUnits;
    }

    public static Set<Long> getParentIds(String entityNumber, Long orgId, boolean includeSelf, OrgViewTypeEnum orgViewType) {
        Set<Long> ids = new HashSet<Long>();
        if (StringUtils.isEmpty(entityNumber) || orgId == 0L || orgViewType == null) {
            return ids;
        }
        DynamicObject orgUnit = OrgUtils.getOrgUnit(entityNumber, orgViewType.getViewType(), orgId);
        if (orgUnit != null) {
            BizOrgUnit bizOrgUnit = new BizOrgUnit(entityNumber, orgUnit);
            ids = OrgUtils.getParentIds(entityNumber, bizOrgUnit, includeSelf, orgViewType);
        }
        return ids;
    }

    public static Set<Long> getParentIds(String entityNumber, BizOrgUnit bizOrgUnit, boolean includeSelf, OrgViewTypeEnum orgViewType) {
        HashSet<Long> ids = new HashSet<Long>();
        if (StringUtils.isEmpty(entityNumber) || bizOrgUnit == null || bizOrgUnit.getObject() == null || orgViewType == null) {
            return ids;
        }
        QFBuilder builder = new QFBuilder();
        DynamicObject orgUnit = null;
        if (StringUtils.isNotEmpty(bizOrgUnit.getLongNumber())) {
            orgUnit = bizOrgUnit.getObject();
        } else {
            builder.clear();
            builder.add(new QFilter("org", "=", (Object)bizOrgUnit.getOrgId()));
            builder.add(new QFilter("view", "=", (Object)Integer.valueOf(orgViewType.getViewType())));
            orgUnit = OrgUtils.getOrgUnit(entityNumber, builder, "org.number, longnumber");
        }
        if (orgUnit != null) {
            String[] numbers = orgUnit.getString("longnumber").split("!");
            HashSet<String> numSets = new HashSet<String>();
            if (numbers != null) {
                for (String number : numbers) {
                    numSets.add(number);
                }
                if (!includeSelf) {
                    numSets.remove(orgUnit.getString("org.number"));
                }
            }
            builder.clear();
            builder.add(new QFilter("org.number", "in", numSets));
            builder.add(new QFilter("view", "=", (Object)Long.parseLong(orgViewType.getViewType())));
            DynamicObjectCollection orgUnits = OrgUtils.getOrgUnits(entityNumber, builder, "org.id");
            if (orgUnits != null) {
                for (DynamicObject parent : orgUnits) {
                    ids.add(parent.getLong("org.id"));
                }
            }
        }
        return ids;
    }

    public static List<Map<String, Object>> queryChildren(String entityNumber, OrgViewTypeEnum orgViewType, Long orgId, boolean hasSelf) {
        ArrayList<Map<String, Object>> childrens = new ArrayList<Map<String, Object>>();
        if (orgId == null || orgId == 0L) {
            return childrens;
        }
        Map<String, Object> orgUnit = OrgUtils.queryOrgUnitMap(entityNumber, orgViewType.getViewType(), orgId);
        if (orgUnit != null) {
            if (hasSelf) {
                childrens.add(orgUnit);
            }
            QFBuilder builder = new QFBuilder();
            builder.add(new QFilter("view", "=", (Object)Long.parseLong(orgViewType.getViewType())));
            builder.add(new QFilter("longnumber", "like", (Object)(orgUnit.get("longnumber") + "!%")));
            childrens.addAll(OrgUtils.queryOrgUnits("bos_adminorg_structure", builder));
        }
        return childrens;
    }
}

