/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.common.utils.PeriodDistribution;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.exception.KDBizException;
import kd.epm.eb.common.cache.IModelCacheHelper;
import kd.epm.eb.common.cache.impl.BaseCache;
import kd.epm.eb.common.cache.impl.Member;
import kd.epm.eb.common.dimension.dimensionrelation.DimensionRelationUtils;
import kd.epm.eb.common.enums.SysDimensionEnum;
import kd.epm.eb.common.enums.dimensionEnums.MetricDataTypeEnum;
import kd.epm.eb.common.perioddistribution.domain.PeriodDisPageDomain;
import kd.epm.eb.common.perioddistribution.domain.PeriodDisPeriodInfo;
import kd.epm.eb.common.utils.StringUtils;
import org.apache.commons.collections.CollectionUtils;

public class PeriodDistributionUtils {
    public static void checkDimRelation(List<Map<String, String>> cells, IModelCacheHelper modelCache, long bizModelId, Long currPeriodId, Map<String, Set<String>> dimRelMap, List<Long> dimRelList) {
        cells.forEach(cell -> {
            boolean validRelation = DimensionRelationUtils.isValidRelation(modelCache, bizModelId, currPeriodId, cell, dimRelMap, dimRelList);
            if (!validRelation) {
                throw new KDBizException(ResManager.loadKDString((String)"\u6846\u9009\u7684\u6570\u636e\u533a\u57df\u4e0d\u5b58\u5728\u6709\u6548\u6210\u5458\uff0c\u8bf7\u91cd\u65b0\u6846\u9009\u533a\u57df\u3002", (String)"PeriodDistributionUtils_0", (String)"epm-eb-common", (Object[])new Object[0]));
            }
        });
    }

    public static PeriodDisPageDomain filterDetailMember(List<Map<String, String>> cells, Map<String, Long> dimensionView, Long datasetID, IModelCacheHelper modelCache) throws KDBizException {
        ArrayList<String[]> _cells = new ArrayList<String[]>(16);
        if (CollectionUtils.isEmpty(cells) || datasetID == null || datasetID == 0L || modelCache == null) {
            return null;
        }
        PeriodDisPageDomain pageDomain = new PeriodDisPageDomain();
        pageDomain.setDimensionView(dimensionView);
        String[] dimensionNums = modelCache.getDimensionNums(datasetID);
        PeriodDistributionUtils.putIndex(dimensionNums, pageDomain);
        for (Map<String, String> cell : cells) {
            boolean isadd = true;
            String[] membNums = new String[dimensionNums.length];
            for (int i = 0; i < dimensionNums.length; ++i) {
                String dimensionNum = dimensionNums[i];
                String memberNum = cell.get(dimensionNum);
                if (StringUtils.isEmpty(memberNum)) {
                    isadd = false;
                    continue;
                }
                Long viewId = dimensionView.get(dimensionNum);
                Member member = modelCache.getMember(dimensionNum, viewId, memberNum);
                if (!PeriodDistributionUtils.getMemberBooleanByDimNumber(dimensionNum, member)) {
                    isadd = false;
                    break;
                }
                membNums[i] = memberNum;
            }
            if (!isadd) continue;
            _cells.add(membNums);
        }
        if (_cells.isEmpty()) {
            throw new KDBizException(ResManager.loadKDString((String)"\u6846\u9009\u7684\u6570\u636e\u533a\u57df\u4e0d\u5b58\u5728\u6709\u6548\u6210\u5458\uff0c\u8bf7\u91cd\u65b0\u6846\u9009\u533a\u57df\u3002", (String)"PeriodDistributionUtils_0", (String)"epm-eb-common", (Object[])new Object[0]));
        }
        PeriodDistributionUtils.filterBperiod(_cells, modelCache, pageDomain);
        return pageDomain;
    }

    private static void putIndex(String[] dimensionNums, PeriodDisPageDomain pageDomain) {
        for (int i = 0; i < dimensionNums.length; ++i) {
            String dimensionNum = dimensionNums[i];
            if (SysDimensionEnum.BudgetPeriod.getNumber().equals(dimensionNum)) {
                pageDomain.setPeriodIndex(i);
            }
            if (!SysDimensionEnum.Metric.getNumber().equals(dimensionNum)) continue;
            pageDomain.setMetricIndex(i);
        }
    }

    private static void filterBperiod(List<String[]> cells, IModelCacheHelper modelCache, PeriodDisPageDomain pageDomain) {
        Integer periodIndex = pageDomain.getPeriodIndex();
        BaseCache mdxMember = null;
        for (String[] cell2 : cells) {
            String bpmember = cell2[periodIndex];
            Member member = modelCache.getMember(SysDimensionEnum.BudgetPeriod.getNumber(), null, bpmember);
            if (member == null || mdxMember != null && ((Member)mdxMember).getLevel() <= member.getLevel()) continue;
            mdxMember = member;
        }
        if (mdxMember == null) {
            throw new KDBizException(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u5b8c\u6574\u7684\u7ef4\u5ea6\u6210\u5458\u3002", (String)"PeriodDistributionUtils_1", (String)"epm-eb-common", (Object[])new Object[0]));
        }
        String topPeriodNumber = mdxMember.getNumber();
        pageDomain.setTopPeriodNumber(topPeriodNumber);
        ArrayList<PeriodDisPeriodInfo> periodInfos = new ArrayList(16);
        for (Member member : ((Member)mdxMember).getAllMembers()) {
            if (!member.isLeaf() || member.getNumber().endsWith("._inv")) continue;
            PeriodDisPeriodInfo periodInfo = new PeriodDisPeriodInfo();
            String number = member.getNumber();
            periodInfo.setNumber(number);
            String period = org.apache.commons.lang3.StringUtils.substringAfterLast((String)number, (String)"M");
            int periodInteger = Integer.parseInt(period);
            periodInfo.setSuff(periodInteger);
            periodInfos.add(periodInfo);
        }
        periodInfos = periodInfos.stream().sorted(Comparator.comparing(PeriodDisPeriodInfo::getSuff)).collect(Collectors.toList());
        pageDomain.setPeriodInfos(periodInfos);
        cells = cells.stream().filter(cell -> topPeriodNumber.equals(cell[periodIndex])).collect(Collectors.toList());
        pageDomain.setCells(cells);
    }

    private static boolean getMemberBooleanByDimNumber(String dimensionNum, Member member) {
        if (member == null) {
            return false;
        }
        if (SysDimensionEnum.BudgetPeriod.getNumber().equals(dimensionNum)) {
            return !member.isLeaf();
        }
        if (SysDimensionEnum.ChangeType.getNumber().equals(dimensionNum)) {
            return member.hasPeriodDistribution();
        }
        if (SysDimensionEnum.Metric.getNumber().equals(dimensionNum)) {
            return MetricDataTypeEnum.CURRENCY.getIndex().equals(member.getDatatype()) || MetricDataTypeEnum.NONMONETARY.getIndex().equals(member.getDatatype()) || MetricDataTypeEnum.RATE.getIndex().equals(member.getDatatype());
        }
        if (SysDimensionEnum.DataType.getNumber().equals(dimensionNum)) {
            return member.isLeaf() && !"Actual".equals(member.getNumber());
        }
        if (member.isAnalyzeMember()) {
            return false;
        }
        return member.isLeaf();
    }

    public static List<Map<String, Object>> getSubMenus() {
        LinkedList<Map<String, Object>> subMenus = new LinkedList<Map<String, Object>>();
        HashMap<String, String> subMenu1 = new HashMap<String, String>();
        subMenu1.put("text", ResManager.loadKDString((String)"\u5e73\u5747\u5206\u5e03", (String)"PeriodDistributionUtils_8", (String)"epm-eb-formplugin", (Object[])new Object[0]));
        subMenu1.put("name", "periodDistributionAverage");
        HashMap<String, String> subMenu2 = new HashMap<String, String>();
        subMenu2.put("text", ResManager.loadKDString((String)"\u6bd4\u4f8b\u5206\u5e03", (String)"PeriodDistributionUtils_9", (String)"epm-eb-formplugin", (Object[])new Object[0]));
        subMenu2.put("name", "periodDistributionRate");
        subMenus.add(subMenu1);
        subMenus.add(subMenu2);
        return subMenus;
    }
}

