/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.common.utils;

import com.google.common.collect.Sets;
import java.sql.Timestamp;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.exception.KDBizException;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.util.StringUtils;
import kd.epm.eb.common.constant.SysMembConstant;
import kd.epm.eb.common.utils.QFBuilder;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.commons.lang3.tuple.Triple;

public class PeriodUtils {
    private static final String[] array = new String[]{"M_", "Q_", "YD_", "YW_", "HF_"};
    public static final String P_M_01_PREFIX = "M_M";
    public static final String P_YD_M_PREFIX = "YD_M";
    public static final String P_YD_D_PREFIX = "YD_D";
    public static final String P_M_Q1_PREFIX = "M_Q";
    public static final String P_M_HF1_PREFIX = "M_HF";
    public static final String P_Q_HF1_PREFIX = "Q_HF";
    public static final String P_Q_Q1_PREFIX = "Q_Q";
    public static final String P_HF_HF1_PREFIX = "HF_HF";
    public static final String NOT_STANDARD_PERIOD = "not_standard_period";
    public static final String FY_PREFIX = "FY";
    public static final Set<String> Standard_Period = Collections.unmodifiableSet(Sets.newHashSet((Object[])new String[]{"M_M", "M_Q", "M_HF", "Q_HF", "Q_Q", "HF_HF", "YD_M", "YD_D"}));
    private static final int[] dayofMonth = new int[SysMembConstant.dayofMonth.size()];
    public static final DateTimeFormatter df = DateTimeFormatter.ofPattern("yyyy-MM-dd");

    public static String formatDate(Date date) {
        return PeriodUtils.formatDate(date, df);
    }

    public static String formatDate(Date date, DateTimeFormatter df) {
        LocalDateTime datetime = LocalDateTime.ofInstant(date.toInstant(), ZoneId.systemDefault());
        return datetime.format(df);
    }

    public static boolean isStandardPeriod(String period) {
        if (StringUtils.isEmpty((String)period)) {
            return false;
        }
        return Standard_Period.stream().anyMatch(p -> period.startsWith((String)p));
    }

    public static String getPeriodType(String period) {
        for (String pf : Standard_Period) {
            if (!period.startsWith(pf)) continue;
            return pf;
        }
        return NOT_STANDARD_PERIOD;
    }

    public static int trans2IntPeriod(String period) {
        if (!PeriodUtils.isStandardPeriod(period)) {
            throw new KDBizException(String.format("%s is not standard period prefix,can't trans to int value!", period));
        }
        int periodInt = 0;
        for (String pf : Standard_Period) {
            if (!period.startsWith(pf)) continue;
            periodInt = Integer.parseInt(period.substring(pf.length()));
        }
        return periodInt;
    }

    public static Optional<String> getLastPeriod(String modelNum, String periodNum, boolean isIncludeAdjPeriod) {
        String lastPeriod = null;
        for (int i = 0; i < SysMembConstant.dayofMonth.size(); ++i) {
            PeriodUtils.dayofMonth[i] = SysMembConstant.dayofMonth.get(i);
        }
        try {
            boolean isYD_Day = periodNum.startsWith("YD_");
            String[] splitArr = PeriodUtils.splitPeriod(periodNum);
            if (PeriodUtils.isFirstPeriod(periodNum)) {
                if (!isYD_Day && isIncludeAdjPeriod) {
                    QFBuilder qf = new QFBuilder();
                    qf.add("number", "like", splitArr[0] + "%");
                    qf.add("model.number", "=", modelNum);
                    DynamicObjectCollection coll = QueryServiceHelper.query((String)"epm_periodmembertree", (String)"number", (QFilter[])qf.toArray(), (String)"number desc", (int)1);
                    if (coll.size() > 0) {
                        lastPeriod = ((DynamicObject)coll.get(0)).getString("number");
                    }
                } else {
                    lastPeriod = PeriodUtils.transLastPeriod(splitArr[0]);
                }
            } else {
                if (isYD_Day) {
                    if (P_YD_M_PREFIX.equals(splitArr[0])) {
                        lastPeriod = String.format("%02d", Integer.parseInt(splitArr[1]) - 1);
                    } else if (P_YD_D_PREFIX.equals(splitArr[0])) {
                        int mouth = Integer.parseInt(splitArr[1].substring(0, 2));
                        int day = Integer.parseInt(splitArr[1].substring(2));
                        if (--day == 0) {
                            day = dayofMonth[--mouth];
                        }
                        lastPeriod = String.format("%02d%02d", mouth, day);
                    }
                    return Optional.ofNullable(splitArr[0] + lastPeriod);
                }
                int intPeriod = Integer.parseInt(splitArr[1]);
                intPeriod = intPeriod > 12 && P_M_01_PREFIX.equals(splitArr[0]) ? 11 : (intPeriod > 4 && P_Q_Q1_PREFIX.equals(splitArr[0]) ? 3 : (intPeriod > 2 && P_HF_HF1_PREFIX.equals(splitArr[0]) ? 1 : --intPeriod));
                lastPeriod = PeriodUtils.combiePeriod(intPeriod, splitArr[0]);
            }
            return Optional.ofNullable(lastPeriod);
        }
        catch (NumberFormatException e) {
            lastPeriod = null;
            return Optional.ofNullable(lastPeriod);
        }
    }

    public static String getLastPeriodElseThrowException(String modelNum, String periodNum, boolean isIncludeAdjPeriod) {
        String lastPeriod = PeriodUtils.getLastPeriod(modelNum, periodNum, isIncludeAdjPeriod).orElse(null);
        if (lastPeriod != null) {
            return lastPeriod;
        }
        throw new KDBizException(ResManager.loadKDString((String)"\u5f53\u524d\u671f\u95f4\u5df2\u7ecf\u662f\u8be5\u4f53\u7cfb\u6700\u65e9\u7684\u671f\u95f4\u3002", (String)"PeriodUtils_0", (String)"epm-eb-common", (Object[])new Object[0]));
    }

    public static Optional<String> getLastYear(String modelNum, String fyNum) {
        int year = Integer.parseInt(fyNum.substring(FY_PREFIX.length()));
        String lastFY = FY_PREFIX + --year;
        if (!QueryServiceHelper.exists((String)"epm_yearmembertree", (QFilter[])new QFBuilder().add("number", "=", lastFY).add("model.number", "=", modelNum).toArray())) {
            lastFY = null;
        }
        return Optional.ofNullable(lastFY);
    }

    public static Optional<String> getNextYear(String modelNum, String fyNum) {
        int year = Integer.parseInt(fyNum.substring(FY_PREFIX.length()));
        String lastFY = FY_PREFIX + ++year;
        if (!QueryServiceHelper.exists((String)"epm_yearmembertree", (QFilter[])new QFBuilder().add("number", "=", lastFY).add("model.number", "=", modelNum).toArray())) {
            lastFY = null;
        }
        return Optional.ofNullable(lastFY);
    }

    public static String[] getLastPeriodIncludeYear(String modelNum, String currFYNum, String currPeriodNum, boolean isIncludeAdjPeriod) {
        Optional<String> lastPeriod = PeriodUtils.getLastPeriod(modelNum, currPeriodNum, isIncludeAdjPeriod);
        String periodNum = lastPeriod.orElse(null);
        if (PeriodUtils.isFirstPeriod(currPeriodNum)) {
            Optional<String> year = PeriodUtils.getLastYear(modelNum, currFYNum);
            return new String[]{year.orElse(null), periodNum};
        }
        return new String[]{currFYNum, periodNum};
    }

    private static String transLastPeriod(String periodPrefix) {
        switch (periodPrefix) {
            case "YD_M": 
            case "M_M": {
                return periodPrefix + "12";
            }
            case "YD_D": {
                return periodPrefix + "1231";
            }
            case "M_Q": {
                return periodPrefix + "4";
            }
            case "M_HF": {
                return periodPrefix + "2";
            }
            case "Q_HF": {
                return periodPrefix + "2";
            }
            case "Q_Q": {
                return periodPrefix + "4";
            }
            case "HF_HF": {
                return periodPrefix + "2";
            }
        }
        throw new KDBizException("not support Period" + periodPrefix);
    }

    public static boolean isFirstPeriod(String periodNum) {
        return "M_M01".equals(periodNum) || "M_Q1".equals(periodNum) || "M_HF1".equals(periodNum) || "Q_HF1".equals(periodNum) || "Q_Q1".equals(periodNum) || "HF_HF1".equals(periodNum) || "YD_M01".equals(periodNum) || "YD_D0101".equals(periodNum);
    }

    public static String[] splitPeriod(String periodNum) {
        char[] chars = periodNum.toCharArray();
        int from = 0;
        for (int i = 0; i < chars.length; ++i) {
            from = i;
            if (Character.isDigit(chars[i])) break;
        }
        return new String[]{periodNum.substring(0, from), periodNum.substring(from)};
    }

    public static int splitPeriod2Int(String periodNum) {
        char[] chars = periodNum.toCharArray();
        int from = 0;
        for (int i = 0; i < chars.length; ++i) {
            from = i;
            if (Character.isDigit(chars[i])) break;
        }
        return Integer.parseInt(new String(Arrays.copyOfRange(chars, from, chars.length)));
    }

    public static String splitPeriod2AllInt(String periodNum) {
        char[] chars = periodNum.toCharArray();
        int from = 0;
        for (int i = 0; i < chars.length; ++i) {
            from = i;
            if (Character.isDigit(chars[i])) break;
        }
        return new String(Arrays.copyOfRange(chars, from, chars.length));
    }

    public static String combiePeriod(int intPeriod, String periodPrefix) {
        switch (periodPrefix) {
            case "M_M": {
                return String.format("%s%s", periodPrefix, intPeriod < 10 ? "0" + intPeriod : "" + intPeriod);
            }
        }
        return String.format("%s%d", periodPrefix, intPeriod);
    }

    public static Date[] calcStartAndEndDate(long modelId, long fyId, long periodId) {
        DynamicObject fy = BusinessDataServiceHelper.loadSingleFromCache((String)"epm_yearmembertree", (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)fyId)});
        String yearNum = fy.getString("number");
        return PeriodUtils.calcStartAndEndDate(yearNum, periodId);
    }

    public static Date[] calcStartAndEndDate(String yearNum, long periodId) {
        DynamicObject period = BusinessDataServiceHelper.loadSingleFromCache((String)"epm_periodmembertree", (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)periodId)});
        int year = Integer.parseInt(yearNum.substring(2));
        int startMonth = period.getInt("effmonth");
        int endMonth = period.getInt("expmonth");
        int startDay = period.getInt("effday");
        int endDay = period.getInt("expday");
        return new Date[]{PeriodUtils.calcDate(year, startMonth, startDay), PeriodUtils.calcDate(year, endMonth, endDay)};
    }

    public static Date[] calcStartAndEndDate(long modelId, String yearNum, String periodNum) {
        DynamicObject period = BusinessDataServiceHelper.loadSingleFromCache((String)"epm_periodmembertree", (QFilter[])new QFilter[]{new QFilter("model", "=", (Object)modelId), new QFilter("number", "=", (Object)periodNum)});
        int year = Integer.parseInt(yearNum.substring(2));
        int startMonth = period.getInt("effmonth");
        int endMonth = period.getInt("expmonth");
        int startDay = period.getInt("effday");
        int endDay = period.getInt("expday");
        return new Date[]{PeriodUtils.calcDate(year, startMonth, startDay), PeriodUtils.calcDate(year, endMonth, endDay)};
    }

    private static Date calcDate(int year, int month, int day) {
        if (month == 2 && day == 29 && !PeriodUtils.isLeapYear(year)) {
            day = 28;
        }
        LocalDate localDate = LocalDate.of(year, month, day);
        ZonedDateTime zonedDateTime = localDate.atStartOfDay(ZoneId.systemDefault());
        Instant instant1 = zonedDateTime.toInstant();
        Date from = Date.from(instant1);
        return from;
    }

    public static boolean isLeapYear(int year) {
        return year % 4 == 0 && year % 100 != 0 || year % 400 == 0;
    }

    public static Pair<Long, Long> getDateMilliScope(String yearNum, long periodId) {
        Triple<Date, Date, Date> peiodStartEndAndYearStartDate = PeriodUtils.getPeiodStartEndAndYearStartDate(yearNum, periodId);
        return Pair.of((Object)((Date)peiodStartEndAndYearStartDate.getMiddle()).getTime(), (Object)((Date)peiodStartEndAndYearStartDate.getRight()).getTime());
    }

    public static Triple<Date, Date, Date> getPeiodStartEndAndYearStartDate(String yearNum, long periodId) {
        DynamicObject periodDyn = BusinessDataServiceHelper.loadSingleFromCache((String)"epm_periodmembertree", (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)periodId)});
        Calendar calendar = Calendar.getInstance();
        calendar.set(Integer.parseInt(yearNum), periodDyn.getInt("effmonth") - 1, periodDyn.getInt("effday"), 0, 0, 0);
        Timestamp startDate = new Timestamp(calendar.getTimeInMillis());
        startDate.setNanos(0);
        int expday = periodDyn.getInt("expday");
        expday = periodDyn.getInt("expmonth") == 2 && expday == 29 && !PeriodUtils.isLeapYear(Integer.parseInt(yearNum)) ? 28 : expday;
        calendar.set(Integer.parseInt(yearNum), periodDyn.getInt("expmonth") - 1, expday, 23, 59, 59);
        Timestamp endDate = new Timestamp(calendar.getTimeInMillis());
        endDate.setNanos(999);
        calendar.set(Integer.parseInt(yearNum), 0, 1, 0, 0, 0);
        Timestamp yearStartDate = new Timestamp(calendar.getTimeInMillis());
        yearStartDate.setNanos(0);
        return Triple.of((Object)yearStartDate, (Object)startDate, (Object)endDate);
    }

    public static boolean hasSystemPrefix(String number) {
        for (String prefix : array) {
            if (!number.startsWith(prefix)) continue;
            return true;
        }
        return false;
    }

    public static Date getPeriodLastDate(String yearNum, Long periodId) {
        String year = yearNum.substring(2);
        DynamicObject periodDyn = BusinessDataServiceHelper.loadSingleFromCache((Object)periodId, (String)"epm_periodmembertree");
        String month = periodDyn.getString("expmonth");
        String day = periodDyn.getString("expday");
        return PeriodUtils.getDate(Integer.parseInt(year), Integer.parseInt(month) - 1, Integer.parseInt(day));
    }

    public static Date getPeriodLastDate(Long yearId, Long periodId) {
        DynamicObject yearDyn = BusinessDataServiceHelper.loadSingleFromCache((Object)yearId, (String)"epm_yearmembertree");
        return PeriodUtils.getPeriodLastDate(yearDyn.getString("number"), periodId);
    }

    public static Date getPeriodLastDate(long modelid, String yearNum, String periodNum) {
        QFilter qf = new QFilter("number", "=", (Object)periodNum);
        QFilter modelQf = new QFilter("model", "=", (Object)modelid);
        DynamicObject periodDyn = BusinessDataServiceHelper.loadSingleFromCache((String)"epm_periodmembertree", (String)"expmonth,expday", (QFilter[])new QFilter[]{qf, modelQf});
        String month = periodDyn.getString("expmonth");
        String day = periodDyn.getString("expday");
        return PeriodUtils.getDate(Integer.parseInt(yearNum.substring(2)), Integer.parseInt(month) - 1, Integer.parseInt(day));
    }

    public static Date getDate(int year, int month, int day) {
        Calendar cal = Calendar.getInstance();
        cal.set(year, month, day, 0, 0, 0);
        cal.set(14, 0);
        if (cal.get(2) > month) {
            cal.add(5, -1);
        }
        return cal.getTime();
    }

    public static List<String> getPeriodListByCurPeriod(String preiod, String periodType, Boolean isEb) {
        ArrayList<String> periodList;
        block6: {
            String monthFlag;
            String prefix;
            block7: {
                int month;
                block5: {
                    String[] split;
                    prefix = "";
                    String monthStr = "";
                    monthFlag = ".M";
                    periodList = new ArrayList<String>();
                    if (isEb.booleanValue()) {
                        split = preiod.split("_");
                        prefix = preiod.contains(FY_PREFIX) ? split[0] + "_" + split[1] : split[0];
                        monthStr = preiod.contains(FY_PREFIX) ? split[2] : split[1];
                        monthFlag = "_M";
                    } else {
                        split = preiod.split("\\.");
                        prefix = split[0];
                        monthStr = split[1];
                        monthFlag = ".M";
                    }
                    month = Integer.parseInt(monthStr.replace("M", ""));
                    if (!"quarter".equals(periodType)) break block5;
                    int quarter = (int)Math.ceil((double)month / 3.0);
                    for (int i = 1; i <= 3; ++i) {
                        String m = prefix + monthFlag + ((quarter - 1) * 3 + i <= 9 ? "0" + ((quarter - 1) * 3 + i) : Integer.valueOf((quarter - 1) * 3 + i));
                        periodList.add(m);
                    }
                    break block6;
                }
                if (!"halfyear".equals(periodType)) break block7;
                int halfYear = (int)Math.ceil((double)month / 6.0);
                for (int i = 1; i <= 6; ++i) {
                    String m = prefix + monthFlag + ((halfYear - 1) * 6 + i <= 9 ? "0" + ((halfYear - 1) * 6 + i) : Integer.valueOf((halfYear - 1) * 6 + i));
                    periodList.add(m);
                }
                break block6;
            }
            if (!"year".equals(periodType)) break block6;
            for (int i = 1; i <= 12; ++i) {
                String m = prefix + monthFlag + (i <= 9 ? "0" + i : Integer.valueOf(i));
                periodList.add(m);
            }
        }
        return periodList;
    }
}

