/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.common.utils;

import java.lang.reflect.Field;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.form.IFormView;
import kd.bos.form.IPageCache;
import kd.bos.orm.util.ReflectionUtils;

public class PluginInitHelper {
    private IFormView formView;

    public PluginInitHelper(IFormView formView) {
        this.formView = formView;
    }

    public IFormView getView() {
        return this.formView;
    }

    public boolean initView(Object plugin) {
        try {
            Field formview_field = this.getField(plugin.getClass(), "formView");
            Field dataModel_field = this.getField(plugin.getClass(), "dataModel");
            Field pageCache_field = this.getField(plugin.getClass(), "pageCache");
            if (formview_field != null) {
                formview_field.set(plugin, this.getView());
            }
            if (dataModel_field != null) {
                dataModel_field.set(plugin, this.getView().getService(IDataModel.class));
            }
            if (pageCache_field != null) {
                pageCache_field.set(plugin, this.getView().getService(IPageCache.class));
            }
            return true;
        }
        catch (Exception exception) {
            return false;
        }
    }

    private Field getField(Class parent, String fieldname) {
        try {
            if (parent.equals(Object.class)) {
                return null;
            }
            Field field = parent.getDeclaredField(fieldname);
            if (field != null) {
                ReflectionUtils.makeAccessible((Field)field);
            }
            return field;
        }
        catch (Exception e) {
            return this.getField(parent.getSuperclass(), fieldname);
        }
    }
}

