/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.common.utils;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import kd.bos.orm.query.QFilter;
import kd.epm.eb.common.utils.StringUtils;

public class QFBuilder {
    private final List<QFilter> filters = new ArrayList<QFilter>(32);

    public List<QFilter> getFilters() {
        return Collections.unmodifiableList(this.filters);
    }

    public QFBuilder() {
    }

    public QFBuilder(String field, String qc, Object val) {
        this.filters.add(new QFilter(field, qc, val));
    }

    public QFBuilder(QFilter filter) {
        if (filter != null) {
            this.filters.add(filter);
        }
    }

    public QFBuilder add(QFilter filter) {
        if (filter != null) {
            this.filters.add(filter);
        }
        return this;
    }

    public QFBuilder retainOrAdd(QFilter filter) {
        if (filter == null) {
            return this;
        }
        boolean retain = false;
        for (QFilter _filter : this.filters) {
            boolean exist = StringUtils.equals(_filter.getProperty(), filter.getProperty());
            if (!exist || !_filter.getNests(true).isEmpty() || !(_filter.getValue() instanceof Collection) || !(filter.getValue() instanceof Collection)) continue;
            Collection _collection1 = (Collection)_filter.getValue();
            Collection _collection2 = (Collection)filter.getValue();
            _collection1.retainAll(_collection2);
            retain = true;
            break;
        }
        if (!retain) {
            this.add(filter);
        }
        return this;
    }

    public QFBuilder add(List<QFilter> filters) {
        if (filters != null && !filters.isEmpty()) {
            this.filters.addAll(filters);
        }
        return this;
    }

    public QFBuilder add(String field, String qc, Object value) {
        this.filters.add(new QFilter(field, qc, value));
        return this;
    }

    public QFilter[] toArrays() {
        return this.filters.toArray(new QFilter[0]);
    }

    public void clear() {
        this.filters.clear();
    }

    public QFBuilder or(String field, String qc, Object val) {
        this.filters.get(this.filters.size() - 1).or(new QFilter(field, qc, val));
        return this;
    }

    public QFBuilder or(QFilter qFilter) {
        this.filters.get(this.filters.size() - 1).or(qFilter);
        return this;
    }

    public QFBuilder and(String field, String qc, Object val) {
        if (this.filters.isEmpty()) {
            this.add(field, qc, val);
        } else {
            this.filters.add(new QFilter(field, qc, val));
        }
        return this;
    }

    public QFBuilder remove(String field) {
        if (this.filters.isEmpty() || field == null) {
            return this;
        }
        ArrayList<QFilter> removes = new ArrayList<QFilter>();
        for (QFilter _filter : this.filters) {
            if (!field.equalsIgnoreCase(_filter.getProperty())) continue;
            removes.add(_filter);
        }
        if (!removes.isEmpty()) {
            this.filters.removeAll(removes);
        }
        return this;
    }

    public QFilter[] toArray() {
        return this.filters.toArray(new QFilter[0]);
    }

    public List<QFilter> toList() {
        return Arrays.asList(this.toArray());
    }

    public QFilter toFilter() {
        QFilter filter = null;
        for (QFilter _filter : this.filters) {
            if (filter == null) {
                filter = _filter.copy();
                continue;
            }
            filter.and(_filter);
        }
        return filter;
    }

    public static QFBuilder newQFilter() {
        return new QFBuilder();
    }

    public String toString() {
        QFilter filter = this.toFilter();
        if (filter != null) {
            return filter.toString();
        }
        return super.toString();
    }
}

