/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.common.utils;

import java.util.List;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.epm.eb.common.enums.SysDimensionEnum;
import kd.epm.eb.common.utils.StringUtils;

public class RollBudgetServiceHelper {
    private static final RollBudgetServiceHelper instance = new RollBudgetServiceHelper();

    private RollBudgetServiceHelper() {
    }

    public static RollBudgetServiceHelper getInstance() {
        return instance;
    }

    public DynamicObject queryOneRecord(Long rollconfigId, Long modelId) {
        QFilter qFilter = new QFilter("rollconfig", "=", (Object)rollconfigId);
        qFilter.and(new QFilter("model", "=", (Object)modelId));
        DynamicObject rollinitrecord = QueryServiceHelper.queryOne((String)"eb_rollinitrecord", (String)"id", (QFilter[])new QFilter[]{qFilter});
        return rollinitrecord;
    }

    public List<Long> queryTemplateById(Long id, Long modelId) {
        QFilter q1 = new QFilter("id", "=", (Object)id);
        QFilter q2 = new QFilter("model", "=", (Object)modelId);
        DynamicObjectCollection rolltemList = QueryServiceHelper.query((String)"eb_rollconfig", (String)"id, rolltemplate.id, rolltemplate.fbasedataid_id", (QFilter[])new QFilter[]{q1.and(q2)});
        List<Long> list = rolltemList.stream().filter(item -> StringUtils.isNotEmpty(item.getString("rolltemplate.id"))).map(item -> item.getLong("rolltemplate.fbasedataid_id")).collect(Collectors.toList());
        return list;
    }

    public DynamicObjectCollection queryRollConfigByModelId(Long modelId) {
        QFilter qFilter1 = new QFilter("model", "=", (Object)modelId);
        DynamicObjectCollection rollList = QueryServiceHelper.query((String)"eb_rollconfig", (String)"id", (QFilter[])new QFilter[]{qFilter1});
        return rollList;
    }

    public DynamicObjectCollection getInitRecords(List<Long> ids) {
        QFilter q0 = new QFilter("id", "in", (Object)ids.toArray());
        DynamicObjectCollection rollinitrecordList = QueryServiceHelper.query((String)"eb_rollinitrecord", (String)"rollconfig.id, id", (QFilter[])new QFilter[]{q0});
        return rollinitrecordList;
    }

    public DynamicObject getDataType(Long modelId, String periodNumber) {
        return BusinessDataServiceHelper.loadSingle((String)SysDimensionEnum.DataType.getMemberTreemodel(), (String)"id,number,name,longnumber,parent", (QFilter[])new QFilter[]{new QFilter("model", "=", (Object)modelId), new QFilter("longnumber", "like", (Object)"DataType!RollBudget!%"), new QFilter("number", "like", (Object)(periodNumber + "%")), new QFilter("isleaf", "=", (Object)Boolean.TRUE)});
    }

    public DynamicObjectCollection queryRecordByConfigIds(List<Long> ids) {
        QFilter q0 = new QFilter("id", "in", (Object)ids.toArray());
        DynamicObjectCollection rollinitrecord = QueryServiceHelper.query((String)"eb_rollinitrecord", (String)"id, model,entry_trial.trial,entry_trial.source", (QFilter[])new QFilter[]{q0}, (String)"executedate desc");
        return rollinitrecord;
    }
}

