/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.common.utils;

import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.form.IFormView;
import kd.bos.orm.query.QFilter;
import kd.epm.eb.common.enums.SaveCheckTypeEnum;
import kd.epm.eb.common.utils.NumberCheckUtils;
import kd.epm.eb.common.utils.StringUtils;

public interface SaveCheck {
    public IFormView getView();

    public Long getModelId();

    default public String saveValidate() {
        String result = null;
        List<String> allCheckTypes = this.getAllCheckTypes();
        String name = this.getNameValue();
        String number = this.getNumberValue();
        for (String allCheckType : allCheckTypes) {
            SaveCheckTypeEnum checkType = SaveCheckTypeEnum.getCheckTypeByKey(allCheckType);
            if (checkType == null) {
                result = this.validate(allCheckType);
            } else {
                switch (checkType) {
                    case EMPTY_CHECK: {
                        if (!this.isBlank(name) && !this.isBlank(number)) break;
                        result = ResManager.loadKDString((String)"\u540d\u79f0\u6216\u7f16\u7801\u4e0d\u5141\u8bb8\u4e3a\u7eaf\u7a7a\u683c\u3002", (String)"SaveCheck_0", (String)"epm-eb-common", (Object[])new Object[0]);
                        break;
                    }
                    case NUMBER_VALID: {
                        result = NumberCheckUtils.checkNumberRule(number);
                        break;
                    }
                    case NUMBER_REPEAT: {
                        QFilter qFilter = new QFilter(this.getNumberField(), "=", (Object)number);
                        qFilter.and(this.getModelField(), "=", (Object)this.getModelId());
                        QFilter qf = this.getExtraFilter();
                        if (qf != null) {
                            qFilter.and(qf);
                        }
                        if (!NumberCheckUtils.checkNumberExist(this.getEntityId(), new QFilter[]{qFilter}, this.getPkId())) break;
                        result = ResManager.loadKDString((String)"\u7f16\u7801\u5df2\u5b58\u5728\uff0c\u8bf7\u91cd\u65b0\u8f93\u5165\u3002", (String)"SaveCheck_1", (String)"epm-eb-common", (Object[])new Object[0]);
                    }
                }
            }
            if (!StringUtils.isNotEmpty(result)) continue;
            break;
        }
        return result;
    }

    default public QFilter getExtraFilter() {
        return null;
    }

    default public String getEntityId() {
        return this.getView().getEntityId();
    }

    default public Long getPkId() {
        return null;
    }

    default public boolean isBlank(String checkStr) {
        return StringUtils.isEmpty(checkStr) || StringUtils.isEmpty(checkStr.trim());
    }

    default public String getNameValue() {
        IDataModel model = this.getView().getModel();
        return model.getValue(this.getNameField()).toString();
    }

    default public String getNameField() {
        return "name";
    }

    default public String getNumberValue() {
        IDataModel model = this.getView().getModel();
        return model.getValue(this.getNumberField()).toString();
    }

    default public String getNumberField() {
        return "number";
    }

    default public String getModelField() {
        return "model";
    }

    default public String validate(String allCheckType) {
        return null;
    }

    default public List<String> getAllCheckTypes() {
        return this.getBaseCheckTypes();
    }

    default public List<String> getBaseCheckTypes() {
        return Arrays.stream(SaveCheckTypeEnum.values()).map(SaveCheckTypeEnum::getCheckKey).collect(Collectors.toList());
    }
}

