/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.common.utils;

import java.util.Collection;
import kd.epm.eb.common.enums.SpreadSelectTypeEnum;
import kd.epm.eb.common.utils.RangeModel;

public class SpreadAreaUtil {
    public static boolean isInArea(String selector, String area) {
        return SpreadAreaUtil.getRangModel(selector).checkIsInArea(SpreadAreaUtil.getRangModel(area));
    }

    public static Collection<String> getRow(String area) {
        return SpreadAreaUtil.getRangModel(area).spiltToRow();
    }

    public static Collection<String> getCol(String area) {
        return SpreadAreaUtil.getRangModel(area).spiltToCol();
    }

    public static String getRowGreen(String area) {
        return String.valueOf(SpreadAreaUtil.getRangModel(area).getYStart() + 1);
    }

    public static int[] getGreenIndex(String area) {
        RangeModel rangeModel = SpreadAreaUtil.getRangModel(area);
        int[] indexs = new int[]{rangeModel.getXStart(), rangeModel.getYStart(), rangeModel.getXEnd(), rangeModel.getYEnd()};
        return indexs;
    }

    public static SpreadSelectTypeEnum selectedInArea(String select, String startpoint, String area) {
        RangeModel area_startpoint;
        RangeModel startpoint_coordinate = SpreadAreaUtil.getRangModel(startpoint);
        RangeModel select_coordinate = SpreadAreaUtil.getRangModel(select);
        if (!select_coordinate.checkIsInArea(area_startpoint = SpreadAreaUtil.getRangModel(area))) {
            return SpreadSelectTypeEnum.NOT_IN;
        }
        if (select_coordinate.getXEnd() < startpoint_coordinate.getXStart()) {
            if (select_coordinate.getYEnd() < startpoint_coordinate.getYStart()) {
                return SpreadSelectTypeEnum.LEFT_TOP;
            }
            if (select_coordinate.getYStart() > startpoint_coordinate.getYEnd()) {
                return SpreadSelectTypeEnum.LEFT_BOTTOM;
            }
        } else if (select_coordinate.getXStart() > startpoint_coordinate.getXEnd()) {
            if (select_coordinate.getYEnd() < startpoint_coordinate.getYStart()) {
                return SpreadSelectTypeEnum.RIGHT_TOP;
            }
            if (select_coordinate.getYStart() > startpoint_coordinate.getYEnd()) {
                return SpreadSelectTypeEnum.RIGHT__BOTTOM;
            }
        }
        return SpreadSelectTypeEnum.ILLEGAL;
    }

    public static RangeModel getRangModel(String coordinate) {
        return new RangeModel(coordinate);
    }

    public static boolean isUpArea(String area1, String area2) {
        RangeModel a1 = new RangeModel(area1);
        RangeModel a2 = new RangeModel(area2);
        return a1.getYEnd() < a2.getYStart();
    }

    public static boolean isLeftArea(String area1, String area2) {
        RangeModel a1 = new RangeModel(area1);
        RangeModel a2 = new RangeModel(area2);
        return a1.getXEnd() < a2.getXStart();
    }

    public static SpreadSelectTypeEnum selectedInCanFloatArea(String select, String startpoint, String area) {
        RangeModel area_startpoint;
        area = "A1:" + area.split(":")[1];
        RangeModel startpoint_coordinate = SpreadAreaUtil.getRangModel(startpoint);
        RangeModel select_coordinate = SpreadAreaUtil.getRangModel(select);
        if (!select_coordinate.checkIsInArea(area_startpoint = SpreadAreaUtil.getRangModel(area))) {
            return SpreadSelectTypeEnum.NOT_IN;
        }
        if (select_coordinate.getXEnd() < startpoint_coordinate.getXStart()) {
            if (select_coordinate.getYEnd() < startpoint_coordinate.getYStart()) {
                return SpreadSelectTypeEnum.LEFT_TOP;
            }
            if (select_coordinate.getYStart() >= startpoint_coordinate.getYEnd()) {
                return SpreadSelectTypeEnum.LEFT_BOTTOM;
            }
        } else if (select_coordinate.getXStart() >= startpoint_coordinate.getXEnd()) {
            if (select_coordinate.getYEnd() < startpoint_coordinate.getYStart()) {
                return SpreadSelectTypeEnum.RIGHT_TOP;
            }
            if (select_coordinate.getYStart() > startpoint_coordinate.getYEnd()) {
                return SpreadSelectTypeEnum.RIGHT__BOTTOM;
            }
        }
        return SpreadSelectTypeEnum.ILLEGAL;
    }

    public static int calcAreaRowAmount(String area) {
        RangeModel rangeModel = SpreadAreaUtil.getRangModel(area);
        return rangeModel.getY_end() - rangeModel.getY_start() + 1;
    }
}

